/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.social.common.ResourceBundleUtil;

public class ResourceBundleUtilTest
extends TestCase {
    public void testReplaceArgumentsWithArrayArguments() {
        String input = "Hello {0}";
        String[] arguments = new String[]{"World"};
        String output = ResourceBundleUtil.replaceArguments((String)input, (String[])arguments);
        ResourceBundleUtilTest.assertEquals((String)"output must be: Hello World", (String)"Hello World", (String)output);
        arguments = new String[]{};
        output = ResourceBundleUtil.replaceArguments((String)input, (String[])arguments);
        ResourceBundleUtilTest.assertEquals((String)("output must be: " + input), (String)input, (String)output);
        arguments = new String[]{"Out There", "World"};
        output = ResourceBundleUtil.replaceArguments((String)input, (String[])arguments);
        ResourceBundleUtilTest.assertEquals((String)"output must be: Hello Out There", (String)"Hello Out There", (String)output);
    }

    public void testReplaceArgumentsWithListArguments() {
        String input = "Hello {0}";
        List<String> arguments = Arrays.asList("World");
        String output = ResourceBundleUtil.replaceArguments((String)input, arguments);
        ResourceBundleUtilTest.assertEquals((String)"output must be: Hello World", (String)"Hello World", (String)output);
        arguments = Arrays.asList(new String[0]);
        output = ResourceBundleUtil.replaceArguments((String)input, arguments);
        ResourceBundleUtilTest.assertEquals((String)("output must be: " + input), (String)input, (String)output);
        arguments = Arrays.asList("Out There", "World");
        output = ResourceBundleUtil.replaceArguments((String)input, arguments);
        ResourceBundleUtilTest.assertEquals((String)"output must be: Hello Out There", (String)"Hello Out There", (String)output);
    }

    public void testReplaceArgumentAdvanced() {
        String input = "At {2} on {3}, we detected {1} spaceships on the planet {0}";
        String[] arguments = new String[]{"Mars", "10", "02:00 PM", "Feb 6, 2012"};
        String output = ResourceBundleUtil.replaceArguments((String)input, (String[])arguments);
        String expected = "At 02:00 PM on Feb 6, 2012, we detected 10 spaceships on the planet Mars";
        ResourceBundleUtilTest.assertEquals((String)("output must be: " + expected), (String)expected, (String)output);
        ArrayList<String> listArguments = new ArrayList<String>(2);
        listArguments.add("old display name");
        listArguments.add("new display name");
        input = "L''espace <strong>{0}</strong> a \u00e9t\u00e9 renomm\u00e9 \u00e0 <strong>{1}</strong>.";
        output = ResourceBundleUtil.replaceArguments((String)input, listArguments);
        expected = "L'espace <strong>old display name</strong> a \u00e9t\u00e9 renomm\u00e9 \u00e0 <strong>new display name</strong>.";
        ResourceBundleUtilTest.assertEquals((String)expected, (String)output);
        input = "{0} a \u00e9t\u00e9 renomm\u00e9 \u00e0 <strong>{1}</strong>.";
        output = ResourceBundleUtil.replaceArguments((String)input, listArguments);
        expected = "old display name a \u00e9t\u00e9 renomm\u00e9 \u00e0 <strong>new display name</strong>.";
        ResourceBundleUtilTest.assertEquals((String)expected, (String)output);
        input = "L''espace <strong>{0}</strong> a \u00e9t\u00e9 renomm\u00e9 \u00e0 <strong>{1}</strong>.";
        arguments = new String[]{"old display name", "new display name"};
        output = ResourceBundleUtil.replaceArguments((String)input, listArguments);
        expected = "L'espace <strong>old display name</strong> a \u00e9t\u00e9 renomm\u00e9 \u00e0 <strong>new display name</strong>.";
        ResourceBundleUtilTest.assertEquals((String)expected, (String)output);
        input = "L''espace <strong>{0}</strong> a \u00e9t\u00e9 renomm\u00e9 \u00e0 <strong>{1}</strong>.";
        arguments = new String[]{"old display name"};
        output = ResourceBundleUtil.replaceArguments((String)input, (String[])arguments);
        expected = "L'espace <strong>old display name</strong> a \u00e9t\u00e9 renomm\u00e9 \u00e0 <strong>{1}</strong>.";
        ResourceBundleUtilTest.assertEquals((String)expected, (String)output);
        input = "L''espace <strong>{0}</strong> a \u00e9t\u00e9 renomm\u00e9 \u00e0 <strong>{1}</strong>.";
        arguments = new String[]{null, null};
        output = ResourceBundleUtil.replaceArguments((String)input, (String[])arguments);
        expected = "L'espace <strong>null</strong> a \u00e9t\u00e9 renomm\u00e9 \u00e0 <strong>null</strong>.";
        ResourceBundleUtilTest.assertEquals((String)expected, (String)output);
        input = "L''espace <strong>{0}</strong> a \u00e9t\u00e9 renomm\u00e9 \u00e0 <strong>{1}</strong>.";
        arguments = null;
        output = ResourceBundleUtil.replaceArguments((String)input, (String[])arguments);
        expected = "L'espace <strong>{0}</strong> a \u00e9t\u00e9 renomm\u00e9 \u00e0 <strong>{1}</strong>.";
        ResourceBundleUtilTest.assertEquals((String)expected, (String)output);
    }

    public void testProcessSingleQuote() throws Exception {
        String input = "I'm connected with {0}";
        String output = ResourceBundleUtil.processSingleQuote((String)input);
        String expected = "I''m connected with {0}";
        ResourceBundleUtilTest.assertEquals((String)expected, (String)output);
        input = "I''m connected with {0}";
        output = ResourceBundleUtil.processSingleQuote((String)input);
        expected = "I''m connected with {0}";
        ResourceBundleUtilTest.assertEquals((String)expected, (String)output);
        input = "I'''m connected with {0}";
        output = ResourceBundleUtil.processSingleQuote((String)input);
        expected = "I''m connected with {0}";
        ResourceBundleUtilTest.assertEquals((String)expected, (String)output);
        input = "I''''m connected with {0}";
        output = ResourceBundleUtil.processSingleQuote((String)input);
        expected = "I''m connected with {0}";
        ResourceBundleUtilTest.assertEquals((String)expected, (String)output);
        input = "I'm connected with {0}";
        String[] arguments = new String[]{"mary"};
        output = ResourceBundleUtil.replaceArguments((String)input, (String[])arguments);
        expected = "I'm connected with mary";
        ResourceBundleUtilTest.assertEquals((String)expected, (String)output);
        input = "I'm connected with '{0}'";
        arguments = new String[]{"mary"};
        output = ResourceBundleUtil.replaceArguments((String)input, (String[])arguments);
        expected = "I'm connected with 'mary'";
        ResourceBundleUtilTest.assertEquals((String)expected, (String)output);
    }
}

