/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.cms.service;

import io.meeds.social.cms.service.CMSServiceImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.junit.Assert;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/exo.social.component.core-local-root-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.core-local-configuration.xml")})
public class CMSServiceTest
extends AbstractKernelTest {
    protected static final Random RANDOM = new Random();
    private static final String CONTENT_TYPE = "contentType";
    private static final String USERS_GROUP = "*:/platform/users";
    private static final String ADMINISTRATORS_GROUP = "*:/platform/administrators";
    private static final String USERNAME = "testuser";
    private CMSServiceImpl cmsService;
    private LayoutService layoutService;
    private IdentityRegistry identityRegistry;
    private static final long SPACE_ID = 3L;
    private static final long USER_IDENTITY_ID = 333L;

    protected void setUp() throws Exception {
        super.setUp();
        this.cmsService = (CMSServiceImpl)this.getContainer().getComponentInstanceOfType(CMSServiceImpl.class);
        this.layoutService = (LayoutService)this.getContainer().getComponentInstanceOfType(LayoutService.class);
        this.identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
        this.begin();
    }

    protected void tearDown() throws Exception {
        this.end();
        super.tearDown();
    }

    public void testSaveSetting() throws ObjectAlreadyExistsException {
        String settingName = "testSaveSetting" + RANDOM.nextLong();
        String pageName = "testCMSSaveSetting";
        CMSServiceTest.assertFalse((boolean)this.cmsService.isSettingNameExists(CONTENT_TYPE, settingName));
        String pageReference = this.createPage(pageName, "Everyone", ADMINISTRATORS_GROUP);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.cmsService.saveSettingName(null, settingName, pageReference, 3L, 333L));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.cmsService.saveSettingName(CONTENT_TYPE, null, pageReference, 3L, 333L));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.cmsService.saveSettingName(CONTENT_TYPE, settingName, null, 3L, 333L));
        this.cmsService.saveSettingName(CONTENT_TYPE, settingName, pageReference, 3L, 333L);
        Assert.assertThrows(ObjectAlreadyExistsException.class, () -> this.cmsService.saveSettingName(CONTENT_TYPE, settingName, pageReference, 3L, 333L));
        CMSServiceTest.assertTrue((boolean)this.cmsService.isSettingNameExists(CONTENT_TYPE, settingName));
    }

    public void testHasAccessPermission() throws ObjectAlreadyExistsException {
        String settingName = "testHasAccessPermission1" + RANDOM.nextLong();
        String pageName = "testHasAccessPermission1";
        CMSServiceTest.assertFalse((boolean)this.cmsService.hasAccessPermission(this.registerInternalUser(USERNAME), CONTENT_TYPE, settingName));
        String pageReference = this.createPage(pageName, "Everyone", ADMINISTRATORS_GROUP);
        this.cmsService.saveSettingName(CONTENT_TYPE, settingName, pageReference, 3L, 333L);
        CMSServiceTest.assertTrue((boolean)this.cmsService.hasAccessPermission(this.registerInternalUser(USERNAME), CONTENT_TYPE, settingName));
        CMSServiceTest.assertTrue((boolean)this.cmsService.hasAccessPermission(null, CONTENT_TYPE, settingName));
        settingName = "testHasAccessPermission2" + RANDOM.nextLong();
        pageName = "testHasAccessPermission2";
        pageReference = this.createPage(pageName, USERS_GROUP, ADMINISTRATORS_GROUP);
        this.cmsService.saveSettingName(CONTENT_TYPE, settingName, pageReference, 3L, 333L);
        CMSServiceTest.assertTrue((boolean)this.cmsService.hasAccessPermission(this.registerInternalUser(USERNAME), CONTENT_TYPE, settingName));
        CMSServiceTest.assertFalse((boolean)this.cmsService.hasAccessPermission(null, CONTENT_TYPE, settingName));
        settingName = "testHasAccessPermission3" + RANDOM.nextLong();
        pageName = "testHasAccessPermission3";
        pageReference = this.createPage(pageName, ADMINISTRATORS_GROUP, ADMINISTRATORS_GROUP);
        this.cmsService.saveSettingName(CONTENT_TYPE, settingName, pageReference, 3L, 333L);
        CMSServiceTest.assertTrue((boolean)this.cmsService.hasAccessPermission(this.registerAdministratorUser(USERNAME), CONTENT_TYPE, settingName));
        CMSServiceTest.assertFalse((boolean)this.cmsService.hasAccessPermission(this.registerInternalUser(USERNAME), CONTENT_TYPE, settingName));
        CMSServiceTest.assertFalse((boolean)this.cmsService.hasAccessPermission(null, CONTENT_TYPE, settingName));
    }

    public void testHasEditPermission() throws ObjectAlreadyExistsException {
        String settingName = "testHasEditPermission1" + RANDOM.nextLong();
        String pageName = "testHasEditPermission1";
        CMSServiceTest.assertFalse((boolean)this.cmsService.hasEditPermission(this.registerInternalUser(USERNAME), CONTENT_TYPE, settingName));
        String pageReference = this.createPage(pageName, "Everyone", ADMINISTRATORS_GROUP);
        this.cmsService.saveSettingName(CONTENT_TYPE, settingName, pageReference, 3L, 333L);
        CMSServiceTest.assertFalse((boolean)this.cmsService.hasEditPermission(this.registerInternalUser(USERNAME), CONTENT_TYPE, settingName));
        CMSServiceTest.assertFalse((boolean)this.cmsService.hasEditPermission(null, CONTENT_TYPE, settingName));
        CMSServiceTest.assertTrue((boolean)this.cmsService.hasEditPermission(this.registerAdministratorUser(USERNAME), CONTENT_TYPE, settingName));
    }

    private String createPage(String pageName, String accessPermission, String editPermission) {
        String siteType = "portal";
        String siteName = "test";
        if (this.layoutService.getPortalConfig(siteName) == null) {
            PortalConfig portal = new PortalConfig();
            portal.setType(siteType);
            portal.setName(siteName);
            portal.setLocale("en");
            portal.setLabel("Test");
            portal.setDescription("Test");
            portal.setAccessPermissions(new String[]{"Everyone"});
            this.layoutService.create(portal);
        }
        PageKey pageKey = new PageKey(siteType, siteName, pageName);
        PageState pageState = new PageState(pageName, null, false, false, null, Collections.singletonList(accessPermission), editPermission, Collections.singletonList(editPermission), Collections.singletonList(editPermission), PageType.PAGE.name(), null);
        this.layoutService.save(new PageContext(pageKey, pageState));
        return pageKey.format();
    }

    private Identity registerAdministratorUser(String user) {
        Identity identity = new Identity(user, Arrays.asList(new MembershipEntry("/platform/administrators")));
        this.identityRegistry.register(identity);
        return identity;
    }

    private Identity registerInternalUser(String username) {
        Identity identity = new Identity(username, Arrays.asList(new MembershipEntry("/platform/users")));
        this.identityRegistry.register(identity);
        return identity;
    }
}

