/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.profile;

import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.UserProfileComparator;

public class UserProfileComparatorTest
extends TestCase {
    public void testHasStringFieldChanged() {
        Profile existingProfile = new Profile();
        Profile toUpdateProfile = new Profile();
        UserProfileComparatorTest.assertFalse((boolean)UserProfileComparator.hasChanged((Profile)toUpdateProfile, (Profile)existingProfile, (String[])new String[]{"firstName"}));
        existingProfile.setProperty("firstName", (Object)"oldValue");
        UserProfileComparatorTest.assertTrue((boolean)UserProfileComparator.hasChanged((Profile)toUpdateProfile, (Profile)existingProfile, (String[])new String[]{"firstName"}));
        toUpdateProfile.setProperty("firstName", (Object)"oldValue");
        UserProfileComparatorTest.assertFalse((boolean)UserProfileComparator.hasChanged((Profile)toUpdateProfile, (Profile)existingProfile, (String[])new String[]{"firstName"}));
        toUpdateProfile.setProperty("firstName", (Object)"newValue");
        UserProfileComparatorTest.assertTrue((boolean)UserProfileComparator.hasChanged((Profile)toUpdateProfile, (Profile)existingProfile, (String[])new String[]{"firstName"}));
        existingProfile.setProperty("firstName", null);
        UserProfileComparatorTest.assertTrue((boolean)UserProfileComparator.hasChanged((Profile)toUpdateProfile, (Profile)existingProfile, (String[])new String[]{"firstName"}));
        toUpdateProfile.setProperty("firstName", null);
        UserProfileComparatorTest.assertFalse((boolean)UserProfileComparator.hasChanged((Profile)toUpdateProfile, (Profile)existingProfile, (String[])new String[]{"firstName"}));
        toUpdateProfile.setProperty("firstName", (Object)"");
        UserProfileComparatorTest.assertFalse((boolean)UserProfileComparator.hasChanged((Profile)toUpdateProfile, (Profile)existingProfile, (String[])new String[]{"firstName"}));
        existingProfile.setProperty("firstName", (Object)"");
        UserProfileComparatorTest.assertFalse((boolean)UserProfileComparator.hasChanged((Profile)toUpdateProfile, (Profile)existingProfile, (String[])new String[]{"firstName"}));
    }

    public void testListStringFieldChanged() {
        Profile existingProfile = new Profile();
        Profile toUpdateProfile = new Profile();
        ArrayList oldExperiences = new ArrayList();
        HashMap<String, String> oldCompany = new HashMap<String, String>();
        oldExperiences.add(oldCompany);
        oldCompany.put("company", "oldValue");
        existingProfile.setProperty("experiences", oldExperiences);
        ArrayList newExperiences = new ArrayList();
        HashMap<String, String> newCompany = new HashMap<String, String>();
        newExperiences.add(newCompany);
        newCompany.put("company", "newValue");
        toUpdateProfile.setProperty("experiences", newExperiences);
        UserProfileComparatorTest.assertTrue((boolean)UserProfileComparator.hasChanged((Profile)toUpdateProfile, (Profile)existingProfile, (String[])new String[]{"experiences"}));
        toUpdateProfile.setProperty("experiences", oldExperiences);
        UserProfileComparatorTest.assertFalse((boolean)UserProfileComparator.hasChanged((Profile)toUpdateProfile, (Profile)existingProfile, (String[])new String[]{"experiences"}));
        toUpdateProfile.setProperty("experiences", newExperiences);
        UserProfileComparatorTest.assertTrue((boolean)UserProfileComparator.hasChanged((Profile)toUpdateProfile, (Profile)existingProfile, (String[])new String[]{"experiences"}));
        oldCompany.put("company", null);
        UserProfileComparatorTest.assertTrue((boolean)UserProfileComparator.hasChanged((Profile)toUpdateProfile, (Profile)existingProfile, (String[])new String[]{"experiences"}));
        newCompany.put("company", "");
        UserProfileComparatorTest.assertFalse((boolean)UserProfileComparator.hasChanged((Profile)toUpdateProfile, (Profile)existingProfile, (String[])new String[]{"experiences"}));
        newCompany.put("company", null);
        UserProfileComparatorTest.assertFalse((boolean)UserProfileComparator.hasChanged((Profile)toUpdateProfile, (Profile)existingProfile, (String[])new String[]{"experiences"}));
        oldCompany.put("company", "");
        UserProfileComparatorTest.assertFalse((boolean)UserProfileComparator.hasChanged((Profile)toUpdateProfile, (Profile)existingProfile, (String[])new String[]{"experiences"}));
    }

    public void testOtherFieldTypeChanged() {
        String fieldName = "testBoolean";
        Profile existingProfile = new Profile();
        existingProfile.setProperty(fieldName, (Object)Boolean.TRUE);
        Profile toUpdateProfile = new Profile();
        toUpdateProfile.setProperty(fieldName, (Object)Boolean.FALSE);
        UserProfileComparatorTest.assertTrue((boolean)UserProfileComparator.hasChanged((Profile)toUpdateProfile, (Profile)existingProfile, (String[])new String[]{fieldName}));
        toUpdateProfile.setProperty(fieldName, (Object)Boolean.TRUE);
        UserProfileComparatorTest.assertFalse((boolean)UserProfileComparator.hasChanged((Profile)toUpdateProfile, (Profile)existingProfile, (String[])new String[]{fieldName}));
    }
}

