/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.test.AbstractCoreTest;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.model.BannerAttachment;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.core.storage.cache.CachedSpaceStorage;
import org.junit.Assert;

public class IdentityStorageTest
extends AbstractCoreTest {
    private IdentityStorage identityStorage;
    private SpaceStorage spaceStorage;
    private CachedSpaceStorage cachedSpaceStorage;
    private List<Identity> tearDownIdentityList;
    private List<Space> tearDownSpaceList;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityStorage = this.getService(IdentityStorage.class);
        this.spaceStorage = this.getService(SpaceStorage.class);
        this.cachedSpaceStorage = this.getService(CachedSpaceStorage.class);
        IdentityStorageTest.assertNotNull((String)"identityStorage must not be null", (Object)this.identityStorage);
        this.tearDownIdentityList = new ArrayList<Identity>();
        this.tearDownSpaceList = new ArrayList<Space>();
    }

    public void testSaveIdentity() {
        Identity tobeSavedIdentity = new Identity("organization", "identity1");
        this.identityStorage.saveIdentity(tobeSavedIdentity);
        IdentityStorageTest.assertNotNull((Object)tobeSavedIdentity.getId());
        String updatedRemoteId = "identity-updated";
        tobeSavedIdentity.setRemoteId("identity-updated");
        this.identityStorage.saveIdentity(tobeSavedIdentity);
        Identity gotIdentity = this.identityStorage.findIdentityById(tobeSavedIdentity.getId());
        IdentityStorageTest.assertEquals((String)"identity-updated", (String)gotIdentity.getRemoteId());
        this.tearDownIdentityList.add(gotIdentity);
    }

    public void testEnableIdentity() {
        String remoteUser = "user";
        Identity identity = new Identity("organization", "user");
        this.identityStorage.saveIdentity(identity);
        String id = identity.getId();
        IdentityStorageTest.assertNotNull((Object)identity.getId());
        this.identityStorage.processEnabledIdentity(identity, false);
        identity = this.identityStorage.findIdentityById(id);
        IdentityStorageTest.assertFalse((boolean)identity.isEnable());
        this.identityStorage.processEnabledIdentity(identity, true);
        identity = this.identityStorage.findIdentityById(id);
        IdentityStorageTest.assertTrue((boolean)identity.isEnable());
        this.tearDownIdentityList.add(identity);
    }

    public void testDeleteIdentity() {
        block2: {
            String username = "username";
            Identity tobeSavedIdentity = new Identity("organization", "username");
            this.identityStorage.saveIdentity(tobeSavedIdentity);
            IdentityStorageTest.assertNotNull((Object)tobeSavedIdentity.getId());
            this.identityStorage.deleteIdentity(tobeSavedIdentity);
            tobeSavedIdentity = this.identityStorage.findIdentity("organization", "username");
            IdentityStorageTest.assertTrue((String)"tobeSavedIdentity must be mark as deleted", (boolean)tobeSavedIdentity.isDeleted());
            tobeSavedIdentity = new Identity("organization", "username");
            this.identityStorage.saveIdentity(tobeSavedIdentity);
            IdentityStorageTest.assertNotNull((String)"tobeSavedIdentity.getId() must not be null.", (Object)tobeSavedIdentity.getId());
            IdentityStorageTest.assertNull((String)"tobeSavedIdentity.getProfile().getId() must be null.", (Object)tobeSavedIdentity.getProfile().getId());
            Profile profile = this.identityStorage.loadProfile(tobeSavedIdentity.getProfile());
            tobeSavedIdentity.setProfile(profile);
            IdentityStorageTest.assertNotNull((String)"tobeSavedIdentity.getProfile().getId() must not be null", (Object)tobeSavedIdentity.getProfile().getId());
            this.identityStorage.deleteIdentity(tobeSavedIdentity);
            IdentityStorageTest.assertNotNull((String)"tobeSavedIdentity.getId() must not be null", (Object)tobeSavedIdentity.getId());
            try {
                this.identityStorage.findIdentityById(tobeSavedIdentity.getId());
            }
            catch (Exception e1) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)("can't update avatar" + String.valueOf(e1)));
            }
        }
    }

    public void testFindIdentityById() {
        String remoteUser = "identity1";
        Identity toSaveIdentity = new Identity("organization", "identity1");
        this.identityStorage.saveIdentity(toSaveIdentity);
        IdentityStorageTest.assertNotNull((Object)toSaveIdentity.getId());
        Identity gotIdentityById = this.identityStorage.findIdentityById(toSaveIdentity.getId());
        IdentityStorageTest.assertNotNull((Object)gotIdentityById);
        IdentityStorageTest.assertEquals((String)toSaveIdentity.getId(), (String)gotIdentityById.getId());
        IdentityStorageTest.assertEquals((String)toSaveIdentity.getProviderId(), (String)gotIdentityById.getProviderId());
        IdentityStorageTest.assertEquals((String)toSaveIdentity.getRemoteId(), (String)gotIdentityById.getRemoteId());
        Identity notFoundIdentityByRemoteid = this.identityStorage.findIdentity("organization", "not-found");
        IdentityStorageTest.assertNull((Object)notFoundIdentityByRemoteid);
        Identity gotIdentityByRemoteId = this.identityStorage.findIdentity("organization", "identity1");
        IdentityStorageTest.assertNotNull((Object)gotIdentityByRemoteId);
        IdentityStorageTest.assertEquals((String)gotIdentityByRemoteId.getId(), (String)toSaveIdentity.getId());
        IdentityStorageTest.assertEquals((String)gotIdentityByRemoteId.getProviderId(), (String)toSaveIdentity.getProviderId());
        IdentityStorageTest.assertEquals((String)gotIdentityByRemoteId.getRemoteId(), (String)toSaveIdentity.getRemoteId());
        this.tearDownIdentityList.add(gotIdentityByRemoteId);
    }

    public void testSortIdentities() {
        ArrayList<CallSite> remoteUsers = new ArrayList<CallSite>();
        for (int i = 0; i < 10; ++i) {
            String remoteId = "sortIdentity" + i;
            remoteUsers.add((CallSite)((Object)remoteId));
            Identity identity = new Identity("organization", remoteId);
            this.identityStorage.saveIdentity(identity);
            Profile profile = new Profile(identity);
            profile.setProperty("firstName", (Object)("user " + i));
            profile.setProperty("lastName", (Object)("user " + i));
            profile.setProperty("fullName", (Object)("user " + i));
            this.identityStorage.saveProfile(profile);
            this.tearDownIdentityList.add(identity);
        }
        List sortIdentities = this.identityStorage.sortIdentities(remoteUsers, "fullName", "asc", true);
        IdentityStorageTest.assertEquals(remoteUsers, (Object)sortIdentities);
        Identity identity1 = this.identityStorage.findIdentity("organization", "sortIdentity1");
        identity1.setEnable(false);
        this.identityStorage.saveIdentity(identity1);
        sortIdentities = this.identityStorage.sortIdentities(remoteUsers, "fullName", "asc");
        IdentityStorageTest.assertEquals((int)9, (int)sortIdentities.size());
        sortIdentities = this.identityStorage.sortIdentities(remoteUsers, "fullName", "asc", false);
        IdentityStorageTest.assertEquals((int)10, (int)sortIdentities.size());
    }

    public void testFindIdentity() {
        String userName = "username";
        Identity tobeSavedIdentity = new Identity("organization", "username");
        this.identityStorage.saveIdentity(tobeSavedIdentity);
        this.tearDownIdentityList.add(tobeSavedIdentity);
        Identity foundIdentity = this.identityStorage.findIdentity("organization", "username");
        IdentityStorageTest.assertNotNull((Object)foundIdentity);
        IdentityStorageTest.assertNotNull((Object)foundIdentity.getId());
        IdentityStorageTest.assertEquals((String)"organization", (String)foundIdentity.getProviderId());
        IdentityStorageTest.assertEquals((String)"username", (String)foundIdentity.getRemoteId());
        this.tearDownIdentityList.add(foundIdentity);
    }

    public void testSaveProfile() {
        String userName = "username";
        String firstName = "FirstName";
        String lastName = "LastName";
        Identity tobeSavedIdentity = new Identity("organization", "username");
        this.identityStorage.saveIdentity(tobeSavedIdentity);
        this.tearDownIdentityList.add(tobeSavedIdentity);
        Profile tobeSavedProfile = tobeSavedIdentity.getProfile();
        tobeSavedProfile.setProperty("username", (Object)"username");
        tobeSavedProfile.setProperty("firstName", (Object)"FirstName");
        tobeSavedProfile.setProperty("lastName", (Object)"LastName");
        IdentityStorageTest.assertTrue((boolean)tobeSavedProfile.hasChanged());
        this.identityStorage.saveProfile(tobeSavedProfile);
        IdentityStorageTest.assertFalse((boolean)tobeSavedProfile.hasChanged());
        IdentityStorageTest.assertNotNull((Object)tobeSavedProfile.getId());
        IdentityStorageTest.assertEquals((Object)"username", (Object)tobeSavedProfile.getProperty("username"));
        IdentityStorageTest.assertEquals((Object)"FirstName", (Object)tobeSavedProfile.getProperty("firstName"));
        IdentityStorageTest.assertEquals((Object)"LastName", (Object)tobeSavedProfile.getProperty("lastName"));
        IdentityStorageTest.assertEquals((String)"FirstName LastName", (String)tobeSavedProfile.getFullName());
        this.tearDownIdentityList.add(this.identityStorage.findIdentity("organization", "username"));
    }

    public void testLoadProfile() throws Exception {
        String username = "username";
        Identity tobeSavedIdentity = new Identity("organization", "username");
        this.identityStorage.saveIdentity(tobeSavedIdentity);
        this.tearDownIdentityList.add(tobeSavedIdentity);
        Profile tobeSavedProfile = tobeSavedIdentity.getProfile();
        tobeSavedProfile.setProperty("username", (Object)"username");
        IdentityStorageTest.assertTrue((boolean)tobeSavedProfile.hasChanged());
        tobeSavedProfile = this.identityStorage.loadProfile(tobeSavedProfile);
        IdentityStorageTest.assertFalse((boolean)tobeSavedProfile.hasChanged());
        IdentityStorageTest.assertNotNull((Object)tobeSavedProfile.getId());
        IdentityStorageTest.assertEquals((Object)"username", (Object)tobeSavedProfile.getProperty("username"));
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        AvatarAttachment avatarAttachment = new AvatarAttachment(null, "avatar", "png", inputStream, System.currentTimeMillis());
        inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        BannerAttachment bannerAttachment = new BannerAttachment(null, "banner", "png", inputStream, System.currentTimeMillis());
        String userDotName = "user.name";
        Identity identity = new Identity("organization", userDotName);
        Profile profile = new Profile(identity);
        identity.setProfile(profile);
        profile.setProperty("avatar", (Object)avatarAttachment);
        profile.setProperty("banner", (Object)bannerAttachment);
        this.identityStorage.saveIdentity(identity);
        this.identityStorage.saveProfile(profile);
        profile = this.identityStorage.loadProfile(profile);
        String gotAvatarURL = profile.getAvatarUrl();
        IdentityStorageTest.assertNotNull((Object)gotAvatarURL);
        IdentityStorageTest.assertEquals((String)LinkProvider.buildAvatarURL((String)"organization", (String)profile.getId(), (boolean)true, (Long)profile.getAvatarLastUpdated()), (String)gotAvatarURL);
        String gotBannerURL = profile.getBannerUrl();
        IdentityStorageTest.assertNotNull((Object)gotBannerURL);
        IdentityStorageTest.assertEquals((String)LinkProvider.buildBannerURL((String)"organization", (String)profile.getId(), (boolean)true, (Long)profile.getBannerLastUpdated()), (String)gotBannerURL);
        this.tearDownIdentityList.add(this.identityStorage.findIdentity("organization", userDotName));
        this.tearDownIdentityList.add(this.identityStorage.findIdentity("organization", "username"));
    }

    public void testLoadProfileByReloadCreatedProfileNode() throws Exception {
        String providerId = "organization";
        String remoteId = "username";
        Identity identity = new Identity(providerId, remoteId);
        this.identityStorage.saveIdentity(identity);
        this.tearDownIdentityList.add(identity);
        Profile profile = new Profile(identity);
        IdentityStorageTest.assertFalse((boolean)profile.hasChanged());
        profile = this.identityStorage.loadProfile(profile);
        IdentityStorageTest.assertFalse((boolean)profile.hasChanged());
        String profileId = profile.getId();
        profile = new Profile(identity);
        IdentityStorageTest.assertFalse((boolean)profile.hasChanged());
        profile = this.identityStorage.loadProfile(profile);
        IdentityStorageTest.assertFalse((boolean)profile.hasChanged());
        IdentityStorageTest.assertEquals((String)profileId, (String)profile.getId());
    }

    public void testFindIdentityByExistName() throws Exception {
        String providerId = "organization";
        String remoteId = "username";
        Identity identity = new Identity(providerId, remoteId);
        this.identityStorage.saveIdentity(identity);
        this.tearDownIdentityList.add(identity);
        Profile profile = new Profile(identity);
        profile.setProperty("firstName", (Object)"FirstName");
        profile.setProperty("lastName", (Object)"LastName");
        profile.setProperty("fullName", (Object)"FirstName LastName");
        this.identityStorage.saveProfile(profile);
        identity.setProfile(profile);
        this.tearDownIdentityList.add(identity);
        ProfileFilter filter = new ProfileFilter();
        filter.setName("First");
        List result = this.identityStorage.getIdentitiesByProfileFilter(providerId, filter, 0L, 1L, false);
        IdentityStorageTest.assertEquals((int)1, (int)result.size());
    }

    public void testFindManyIdentitiesByExistName() throws Exception {
        String providerId = "organization";
        int total = 10;
        for (int i = 0; i < 10; ++i) {
            String remoteId = "username" + i;
            Identity identity = new Identity("organization", remoteId + i);
            this.identityStorage.saveIdentity(identity);
            this.tearDownIdentityList.add(identity);
            Profile profile = new Profile(identity);
            profile.setProperty("firstName", (Object)("FirstName" + i));
            profile.setProperty("lastName", (Object)("LastName" + i));
            profile.setProperty("fullName", (Object)("FirstName" + i + " LastName" + i));
            this.identityStorage.saveProfile(profile);
            identity.setProfile(profile);
        }
        ProfileFilter filter = new ProfileFilter();
        filter.setName("FirstName");
        List result = this.identityStorage.getIdentitiesByProfileFilter("organization", filter, 0L, 10L, false);
        IdentityStorageTest.assertEquals((int)10, (int)result.size());
    }

    public void testGetIdentitiesSorted() throws Exception {
        Profile profile;
        Identity identity;
        String remoteId;
        int i;
        int total = 10;
        String remoteIdPrefix = "username";
        for (i = 0; i < 7; ++i) {
            remoteId = remoteIdPrefix + i;
            identity = new Identity("organization", remoteId + i);
            this.identityStorage.saveIdentity(identity);
            this.tearDownIdentityList.add(identity);
            profile = new Profile(identity);
            profile.setProperty("firstName", (Object)("FirstName" + i));
            profile.setProperty("lastName", (Object)("LastName" + i));
            profile.setProperty("fullName", (Object)("FirstName" + i + " LastName" + i));
            this.identityStorage.saveProfile(profile);
            identity.setProfile(profile);
        }
        for (i = 7; i < 10; ++i) {
            remoteId = remoteIdPrefix + i;
            identity = new Identity("organization", remoteId + i);
            this.identityStorage.saveIdentity(identity);
            this.tearDownIdentityList.add(identity);
            profile = new Profile(identity);
            profile.setProperty("firstName", (Object)("FirstName" + i));
            profile.setProperty("lastName", (Object)("LastName" + i));
            profile.setProperty("fullName", (Object)("FirstName" + i + " LastName" + i));
            profile.setProperty("external", (Object)"true");
            profile.setProperty("enrollmentDate", (Object)new Date().getTime());
            this.identityStorage.saveProfile(profile);
            identity.setProfile(profile);
        }
        long offset = 0L;
        long limit = Integer.MAX_VALUE;
        String providerId = "organization";
        String sortDirection = Sorting.OrderBy.ASC.name();
        String sortField = Sorting.SortBy.FULLNAME.getFieldName();
        String fieldName = "fullName";
        List result = this.identityStorage.getIdentities(providerId, sortField, sortDirection, true, null, null, null, offset, limit);
        IdentityStorageTest.assertTrue((String)"Returned result count is not consistent", (result.size() >= 10 ? 1 : 0) != 0);
        this.assertSorted(remoteIdPrefix, fieldName, result);
        fieldName = "lastName";
        sortField = Sorting.SortBy.LASTNAME.getFieldName();
        result = this.identityStorage.getIdentities(providerId, sortField, sortDirection, true, null, null, null, offset, limit);
        IdentityStorageTest.assertTrue((String)"Returned result count is not consistent", (result.size() >= 10 ? 1 : 0) != 0);
        this.assertSorted(remoteIdPrefix, fieldName, result);
        fieldName = "firstName";
        sortField = Sorting.SortBy.FIRSTNAME.getFieldName();
        result = this.identityStorage.getIdentities(providerId, sortField, sortDirection, true, null, null, null, offset, limit);
        IdentityStorageTest.assertTrue((String)"Returned result count is not consistent", (result.size() >= 10 ? 1 : 0) != 0);
        this.assertSorted(remoteIdPrefix, fieldName, result);
        result = this.identityStorage.getIdentities(providerId, sortField, sortDirection, true, null, null, null, offset, limit);
        IdentityStorageTest.assertTrue((String)"Returned result count is not consistent", (result.size() >= 10 ? 1 : 0) != 0);
        this.assertSorted(remoteIdPrefix, fieldName, result);
        result = this.identityStorage.getIdentities(providerId, sortField, sortDirection, true, null, null, null, offset, limit);
        IdentityStorageTest.assertTrue((String)"Returned result count is not consistent", (result.size() >= 10 ? 1 : 0) != 0);
        this.assertSorted(remoteIdPrefix, fieldName, result);
        sortField = Sorting.SortBy.FULLNAME.getFieldName();
        fieldName = "fullName";
        result = this.identityStorage.getIdentities(providerId, sortField, sortDirection, true, "internal", null, null, offset, limit);
        IdentityStorageTest.assertTrue((String)"Returned result count is not consistent", (result.size() == 7 ? 1 : 0) != 0);
        this.assertSorted(remoteIdPrefix, fieldName, result);
        result = this.identityStorage.getIdentities(providerId, sortField, sortDirection, true, "external", null, null, offset, limit);
        IdentityStorageTest.assertTrue((String)"Returned result count is not consistent", (result.size() == 3 ? 1 : 0) != 0);
        this.assertSorted(remoteIdPrefix, fieldName, result);
        result = this.identityStorage.getIdentities(providerId, sortField, sortDirection, true, null, Boolean.valueOf(false), null, offset, limit);
        IdentityStorageTest.assertTrue((String)"Returned result count is not consistent", (result.size() == 10 ? 1 : 0) != 0);
        this.assertSorted(remoteIdPrefix, fieldName, result);
        result = this.identityStorage.getIdentities(providerId, sortField, sortDirection, true, null, Boolean.valueOf(true), null, offset, limit);
        IdentityStorageTest.assertTrue((String)"Returned result count is not consistent", (result.size() == 0 ? 1 : 0) != 0);
        this.assertSorted(remoteIdPrefix, fieldName, result);
        result = this.identityStorage.getIdentities(providerId, offset, limit);
        IdentityStorageTest.assertTrue((String)"Returned result count is not consistent", (result.size() == 10 ? 1 : 0) != 0);
        this.assertSorted(remoteIdPrefix, fieldName, result);
        List result1 = this.identityStorage.getIdentitiesWithRelationships("1", 0, 20);
        IdentityStorageTest.assertTrue((String)"Returned result count is not consistent", (result1.size() == 10 ? 1 : 0) != 0);
        this.assertSorted(remoteIdPrefix, fieldName, result);
        sortField = Sorting.SortBy.FULLNAME.getFieldName();
        result = this.identityStorage.getIdentities(providerId, sortField, sortDirection, true, null, null, "notEnrolled", offset, limit);
        IdentityStorageTest.assertTrue((String)"Returned result count is not consistent", (result.size() == 7 ? 1 : 0) != 0);
        this.assertSorted(remoteIdPrefix, fieldName, result);
        result = this.identityStorage.getIdentities(providerId, sortField, sortDirection, true, null, null, "noEnrollmentPossible", offset, limit);
        IdentityStorageTest.assertTrue((String)"Returned result count is not consistent", (result.size() == 3 ? 1 : 0) != 0);
        this.assertSorted(remoteIdPrefix, fieldName, result);
        result = this.identityStorage.getIdentities(providerId, sortField, sortDirection, true, null, null, "enrolled", offset, limit);
        IdentityStorageTest.assertTrue((String)"Returned result count is not consistent", (result.size() == 3 ? 1 : 0) != 0);
        this.assertSorted(remoteIdPrefix, fieldName, result);
    }

    public void testFindIdentityByNotExistName() throws Exception {
        String providerId = "organization";
        String remoteId = "username";
        Identity identity = new Identity(providerId, remoteId);
        this.identityStorage.saveIdentity(identity);
        this.tearDownIdentityList.add(identity);
        Profile profile = new Profile(identity);
        profile.setProperty("firstName", (Object)"FirstName");
        profile.setProperty("lastName", (Object)"LastName");
        profile.setProperty("fullName", (Object)"FirstName LastName");
        this.identityStorage.saveProfile(profile);
        identity.setProfile(profile);
        ProfileFilter filter = new ProfileFilter();
        filter.setName("notfound");
        List result = this.identityStorage.getIdentitiesByProfileFilter(providerId, filter, 0L, 1L, false);
        IdentityStorageTest.assertEquals((int)0, (int)result.size());
    }

    public void testGetIdentitiesByProfileFilterCount() throws Exception {
        this.populateData();
        ProfileFilter pf = new ProfileFilter();
        int idsCount = this.identityStorage.getIdentitiesByProfileFilterCount("organization", pf);
        IdentityStorageTest.assertEquals((int)5, (int)idsCount);
        pf.setPosition("developer");
        pf.setName("FirstName");
        idsCount = this.identityStorage.getIdentitiesByProfileFilterCount("organization", pf);
        IdentityStorageTest.assertEquals((int)5, (int)idsCount);
        pf.setName("LastN");
        idsCount = this.identityStorage.getIdentitiesByProfileFilterCount("organization", pf);
        IdentityStorageTest.assertEquals((int)5, (int)idsCount);
        Identity identity = this.identityStorage.findIdentity("organization", "username1");
        this.identityStorage.processEnabledIdentity(identity, false);
        IdentityStorageTest.assertEquals((int)4, (int)this.identityStorage.getIdentitiesByProfileFilterCount("organization", pf));
        this.identityStorage.processEnabledIdentity(identity, true);
        IdentityStorageTest.assertEquals((int)5, (int)this.identityStorage.getIdentitiesByProfileFilterCount("organization", pf));
        Identity externalIdentity = new Identity("organization", "username6");
        this.identityStorage.saveIdentity(externalIdentity);
        this.tearDownIdentityList.add(externalIdentity);
        Identity enrolledIdentity = new Identity("organization", "username7");
        this.identityStorage.saveIdentity(enrolledIdentity);
        this.tearDownIdentityList.add(enrolledIdentity);
        Identity noEnrollmentPossibleIdentity = new Identity("organization", "username8");
        this.identityStorage.saveIdentity(noEnrollmentPossibleIdentity);
        this.tearDownIdentityList.add(noEnrollmentPossibleIdentity);
        Profile profile = new Profile(externalIdentity);
        profile.setProperty("firstName", (Object)"FirstName6");
        profile.setProperty("lastName", (Object)"LastName6");
        profile.setProperty("fullName", (Object)"FirstName6 LastName6");
        profile.setProperty("external", (Object)"true");
        profile.setProperty("position", (Object)"developer");
        profile.setProperty("gender", (Object)"male");
        identity.setProfile(profile);
        this.identityStorage.saveProfile(profile);
        Profile enrolledProfile = new Profile(enrolledIdentity);
        enrolledProfile.setProperty("firstName", (Object)"FirstName7");
        enrolledProfile.setProperty("lastName", (Object)"LastName7");
        enrolledProfile.setProperty("fullName", (Object)"FirstName7 LastName7");
        enrolledProfile.setProperty("enrollmentDate", (Object)new Date().getTime());
        enrolledProfile.setProperty("position", (Object)"developer");
        enrolledProfile.setProperty("gender", (Object)"male");
        identity.setProfile(enrolledProfile);
        this.identityStorage.saveProfile(enrolledProfile);
        Profile noEnrollmentPossibleProfile = new Profile(noEnrollmentPossibleIdentity);
        noEnrollmentPossibleProfile.setProperty("firstName", (Object)"FirstName8");
        noEnrollmentPossibleProfile.setProperty("lastName", (Object)"LastName8");
        noEnrollmentPossibleProfile.setProperty("fullName", (Object)"FirstName8 LastName8");
        noEnrollmentPossibleProfile.setProperty("lastLoginTime", (Object)new Date().getTime());
        noEnrollmentPossibleProfile.setProperty("position", (Object)"developer");
        noEnrollmentPossibleProfile.setProperty("gender", (Object)"male");
        identity.setProfile(noEnrollmentPossibleProfile);
        this.identityStorage.saveProfile(noEnrollmentPossibleProfile);
        IdentityStorageTest.assertEquals((int)8, (int)this.identityStorage.getIdentitiesByProfileFilterCount("organization", pf));
        pf.setUserType("internal");
        IdentityStorageTest.assertEquals((int)7, (int)this.identityStorage.getIdentitiesByProfileFilterCount("organization", pf));
        pf.setConnected(Boolean.valueOf(true));
        IdentityStorageTest.assertEquals((int)1, (int)this.identityStorage.getIdentitiesByProfileFilterCount("organization", pf));
        pf.setConnected(Boolean.valueOf(false));
        IdentityStorageTest.assertEquals((int)6, (int)this.identityStorage.getIdentitiesByProfileFilterCount("organization", pf));
        pf.setUserType(null);
        IdentityStorageTest.assertEquals((int)7, (int)this.identityStorage.getIdentitiesByProfileFilterCount("organization", pf));
        pf.setEnrollmentStatus("enrolled");
        IdentityStorageTest.assertEquals((int)1, (int)this.identityStorage.getIdentitiesByProfileFilterCount("organization", pf));
        pf.setEnrollmentStatus("notEnrolled");
        IdentityStorageTest.assertEquals((int)5, (int)this.identityStorage.getIdentitiesByProfileFilterCount("organization", pf));
        pf.setEnrollmentStatus("noEnrollmentPossible");
        this.identityStorage.getIdentities("organization", Sorting.SortBy.FULLNAME.getFieldName(), Sorting.OrderBy.ASC.name(), true, null, null, "noEnrollmentPossible", 0L, Integer.MAX_VALUE);
        IdentityStorageTest.assertEquals((int)1, (int)this.identityStorage.getIdentitiesByProfileFilterCount("organization", pf));
    }

    public void testGetIdentitiesByProfileFilterAccessList() throws Exception {
        block8: {
            List identities;
            ProfileFilter pf;
            block7: {
                block6: {
                    this.populateData();
                    pf = new ProfileFilter();
                    identities = this.identityStorage.getIdentitiesByProfileFilter("organization", pf, 0L, 20L, false);
                    IdentityStorageTest.assertEquals((String)("Number of identities must be " + identities.size()), (int)5, (int)identities.size());
                    pf.setPosition("developer");
                    pf.setName("FirstName");
                    identities = this.identityStorage.getIdentitiesByProfileFilter("organization", pf, 0L, 20L, false);
                    IdentityStorageTest.assertEquals((String)("Number of identities must be " + identities.size()), (int)5, (int)identities.size());
                    try {
                        identities = this.identityStorage.getIdentitiesByProfileFilter("organization", pf, -1L, 20L, false);
                    }
                    catch (Exception ext) {
                        if ($assertionsDisabled) break block6;
                        throw new AssertionError((Object)("Can not get Identity by profile filter. " + String.valueOf(ext)));
                    }
                }
                try {
                    identities = this.identityStorage.getIdentitiesByProfileFilter("organization", pf, 0L, -1L, false);
                }
                catch (Exception ext) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError((Object)("Can not get Identity by profile filter. " + String.valueOf(ext)));
                }
            }
            try {
                identities = this.identityStorage.getIdentitiesByProfileFilter("organization", pf, 30L, 40L, false);
            }
            catch (Exception ext) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)("Can not get Identity by profile filter. " + String.valueOf(ext)));
            }
        }
    }

    public void testUpdateIdentity() throws Exception {
        String providerId = "organization";
        String newProviderId = "space";
        String userName = "userIdentity1";
        Identity identity = this.populateIdentity(userName, true);
        IdentityStorageTest.assertNotNull((String)"Identity must not be null", (Object)identity);
        IdentityStorageTest.assertEquals((String)("Identity status must be " + identity.isDeleted()), (boolean)false, (boolean)identity.isDeleted());
        identity.setDeleted(true);
        this.identityStorage.updateIdentity(identity);
        Identity updatedIdentity = this.identityStorage.findIdentity(providerId, userName);
        IdentityStorageTest.assertEquals((String)("Identity status must be " + updatedIdentity.isDeleted()), (boolean)true, (boolean)updatedIdentity.isDeleted());
        identity.setProviderId(newProviderId);
        identity.setDeleted(false);
        this.identityStorage.updateIdentity(identity);
        updatedIdentity = this.identityStorage.findIdentity(newProviderId, userName);
        this.tearDownIdentityList.add(updatedIdentity);
        IdentityStorageTest.assertEquals((String)("Identity status must be " + updatedIdentity.isDeleted()), (boolean)false, (boolean)updatedIdentity.isDeleted());
        IdentityStorageTest.assertEquals((String)("Identity provider id must be " + updatedIdentity.getProviderId()), (String)newProviderId, (String)updatedIdentity.getProviderId());
    }

    public void testGetIdentitiesCount() throws Exception {
        Identity identity;
        int i;
        int numberUser = 10;
        int numberDisableUser = 5;
        ArrayList<Identity> identities = new ArrayList<Identity>();
        for (i = 0; i < numberUser; ++i) {
            identity = new Identity("organization", "user" + i);
            this.identityStorage.saveIdentity(identity);
            identities.add(identity);
            this.tearDownIdentityList.add(identity);
        }
        IdentityStorageTest.assertEquals((int)10, (int)this.identityStorage.getIdentitiesCount("organization"));
        for (i = 0; i < numberDisableUser; ++i) {
            identity = (Identity)identities.get(i);
            this.identityStorage.processEnabledIdentity(identity, false);
        }
        IdentityStorageTest.assertEquals((int)(numberUser - numberDisableUser), (int)this.identityStorage.getIdentitiesCount("organization"));
    }

    public void testGetSpaceMemberByProfileFilter() throws Exception {
        this.populateData();
        this.populateSpaceData();
        this.populateUser("username4");
        this.populateUser("username1");
        this.populateUser("username5");
        this.populateUser("username6");
        Space space = new Space();
        space.setApp("app");
        space.setDisplayName("my space");
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space ");
        space.setType("classic");
        space.setVisibility("public");
        space.setPriority("2");
        space.setGroupId(SpaceUtils.createGroup((String)space.getPrettyName(), (String)"username4"));
        space.setUrl(space.getPrettyName());
        String[] managers = new String[]{};
        String[] members = new String[]{"username1", "username2", "username3", "abc", "acb", "bac", "bca", "cab", "cba"};
        String[] invitedUsers = new String[]{"username5"};
        String[] pendingUsers = new String[]{"username6"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        this.spaceStorage.saveSpace(space, true);
        this.tearDownSpaceList.add(space);
        ProfileFilter profileFilter = new ProfileFilter();
        ProfileFilter firstProfileFilter = new ProfileFilter();
        profileFilter.setSorting(new Sorting(Sorting.SortBy.FULLNAME, Sorting.OrderBy.ASC));
        List identities = this.identityStorage.getSpaceMemberIdentitiesByProfileFilter(space, profileFilter, SpaceMemberFilterListAccess.Type.MEMBER, 0L, 9L);
        IdentityStorageTest.assertEquals((int)9, (int)identities.size());
        IdentityStorageTest.assertEquals((String)"First member in list should be 'abc'", (String)"abc", (String)((Identity)identities.get(0)).getRemoteId());
        IdentityStorageTest.assertEquals((String)"Second member in list should be 'acb'", (String)"acb", (String)((Identity)identities.get(1)).getRemoteId());
        profileFilter.setSorting(new Sorting(Sorting.SortBy.FIRSTNAME, Sorting.OrderBy.DESC));
        identities = this.identityStorage.getSpaceMemberIdentitiesByProfileFilter(space, profileFilter, SpaceMemberFilterListAccess.Type.MEMBER, 0L, 9L);
        IdentityStorageTest.assertEquals((int)9, (int)identities.size());
        IdentityStorageTest.assertEquals((String)"First member in list should be 'username3'", (String)"username3", (String)((Identity)identities.get(0)).getRemoteId());
        IdentityStorageTest.assertEquals((String)"Second member in list should be 'username2'", (String)"username2", (String)((Identity)identities.get(1)).getRemoteId());
        profileFilter.setSorting(new Sorting(Sorting.SortBy.LASTNAME, Sorting.OrderBy.DESC));
        identities = this.identityStorage.getSpaceMemberIdentitiesByProfileFilter(space, profileFilter, SpaceMemberFilterListAccess.Type.MEMBER, 0L, 9L);
        IdentityStorageTest.assertEquals((int)9, (int)identities.size());
        IdentityStorageTest.assertEquals((String)"First member in list should be 'username3'", (String)"username3", (String)((Identity)identities.get(0)).getRemoteId());
        IdentityStorageTest.assertEquals((String)"Second member in list should be 'username2'", (String)"username2", (String)((Identity)identities.get(1)).getRemoteId());
        profileFilter.setSorting(new Sorting(Sorting.SortBy.LASTNAME, Sorting.OrderBy.ASC));
        identities = this.identityStorage.getSpaceMemberIdentitiesByProfileFilter(space, profileFilter, SpaceMemberFilterListAccess.Type.MEMBER, 0L, 9L);
        IdentityStorageTest.assertEquals((int)9, (int)identities.size());
        IdentityStorageTest.assertEquals((String)"First member in list should be 'cba'", (String)"cba", (String)((Identity)identities.get(0)).getRemoteId());
        IdentityStorageTest.assertEquals((String)"Second member in list should be 'bca'", (String)"bca", (String)((Identity)identities.get(1)).getRemoteId());
        identities = this.identityStorage.getSpaceMemberIdentitiesByProfileFilter(space, firstProfileFilter, SpaceMemberFilterListAccess.Type.MEMBER, 0L, 2L);
        IdentityStorageTest.assertEquals((int)2, (int)identities.size());
        Identity username1Identity = this.identityManager.getOrCreateUserIdentity("username1");
        this.tearDownIdentityList.add(username1Identity);
        this.tearDownIdentityList.add(this.identityManager.getOrCreateUserIdentity("username4"));
        firstProfileFilter.setViewerIdentity(username1Identity);
        IdentityStorageTest.assertEquals((int)8, (int)this.identityStorage.countSpaceMemberIdentitiesByProfileFilter(space, firstProfileFilter, SpaceMemberFilterListAccess.Type.MEMBER));
        IdentityStorageTest.addUserToGroupWithMembership("username4", space.getGroupId(), "*");
        identities = this.identityStorage.getSpaceMemberIdentitiesByProfileFilter(space, new ProfileFilter(), SpaceMemberFilterListAccess.Type.MANAGER, 0L, 10L);
        IdentityStorageTest.assertEquals((int)1, (int)identities.size());
        IdentityStorageTest.assertEquals((int)1, (int)this.identityStorage.countSpaceMemberIdentitiesByProfileFilter(space, new ProfileFilter(), SpaceMemberFilterListAccess.Type.INVITED));
        identities = this.identityStorage.getSpaceMemberIdentitiesByProfileFilter(space, new ProfileFilter(), SpaceMemberFilterListAccess.Type.INVITED, 0L, 10L);
        IdentityStorageTest.assertEquals((int)1, (int)identities.size());
        IdentityStorageTest.assertEquals((int)1, (int)this.identityStorage.countSpaceMemberIdentitiesByProfileFilter(space, new ProfileFilter(), SpaceMemberFilterListAccess.Type.PENDING));
        identities = this.identityStorage.getSpaceMemberIdentitiesByProfileFilter(space, new ProfileFilter(), SpaceMemberFilterListAccess.Type.PENDING, 0L, 10L);
        IdentityStorageTest.assertEquals((int)1, (int)identities.size());
    }

    public void testGetDisabledSpaceMembers() throws Exception {
        for (int i = 0; i < 7; ++i) {
            this.populateUser("username" + i);
        }
        this.restartTransaction();
        Space space = new Space();
        space.setApp("app");
        space.setDisplayName("my space");
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space ");
        space.setType("classic");
        space.setVisibility("public");
        space.setPriority("2");
        space.setGroupId(SpaceUtils.createGroup((String)space.getPrettyName(), (String)"username4"));
        space.setUrl(space.getPrettyName());
        String[] managers = new String[]{"username1", "username2"};
        String[] members = new String[]{"username0", "username1", "username2", "username3", "username4"};
        String[] invitedUsers = new String[]{"username5"};
        String[] pendingUsers = new String[]{"username6"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        this.spaceStorage.saveSpace(space, true);
        this.tearDownSpaceList.add(space);
        ProfileFilter profileFilter = new ProfileFilter();
        List identities = this.identityStorage.getSpaceMemberIdentitiesByProfileFilter(space, profileFilter, SpaceMemberFilterListAccess.Type.MEMBER, 0L, 9L);
        IdentityStorageTest.assertEquals((int)5, (int)identities.size());
        identities = this.identityStorage.getSpaceMemberIdentitiesByProfileFilter(space, profileFilter, SpaceMemberFilterListAccess.Type.MANAGER, 0L, 9L);
        IdentityStorageTest.assertEquals((int)2, (int)identities.size());
        this.identityManager.processEnabledIdentity("username2", false);
        this.cachedSpaceStorage.clearSpaceCached(space.getId());
        identities = this.identityStorage.getSpaceMemberIdentitiesByProfileFilter(space, profileFilter, SpaceMemberFilterListAccess.Type.MEMBER, 0L, 9L);
        IdentityStorageTest.assertEquals((int)4, (int)identities.size());
        identities = this.identityStorage.getSpaceMemberIdentitiesByProfileFilter(space, profileFilter, SpaceMemberFilterListAccess.Type.MANAGER, 0L, 9L);
        IdentityStorageTest.assertEquals((int)1, (int)identities.size());
        identities = this.identityStorage.getSpaceMemberIdentitiesByProfileFilter(space, profileFilter, SpaceMemberFilterListAccess.Type.DISABLED, 0L, 9L);
        IdentityStorageTest.assertEquals((int)1, (int)identities.size());
    }

    public void testGetAvatarInputStreamById() throws Exception {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        AvatarAttachment avatarAttachment = new AvatarAttachment(null, "avatar", "png", inputStream, System.currentTimeMillis());
        String userName = "userIdentity2";
        Identity identity = this.populateIdentity(userName);
        this.identityStorage.saveIdentity(identity);
        this.tearDownIdentityList.add(identity);
        String identityId = identity.getId();
        IdentityStorageTest.assertNotNull((Object)identityId);
        InputStream stream = this.identityStorage.getAvatarInputStreamById(identity);
        IdentityStorageTest.assertNotNull((Object)stream);
        FileItem avatarFile = this.identityStorage.getAvatarFile(identity);
        IdentityStorageTest.assertNotNull((Object)avatarFile);
        IdentityStorageTest.assertNotNull((Object)avatarFile.getFileInfo().getId());
        IdentityStorageTest.assertEquals((String)"DEFAULT_AVATAR", (String)avatarFile.getFileInfo().getName());
        Profile profile = new Profile(identity);
        profile.setProperty("avatar", (Object)avatarAttachment);
        this.identityStorage.updateIdentity(identity);
        this.identityStorage.saveProfile(profile);
        profile = this.identityStorage.loadProfile(profile);
        Long avatarLastUpdated = profile.getAvatarLastUpdated();
        IdentityStorageTest.assertNotNull((Object)avatarLastUpdated);
        IdentityStorageTest.assertFalse((boolean)profile.isDefaultAvatar());
        this.restartTransaction();
        this.sleep(10);
        profile.setProperty("avatar", (Object)avatarAttachment);
        this.identityStorage.updateProfile(profile);
        this.restartTransaction();
        this.sleep(10);
        profile = this.identityStorage.loadProfile(profile);
        Long avatarLastUpdated1 = profile.getAvatarLastUpdated();
        IdentityStorageTest.assertNotNull((Object)avatarLastUpdated1);
        IdentityStorageTest.assertTrue((avatarLastUpdated1 > avatarLastUpdated ? 1 : 0) != 0);
        stream = this.identityStorage.getAvatarInputStreamById(identity);
        IdentityStorageTest.assertNotNull((Object)stream);
        Space space = this.getSpaceInstance(1);
        this.spaceStorage.saveSpace(space, true);
        String remoteId = space.getPrettyName();
        IdentityStorageTest.assertNotNull((Object)remoteId);
        identity = new Identity("space", remoteId);
        this.identityStorage.saveIdentity(identity);
        this.tearDownIdentityList.add(identity);
        IdentityStorageTest.assertNotNull((Object)identity.getId());
        IdentityStorageTest.assertNotNull((Object)identity.getRemoteId());
        stream = this.identityStorage.getAvatarInputStreamById(identity);
        IdentityStorageTest.assertNotNull((Object)stream);
        space.setAvatarAttachment(avatarAttachment);
        this.spaceStorage.saveSpace(space, false);
        space = this.spaceStorage.getSpaceByPrettyName(remoteId);
        identity = new Identity("space", space.getPrettyName());
        profile = new Profile(identity);
        profile.setProperty("avatar", (Object)avatarAttachment);
        this.identityStorage.saveIdentity(identity);
        this.identityStorage.saveProfile(profile);
        this.restartTransaction();
        profile = this.identityStorage.loadProfile(profile);
        avatarLastUpdated = profile.getAvatarLastUpdated();
        IdentityStorageTest.assertNotNull((Object)avatarLastUpdated);
        this.restartTransaction();
        this.sleep(10);
        profile.setProperty("avatar", (Object)avatarAttachment);
        this.identityStorage.updateProfile(profile);
        profile = this.identityStorage.loadProfile(profile);
        avatarLastUpdated1 = profile.getAvatarLastUpdated();
        IdentityStorageTest.assertNotNull((Object)avatarLastUpdated1);
        IdentityStorageTest.assertNotSame((Object)avatarLastUpdated1, (Object)avatarLastUpdated);
        IdentityStorageTest.assertTrue((avatarLastUpdated1 > avatarLastUpdated ? 1 : 0) != 0);
        this.tearDownIdentityList.add(identity);
        stream = this.identityStorage.getAvatarInputStreamById(identity);
        IdentityStorageTest.assertNotNull((Object)stream);
    }

    public void testIdentityDefaultAvatar() throws Exception {
        String userName = "userIdentity2";
        Identity identity = this.populateIdentity(userName);
        this.identityStorage.saveIdentity(identity);
        this.tearDownIdentityList.add(identity);
        String identityId = identity.getId();
        IdentityStorageTest.assertNotNull((Object)identityId);
        FileItem avatarFile = this.identityStorage.getAvatarFile(identity);
        Profile profile = new Profile(identity);
        profile = this.identityStorage.loadProfile(profile);
        IdentityStorageTest.assertNotNull((Object)avatarFile);
        IdentityStorageTest.assertNotNull((Object)avatarFile.getFileInfo().getId());
        IdentityStorageTest.assertEquals((String)"DEFAULT_AVATAR", (String)avatarFile.getFileInfo().getName());
        IdentityStorageTest.assertTrue((boolean)profile.isDefaultAvatar());
    }

    public void testGroupIdentityDefaultAvatar() throws Exception {
        Identity groupIdentity = new Identity("group", "testGroup");
        this.identityStorage.saveIdentity(groupIdentity);
        Profile groupProfile = new Profile(groupIdentity);
        this.identityStorage.saveProfile(groupProfile);
        groupIdentity.setProfile(groupProfile);
        this.tearDownIdentityList.add(groupIdentity);
        String groupIdentityId = groupIdentity.getId();
        IdentityStorageTest.assertNotNull((Object)groupIdentityId);
        FileItem groupAvatarFile = this.identityStorage.getAvatarFile(groupIdentity);
        IdentityStorageTest.assertNull((Object)groupAvatarFile);
    }

    public void testIdentityDefaultAvatarWhenRenameUserFirstName() throws Exception {
        String userName = "userIdentity2";
        Identity identity = this.populateIdentity(userName);
        this.identityStorage.saveIdentity(identity);
        this.tearDownIdentityList.add(identity);
        String identityId = identity.getId();
        IdentityStorageTest.assertNotNull((Object)identityId);
        FileItem avatarFile = this.identityStorage.getAvatarFile(identity);
        Profile profile = new Profile(identity);
        profile = this.identityStorage.loadProfile(profile);
        IdentityStorageTest.assertEquals((String)"DEFAULT_AVATAR", (String)avatarFile.getFileInfo().getName());
        IdentityStorageTest.assertTrue((boolean)profile.isDefaultAvatar());
        Long avatarFileId = avatarFile.getFileInfo().getId();
        IdentityStorageTest.assertNotNull((Object)avatarFileId);
        profile.setProperty("firstName", (Object)"alice");
        this.identityStorage.saveProfile(profile);
        this.restartTransaction();
        avatarFile = this.identityStorage.getAvatarFile(identity);
        IdentityStorageTest.assertNotNull((Object)avatarFile);
        Long updatedAvatarFileId = avatarFile.getFileInfo().getId();
        IdentityStorageTest.assertNotNull((Object)updatedAvatarFileId);
        Assert.assertNotEquals((Object)avatarFileId, (Object)updatedAvatarFileId);
    }

    public void testGetBannerInputStreamById() throws Exception {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        BannerAttachment bannerAttachment = new BannerAttachment(null, "banner", "png", inputStream, System.currentTimeMillis());
        String userName = "userIdentity3";
        Identity identity = this.populateIdentity(userName);
        this.identityStorage.saveIdentity(identity);
        this.tearDownIdentityList.add(identity);
        String identityId = identity.getId();
        IdentityStorageTest.assertNotNull((Object)identityId);
        InputStream stream = this.identityStorage.getBannerInputStreamById(identity);
        IdentityStorageTest.assertNull((Object)stream);
        this.sleep(10);
        Profile profile = new Profile(identity);
        profile.setProperty("banner", (Object)bannerAttachment);
        this.identityStorage.updateIdentity(identity);
        this.identityStorage.saveProfile(profile);
        profile = this.identityStorage.loadProfile(profile);
        Long bannerLastUpdated = profile.getBannerLastUpdated();
        IdentityStorageTest.assertNotNull((Object)bannerLastUpdated);
        this.restartTransaction();
        profile.setProperty("banner", (Object)bannerAttachment);
        this.sleep(10);
        this.identityStorage.updateProfile(profile);
        profile = this.identityStorage.loadProfile(profile);
        Long bannerLastUpdated1 = profile.getBannerLastUpdated();
        IdentityStorageTest.assertNotNull((Object)bannerLastUpdated1);
        IdentityStorageTest.assertNotSame((Object)bannerLastUpdated1, (Object)bannerLastUpdated);
        IdentityStorageTest.assertTrue((bannerLastUpdated1 > bannerLastUpdated ? 1 : 0) != 0);
        stream = this.identityStorage.getBannerInputStreamById(identity);
        IdentityStorageTest.assertNotNull((Object)stream);
        Space space = this.getSpaceInstance(1);
        this.spaceStorage.saveSpace(space, true);
        String remoteId = space.getPrettyName();
        IdentityStorageTest.assertNotNull((Object)remoteId);
        identity = new Identity("space", remoteId);
        this.identityStorage.saveIdentity(identity);
        IdentityStorageTest.assertNotNull((Object)identity.getId());
        IdentityStorageTest.assertNotNull((Object)identity.getRemoteId());
        stream = this.identityStorage.getBannerInputStreamById(identity);
        IdentityStorageTest.assertNull((Object)stream);
        space.setBannerAttachment(bannerAttachment);
        this.spaceStorage.saveSpace(space, false);
        space = this.spaceStorage.getSpaceByPrettyName(remoteId);
        identity = new Identity("space", space.getPrettyName());
        profile = new Profile(identity);
        profile.setProperty("banner", (Object)bannerAttachment);
        this.identityStorage.saveIdentity(identity);
        this.identityStorage.saveProfile(profile);
        profile = this.identityStorage.loadProfile(profile);
        bannerLastUpdated = profile.getBannerLastUpdated();
        IdentityStorageTest.assertNotNull((Object)bannerLastUpdated);
        this.restartTransaction();
        this.sleep(10);
        profile.setProperty("banner", (Object)bannerAttachment);
        this.identityStorage.updateProfile(profile);
        profile = this.identityStorage.loadProfile(profile);
        bannerLastUpdated1 = profile.getBannerLastUpdated();
        IdentityStorageTest.assertNotNull((Object)bannerLastUpdated1);
        IdentityStorageTest.assertNotSame((Object)bannerLastUpdated1, (Object)bannerLastUpdated);
        IdentityStorageTest.assertTrue((bannerLastUpdated1 > bannerLastUpdated ? 1 : 0) != 0);
        this.tearDownIdentityList.add(identity);
        stream = this.identityStorage.getBannerInputStreamById(identity);
        IdentityStorageTest.assertNotNull((Object)stream);
    }

    public void testUpdateProfile() throws Exception {
        String userName = "userIdentity4";
        Identity identity = this.populateIdentity(userName);
        this.identityStorage.saveIdentity(identity);
        this.tearDownIdentityList.add(identity);
        Profile profile = identity.getProfile();
        profile.setProperty("gender", (Object)"male");
        profile.setProperty("position", (Object)"developer");
        this.identityStorage.updateProfile(profile);
        identity = this.identityStorage.findIdentity("organization", userName);
        IdentityStorageTest.assertNotNull((Object)identity);
        IdentityStorageTest.assertNotNull((Object)identity.getProfile());
        IdentityStorageTest.assertEquals((String)"male", (String)identity.getProfile().getGender());
        IdentityStorageTest.assertEquals((String)"developer", (String)identity.getProfile().getPosition());
        profile.removeProperty("position");
        this.identityStorage.updateProfile(profile);
        identity = this.identityStorage.findIdentity("organization", userName);
        IdentityStorageTest.assertNotNull((Object)identity);
        IdentityStorageTest.assertNotNull((Object)identity.getProfile());
        IdentityStorageTest.assertEquals((String)"male", (String)identity.getProfile().getGender());
        IdentityStorageTest.assertNull((Object)identity.getProfile().getPosition());
        profile.setProperty("multi-field", Collections.singletonList("new field"));
        this.identityStorage.updateProfile(profile);
        identity = this.identityStorage.findIdentity("organization", userName);
        IdentityStorageTest.assertNotNull((Object)identity);
        IdentityStorageTest.assertNotNull((Object)identity.getProfile());
        IdentityStorageTest.assertNotNull((Object)identity.getProfile().getProperty("multi-field"));
        IdentityStorageTest.assertTrue((boolean)(identity.getProfile().getProperty("multi-field") instanceof ArrayList));
        profile.removeProperty("multi-field");
        this.identityStorage.updateProfile(profile);
        identity = this.identityStorage.findIdentity("organization", userName);
        IdentityStorageTest.assertNotNull((Object)identity);
        IdentityStorageTest.assertNotNull((Object)identity.getProfile());
        IdentityStorageTest.assertNull((Object)identity.getProfile().getProperty("multi-field"));
    }

    private Identity populateIdentity(String remoteId) {
        return this.populateIdentity(remoteId, false);
    }

    private Identity populateIdentity(String remoteId, boolean addedToTearDown) {
        String providerId = "organization";
        Identity identity = new Identity(providerId, remoteId);
        this.identityStorage.saveIdentity(identity);
        Profile profile = new Profile(identity);
        profile.setProperty("firstName", (Object)remoteId);
        profile.setProperty("lastName", (Object)"gtn");
        profile.setProperty("fullName", (Object)(remoteId + " gtn"));
        profile.setProperty("position", (Object)"developer");
        profile.setProperty("gender", (Object)"male");
        this.identityStorage.saveProfile(profile);
        identity.setProfile(profile);
        if (addedToTearDown) {
            this.tearDownIdentityList.add(identity);
        }
        return identity;
    }

    private void populateData() {
        this.populateData(5);
    }

    private void populateData(int number) {
        String providerId = "organization";
        for (int i = 0; i < number; ++i) {
            String remoteId = "username" + i;
            Identity identity = new Identity(providerId, remoteId);
            this.identityStorage.saveIdentity(identity);
            this.tearDownIdentityList.add(identity);
            Profile profile = new Profile(identity);
            profile.setProperty("firstName", (Object)("FirstName" + i));
            profile.setProperty("lastName", (Object)("LastName" + i));
            profile.setProperty("fullName", (Object)("FirstName" + i + " LastName" + i));
            profile.setProperty("position", (Object)"developer");
            profile.setProperty("gender", (Object)"male");
            identity.setProfile(profile);
            this.identityStorage.saveProfile(profile);
        }
    }

    private void populateSpaceData() {
        String[] spaceMembers;
        String providerId = "organization";
        for (String member : spaceMembers = new String[]{"ABC", "ACB", "BAC", "BCA", "CAB", "CBA"}) {
            String remoteId = member.toLowerCase();
            Identity identity = new Identity(providerId, remoteId);
            this.identityStorage.saveIdentity(identity);
            StringBuilder sb = new StringBuilder(member).reverse();
            String lastName = sb.toString();
            Profile profile = new Profile(identity);
            profile.setProperty("firstName", (Object)member);
            profile.setProperty("lastName", (Object)lastName);
            profile.setProperty("fullName", (Object)(member + " " + lastName));
            profile.setProperty("position", (Object)"developer");
            profile.setProperty("gender", (Object)"male");
            identity.setProfile(profile);
            this.tearDownIdentityList.add(identity);
            this.identityStorage.saveProfile(profile);
        }
    }

    private User populateUser(String name) {
        OrganizationService os = SpaceUtils.getOrganizationService();
        User user = os.getUserHandler().createUserInstance(name);
        user.setFirstName(name);
        user.setLastName(name);
        try {
            os.getUserHandler().createUser(user, true);
        }
        catch (Exception e) {
            return null;
        }
        return user;
    }

    private Space getSpaceInstance(int number) {
        Space space = new Space();
        space.setApp("app1,app2");
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setPriority("2");
        space.setGroupId("/spaces/space" + number);
        String[] managers = new String[]{"demo", "tom"};
        String[] members = new String[]{"raul", "ghost", "dragon"};
        String[] invitedUsers = new String[]{"register1", "mary"};
        String[] pendingUsers = new String[]{"jame", "paul", "hacker"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        space.setUrl(space.getPrettyName());
        return space;
    }

    private static void addUserToGroupWithMembership(String remoteId, String groupId, String membership) {
        OrganizationService organizationService = SpaceUtils.getOrganizationService();
        MembershipHandler membershipHandler = organizationService.getMembershipHandler();
        Membership found = membershipHandler.findMembershipByUserGroupAndType(remoteId, groupId, membership);
        if (found == null) {
            User user = organizationService.getUserHandler().findUserByName(remoteId);
            MembershipType membershipType = organizationService.getMembershipTypeHandler().findMembershipType(membership);
            GroupHandler groupHandler = organizationService.getGroupHandler();
            Group existingGroup = groupHandler.findGroupById(groupId);
            membershipHandler.linkMembership(user, existingGroup, membershipType, true);
        }
    }

    private void assertSorted(String remoteIdPrefix, String fieldName, List<Identity> result) {
        List identitiesList = result.stream().map(identity -> identity.getProfile().getProperty(fieldName).toString()).collect(Collectors.toList());
        Iterator iterator = identitiesList.iterator();
        while (iterator.hasNext()) {
            String username = (String)iterator.next();
            if (username.startsWith(remoteIdPrefix)) continue;
            iterator.remove();
        }
        ArrayList identitiesListBackup = new ArrayList(identitiesList);
        Collections.sort(identitiesList);
        IdentityStorageTest.assertEquals((String)("List '" + String.valueOf(identitiesList) + "' is not sorted"), identitiesList, identitiesListBackup);
    }
}

