/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.common.lifecycle.LifeCycleCompletionService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.junit.Before;
import org.junit.Test;

public class GroupSynchronizationSocialProfileListenerTest
extends AbstractCoreTest {
    private OrganizationService organizationService;
    private IdentityManager identityManager;
    private ProfilePropertyService profilePropertyService;
    private LifeCycleCompletionService completionService;
    private Identity paul;
    private Identity john;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.organizationService = (OrganizationService)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
        this.profilePropertyService = (ProfilePropertyService)this.getContainer().getComponentInstanceOfType(ProfilePropertyService.class);
        this.completionService = (LifeCycleCompletionService)this.getContainer().getComponentInstanceOfType(LifeCycleCompletionService.class);
        this.paul = this.identityManager.getOrCreateIdentity("organization", "paul", true);
        this.john = this.identityManager.getOrCreateIdentity("organization", "john", true);
    }

    @Test
    public void testProfilePropertiesGroupSynchronization() throws Exception {
        ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
        profilePropertySetting.setActive(true);
        profilePropertySetting.setEditable(true);
        profilePropertySetting.setVisible(true);
        profilePropertySetting.setPropertyName("postalCode");
        profilePropertySetting.setGroupSynchronized(true);
        profilePropertySetting.setMultiValued(false);
        profilePropertySetting.setParentId(Long.valueOf(0L));
        profilePropertySetting.setOrder(Long.valueOf(0L));
        this.profilePropertyService.createPropertySetting(profilePropertySetting);
        profilePropertySetting.setPropertyName("street");
        this.profilePropertyService.createPropertySetting(profilePropertySetting);
        String paulRemoteId = "paul";
        Profile profile = this.paul.getProfile();
        profile.setProperty("postalCode", (Object)"2100");
        this.identityManager.updateProfile(profile, true);
        this.completionService.waitAllTaskFinished(1000L);
        Group group = this.organizationService.getGroupHandler().findGroupById("/profile/postalcode/2100");
        GroupSynchronizationSocialProfileListenerTest.assertNotNull((Object)group);
        Collection groups = this.organizationService.getGroupHandler().findGroupsOfUser(paulRemoteId);
        GroupSynchronizationSocialProfileListenerTest.assertTrue((boolean)groups.contains(group));
        Group group1 = this.organizationService.getGroupHandler().findGroupById("/profile/street");
        GroupSynchronizationSocialProfileListenerTest.assertNull((Object)group1);
        String propertyName = "propertytest";
        profilePropertySetting.setPropertyName(propertyName);
        this.profilePropertyService.createPropertySetting(profilePropertySetting);
        String groupLabel = "Test'propertytest";
        String expectedGroupName = "test_propertytest";
        StringBuilder expectedGroupId = new StringBuilder();
        expectedGroupId.append("/profile/");
        expectedGroupId.append(propertyName);
        expectedGroupId.append("/");
        expectedGroupId.append(expectedGroupName);
        profile.setProperty("propertytest", (Object)groupLabel);
        this.identityManager.updateProfile(profile, true);
        this.completionService.waitAllTaskFinished(1000L);
        Group group2 = this.organizationService.getGroupHandler().findGroupById(expectedGroupId.toString());
        GroupSynchronizationSocialProfileListenerTest.assertNotNull((Object)group2);
        GroupSynchronizationSocialProfileListenerTest.assertEquals((String)group2.getLabel(), (String)groupLabel);
        GroupSynchronizationSocialProfileListenerTest.assertEquals((String)group2.getGroupName(), (String)expectedGroupName);
        groups = this.organizationService.getGroupHandler().findGroupsOfUser(paulRemoteId);
        GroupSynchronizationSocialProfileListenerTest.assertTrue((boolean)groups.contains(group2));
        GroupSynchronizationSocialProfileListenerTest.assertEquals((int)3, (int)groups.size());
        this.identityManager.updateProfile(profile);
        groups = this.organizationService.getGroupHandler().findGroupsOfUser(paulRemoteId);
        GroupSynchronizationSocialProfileListenerTest.assertEquals((int)3, (int)groups.size());
    }

    @Test
    public void testMultivaluedProfilePropertiesGroupSynchronization() throws Exception {
        ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
        profilePropertySetting.setActive(true);
        profilePropertySetting.setEditable(true);
        profilePropertySetting.setVisible(true);
        profilePropertySetting.setPropertyName("multivaluedProperty");
        profilePropertySetting.setGroupSynchronized(true);
        profilePropertySetting.setMultiValued(true);
        profilePropertySetting.setParentId(Long.valueOf(0L));
        profilePropertySetting.setOrder(Long.valueOf(0L));
        this.profilePropertyService.createPropertySetting(profilePropertySetting);
        Profile profile = this.john.getProfile();
        ArrayList values = new ArrayList();
        HashMap<String, String> value1 = new HashMap<String, String>();
        value1.put("key", null);
        value1.put("value", "multivaluedPropertyValue1");
        values.add(value1);
        HashMap<String, String> value2 = new HashMap<String, String>();
        value2.put("key", null);
        value2.put("value", "multivaluedPropertyValue2");
        values.add(value2);
        profile.setProperty("multivaluedProperty", values);
        this.identityManager.updateProfile(profile, true);
        this.completionService.waitAllTaskFinished(2000L);
        Group group1 = this.organizationService.getGroupHandler().findGroupById("/profile/multivaluedproperty/multivaluedpropertyvalue1");
        GroupSynchronizationSocialProfileListenerTest.assertNotNull((Object)group1);
        Group group2 = this.organizationService.getGroupHandler().findGroupById("/profile/multivaluedproperty/multivaluedpropertyvalue2");
        GroupSynchronizationSocialProfileListenerTest.assertNotNull((Object)group2);
        Collection groups = this.organizationService.getGroupHandler().findGroupsOfUser(this.john.getRemoteId());
        GroupSynchronizationSocialProfileListenerTest.assertTrue((boolean)groups.contains(group1));
        GroupSynchronizationSocialProfileListenerTest.assertTrue((boolean)groups.contains(group2));
        values = new ArrayList();
        HashMap<String, String> value3 = new HashMap<String, String>();
        value3.put("key", null);
        value3.put("value", "multivaluedPropertyValue3");
        values.add(value3);
        values.add(value2);
        profile.setProperty("multivaluedProperty", values);
        this.identityManager.updateProfile(profile, true);
        this.completionService.waitAllTaskFinished(2000L);
        group2 = this.organizationService.getGroupHandler().findGroupById("/profile/multivaluedproperty/multivaluedpropertyvalue2");
        GroupSynchronizationSocialProfileListenerTest.assertNotNull((Object)group2);
        Group group3 = this.organizationService.getGroupHandler().findGroupById("/profile/multivaluedproperty/multivaluedpropertyvalue3");
        GroupSynchronizationSocialProfileListenerTest.assertNotNull((Object)group3);
        groups = this.organizationService.getGroupHandler().findGroupsOfUser(this.john.getRemoteId());
        GroupSynchronizationSocialProfileListenerTest.assertFalse((boolean)groups.contains(group1));
        GroupSynchronizationSocialProfileListenerTest.assertTrue((boolean)groups.contains(group2));
        GroupSynchronizationSocialProfileListenerTest.assertTrue((boolean)groups.contains(group3));
    }
}

