/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.spi;

import java.util.ArrayList;
import java.util.Arrays;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.space.SpacesAdministrationService;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class SpacesAdministrationServiceTest
extends AbstractCoreTest {
    private SpacesAdministrationService spacesAdministrationService;

    @Override
    public void setUp() {
        this.spacesAdministrationService = (SpacesAdministrationService)CommonsUtils.getService(SpacesAdministrationService.class);
    }

    @Override
    public void tearDown() {
    }

    public void testShouldReturnTrueWhenUserIsSuperUser() {
        this.startSessionAs("root");
        boolean spaceCreator = this.spacesAdministrationService.canCreateSpace("root");
        SpacesAdministrationServiceTest.assertTrue((boolean)spaceCreator);
    }

    public void testReturnTrueWhenUserIsMemberofSecondGroup() {
        this.startSessionAs("mary");
        this.spacesAdministrationService.updateSpacesAdministratorsMemberships(Arrays.asList(new MembershipEntry("/organization/management", "manager"), new MembershipEntry("/platform/users", "*")));
        boolean spaceCreator = this.spacesAdministrationService.canCreateSpace("mary");
        SpacesAdministrationServiceTest.assertTrue((boolean)spaceCreator);
    }

    public void testReturnFalseWhenUserIsNotMember() {
        this.startSessionAs("leo");
        ArrayList<MembershipEntry> spaceCreatorsMemberships = new ArrayList<MembershipEntry>();
        spaceCreatorsMemberships.add(new MembershipEntry("/organization/management", "*"));
        this.spacesAdministrationService.updateSpacesCreatorsMemberships(spaceCreatorsMemberships);
        boolean spaceCreator = this.spacesAdministrationService.canCreateSpace("leo");
        SpacesAdministrationServiceTest.assertFalse((boolean)spaceCreator);
    }
}

