/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import io.meeds.social.space.constant.PublicSiteVisibility;
import io.meeds.social.space.constant.Registration;
import io.meeds.social.space.constant.SpaceMembershipStatus;
import io.meeds.social.space.constant.Visibility;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.IdentityWithRelationship;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.storage.entity.ConnectionEntity;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity;
import org.exoplatform.social.core.jpa.storage.entity.ProfileExperienceEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceMemberEntity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EntityConverterUtils {
    public static final String DEFAULT_AVATAR = "DEFAULT_AVATAR";
    private static final Log LOG = ExoLogger.getLogger(EntityConverterUtils.class);

    public static Identity convertToIdentity(IdentityEntity entity) {
        return EntityConverterUtils.convertToIdentity(entity, true);
    }

    public static Identity convertToIdentity(IdentityEntity entity, boolean mapDeleted) {
        if (entity.isDeleted() && !mapDeleted) {
            return null;
        }
        Identity identity = new Identity(entity.getStringId());
        EntityConverterUtils.mapToIdentity(entity, identity);
        return identity;
    }

    public static void mapToIdentity(IdentityEntity entity, Identity identity) {
        identity.setProviderId(entity.getProviderId());
        identity.setRemoteId(entity.getRemoteId());
        identity.setProfileLoader(() -> EntityConverterUtils.convertToProfile(entity, identity));
        identity.setEnable(entity.isEnabled());
        identity.setDeleted(entity.isDeleted());
    }

    public static Profile convertToProfile(IdentityEntity entity, Identity identity) {
        Profile p = new Profile(identity);
        p.setId(String.valueOf(identity.getId()));
        EntityConverterUtils.mapToProfile(entity, p);
        if ("organization".equals(identity.getProviderId()) && p.getProperty("username") == null) {
            p.getProperties().put("username", identity.getRemoteId());
        }
        return p;
    }

    public static void mapToProfile(IdentityEntity entity, Profile p) {
        Map<String, String> properties = entity.getProperties();
        Map props = p.getProperties();
        Identity identity = p.getIdentity();
        Long avatarLastUpdated = null;
        if (entity.getAvatarFileId() != null && entity.getAvatarFileId() > 0L) {
            avatarLastUpdated = EntityConverterUtils.getFileLastUpdated(entity.getAvatarFileId());
            p.setDefaultAvatar(EntityConverterUtils.isDefaultAvatar(entity.getAvatarFileId()));
        } else if (identity.isUser() || identity.isSpace()) {
            avatarLastUpdated = System.currentTimeMillis();
            p.setDefaultAvatar(true);
        }
        Long bannerLastUpdated = null;
        if (entity.getBannerFileId() != null && entity.getBannerFileId() > 0L) {
            bannerLastUpdated = EntityConverterUtils.getFileLastUpdated(entity.getBannerFileId());
        }
        if (!identity.isUser() && !identity.isSpace()) {
            p.setUrl(properties.get("Url"));
            p.setAvatarUrl(LinkProvider.buildAvatarURL(identity.getProviderId(), identity.getRemoteId(), avatarLastUpdated));
            p.setBannerUrl(LinkProvider.buildBannerURL(identity.getProviderId(), identity.getRemoteId(), bannerLastUpdated));
        } else {
            String remoteId = entity.getRemoteId();
            if (identity.isUser()) {
                p.setUrl(LinkProvider.getUserProfileUri(remoteId));
            } else if (identity.isSpace()) {
                p.setUrl(LinkProvider.getSpaceUri(remoteId));
            }
            if (avatarLastUpdated != null) {
                p.setAvatarLastUpdated(avatarLastUpdated);
            }
            if (bannerLastUpdated != null) {
                p.setBannerLastUpdated(bannerLastUpdated);
            }
            p.setAvatarUrl(LinkProvider.buildAvatarURL(identity.getProviderId(), identity.isUser() ? identity.getId() : identity.getRemoteId(), identity.isUser(), avatarLastUpdated));
            p.setBannerUrl(LinkProvider.buildBannerURL(identity.getProviderId(), identity.isUser() ? identity.getId() : identity.getRemoteId(), identity.isUser(), bannerLastUpdated));
        }
        StringBuilder skills = new StringBuilder();
        StringBuilder positions = new StringBuilder();
        Set<ProfileExperienceEntity> experiences = entity.getExperiences();
        if (experiences != null && !experiences.isEmpty()) {
            ArrayList xpData = new ArrayList();
            for (ProfileExperienceEntity exp : experiences) {
                HashMap<String, Object> xpMap = new HashMap<String, Object>();
                if (exp.getSkills() != null && !exp.getSkills().isEmpty()) {
                    skills.append(exp.getSkills()).append(",");
                }
                if (exp.getPosition() != null && !exp.getPosition().isEmpty()) {
                    positions.append(exp.getPosition()).append(",");
                }
                xpMap.put("id", String.valueOf(exp.getId()));
                xpMap.put("skills", exp.getSkills());
                xpMap.put("position", exp.getPosition());
                xpMap.put("startDate", exp.getStartDate());
                xpMap.put("endDate", exp.getEndDate());
                xpMap.put("company", exp.getCompany());
                xpMap.put("description", exp.getDescription());
                xpMap.put("isCurrent", exp.isCurrent());
                xpData.add(xpMap);
            }
            props.put("experiences", xpData);
        }
        if (skills.length() > 0) {
            skills.deleteCharAt(skills.length() - 1);
            props.put("skills", skills.toString());
        }
        if (positions.length() > 0) {
            positions.deleteCharAt(positions.length() - 1);
            props.put("position", positions.toString());
        }
        if (properties != null && properties.size() > 0) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                boolean isJsonArray = false;
                JSONArray arr = null;
                try {
                    arr = new JSONArray(value);
                    isJsonArray = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ("ims".equals(key) || "phones".equals(key) || "urls".equals(key) || isJsonArray) {
                    ArrayList list = new ArrayList();
                    if (arr != null) {
                        try {
                            for (int i = 0; i < arr.length(); ++i) {
                                HashMap<String, String> map = new HashMap<String, String>();
                                JSONObject json = arr.getJSONObject(i);
                                Iterator keys = json.keys();
                                while (keys.hasNext()) {
                                    String k = (String)keys.next();
                                    map.put(k, json.optString(k));
                                }
                                list.add(map);
                            }
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                    props.put(key, list);
                    continue;
                }
                if ("Url".equals(key)) continue;
                props.put(key, value);
            }
        }
        p.setCreatedTime(Long.valueOf(entity.getCreatedDate().getTime()));
        p.setLastLoaded(System.currentTimeMillis());
    }

    public static void mapToEntity(Identity identity, IdentityEntity entity) {
        entity.setProviderId(identity.getProviderId());
        entity.setRemoteId(identity.getRemoteId());
        entity.setEnabled(identity.isEnable());
        entity.setDeleted(identity.isDeleted());
    }

    public static long parseId(String id) {
        try {
            return Long.parseLong(id);
        }
        catch (NumberFormatException ex) {
            return 0L;
        }
    }

    public static List<IdentityWithRelationship> convertToIdentitiesWithRelationship(ListAccess<Map.Entry<IdentityEntity, ConnectionEntity>> list, int offset, int limit) {
        try {
            if (list == null) {
                return Collections.emptyList();
            }
            Map.Entry[] entities = (Map.Entry[])list.load(offset, limit);
            ArrayList<IdentityWithRelationship> result = new ArrayList<IdentityWithRelationship>(limit);
            for (Map.Entry tuple : entities) {
                IdentityEntity identityEntity = (IdentityEntity)tuple.getKey();
                ConnectionEntity connectionEntity = (ConnectionEntity)tuple.getValue();
                IdentityWithRelationship identityWithRelationship = new IdentityWithRelationship(identityEntity.getStringId());
                EntityConverterUtils.mapToIdentity(identityEntity, (Identity)identityWithRelationship);
                Relationship relationship = EntityConverterUtils.convertRelationshipItemToRelationship(connectionEntity);
                identityWithRelationship.setRelationship(relationship);
                result.add(identityWithRelationship);
            }
            return result;
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    public static List<Identity> convertToIdentities(ListAccess<IdentityEntity> list, long offset, long limit) {
        try {
            return EntityConverterUtils.convertToIdentities((IdentityEntity[])list.load((int)offset, (int)limit));
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    public static List<Identity> convertToIdentities(IdentityEntity[] entities) {
        if (entities == null || entities.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(entities).map(EntityConverterUtils::convertToIdentity).toList();
    }

    public static SpaceEntity buildFrom(Space space, SpaceEntity spaceEntity) {
        if (space.getAvatarLastUpdated() != null) {
            spaceEntity.setAvatarLastUpdated(space.getAvatarLastUpdated() > 0L ? new Date(space.getAvatarLastUpdated()) : null);
        } else {
            spaceEntity.setAvatarLastUpdated(null);
        }
        if (space.getBannerLastUpdated() != null) {
            spaceEntity.setBannerLastUpdated(space.getBannerLastUpdated() > 0L ? new Date(space.getBannerLastUpdated()) : null);
        } else {
            spaceEntity.setBannerLastUpdated(null);
        }
        spaceEntity.setCreatedDate(space.getCreatedTime() > 0L ? new Date(space.getCreatedTime()) : new Date());
        spaceEntity.setDescription(space.getDescription());
        spaceEntity.setTemplateId(space.getTemplateId() == 0L ? null : Long.valueOf(space.getTemplateId()));
        spaceEntity.setDisplayName(space.getDisplayName());
        spaceEntity.setGroupId(space.getGroupId());
        spaceEntity.setPrettyName(space.getPrettyName());
        spaceEntity.setPublicSiteId(space.getPublicSiteId());
        spaceEntity.setPublicSiteVisibility(space.getPublicSiteVisibility() == null ? PublicSiteVisibility.MANAGER : PublicSiteVisibility.valueOf(space.getPublicSiteVisibility().toUpperCase()));
        spaceEntity.setDeletePermissions(space.getDeletePermissions());
        spaceEntity.setLayoutPermissions(space.getLayoutPermissions());
        spaceEntity.setPublicSitePermissions(space.getPublicSitePermissions());
        if (space.getRegistration() != null) {
            spaceEntity.setRegistration(Registration.valueOf(space.getRegistration().toUpperCase()));
        }
        spaceEntity.setUrl(space.getUrl());
        Visibility visibility = null;
        if (space.getVisibility() != null) {
            visibility = Visibility.valueOf(space.getVisibility().toUpperCase());
        }
        spaceEntity.setVisibility(visibility);
        EntityConverterUtils.buildMembers(space, spaceEntity);
        return spaceEntity;
    }

    public static Relationship convertRelationshipItemToRelationship(ConnectionEntity item) {
        if (item == null) {
            return null;
        }
        Relationship relationship = new Relationship(Long.toString(item.getId()));
        relationship.setId(String.valueOf(item.getId()));
        relationship.setSender(EntityConverterUtils.convertToIdentity(item.getSender()));
        relationship.setReceiver(EntityConverterUtils.convertToIdentity(item.getReceiver()));
        relationship.setStatus(item.getStatus());
        return relationship;
    }

    private static Long getFileLastUpdated(Long fileId) {
        FileService fileService = (FileService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(FileService.class);
        if (fileService != null) {
            FileInfo fileInfo = fileService.getFileInfo(fileId.longValue());
            if (fileInfo != null && fileInfo.getUpdatedDate() != null) {
                return fileInfo.getUpdatedDate().getTime();
            }
            return null;
        }
        LOG.warn((Object)"File service is null");
        return null;
    }

    private static boolean isDefaultAvatar(Long fileId) {
        FileService fileService = (FileService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(FileService.class);
        FileInfo fileInfo = fileService.getFileInfo(fileId.longValue());
        return fileInfo != null && DEFAULT_AVATAR.equals(fileInfo.getName());
    }

    private static void buildMembers(Space space, SpaceEntity spaceEntity) {
        Set<SpaceMemberEntity> invited = EntityConverterUtils.getMembers(spaceEntity, SpaceMembershipStatus.INVITED);
        EntityConverterUtils.merge(spaceEntity, invited, space.getInvitedUsers(), SpaceMembershipStatus.INVITED);
        Set<SpaceMemberEntity> manager = EntityConverterUtils.getMembers(spaceEntity, SpaceMembershipStatus.MANAGER);
        EntityConverterUtils.merge(spaceEntity, manager, space.getManagers(), SpaceMembershipStatus.MANAGER);
        Set<SpaceMemberEntity> member = EntityConverterUtils.getMembers(spaceEntity, SpaceMembershipStatus.MEMBER);
        EntityConverterUtils.merge(spaceEntity, member, space.getMembers(), SpaceMembershipStatus.MEMBER);
        Set<SpaceMemberEntity> redactor = EntityConverterUtils.getMembers(spaceEntity, SpaceMembershipStatus.REDACTOR);
        EntityConverterUtils.merge(spaceEntity, redactor, space.getRedactors(), SpaceMembershipStatus.REDACTOR);
        Set<SpaceMemberEntity> publisher = EntityConverterUtils.getMembers(spaceEntity, SpaceMembershipStatus.PUBLISHER);
        EntityConverterUtils.merge(spaceEntity, publisher, space.getPublishers(), SpaceMembershipStatus.PUBLISHER);
        Set<SpaceMemberEntity> pending = EntityConverterUtils.getMembers(spaceEntity, SpaceMembershipStatus.PENDING);
        EntityConverterUtils.merge(spaceEntity, pending, space.getPendingUsers(), SpaceMembershipStatus.PENDING);
    }

    private static void merge(SpaceEntity spaceEntity, Set<SpaceMemberEntity> spaceMembers, String[] userIds, SpaceMembershipStatus status) {
        HashSet ids = new HashSet(userIds != null ? Arrays.asList(userIds) : Collections.emptyList());
        for (SpaceMemberEntity mem : spaceMembers) {
            String id = mem.getUserId();
            if (ids.contains(mem.getUserId())) {
                ids.remove(id);
                continue;
            }
            spaceEntity.getMembers().remove(mem);
        }
        for (String id : ids) {
            if (!StringUtils.isNotBlank((CharSequence)id)) continue;
            spaceEntity.getMembers().add(new SpaceMemberEntity(spaceEntity, id, status, Instant.now()));
        }
    }

    private static Set<SpaceMemberEntity> getMembers(SpaceEntity spaceEntity, SpaceMembershipStatus status) {
        HashSet<SpaceMemberEntity> mems = new HashSet<SpaceMemberEntity>();
        for (SpaceMemberEntity mem : spaceEntity.getMembers()) {
            if (!mem.getStatus().equals((Object)status)) continue;
            mems.add(mem);
        }
        return mems;
    }
}

