/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.model.data;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.cache.model.data.CacheData;

public class SpaceData
implements CacheData<Space> {
    private static final long serialVersionUID = 6109309246791818373L;
    private final String id;
    private final String prettyName;
    private final String displayName;
    private final String registration;
    private final String description;
    private final String visibility;
    private final String avatarUrl;
    private final String bannerUrl;
    private final String groupId;
    private final String url;
    private final Long avatarLastUpdated;
    private final Long bannerLastUpdated;
    private final Long createdTime;
    private final Long lastUpdatedTime;
    private final long templateId;
    private final long cacheTime;
    private final String[] members;
    private final String[] redactors;
    private final String[] publishers;
    private final String[] managers;
    private final String[] pendingUser;
    private final String[] invitedUser;
    private long publicSiteId;
    private String publicSiteVisibility;
    private List<String> layoutPermissions;
    private List<String> deletePermissions;
    private List<String> publicSitePermissions;

    public SpaceData(Space space) {
        this.id = space.getId();
        this.templateId = space.getTemplateId();
        this.prettyName = space.getPrettyName();
        this.displayName = space.getDisplayName();
        this.registration = space.getRegistration();
        this.description = space.getDescription();
        this.visibility = space.getVisibility();
        this.avatarLastUpdated = space.getAvatarLastUpdated();
        this.bannerLastUpdated = space.getBannerLastUpdated();
        this.avatarUrl = space.getAvatarUrl();
        this.bannerUrl = space.getBannerUrl();
        this.groupId = space.getGroupId();
        this.url = space.getUrl();
        this.members = space.getMembers();
        this.redactors = space.getRedactors();
        this.publishers = space.getPublishers();
        this.managers = space.getManagers();
        this.pendingUser = space.getPendingUsers();
        this.invitedUser = space.getInvitedUsers();
        this.createdTime = space.getCreatedTime();
        this.publicSiteId = space.getPublicSiteId();
        this.publicSiteVisibility = space.getPublicSiteVisibility();
        this.layoutPermissions = space.getLayoutPermissions();
        this.deletePermissions = space.getDeletePermissions();
        this.publicSitePermissions = space.getPublicSitePermissions();
        this.lastUpdatedTime = space.getLastUpdatedTime();
        this.cacheTime = System.currentTimeMillis();
    }

    @Override
    public Space build() {
        Space space = new Space();
        space.setId(this.id);
        space.setTemplateId(this.templateId);
        space.setDisplayName(this.displayName);
        space.setPrettyName(this.prettyName);
        space.setRegistration(this.registration);
        space.setDescription(this.description);
        space.setVisibility(this.visibility);
        space.setAvatarLastUpdated(this.avatarLastUpdated);
        space.setBannerLastUpdated(this.bannerLastUpdated);
        space.setAvatarUrl(this.avatarUrl);
        space.setBannerUrl(this.bannerUrl);
        space.setGroupId(this.groupId);
        space.setUrl(this.url);
        space.setMembers(this.members);
        space.setRedactors(this.redactors);
        space.setPublishers(this.publishers);
        space.setManagers(this.managers);
        space.setPendingUsers(this.pendingUser);
        space.setInvitedUsers(this.invitedUser);
        space.setCreatedTime(this.createdTime);
        space.setLastUpdatedTime(this.lastUpdatedTime.longValue());
        space.setCacheTime(this.cacheTime);
        space.setPublicSiteId(this.publicSiteId);
        space.setPublicSiteVisibility(this.publicSiteVisibility);
        space.setLayoutPermissions(this.layoutPermissions);
        space.setDeletePermissions(this.deletePermissions);
        space.setPublicSitePermissions(this.publicSitePermissions);
        return space;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpaceData)) {
            return false;
        }
        SpaceData other = (SpaceData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.templateId != other.templateId) {
            return false;
        }
        if (this.cacheTime != other.cacheTime) {
            return false;
        }
        if (this.publicSiteId != other.publicSiteId) {
            return false;
        }
        Long this$avatarLastUpdated = this.avatarLastUpdated;
        Long other$avatarLastUpdated = other.avatarLastUpdated;
        if (this$avatarLastUpdated == null ? other$avatarLastUpdated != null : !((Object)this$avatarLastUpdated).equals(other$avatarLastUpdated)) {
            return false;
        }
        Long this$bannerLastUpdated = this.bannerLastUpdated;
        Long other$bannerLastUpdated = other.bannerLastUpdated;
        if (this$bannerLastUpdated == null ? other$bannerLastUpdated != null : !((Object)this$bannerLastUpdated).equals(other$bannerLastUpdated)) {
            return false;
        }
        Long this$createdTime = this.createdTime;
        Long other$createdTime = other.createdTime;
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        Long this$lastUpdatedTime = this.lastUpdatedTime;
        Long other$lastUpdatedTime = other.lastUpdatedTime;
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$prettyName = this.prettyName;
        String other$prettyName = other.prettyName;
        if (this$prettyName == null ? other$prettyName != null : !this$prettyName.equals(other$prettyName)) {
            return false;
        }
        String this$displayName = this.displayName;
        String other$displayName = other.displayName;
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$registration = this.registration;
        String other$registration = other.registration;
        if (this$registration == null ? other$registration != null : !this$registration.equals(other$registration)) {
            return false;
        }
        String this$description = this.description;
        String other$description = other.description;
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$visibility = this.visibility;
        String other$visibility = other.visibility;
        if (this$visibility == null ? other$visibility != null : !this$visibility.equals(other$visibility)) {
            return false;
        }
        String this$avatarUrl = this.avatarUrl;
        String other$avatarUrl = other.avatarUrl;
        if (this$avatarUrl == null ? other$avatarUrl != null : !this$avatarUrl.equals(other$avatarUrl)) {
            return false;
        }
        String this$bannerUrl = this.bannerUrl;
        String other$bannerUrl = other.bannerUrl;
        if (this$bannerUrl == null ? other$bannerUrl != null : !this$bannerUrl.equals(other$bannerUrl)) {
            return false;
        }
        String this$groupId = this.groupId;
        String other$groupId = other.groupId;
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$url = this.url;
        String other$url = other.url;
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        if (!Arrays.deepEquals(this.members, other.members)) {
            return false;
        }
        if (!Arrays.deepEquals(this.redactors, other.redactors)) {
            return false;
        }
        if (!Arrays.deepEquals(this.publishers, other.publishers)) {
            return false;
        }
        if (!Arrays.deepEquals(this.managers, other.managers)) {
            return false;
        }
        if (!Arrays.deepEquals(this.pendingUser, other.pendingUser)) {
            return false;
        }
        if (!Arrays.deepEquals(this.invitedUser, other.invitedUser)) {
            return false;
        }
        String this$publicSiteVisibility = this.publicSiteVisibility;
        String other$publicSiteVisibility = other.publicSiteVisibility;
        if (this$publicSiteVisibility == null ? other$publicSiteVisibility != null : !this$publicSiteVisibility.equals(other$publicSiteVisibility)) {
            return false;
        }
        List<String> this$layoutPermissions = this.layoutPermissions;
        List<String> other$layoutPermissions = other.layoutPermissions;
        if (this$layoutPermissions == null ? other$layoutPermissions != null : !((Object)this$layoutPermissions).equals(other$layoutPermissions)) {
            return false;
        }
        List<String> this$deletePermissions = this.deletePermissions;
        List<String> other$deletePermissions = other.deletePermissions;
        if (this$deletePermissions == null ? other$deletePermissions != null : !((Object)this$deletePermissions).equals(other$deletePermissions)) {
            return false;
        }
        List<String> this$publicSitePermissions = this.publicSitePermissions;
        List<String> other$publicSitePermissions = other.publicSitePermissions;
        return !(this$publicSitePermissions == null ? other$publicSitePermissions != null : !((Object)this$publicSitePermissions).equals(other$publicSitePermissions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpaceData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $templateId = this.templateId;
        result = result * 59 + (int)($templateId >>> 32 ^ $templateId);
        long $cacheTime = this.cacheTime;
        result = result * 59 + (int)($cacheTime >>> 32 ^ $cacheTime);
        long $publicSiteId = this.publicSiteId;
        result = result * 59 + (int)($publicSiteId >>> 32 ^ $publicSiteId);
        Long $avatarLastUpdated = this.avatarLastUpdated;
        result = result * 59 + ($avatarLastUpdated == null ? 43 : ((Object)$avatarLastUpdated).hashCode());
        Long $bannerLastUpdated = this.bannerLastUpdated;
        result = result * 59 + ($bannerLastUpdated == null ? 43 : ((Object)$bannerLastUpdated).hashCode());
        Long $createdTime = this.createdTime;
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        Long $lastUpdatedTime = this.lastUpdatedTime;
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $prettyName = this.prettyName;
        result = result * 59 + ($prettyName == null ? 43 : $prettyName.hashCode());
        String $displayName = this.displayName;
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $registration = this.registration;
        result = result * 59 + ($registration == null ? 43 : $registration.hashCode());
        String $description = this.description;
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $visibility = this.visibility;
        result = result * 59 + ($visibility == null ? 43 : $visibility.hashCode());
        String $avatarUrl = this.avatarUrl;
        result = result * 59 + ($avatarUrl == null ? 43 : $avatarUrl.hashCode());
        String $bannerUrl = this.bannerUrl;
        result = result * 59 + ($bannerUrl == null ? 43 : $bannerUrl.hashCode());
        String $groupId = this.groupId;
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $url = this.url;
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.members);
        result = result * 59 + Arrays.deepHashCode(this.redactors);
        result = result * 59 + Arrays.deepHashCode(this.publishers);
        result = result * 59 + Arrays.deepHashCode(this.managers);
        result = result * 59 + Arrays.deepHashCode(this.pendingUser);
        result = result * 59 + Arrays.deepHashCode(this.invitedUser);
        String $publicSiteVisibility = this.publicSiteVisibility;
        result = result * 59 + ($publicSiteVisibility == null ? 43 : $publicSiteVisibility.hashCode());
        List<String> $layoutPermissions = this.layoutPermissions;
        result = result * 59 + ($layoutPermissions == null ? 43 : ((Object)$layoutPermissions).hashCode());
        List<String> $deletePermissions = this.deletePermissions;
        result = result * 59 + ($deletePermissions == null ? 43 : ((Object)$deletePermissions).hashCode());
        List<String> $publicSitePermissions = this.publicSitePermissions;
        result = result * 59 + ($publicSitePermissions == null ? 43 : ((Object)$publicSitePermissions).hashCode());
        return result;
    }
}

