/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.social.core.identity.SocialUserSearchServiceImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class UserSearchServiceTest
extends TestCase {
    private final Log LOG = ExoLogger.getLogger(UserSearchServiceTest.class);

    public void testSearch() {
        User[] users;
        int size;
        ListAccess searchUsers;
        SocialUserSearchServiceImpl userSearchService;
        String userId = "testuser";
        UserImpl user = new UserImpl(userId);
        IdentityStorage identityStorageMock = (IdentityStorage)Mockito.mock(IdentityStorage.class);
        OrganizationService orgSrvMock = (OrganizationService)Mockito.mock(OrganizationService.class);
        UserHandler userHandlerMock = (UserHandler)Mockito.mock(UserHandler.class);
        Identity identity = new Identity("organization", userId);
        List<Identity> identities = Collections.singletonList(identity);
        Mockito.when((Object)identityStorageMock.getIdentitiesByProfileFilterCount((String)ArgumentMatchers.eq((Object)"organization"), (ProfileFilter)ArgumentMatchers.any())).thenReturn((Object)1);
        Mockito.when((Object)identityStorageMock.getIdentitiesForMentionsCount((String)ArgumentMatchers.eq((Object)"organization"), (ProfileFilter)ArgumentMatchers.any(), (Relationship.Type)ArgumentMatchers.any())).thenReturn((Object)1);
        Mockito.when((Object)identityStorageMock.getIdentitiesByProfileFilter((String)ArgumentMatchers.eq((Object)"organization"), (ProfileFilter)ArgumentMatchers.any(ProfileFilter.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean())).thenReturn(identities);
        Mockito.when((Object)identityStorageMock.getIdentitiesForMentions((String)ArgumentMatchers.eq((Object)"organization"), (ProfileFilter)ArgumentMatchers.any(ProfileFilter.class), (Relationship.Type)ArgumentMatchers.any(Relationship.Type.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean())).thenReturn(identities);
        try {
            Mockito.when((Object)orgSrvMock.getUserHandler()).thenReturn((Object)userHandlerMock);
            Mockito.when((Object)userHandlerMock.findUserByName((String)ArgumentMatchers.eq((Object)userId))).thenReturn((Object)user);
        }
        catch (Exception e) {
            this.LOG.error((Object)"failed to initialize mock", (Throwable)e);
        }
        try {
            userSearchService = new SocialUserSearchServiceImpl(orgSrvMock, identityStorageMock);
            searchUsers = userSearchService.searchUsers(null);
            size = searchUsers.getSize();
            UserSearchServiceTest.assertEquals((int)1, (int)size);
            users = (User[])searchUsers.load(0, size);
            UserSearchServiceTest.assertNotNull((Object)users);
            UserSearchServiceTest.assertEquals((int)1, (int)users.length);
        }
        catch (Exception e) {
            this.LOG.error((Object)"failed to test search method on UserSearchService", (Throwable)e);
            UserSearchServiceTest.fail((String)("failed to test search method on UserSearchService, cause = " + e.getMessage()));
            return;
        }
        ((IdentityStorage)Mockito.verify((Object)identityStorageMock, (VerificationMode)Mockito.atMost((int)0))).getIdentitiesForMentionsCount(ArgumentMatchers.anyString(), (ProfileFilter)ArgumentMatchers.any(), (Relationship.Type)ArgumentMatchers.any());
        ((IdentityStorage)Mockito.verify((Object)identityStorageMock, (VerificationMode)Mockito.atMost((int)0))).getIdentitiesForMentions(ArgumentMatchers.anyString(), (ProfileFilter)ArgumentMatchers.any(), (Relationship.Type)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
        ((IdentityStorage)Mockito.verify((Object)identityStorageMock, (VerificationMode)Mockito.atLeast((int)1))).getIdentitiesByProfileFilterCount(ArgumentMatchers.anyString(), (ProfileFilter)ArgumentMatchers.any());
        ((IdentityStorage)Mockito.verify((Object)identityStorageMock, (VerificationMode)Mockito.atLeast((int)1))).getIdentitiesByProfileFilter(ArgumentMatchers.anyString(), (ProfileFilter)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
        try {
            userSearchService = new SocialUserSearchServiceImpl(orgSrvMock, identityStorageMock);
            searchUsers = userSearchService.searchUsers("test");
            size = searchUsers.getSize();
            UserSearchServiceTest.assertEquals((int)1, (int)size);
            users = (User[])searchUsers.load(0, size);
            UserSearchServiceTest.assertNotNull((Object)users);
            UserSearchServiceTest.assertEquals((int)1, (int)users.length);
        }
        catch (Exception e) {
            this.LOG.error((Object)"failed to test search method on UserSearchService", (Throwable)e);
            UserSearchServiceTest.fail((String)("failed to test search method on UserSearchService, cause = " + e.getMessage()));
            return;
        }
        ((IdentityStorage)Mockito.verify((Object)identityStorageMock, (VerificationMode)Mockito.atLeast((int)1))).getIdentitiesByProfileFilterCount(ArgumentMatchers.anyString(), (ProfileFilter)ArgumentMatchers.any());
        ((IdentityStorage)Mockito.verify((Object)identityStorageMock, (VerificationMode)Mockito.atLeast((int)1))).getIdentitiesByProfileFilter(ArgumentMatchers.anyString(), (ProfileFilter)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
    }
}

