/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.service;

import io.meeds.social.navigation.AbstractNavigationConfigurationTest;
import io.meeds.social.navigation.constant.SidebarMode;
import io.meeds.social.navigation.model.NavigationConfiguration;
import io.meeds.social.navigation.model.SidebarConfiguration;
import io.meeds.social.navigation.model.SidebarItem;
import io.meeds.social.navigation.model.TopbarConfiguration;
import java.util.Locale;
import org.exoplatform.social.core.space.model.Space;
import org.junit.Before;
import org.junit.Test;

public class NavigationConfigurationServiceTest
extends AbstractNavigationConfigurationTest {
    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        if (this.spaceTemplate == null) {
            this.mockSpaceTemplate();
            for (int i = 0; i < 5; ++i) {
                Space space = new Space();
                space.setRegistration("open");
                space.setVisibility("public");
                space.setTemplateId(this.spaceTemplate.getId());
                this.spaceService.createSpace(space, this.userAcl.getSuperUser());
            }
        }
    }

    @Test
    public void testGetConfiguration() {
        NavigationConfiguration configuration = this.navigationConfigurationService.getConfiguration();
        NavigationConfigurationServiceTest.assertNotNull((Object)configuration);
        NavigationConfigurationServiceTest.assertNotNull((Object)configuration.getTopbar());
        NavigationConfigurationServiceTest.assertNotNull((Object)configuration.getSidebar());
    }

    @Test
    public void testGetConfigurationByUser() {
        NavigationConfiguration configuration = this.navigationConfigurationService.getConfiguration(this.userAcl.getSuperUser(), Locale.FRENCH, true);
        NavigationConfigurationServiceTest.assertNotNull((Object)configuration);
        TopbarConfiguration topbar = configuration.getTopbar();
        NavigationConfigurationServiceTest.assertNotNull((Object)topbar);
        NavigationConfigurationServiceTest.assertTrue((boolean)topbar.isDisplayCompanyName());
        NavigationConfigurationServiceTest.assertTrue((boolean)topbar.isDisplaySiteName());
        SidebarConfiguration sidebar = configuration.getSidebar();
        NavigationConfigurationServiceTest.assertNotNull((Object)sidebar);
        NavigationConfigurationServiceTest.assertTrue((boolean)sidebar.isAllowUserCustomHome());
        NavigationConfigurationServiceTest.assertEquals((int)3, (int)sidebar.getAllowedModes().size());
        NavigationConfigurationServiceTest.assertEquals((Object)SidebarMode.ICON, (Object)sidebar.getDefaultMode());
        NavigationConfigurationServiceTest.assertNotNull((Object)sidebar.getItems());
        NavigationConfigurationServiceTest.assertFalse((boolean)sidebar.getItems().isEmpty());
        SidebarItem item = (SidebarItem)sidebar.getItems().getFirst();
        NavigationConfigurationServiceTest.assertEquals((String)"contribute", (String)item.getName());
    }

    @Test
    public void testSidebarUserMode() {
        NavigationConfiguration configuration = this.navigationConfigurationService.getConfiguration(this.userAcl.getSuperUser(), Locale.FRENCH, true);
        SidebarMode sidebarUserMode = this.navigationConfigurationService.getSidebarUserMode(this.userAcl.getSuperUser());
        NavigationConfigurationServiceTest.assertEquals((Object)configuration.getSidebar().getDefaultMode(), (Object)sidebarUserMode);
        this.navigationConfigurationService.updateSidebarUserMode(this.userAcl.getSuperUser(), SidebarMode.STICKY);
        sidebarUserMode = this.navigationConfigurationService.getSidebarUserMode(this.userAcl.getSuperUser());
        NavigationConfigurationServiceTest.assertEquals((Object)SidebarMode.STICKY, (Object)sidebarUserMode);
        this.navigationConfigurationService.updateSidebarUserMode(this.userAcl.getSuperUser(), SidebarMode.ICON);
        sidebarUserMode = this.navigationConfigurationService.getSidebarUserMode(this.userAcl.getSuperUser());
        NavigationConfigurationServiceTest.assertEquals((Object)SidebarMode.ICON, (Object)sidebarUserMode);
    }
}

