/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.application.SpaceActivityPublisher;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.test.AbstractCoreTest;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;

public class SpaceActivityRDBMSPublisherTest
extends AbstractCoreTest {
    private final Log LOG = ExoLogger.getLogger(SpaceActivityRDBMSPublisherTest.class);
    private IdentityStorage identityStorage;
    private SpaceStorage spaceStorage;
    private SpaceActivityPublisher spaceActivityPublisher;
    private RelationshipManager relationshipManager;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.spaceStorage = this.getService(SpaceStorage.class);
        this.spaceActivityPublisher = this.getService(SpaceActivityPublisher.class);
        this.identityStorage = this.getService(IdentityStorage.class);
        this.relationshipManager = this.getService(RelationshipManager.class);
        SpaceActivityRDBMSPublisherTest.assertNotNull((Object)this.spaceStorage);
        SpaceActivityRDBMSPublisherTest.assertNotNull((Object)this.spaceActivityPublisher);
        SpaceActivityRDBMSPublisherTest.assertNotNull((Object)this.identityStorage);
        this.rootIdentity = this.createIdentity("root");
        this.johnIdentity = this.createIdentity("john");
        this.maryIdentity = this.createIdentity("mary");
        this.demoIdentity = this.createIdentity("demo");
    }

    public void testSpaceCreation() throws Exception {
        Space space = new Space();
        space.setDisplayName("Toto");
        space.setPrettyName(space.getDisplayName());
        space.setGroupId("/platform/users");
        space.setVisibility("private");
        space.setType("classic");
        space.setRegistration("open");
        String[] managers = new String[]{"root"};
        String[] members = new String[]{"root"};
        space.setManagers(managers);
        space.setMembers(members);
        this.spaceService.saveSpace(space, true);
        SpaceActivityRDBMSPublisherTest.assertNotNull((String)"space.getId() must not be null", (Object)space.getId());
        SpaceLifeCycleEvent event = new SpaceLifeCycleEvent(space, this.rootIdentity.getRemoteId(), SpaceLifeCycleEvent.Type.SPACE_CREATED);
        this.spaceActivityPublisher.spaceCreated(event);
        Identity identity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), true);
        RealtimeListAccess listAccess = this.activityManager.getActivitiesOfSpaceWithListAccess(identity);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)1, (int)listAccess.getSize());
        List activities = listAccess.loadAsList(0, 10);
        listAccess = this.activityManager.getActivityFeedWithListAccess(this.rootIdentity);
        List feed = listAccess.loadAsList(0, 10);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)1, (int)feed.size());
        SpaceActivityRDBMSPublisherTest.assertEquals((int)1, (int)listAccess.getSize());
        Relationship relationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.rootIdentity);
        listAccess = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)0, (int)listAccess.loadAsList(0, 10).size());
        SpaceActivityRDBMSPublisherTest.assertEquals((int)0, (int)listAccess.getSize());
        ActivityStream activityStream = ((ExoSocialActivity)activities.get(0)).getActivityStream();
        SpaceActivityRDBMSPublisherTest.assertNotNull((String)"activityStream.getId() must not be null", (Object)activityStream.getId());
        SpaceActivityRDBMSPublisherTest.assertEquals((String)("activityStream.getPrettyId() must return: " + space.getPrettyName()), (String)space.getPrettyName(), (String)activityStream.getPrettyId());
        SpaceActivityRDBMSPublisherTest.assertEquals((Object)ActivityStream.Type.SPACE, (Object)activityStream.getType());
        SpaceActivityRDBMSPublisherTest.assertEquals((String)"space", (String)activityStream.getType().toString());
    }

    public void testSpaceUpdated() throws Exception {
        Space space = new Space();
        space.setDisplayName("Toto");
        space.setPrettyName(space.getDisplayName());
        space.setGroupId("/platform/users");
        space.setVisibility("private");
        space.setRegistration("open");
        space.setType("classic");
        String[] managers = new String[]{"root"};
        String[] members = new String[]{"root"};
        space.setManagers(managers);
        space.setMembers(members);
        this.spaceService.saveSpace(space, true);
        SpaceActivityRDBMSPublisherTest.assertNotNull((String)"space.getId() must not be null", (Object)space.getId());
        SpaceLifeCycleEvent event = new SpaceLifeCycleEvent(space, this.rootIdentity.getRemoteId(), SpaceLifeCycleEvent.Type.SPACE_CREATED);
        this.spaceActivityPublisher.spaceCreated(event);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        String activityId = this.identityStorage.getProfileActivityId(spaceIdentity.getProfile(), Profile.AttachedActivityType.SPACE);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        List comments = this.activityManager.getCommentsWithListAccess(activity).loadAsList(0, 20);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)1, (int)comments.size());
        SpaceActivityRDBMSPublisherTest.assertEquals((String)"Has joined the space.", (String)((ExoSocialActivity)comments.get(0)).getTitle());
        space.setEditor(this.rootIdentity.getRemoteId());
        this.spaceService.renameSpace(space, "Social");
        activity = this.activityManager.getActivity(activityId);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)2, (int)this.activityManager.getCommentsWithListAccess(activity).getSize());
        comments = this.activityManager.getCommentsWithListAccess(activity).loadAsList(0, 20);
        SpaceActivityRDBMSPublisherTest.assertEquals((String)("Name has been updated to: " + space.getDisplayName()), (String)((ExoSocialActivity)comments.get(1)).getTitle());
        space.setDescription("social's team");
        space.setField(Space.UpdatedField.DESCRIPTION);
        this.spaceService.updateSpace(space);
        comments = this.activityManager.getCommentsWithListAccess(activity).loadAsList(0, 20);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)3, (int)comments.size());
        SpaceActivityRDBMSPublisherTest.assertEquals((String)"Description has been updated to: social&#39;s team", (String)((ExoSocialActivity)comments.get(2)).getTitle());
        AvatarAttachment avatar = new AvatarAttachment();
        avatar.setMimeType("plain/text");
        avatar.setInputStream((InputStream)new ByteArrayInputStream("Attachment content".getBytes()));
        space.setAvatarAttachment(avatar);
        this.spaceService.updateSpaceAvatar(space);
        comments = this.activityManager.getCommentsWithListAccess(activity).loadAsList(0, 20);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)4, (int)comments.size());
        SpaceActivityRDBMSPublisherTest.assertEquals((String)"Space has a new avatar.", (String)((ExoSocialActivity)comments.get(3)).getTitle());
        this.activityManager.deleteActivity(activityId);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)0, (int)this.activityManager.getActivitiesWithListAccess(spaceIdentity).getSize());
        space.setField(null);
        this.spaceService.renameSpace(space, "SocialTeam");
        activityId = this.identityStorage.getProfileActivityId(spaceIdentity.getProfile(), Profile.AttachedActivityType.SPACE);
        ExoSocialActivity newActivity = this.activityManager.getActivity(activityId);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)1, (int)this.activityManager.getCommentsWithListAccess(newActivity).getSize());
        String[] spaceManagers = new String[]{"root"};
        String[] spaceMembers = new String[]{"demo"};
        space.setField(null);
        space.setManagers(spaceManagers);
        space.setMembers(spaceMembers);
        space.setEditor("root");
        this.spaceService.setManager(space, "demo", true);
        comments = this.activityManager.getCommentsWithListAccess(newActivity).loadAsList(0, 20);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)2, (int)this.activityManager.getCommentsWithListAccess(newActivity).getSize());
        SpaceActivityRDBMSPublisherTest.assertEquals((String)this.identityManager.getOrCreateIdentity("organization", "root", false).getId(), (String)((ExoSocialActivity)comments.get(1)).getUserId());
        this.spaceService.setManager(space, "demo", false);
        comments = this.activityManager.getCommentsWithListAccess(newActivity).loadAsList(0, 20);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)3, (int)this.activityManager.getCommentsWithListAccess(newActivity).getSize());
        SpaceActivityRDBMSPublisherTest.assertEquals((String)this.identityManager.getOrCreateIdentity("organization", "root", false).getId(), (String)((ExoSocialActivity)comments.get(2)).getUserId());
        SpaceActivityRDBMSPublisherTest.assertEquals((String)"social's team", (String)space.getDescription());
        String newDescription = "new description";
        space.setDescription(newDescription);
        space.setField(Space.UpdatedField.DESCRIPTION);
        String newDisplayName = "newSpaceName";
        this.spaceService.renameSpace(space, newDisplayName);
        comments = this.activityManager.getCommentsWithListAccess(newActivity).loadAsList(0, 20);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)5, (int)comments.size());
        SpaceActivityRDBMSPublisherTest.assertEquals((String)("Name has been updated to: " + space.getDisplayName()), (String)((ExoSocialActivity)comments.get(3)).getTitle());
        SpaceActivityRDBMSPublisherTest.assertEquals((String)("Description has been updated to: " + space.getDescription()), (String)((ExoSocialActivity)comments.get(4)).getTitle());
        SpaceActivityRDBMSPublisherTest.assertEquals((String)"new description", (String)space.getDescription());
        space.setDescription("Cet espace est \u00e0 chercher des bugs");
        space.setField(Space.UpdatedField.DESCRIPTION);
        this.spaceService.updateSpace(space);
        comments = this.activityManager.getCommentsWithListAccess(newActivity).loadAsList(0, 20);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)6, (int)comments.size());
    }

    public void testSpaceHidden() throws Exception {
        Space space = new Space();
        space.setDisplayName("Toto");
        space.setPrettyName(space.getDisplayName());
        space.setGroupId("/platform/users");
        space.setVisibility("hidden");
        space.setRegistration("open");
        String[] managers = new String[]{"root"};
        String[] members = new String[]{"root"};
        space.setManagers(managers);
        space.setMembers(members);
        this.spaceService.saveSpace(space, true);
        SpaceLifeCycleEvent event = new SpaceLifeCycleEvent(space, this.rootIdentity.getRemoteId(), SpaceLifeCycleEvent.Type.SPACE_CREATED);
        this.spaceActivityPublisher.spaceCreated(event);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        RealtimeListAccess spaceActivities = this.activityManager.getActivitiesOfSpaceWithListAccess(spaceIdentity);
        RealtimeListAccess userFeedActivities = this.activityManager.getActivityFeedWithListAccess(this.rootIdentity);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)0, (int)userFeedActivities.getSize());
        SpaceActivityRDBMSPublisherTest.assertEquals((int)0, (int)spaceActivities.getSize());
        space.setVisibility("private");
        this.spaceService.saveSpace(space, false);
        spaceActivities = this.activityManager.getActivitiesOfSpaceWithListAccess(spaceIdentity);
        userFeedActivities = this.activityManager.getActivityFeedWithListAccess(this.rootIdentity);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)1, (int)spaceActivities.getSize());
        SpaceActivityRDBMSPublisherTest.assertEquals((int)1, (int)((ExoSocialActivity[])spaceActivities.load(0, 10)).length);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)1, (int)userFeedActivities.getSize());
        SpaceActivityRDBMSPublisherTest.assertEquals((int)1, (int)((ExoSocialActivity[])userFeedActivities.load(0, 10)).length);
        space.setVisibility("hidden");
        this.spaceService.saveSpace(space, false);
        spaceActivities = this.activityManager.getActivitiesOfSpaceWithListAccess(spaceIdentity);
        userFeedActivities = this.activityManager.getActivityFeedWithListAccess(this.rootIdentity);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)0, (int)spaceActivities.getSize());
        SpaceActivityRDBMSPublisherTest.assertEquals((int)0, (int)((ExoSocialActivity[])spaceActivities.load(0, 10)).length);
        SpaceActivityRDBMSPublisherTest.assertEquals((int)0, (int)userFeedActivities.getSize());
        SpaceActivityRDBMSPublisherTest.assertEquals((int)0, (int)((ExoSocialActivity[])userFeedActivities.load(0, 10)).length);
    }
}

