/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.search;

import java.util.HashMap;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.social.core.search.SearchConnector;
import org.exoplatform.social.core.search.SearchConnectorPlugin;
import org.exoplatform.social.core.search.impl.SearchServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class SearchServiceTest {
    private SearchServiceImpl searchService;

    @Before
    public void setup() {
        HashMap settingValues = new HashMap();
        SettingService settingService = (SettingService)Mockito.mock(SettingService.class);
        ((SettingService)Mockito.doAnswer(invocation -> {
            Context context = (Context)invocation.getArgument(0, Context.class);
            Scope scope = (Scope)invocation.getArgument(1, Scope.class);
            String key = (String)invocation.getArgument(2, String.class);
            SettingValue value = (SettingValue)invocation.getArgument(3, SettingValue.class);
            String settingKey = context.getId() + context.getName() + scope.getId() + scope.getName() + key;
            settingValues.put(settingKey, value.toString());
            return null;
        }).when((Object)settingService)).set((Context)Matchers.any(Context.class), (Scope)Matchers.any(Scope.class), Matchers.anyString(), (SettingValue)Matchers.any(SettingValue.class));
        Mockito.when((Object)settingService.get((Context)Matchers.any(Context.class), (Scope)Matchers.any(Scope.class), Matchers.anyString())).thenAnswer(invocation -> {
            Context context = (Context)invocation.getArgument(0, Context.class);
            Scope scope = (Scope)invocation.getArgument(1, Scope.class);
            String key = (String)invocation.getArgument(2, String.class);
            String settingKey = context.getId() + context.getName() + scope.getId() + scope.getName() + key;
            String value = (String)settingValues.get(settingKey);
            return value == null ? null : SettingValue.create((String)value);
        });
        this.searchService = new SearchServiceImpl(settingService);
    }

    @Test
    public void testAddConnector() {
        InitParams params = new InitParams();
        ObjectParameter objectParameter = new ObjectParameter();
        SearchConnector searchConnector = new SearchConnector();
        searchConnector.setEnabled(false);
        searchConnector.setName("testConnector");
        searchConnector.setUri("uri");
        objectParameter.setObject((Object)searchConnector);
        params.addParam((Object)objectParameter);
        SearchConnectorPlugin connectorPlugin = new SearchConnectorPlugin(params);
        this.searchService.addConnector(connectorPlugin);
        Assert.assertNotNull((Object)this.searchService.getConnectors());
        Assert.assertEquals((long)1L, (long)this.searchService.getConnectors().size());
    }

    @Test
    public void testGetConnectors() {
        InitParams params = new InitParams();
        ObjectParameter objectParameter = new ObjectParameter();
        SearchConnector searchConnector = new SearchConnector();
        searchConnector.setEnabled(false);
        searchConnector.setName("testConnector");
        searchConnector.setUri("uri");
        objectParameter.setObject((Object)searchConnector);
        params.addParam((Object)objectParameter);
        SearchConnectorPlugin connectorPlugin = new SearchConnectorPlugin(params);
        this.searchService.addConnector(connectorPlugin);
        Assert.assertNotNull((Object)this.searchService.getConnectors());
        Assert.assertEquals((long)1L, (long)this.searchService.getConnectors().size());
        try {
            this.searchService.getConnectors().iterator().remove();
            Assert.fail((String)"Returned list must be unmodifiable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SearchConnector searchConnectorResult = (SearchConnector)this.searchService.getConnectors().iterator().next();
        Assert.assertNotNull((Object)searchConnectorResult);
        Assert.assertFalse((boolean)searchConnectorResult.isEnabled());
        Assert.assertEquals((Object)"testConnector", (Object)searchConnectorResult.getName());
        Assert.assertEquals((Object)"uri", (Object)searchConnectorResult.getUri());
        searchConnectorResult.setEnabled(true);
        Assert.assertTrue((boolean)searchConnectorResult.isEnabled());
        searchConnectorResult = (SearchConnector)this.searchService.getConnectors().iterator().next();
        Assert.assertNotNull((Object)searchConnectorResult);
        Assert.assertFalse((String)"modification made on returned object, should not be applied on original objects of service", (boolean)searchConnectorResult.isEnabled());
    }

    @Test
    public void testGetEnabledConnectors() {
        InitParams params = new InitParams();
        ObjectParameter objectParameter = new ObjectParameter();
        SearchConnector searchConnector = new SearchConnector();
        searchConnector.setEnabled(true);
        searchConnector.setName("testConnector");
        searchConnector.setUri("uri");
        objectParameter.setObject((Object)searchConnector);
        params.addParam((Object)objectParameter);
        SearchConnectorPlugin connectorPlugin = new SearchConnectorPlugin(params);
        this.searchService.addConnector(connectorPlugin);
        Assert.assertNotNull((Object)this.searchService.getEnabledConnectors());
        Assert.assertEquals((long)1L, (long)this.searchService.getEnabledConnectors().size());
        try {
            this.searchService.getEnabledConnectors().iterator().remove();
            Assert.fail((String)"Returned list must be unmodifiable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SearchConnector searchConnectorResult = (SearchConnector)this.searchService.getEnabledConnectors().iterator().next();
        Assert.assertNotNull((Object)searchConnectorResult);
        Assert.assertTrue((boolean)searchConnectorResult.isEnabled());
        Assert.assertEquals((Object)"testConnector", (Object)searchConnectorResult.getName());
        Assert.assertEquals((Object)"uri", (Object)searchConnectorResult.getUri());
        this.searchService.setConnectorAsEnabled(searchConnector.getName(), false);
        Assert.assertNotNull((Object)this.searchService.getEnabledConnectors());
        Assert.assertEquals((long)0L, (long)this.searchService.getEnabledConnectors().size());
    }

    @Test
    public void testSetConnectorAsEnabled() {
        InitParams params = new InitParams();
        ObjectParameter objectParameter = new ObjectParameter();
        SearchConnector searchConnector = new SearchConnector();
        searchConnector.setEnabled(false);
        searchConnector.setName("testConnector");
        searchConnector.setUri("uri");
        objectParameter.setObject((Object)searchConnector);
        params.addParam((Object)objectParameter);
        SearchConnectorPlugin connectorPlugin = new SearchConnectorPlugin(params);
        this.searchService.addConnector(connectorPlugin);
        Assert.assertNotNull((Object)this.searchService.getConnectors());
        Assert.assertEquals((long)1L, (long)this.searchService.getConnectors().size());
        SearchConnector searchConnectorResult = (SearchConnector)this.searchService.getConnectors().iterator().next();
        Assert.assertNotNull((Object)searchConnectorResult);
        this.searchService.setConnectorAsEnabled(searchConnectorResult.getName(), true);
        searchConnectorResult = (SearchConnector)this.searchService.getConnectors().iterator().next();
        Assert.assertNotNull((Object)searchConnectorResult);
        Assert.assertTrue((String)"modification made using setConnectorAsEnabled, should be applied on original objects of service", (boolean)searchConnectorResult.isEnabled());
    }

    @Test
    public void testGetEnabledConnectorNames() {
        InitParams params = new InitParams();
        ObjectParameter objectParameter = new ObjectParameter();
        SearchConnector searchConnector = new SearchConnector();
        searchConnector.setEnabled(false);
        searchConnector.setName("testConnector");
        searchConnector.setUri("uri");
        objectParameter.setObject((Object)searchConnector);
        params.addParam((Object)objectParameter);
        SearchConnectorPlugin connectorPlugin = new SearchConnectorPlugin(params);
        this.searchService.addConnector(connectorPlugin);
        Assert.assertNotNull((Object)this.searchService.getConnectors());
        Assert.assertEquals((long)1L, (long)this.searchService.getConnectors().size());
        Assert.assertNotNull((Object)this.searchService.getEnabledConnectorNames());
        Assert.assertEquals((long)0L, (long)this.searchService.getEnabledConnectorNames().size());
        SearchConnector searchConnectorResult = (SearchConnector)this.searchService.getConnectors().iterator().next();
        Assert.assertNotNull((Object)searchConnectorResult);
        this.searchService.setConnectorAsEnabled(searchConnectorResult.getName(), true);
        Assert.assertNotNull((Object)this.searchService.getEnabledConnectorNames());
        Assert.assertEquals((long)1L, (long)this.searchService.getEnabledConnectorNames().size());
    }
}

