/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.feature;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class SpaceLastVisitedTest
extends AbstractCoreTest {
    private SpaceService spaceService;
    private IdentityStorage identityStorage;
    private List<Space> tearDownSpaceList;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.tearDownSpaceList = new ArrayList<Space>();
        SpaceLastVisitedTest.assertNotNull((Object)this.identityStorage);
        SpaceLastVisitedTest.assertNotNull(this.tearDownSpaceList);
        this.rootIdentity = new Identity("organization", "root");
        this.johnIdentity = new Identity("organization", "john");
        this.maryIdentity = new Identity("organization", "mary");
        this.demoIdentity = new Identity("organization", "demo");
        this.identityStorage.saveIdentity(this.rootIdentity);
        this.identityStorage.saveIdentity(this.johnIdentity);
        this.identityStorage.saveIdentity(this.maryIdentity);
        this.identityStorage.saveIdentity(this.demoIdentity);
        SpaceLastVisitedTest.assertNotNull((Object)this.rootIdentity.getId());
        SpaceLastVisitedTest.assertNotNull((Object)this.johnIdentity.getId());
        SpaceLastVisitedTest.assertNotNull((Object)this.maryIdentity.getId());
        SpaceLastVisitedTest.assertNotNull((Object)this.demoIdentity.getId());
    }

    @Override
    protected void tearDown() throws Exception {
        for (Space space : this.tearDownSpaceList) {
            Identity spaceIdentity = this.identityStorage.findIdentity("space", space.getPrettyName());
            if (spaceIdentity != null) {
                this.identityStorage.deleteIdentity(spaceIdentity);
            }
            this.spaceService.deleteSpace(space);
        }
        this.identityStorage.deleteIdentity(this.rootIdentity);
        this.identityStorage.deleteIdentity(this.johnIdentity);
        this.identityStorage.deleteIdentity(this.maryIdentity);
        this.identityStorage.deleteIdentity(this.demoIdentity);
        super.tearDown();
    }

    private Space getSpaceInstance(int number, String apps) throws Exception {
        Space space = new Space();
        space.setDisplayName("space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/space/space" + number);
        space.setApp(apps);
        String[] managers = new String[]{"john", "mary"};
        String[] members = new String[]{"john", "mary", "demo"};
        space.setManagers(managers);
        space.setMembers(members);
        space.setUrl(space.getPrettyName());
        this.spaceService.saveSpace(space, true);
        return space;
    }
}

