/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.apache.commons.lang3.ArrayUtils;
import org.exoplatform.commons.testing.BaseExoTestCase;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.core.storage.cache.CachedSpaceStorage;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/exo.social.component.core-local-root-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.core-local-configuration.xml")})
public abstract class AbstractCoreTest
extends BaseExoTestCase {
    public static boolean wantCount = false;
    private static int count;
    private int maxQuery;
    private final Log LOG = ExoLogger.getLogger(AbstractCoreTest.class);
    protected SpaceService spaceService;
    protected IdentityManager identityManager;
    protected IdentityRegistry identityRegistry;

    protected void setUp() throws Exception {
        this.begin();
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
        this.deleteAllSpaces();
    }

    protected void tearDown() throws Exception {
        this.deleteAllSpaces();
        wantCount = false;
        this.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteAllSpaces() throws SpaceException {
        List allSpaces = this.spaceService.getAllSpaces();
        if (allSpaces != null && !allSpaces.isEmpty()) {
            for (Space space : allSpaces) {
                try {
                    this.spaceService.deleteSpace(space);
                }
                catch (Throwable e) {
                    this.LOG.warn("The space {} wasn't cleaned up properly. This may be due to bad cache management", new Object[]{space.getDisplayName()});
                }
                finally {
                    this.restartTransaction();
                }
            }
        }
        CachedSpaceStorage spaceStorage = (CachedSpaceStorage)this.getService(SpaceStorage.class);
        spaceStorage.clearCaches();
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)this.getContainer().getComponentInstanceOfType(clazz);
    }

    protected void runTest() throws Throwable {
        String fName = this.getName();
        AbstractCoreTest.assertNotNull((String)"TestCase.fName cannot be null", (Object)fName);
        Method runMethod = null;
        try {
            runMethod = ((Object)((Object)this)).getClass().getMethod(fName, null);
        }
        catch (NoSuchMethodException e) {
            AbstractCoreTest.fail((String)("Method \"" + fName + "\" not found"));
        }
        if (!Modifier.isPublic(runMethod.getModifiers())) {
            AbstractCoreTest.fail((String)("Method \"" + fName + "\" should be public"));
        }
        try {
            runMethod.invoke((Object)this, new Object[0]);
        }
        catch (InvocationTargetException e) {
            e.fillInStackTrace();
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            e.fillInStackTrace();
            throw e;
        }
        if (wantCount && count > this.maxQuery) {
            throw new AssertionFailedError(count + " JDBC queries was executed but the maximum is : " + this.maxQuery);
        }
    }

    protected Identity startSessionAndRegisterAs(String user) {
        Identity userAcl = this.startSessionAs(user, Collections.singleton(new MembershipEntry("/platform/users", "member")));
        this.identityRegistry.register(userAcl);
        return userAcl;
    }

    protected Identity startSessionAs(String user) {
        return this.startSessionAs(user, Collections.singleton(new MembershipEntry("/platform/users", "member")));
    }

    protected Identity startSessionAs(String user, Collection<MembershipEntry> memberships) {
        Identity identity = new Identity(user, memberships);
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
        return identity;
    }

    public Space getSpaceInstance(int number, String visible, String registration, String manager, String ... members) {
        Space space = new Space();
        space.setApp("app");
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration(registration);
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility(visible);
        space.setPriority("2");
        space.setGroupId("/spaces/space" + number);
        String[] managers = new String[]{manager};
        String[] invitedUsers = new String[]{};
        String[] pendingUsers = new String[]{};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        space.setUrl(space.getPrettyName());
        return space;
    }

    protected Space createSpaceNonInitApps(Space space, String creator, String invitedGroupId) {
        String groupId = null;
        try {
            groupId = SpaceUtils.createGroup((String)space.getDisplayName(), (String)creator);
        }
        catch (SpaceException e) {
            this.LOG.error((Object)"Error while creating group", (Throwable)e);
        }
        if (invitedGroupId != null) {
            OrganizationService org = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
            try {
                PageList groupMembersAccess = org.getUserHandler().findUsersByGroup(invitedGroupId);
                List users = groupMembersAccess.getAll();
                for (User user : users) {
                    Object[] invitedUsers;
                    String userId = user.getUserName();
                    if (userId.equals(creator) || ArrayUtils.contains((Object[])(invitedUsers = space.getInvitedUsers()), (Object)userId)) continue;
                    invitedUsers = (String[])ArrayUtils.add((Object[])invitedUsers, (Object)userId);
                    space.setInvitedUsers((String[])invitedUsers);
                }
            }
            catch (Exception e) {
                this.LOG.error((Object)("Failed to invite users from group " + invitedGroupId), (Throwable)e);
            }
        }
        String[] managers = new String[]{creator};
        space.setManagers(managers);
        space.setGroupId(groupId);
        space.setUrl(space.getPrettyName());
        try {
            this.spaceService.saveSpace(space, true);
        }
        catch (SpaceException e) {
            this.LOG.warn((Object)"Error while saving space", (Throwable)e);
        }
        return space;
    }

    protected org.exoplatform.social.core.identity.model.Identity createOrUpdateIdentity(String remoteId) {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", remoteId);
        identity.setDeleted(false);
        identity.setEnable(true);
        this.identityManager.updateIdentity(identity);
        return identity;
    }

    protected void addUserToGroupWithMembership(String remoteId, String groupId, String membership) {
        OrganizationService organizationService = SpaceUtils.getOrganizationService();
        try {
            MembershipHandler membershipHandler = organizationService.getMembershipHandler();
            Membership found = membershipHandler.findMembershipByUserGroupAndType(remoteId, groupId, membership);
            if (found != null) {
                return;
            }
            User user = organizationService.getUserHandler().findUserByName(remoteId);
            MembershipType membershipType = organizationService.getMembershipTypeHandler().findMembershipType(membership);
            GroupHandler groupHandler = organizationService.getGroupHandler();
            Group existingGroup = groupHandler.findGroupById(groupId);
            membershipHandler.linkMembership(user, existingGroup, membershipType, true);
        }
        catch (Exception e) {
            return;
        }
    }
}

