/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.impl;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.DynamicPortalLayoutMatcher;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class DynamicSpacePortalLayoutMatcher
extends DynamicPortalLayoutMatcher {
    private String spaceTemplateRegex = null;
    private Pattern spaceTemplatePattern = null;
    private SpaceService spaceService = null;

    public void setSpaceTemplateRegex(String spaceTemplateRegex) {
        this.spaceTemplateRegex = spaceTemplateRegex;
    }

    public Pattern getSpaceTemplatePattern() {
        if (this.spaceTemplatePattern == null && StringUtils.isNotBlank((CharSequence)this.spaceTemplateRegex)) {
            this.spaceTemplatePattern = Pattern.compile(this.spaceTemplateRegex);
        }
        return this.spaceTemplatePattern;
    }

    public boolean matches(SiteKey siteKey, String currentSiteName) {
        if (!super.matches(siteKey, currentSiteName)) {
            return false;
        }
        if (this.isSpaceSite(siteKey)) {
            Space space = this.getSpaceService().getSpaceByGroupId(siteKey.getName());
            if (space == null) {
                return false;
            }
            if (this.getSpaceTemplatePattern() == null) {
                return true;
            }
            return space.getTemplate() != null && this.getSpaceTemplatePattern().matcher(space.getTemplate()).matches();
        }
        return false;
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
        }
        return this.spaceService;
    }

    public void setSpaceService(SpaceService spaceService) {
        this.spaceService = spaceService;
    }

    private boolean isSpaceSite(SiteKey siteKey) {
        return SiteType.GROUP.equals((Object)siteKey.getType()) && siteKey.getName().startsWith("/spaces");
    }
}

