/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activity;

import java.util.Collections;
import java.util.List;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.ActivityFilter;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.impl.StorageUtils;

public class ActivitiesRealtimeListAccess
implements RealtimeListAccess<ExoSocialActivity> {
    private ActivityStorage activityStorage;
    private ActivityType activityType;
    private Identity ownerIdentity;
    private Identity viewerIdentity;
    private String[] activityTypes;
    private ActivityFilter activityFilter;

    public ActivitiesRealtimeListAccess(ActivityStorage existingActivityStorage, ActivityType chosenActivityType) {
        this.activityStorage = existingActivityStorage;
        this.activityType = chosenActivityType;
    }

    public ActivitiesRealtimeListAccess(ActivityStorage existingActivityStorage, ActivityType chosenActivityType, Identity chosenOwnerIdentity) {
        this.activityStorage = existingActivityStorage;
        this.activityType = chosenActivityType;
        this.ownerIdentity = chosenOwnerIdentity;
    }

    public ActivitiesRealtimeListAccess(ActivityStorage existingActivityStorage, ActivityType chosenActivityType, Identity chosenOwnerIdentity, String ... activityTypes) {
        this.activityStorage = existingActivityStorage;
        this.activityType = chosenActivityType;
        this.ownerIdentity = chosenOwnerIdentity;
        this.activityTypes = activityTypes;
    }

    public ActivitiesRealtimeListAccess(ActivityStorage existingActivityStorage, ActivityType chosenActivityType, Identity chosenOwnerIdentity, Identity viewerIndentity) {
        this.activityStorage = existingActivityStorage;
        this.activityType = chosenActivityType;
        this.ownerIdentity = chosenOwnerIdentity;
        this.viewerIdentity = viewerIndentity;
    }

    public ActivitiesRealtimeListAccess(ActivityStorage activityStorage, Identity viewerIdentity, ActivityFilter activityFilter) {
        this.activityStorage = activityStorage;
        this.viewerIdentity = viewerIdentity;
        this.activityFilter = activityFilter;
    }

    public List<String> loadIdsAsList(int index, int limit) {
        if (this.activityFilter != null) {
            return this.activityStorage.getActivityIdsByFilter(this.viewerIdentity, this.activityFilter, (long)index, (long)limit);
        }
        if (this.activityType != null) {
            switch (this.activityType.ordinal()) {
                case 0: {
                    return this.activityStorage.getActivityIdsFeed(this.ownerIdentity, index, limit);
                }
                case 1: {
                    return this.activityStorage.getUserIdsActivities(this.ownerIdentity, (long)index, (long)limit);
                }
                case 2: {
                    return StorageUtils.getIds(this.activityStorage.getActivities(this.ownerIdentity, this.viewerIdentity, (long)index, (long)limit));
                }
                case 3: {
                    return this.activityStorage.getActivityIdsOfConnections(this.ownerIdentity, index, limit);
                }
                case 4: {
                    return this.activityStorage.getUserSpacesActivityIds(this.ownerIdentity, index, limit);
                }
                case 5: {
                    return this.activityStorage.getSpaceActivityIds(this.ownerIdentity, index, limit);
                }
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public List<ExoSocialActivity> loadAsList(int index, int limit) {
        if (this.activityFilter != null) {
            return this.activityStorage.getActivitiesByFilter(this.viewerIdentity, this.activityFilter, (long)index, (long)limit);
        }
        if (this.activityType != null) {
            switch (this.activityType.ordinal()) {
                case 0: {
                    return this.activityStorage.getActivityFeed(this.ownerIdentity, index, limit);
                }
                case 1: {
                    return this.activityStorage.getUserActivities(this.ownerIdentity, (long)index, (long)limit);
                }
                case 2: {
                    return this.activityStorage.getActivities(this.ownerIdentity, this.viewerIdentity, (long)index, (long)limit);
                }
                case 3: {
                    return this.activityStorage.getActivitiesOfConnections(this.ownerIdentity, index, limit);
                }
                case 4: {
                    return this.activityStorage.getUserSpacesActivities(this.ownerIdentity, index, limit);
                }
                case 5: {
                    return this.activityStorage.getSpaceActivities(this.ownerIdentity, index, limit);
                }
                case 6: {
                    return this.activityStorage.getActivitiesByPoster(this.ownerIdentity, index, limit);
                }
                case 7: {
                    return this.activityStorage.getActivitiesByPoster(this.ownerIdentity, index, limit, this.activityTypes);
                }
                case 8: {
                    return this.activityStorage.getAllActivities(index, limit);
                }
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public ExoSocialActivity[] load(int index, int limit) {
        return (ExoSocialActivity[])RealtimeListAccess.convertListToArray(this.loadAsList(index, limit), ExoSocialActivity.class);
    }

    public int getSize() {
        if (this.activityFilter != null) {
            return this.activityStorage.getActivitiesCountByFilter(this.viewerIdentity, this.activityFilter);
        }
        if (this.activityType != null) {
            switch (this.activityType.ordinal()) {
                case 0: {
                    return this.activityStorage.getNumberOfActivitesOnActivityFeed(this.ownerIdentity);
                }
                case 1: {
                    return this.activityStorage.getNumberOfUserActivities(this.ownerIdentity);
                }
                case 3: {
                    return this.activityStorage.getNumberOfActivitiesOfConnections(this.ownerIdentity);
                }
                case 4: {
                    return this.activityStorage.getNumberOfUserSpacesActivities(this.ownerIdentity);
                }
                case 5: {
                    return this.activityStorage.getNumberOfSpaceActivities(this.ownerIdentity);
                }
                case 6: {
                    return this.activityStorage.getNumberOfActivitiesByPoster(this.ownerIdentity);
                }
                case 7: {
                    return 0;
                }
                case 2: {
                    return this.activityStorage.getNumberOfActivitiesByPoster(this.ownerIdentity, this.viewerIdentity);
                }
            }
        }
        return 0;
    }

    public List<ExoSocialActivity> loadNewer(ExoSocialActivity baseActivity, int length) {
        switch (this.activityType.ordinal()) {
            case 0: {
                return this.activityStorage.getNewerOnActivityFeed(this.ownerIdentity, baseActivity, length);
            }
            case 1: {
                return this.activityStorage.getNewerOnUserActivities(this.ownerIdentity, baseActivity, length);
            }
            case 3: {
                return this.activityStorage.getNewerOnActivitiesOfConnections(this.ownerIdentity, baseActivity, (long)length);
            }
            case 4: {
                return this.activityStorage.getNewerOnUserSpacesActivities(this.ownerIdentity, baseActivity, length);
            }
            case 5: {
                return this.activityStorage.getNewerOnSpaceActivities(this.ownerIdentity, baseActivity, length);
            }
        }
        return Collections.emptyList();
    }

    public int getNumberOfNewer(ExoSocialActivity baseActivity) {
        switch (this.activityType.ordinal()) {
            case 0: {
                return this.activityStorage.getNumberOfNewerOnActivityFeed(this.ownerIdentity, baseActivity);
            }
            case 1: {
                return this.activityStorage.getNumberOfNewerOnUserActivities(this.ownerIdentity, baseActivity);
            }
            case 3: {
                return this.activityStorage.getNumberOfNewerOnActivitiesOfConnections(this.ownerIdentity, baseActivity);
            }
            case 4: {
                return this.activityStorage.getNumberOfNewerOnUserSpacesActivities(this.ownerIdentity, baseActivity);
            }
            case 5: {
                return this.activityStorage.getNumberOfNewerOnSpaceActivities(this.ownerIdentity, baseActivity);
            }
        }
        return 0;
    }

    public List<ExoSocialActivity> loadOlder(ExoSocialActivity baseActivity, int length) {
        switch (this.activityType.ordinal()) {
            case 0: {
                return this.activityStorage.getOlderOnActivityFeed(this.ownerIdentity, baseActivity, length);
            }
            case 1: {
                return this.activityStorage.getOlderOnUserActivities(this.ownerIdentity, baseActivity, length);
            }
            case 3: {
                return this.activityStorage.getOlderOnActivitiesOfConnections(this.ownerIdentity, baseActivity, length);
            }
            case 4: {
                return this.activityStorage.getOlderOnUserSpacesActivities(this.ownerIdentity, baseActivity, length);
            }
            case 5: {
                return this.activityStorage.getOlderOnSpaceActivities(this.ownerIdentity, baseActivity, length);
            }
        }
        return Collections.emptyList();
    }

    public int getNumberOfOlder(ExoSocialActivity baseActivity) {
        switch (this.activityType.ordinal()) {
            case 0: {
                return this.activityStorage.getNumberOfOlderOnActivityFeed(this.ownerIdentity, baseActivity);
            }
            case 1: {
                return this.activityStorage.getNumberOfOlderOnUserActivities(this.ownerIdentity, baseActivity);
            }
            case 3: {
                return this.activityStorage.getNumberOfOlderOnActivitiesOfConnections(this.ownerIdentity, baseActivity);
            }
            case 4: {
                return this.activityStorage.getNumberOfOlderOnUserSpacesActivities(this.ownerIdentity, baseActivity);
            }
            case 5: {
                return this.activityStorage.getNumberOfOlderOnSpaceActivities(this.ownerIdentity, baseActivity);
            }
        }
        return 0;
    }

    public int getNumberOfNewer(Long sinceTime) {
        switch (this.activityType.ordinal()) {
            case 0: {
                return this.activityStorage.getNumberOfNewerOnActivityFeed(this.ownerIdentity, sinceTime);
            }
            case 1: {
                return this.activityStorage.getNumberOfNewerOnUserActivities(this.ownerIdentity, sinceTime);
            }
            case 3: {
                return this.activityStorage.getNumberOfNewerOnActivitiesOfConnections(this.ownerIdentity, sinceTime);
            }
            case 4: {
                return this.activityStorage.getNumberOfNewerOnUserSpacesActivities(this.ownerIdentity, sinceTime);
            }
            case 5: {
                return this.activityStorage.getNumberOfNewerOnSpaceActivities(this.ownerIdentity, sinceTime);
            }
        }
        return 0;
    }

    public List<ExoSocialActivity> getUpadtedActivities(Long sinceTime, int limit) {
        switch (this.activityType.ordinal()) {
            case 0: {
                return this.activityStorage.getNewerFeedActivities(this.ownerIdentity, sinceTime, limit);
            }
            case 1: {
                return this.activityStorage.getNewerUserActivities(this.ownerIdentity, sinceTime, limit);
            }
            case 3: {
                return this.activityStorage.getNewerActivitiesOfConnections(this.ownerIdentity, sinceTime, limit);
            }
            case 4: {
                return this.activityStorage.getNewerUserSpacesActivities(this.ownerIdentity, sinceTime, limit);
            }
            case 5: {
                return this.activityStorage.getNewerSpaceActivities(this.ownerIdentity, sinceTime, limit);
            }
        }
        return Collections.emptyList();
    }

    public List<ExoSocialActivity> loadNewer(Long sinceTime, int limit) {
        switch (this.activityType.ordinal()) {
            case 0: {
                return this.activityStorage.getNewerFeedActivities(this.ownerIdentity, sinceTime, limit);
            }
            case 1: {
                return this.activityStorage.getNewerUserActivities(this.ownerIdentity, sinceTime, limit);
            }
            case 3: {
                return this.activityStorage.getNewerActivitiesOfConnections(this.ownerIdentity, sinceTime, limit);
            }
            case 4: {
                return this.activityStorage.getNewerUserSpacesActivities(this.ownerIdentity, sinceTime, limit);
            }
            case 5: {
                return this.activityStorage.getNewerSpaceActivities(this.ownerIdentity, sinceTime, limit);
            }
        }
        return Collections.emptyList();
    }

    public List<ExoSocialActivity> loadOlder(Long sinceTime, int limit) {
        switch (this.activityType.ordinal()) {
            case 0: {
                return this.activityStorage.getOlderFeedActivities(this.ownerIdentity, sinceTime, limit);
            }
            case 1: {
                return this.activityStorage.getOlderUserActivities(this.ownerIdentity, sinceTime, limit);
            }
            case 3: {
                return this.activityStorage.getOlderActivitiesOfConnections(this.ownerIdentity, sinceTime, limit);
            }
            case 4: {
                return this.activityStorage.getOlderUserSpacesActivities(this.ownerIdentity, sinceTime, limit);
            }
            case 5: {
                return this.activityStorage.getOlderSpaceActivities(this.ownerIdentity, sinceTime, limit);
            }
        }
        return Collections.emptyList();
    }

    public int getNumberOfOlder(Long sinceTime) {
        switch (this.activityType.ordinal()) {
            case 0: {
                return this.activityStorage.getNumberOfOlderOnActivityFeed(this.ownerIdentity, sinceTime);
            }
            case 1: {
                return this.activityStorage.getNumberOfOlderOnUserActivities(this.ownerIdentity, sinceTime);
            }
            case 3: {
                return this.activityStorage.getNumberOfOlderOnActivitiesOfConnections(this.ownerIdentity, sinceTime);
            }
            case 4: {
                return this.activityStorage.getNumberOfOlderOnUserSpacesActivities(this.ownerIdentity, sinceTime);
            }
            case 5: {
                return this.activityStorage.getNumberOfOlderOnSpaceActivities(this.ownerIdentity, sinceTime);
            }
        }
        return 0;
    }

    public int getNumberOfUpgrade() {
        switch (this.activityType.ordinal()) {
            case 0: {
                return this.activityStorage.getNumberOfActivitesOnActivityFeedForUpgrade(this.ownerIdentity);
            }
            case 1: {
                return this.activityStorage.getNumberOfUserActivitiesForUpgrade(this.ownerIdentity);
            }
            case 3: {
                return this.activityStorage.getNumberOfActivitiesOfConnectionsForUpgrade(this.ownerIdentity);
            }
            case 4: {
                return this.activityStorage.getNumberOfUserSpacesActivitiesForUpgrade(this.ownerIdentity);
            }
            case 5: {
                return this.activityStorage.getNumberOfSpaceActivitiesForUpgrade(this.ownerIdentity);
            }
            case 6: {
                return this.activityStorage.getNumberOfActivitiesByPoster(this.ownerIdentity);
            }
            case 7: {
                return 0;
            }
            case 2: {
                return this.activityStorage.getNumberOfActivitiesByPoster(this.ownerIdentity, this.viewerIdentity);
            }
        }
        return 0;
    }

    public static enum ActivityType {
        ACTIVITY_FEED,
        USER_ACTIVITIES,
        VIEW_USER_ACTIVITIES,
        CONNECTIONS_ACTIVITIES,
        USER_SPACE_ACTIVITIES,
        SPACE_ACTIVITIES,
        POSTER_ACTIVITIES,
        POSTER_AND_TYPES_ACTIVITIES,
        ALL;

    }
}

