/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.common.lifecycle.LifeCycleCompletionService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.SpaceAccessType;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class SpaceAccessTest
extends AbstractCoreTest {
    private SpaceService spaceService;
    private IdentityStorage identityStorage;
    private LifeCycleCompletionService lifeCycleCompletionService;
    private List<Space> tearDownSpaceList;
    private List<Identity> tearDownUserList;
    private final Log LOG = ExoLogger.getLogger(SpaceAccessTest.class);
    private Identity demo;
    private Identity ghost;
    private Identity john;
    private Identity mary;
    private Identity root;
    private Identity jame;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.lifeCycleCompletionService = (LifeCycleCompletionService)this.getContainer().getComponentInstanceOfType(LifeCycleCompletionService.class);
        this.tearDownSpaceList = new ArrayList<Space>();
        this.tearDownUserList = new ArrayList<Identity>();
        this.demo = new Identity("organization", "demo");
        this.ghost = new Identity("organization", "ghost");
        this.mary = new Identity("organization", "mary");
        this.john = new Identity("organization", "john");
        this.root = new Identity("organization", "root");
        this.jame = new Identity("organization", "jame");
        this.identityStorage.saveIdentity(this.demo);
        this.identityStorage.saveIdentity(this.ghost);
        this.identityStorage.saveIdentity(this.mary);
        this.identityStorage.saveIdentity(this.john);
        this.identityStorage.saveIdentity(this.root);
        this.identityStorage.saveIdentity(this.jame);
        this.tearDownUserList = new ArrayList<Identity>();
        this.tearDownUserList.add(this.demo);
        this.tearDownUserList.add(this.ghost);
        this.tearDownUserList.add(this.mary);
        this.tearDownUserList.add(this.john);
        this.tearDownUserList.add(this.root);
        this.tearDownUserList.add(this.jame);
    }

    @Override
    public void tearDown() throws Exception {
        this.end();
        this.begin();
        for (Identity identity : this.tearDownUserList) {
            this.identityStorage.deleteIdentity(identity);
        }
        for (Space space : this.tearDownSpaceList) {
            Identity spaceIdentity = this.identityStorage.findIdentity("space", space.getPrettyName());
            if (spaceIdentity != null) {
                this.identityStorage.deleteIdentity(spaceIdentity);
            }
            this.spaceService.deleteSpace(space);
        }
        super.tearDown();
    }

    public void testSpaceNotFound() throws Exception {
        Space space = this.spaceService.getSpaceByPrettyName("space_not_found");
        boolean gotStatus = SpaceAccessType.SPACE_NOT_FOUND.doCheck(this.root.getRemoteId(), space);
        SpaceAccessTest.assertTrue((boolean)gotStatus);
    }

    public void testInvitedSpace() throws Exception {
        Space space = this.createSpaceData("invited space", "validation", new String[]{this.root.getRemoteId(), this.john.getRemoteId()}, new String[]{this.root.getRemoteId(), this.john.getRemoteId(), this.mary.getRemoteId()});
        space.setInvitedUsers(new String[]{this.demo.getRemoteId(), this.jame.getRemoteId()});
        this.spaceService.saveSpace(space, true);
        space = this.spaceService.getSpaceByPrettyName(space.getPrettyName());
        SpaceAccessTest.assertNotNull((Object)space);
        boolean gotStatus = SpaceAccessType.INVITED_SPACE.doCheck(this.demo.getRemoteId(), space);
        SpaceAccessTest.assertTrue((boolean)gotStatus);
        gotStatus = SpaceAccessType.INVITED_SPACE.doCheck(this.jame.getRemoteId(), space);
        SpaceAccessTest.assertTrue((boolean)gotStatus);
        this.tearDownSpaceList.add(space);
    }

    public void testRequestedToJoinSpace() throws Exception {
        Space space = this.createSpaceData("requested space", "validation", new String[]{this.root.getRemoteId(), this.john.getRemoteId()}, new String[]{this.root.getRemoteId(), this.john.getRemoteId(), this.mary.getRemoteId()});
        space.setPendingUsers(new String[]{this.demo.getRemoteId(), this.jame.getRemoteId()});
        this.spaceService.saveSpace(space, true);
        space = this.spaceService.getSpaceByPrettyName(space.getPrettyName());
        SpaceAccessTest.assertNotNull((Object)space);
        boolean gotStatus = SpaceAccessType.REQUESTED_JOIN_SPACE.doCheck(this.demo.getRemoteId(), space);
        SpaceAccessTest.assertTrue((boolean)gotStatus);
        gotStatus = SpaceAccessType.REQUESTED_JOIN_SPACE.doCheck(this.jame.getRemoteId(), space);
        SpaceAccessTest.assertTrue((boolean)gotStatus);
        this.tearDownSpaceList.add(space);
    }

    public void testRequestToJoinSpace() throws Exception {
        Space space = this.createSpaceData("request space", "validation", new String[]{this.root.getRemoteId(), this.john.getRemoteId()}, new String[]{this.root.getRemoteId(), this.john.getRemoteId(), this.mary.getRemoteId()});
        this.spaceService.saveSpace(space, true);
        space = this.spaceService.getSpaceByPrettyName(space.getPrettyName());
        SpaceAccessTest.assertNotNull((Object)space);
        boolean gotStatus = SpaceAccessType.REQUEST_JOIN_SPACE.doCheck(this.demo.getRemoteId(), space);
        SpaceAccessTest.assertTrue((boolean)gotStatus);
        gotStatus = SpaceAccessType.REQUEST_JOIN_SPACE.doCheck(this.jame.getRemoteId(), space);
        SpaceAccessTest.assertTrue((boolean)gotStatus);
        this.tearDownSpaceList.add(space);
    }

    public void testJoinSpace() throws Exception {
        Space space = this.createSpaceData("request space", "open", new String[]{this.root.getRemoteId(), this.john.getRemoteId()}, new String[]{this.root.getRemoteId(), this.john.getRemoteId(), this.mary.getRemoteId()});
        this.spaceService.saveSpace(space, true);
        space = this.spaceService.getSpaceByPrettyName(space.getPrettyName());
        SpaceAccessTest.assertNotNull((Object)space);
        boolean gotStatus = SpaceAccessType.JOIN_SPACE.doCheck(this.demo.getRemoteId(), space);
        SpaceAccessTest.assertTrue((boolean)gotStatus);
        gotStatus = SpaceAccessType.JOIN_SPACE.doCheck(this.jame.getRemoteId(), space);
        SpaceAccessTest.assertTrue((boolean)gotStatus);
        this.tearDownSpaceList.add(space);
    }

    public void testClosedSpace() throws Exception {
        Space space = this.createSpaceData("request space", "close", new String[]{this.root.getRemoteId(), this.john.getRemoteId()}, new String[]{this.root.getRemoteId(), this.john.getRemoteId(), this.mary.getRemoteId()});
        this.spaceService.saveSpace(space, true);
        space = this.spaceService.getSpaceByPrettyName(space.getPrettyName());
        SpaceAccessTest.assertNotNull((Object)space);
        boolean gotStatus = SpaceAccessType.CLOSED_SPACE.doCheck(this.demo.getRemoteId(), space);
        SpaceAccessTest.assertTrue((boolean)gotStatus);
        gotStatus = SpaceAccessType.CLOSED_SPACE.doCheck(this.jame.getRemoteId(), space);
        SpaceAccessTest.assertTrue((boolean)gotStatus);
        this.tearDownSpaceList.add(space);
    }

    public void testHiddenValidationSpace() throws Exception {
        Space space = this.createSpaceData("request space", "validation", "hidden", new String[]{this.root.getRemoteId(), this.john.getRemoteId()}, new String[]{this.root.getRemoteId(), this.john.getRemoteId(), this.mary.getRemoteId()});
        this.spaceService.saveSpace(space, true);
        space = this.spaceService.getSpaceByPrettyName(space.getPrettyName());
        SpaceAccessTest.assertNotNull((Object)space);
        boolean gotStatus = !SpaceAccessType.SPACE_NOT_FOUND.doCheck(this.demo.getRemoteId(), space) && SpaceAccessType.REQUEST_JOIN_SPACE.doCheck(this.demo.getRemoteId(), space);
        SpaceAccessTest.assertTrue((boolean)gotStatus);
        gotStatus = !SpaceAccessType.SPACE_NOT_FOUND.doCheck(this.jame.getRemoteId(), space) && SpaceAccessType.REQUEST_JOIN_SPACE.doCheck(this.jame.getRemoteId(), space);
        SpaceAccessTest.assertTrue((boolean)gotStatus);
        this.tearDownSpaceList.add(space);
    }

    private Space createSpaceData(String spaceName, String registration, String[] managers, String[] members) throws Exception {
        Space space2 = new Space();
        space2.setApp("Contact,Forum");
        space2.setDisplayName(spaceName);
        space2.setPrettyName(space2.getDisplayName());
        String shortName = Utils.cleanString((String)spaceName);
        space2.setGroupId("/spaces/" + shortName);
        space2.setUrl(shortName);
        space2.setMembers(members);
        space2.setManagers(managers);
        space2.setRegistration(registration);
        space2.setDescription("This is my second space for testing");
        space2.setType("classic");
        space2.setVisibility("public");
        space2.setPriority("2");
        return space2;
    }

    private Space createSpaceData(String spaceName, String registration, String visibility, String[] managers, String[] members) throws Exception {
        Space space2 = this.createSpaceData(spaceName, registration, managers, members);
        space2.setVisibility(visibility);
        return space2;
    }
}

