/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.exoplatform.social.core.jpa.storage.dao.ActivityDAO;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.jpa.storage.dao.SpaceDAO;
import org.exoplatform.social.core.jpa.storage.entity.ActivityEntity;
import org.exoplatform.social.core.jpa.storage.entity.AppEntity;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceMemberEntity;
import org.exoplatform.social.core.jpa.test.BaseCoreTest;

public class SpaceDAOTest
extends BaseCoreTest {
    private SpaceDAO spaceDAO;
    private ActivityDAO activityDao;
    private IdentityDAO identityDAO;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.spaceDAO = this.getService(SpaceDAO.class);
        this.activityDao = this.getService(ActivityDAO.class);
        this.identityDAO = this.getService(IdentityDAO.class);
    }

    @Override
    public void tearDown() throws Exception {
        this.spaceDAO.deleteAll();
        super.tearDown();
    }

    public void testSaveSpace() throws Exception {
        SpaceEntity spaceEntity = this.createSpace("testPrettyName");
        this.spaceDAO.create((Object)spaceEntity);
        this.end();
        this.begin();
        SpaceEntity result = (SpaceEntity)this.spaceDAO.find((Serializable)spaceEntity.getId());
        this.assertSpace(spaceEntity, result);
    }

    public void testGetSpace() throws Exception {
        SpaceEntity spaceEntity = this.createSpace("testPrettyName");
        this.spaceDAO.create((Object)spaceEntity);
        this.end();
        this.begin();
        SpaceEntity result = this.spaceDAO.getSpaceByDisplayName(spaceEntity.getDisplayName());
        this.assertSpace(spaceEntity, result);
        result = this.spaceDAO.getSpaceByGroupId(spaceEntity.getGroupId());
        this.assertSpace(spaceEntity, result);
        result = this.spaceDAO.getSpaceByPrettyName(spaceEntity.getPrettyName());
        this.assertSpace(spaceEntity, result);
        result = this.spaceDAO.getSpaceByURL(spaceEntity.getUrl());
        this.assertSpace(spaceEntity, result);
    }

    public void testGetLastSpace() throws Exception {
        SpaceEntity space2 = this.createSpace("testPrettyName2");
        this.spaceDAO.create((Object)space2);
        this.end();
        this.begin();
        List result = this.spaceDAO.getLastSpaces(1);
        SpaceDAOTest.assertEquals((int)1, (int)result.size());
        SpaceDAOTest.assertEquals((Object)space2.getId(), result.iterator().next());
    }

    private SpaceEntity createSpace(String spacePrettyName) {
        SpaceEntity spaceEntity = new SpaceEntity();
        spaceEntity.setApp(this.createApp());
        spaceEntity.setAvatarLastUpdated(new Date());
        spaceEntity.setDescription("testDesc");
        spaceEntity.setDisplayName("testDisplayName");
        spaceEntity.setGroupId("testGroupId");
        spaceEntity.setPrettyName(spacePrettyName);
        spaceEntity.setPriority(SpaceEntity.PRIORITY.HIGH);
        spaceEntity.setRegistration(SpaceEntity.REGISTRATION.OPEN);
        spaceEntity.setUrl("testUrl");
        spaceEntity.setVisibility(SpaceEntity.VISIBILITY.PRIVATE);
        spaceEntity.setBannerLastUpdated(new Date());
        this.addMember(spaceEntity, "root", SpaceMemberEntity.Status.PENDING);
        return spaceEntity;
    }

    private void addMember(SpaceEntity spaceEntity, String username, SpaceMemberEntity.Status status) {
        SpaceMemberEntity mem = new SpaceMemberEntity();
        mem.setSpace(spaceEntity);
        mem.setStatus(status);
        mem.setUserId(username);
        spaceEntity.getMembers().add(mem);
    }

    private Set<AppEntity> createApp() {
        HashSet<AppEntity> apps = new HashSet<AppEntity>();
        AppEntity app = new AppEntity();
        app.setAppId("appId");
        app.setAppName("appName");
        app.setRemovable(true);
        app.setStatus(AppEntity.Status.ACTIVE);
        apps.add(app);
        return apps;
    }

    private void assertSpace(SpaceEntity spaceEntity, SpaceEntity result) {
        SpaceDAOTest.assertNotNull((Object)result);
        SpaceDAOTest.assertEquals((String)spaceEntity.getPrettyName(), (String)result.getPrettyName());
        SpaceDAOTest.assertEquals((int)1, (int)result.getApp().size());
        AppEntity appEx = (AppEntity)spaceEntity.getApp().iterator().next();
        AppEntity app = (AppEntity)result.getApp().iterator().next();
        SpaceDAOTest.assertEquals((Object)appEx, (Object)app);
        SpaceDAOTest.assertEquals((boolean)appEx.isRemovable(), (boolean)app.isRemovable());
        SpaceDAOTest.assertEquals((Object)appEx.getStatus(), (Object)app.getStatus());
        SpaceDAOTest.assertEquals((String)spaceEntity.getDescription(), (String)result.getDescription());
        SpaceDAOTest.assertEquals((String)spaceEntity.getDisplayName(), (String)result.getDisplayName());
        SpaceDAOTest.assertEquals((String)spaceEntity.getGroupId(), (String)result.getGroupId());
        SpaceDAOTest.assertEquals((Object)spaceEntity.getPriority(), (Object)result.getPriority());
        SpaceDAOTest.assertEquals((Object)spaceEntity.getRegistration(), (Object)result.getRegistration());
        SpaceDAOTest.assertEquals((String)spaceEntity.getUrl(), (String)result.getUrl());
        SpaceDAOTest.assertEquals((String)spaceEntity.getUrl(), (String)result.getUrl());
        SpaceDAOTest.assertEquals((Object)spaceEntity.getVisibility(), (Object)result.getVisibility());
        SpaceDAOTest.assertEquals((Object)spaceEntity.getAvatarLastUpdated(), (Object)result.getAvatarLastUpdated());
        SpaceDAOTest.assertEquals((Object)spaceEntity.getBannerLastUpdated(), (Object)result.getBannerLastUpdated());
        SpaceDAOTest.assertEquals((Object)spaceEntity.getCreatedDate(), (Object)result.getCreatedDate());
        SpaceDAOTest.assertEquals((int)1, (int)result.getMembers().size());
    }

    public void testSaveActivity() throws Exception {
        String activityTitle = "activity title";
        String commentTitle = "Comment title";
        SpaceEntity spaceEntity = this.createSpace("testPrettyName3");
        spaceEntity = (SpaceEntity)this.spaceDAO.create((Object)spaceEntity);
        this.addMember(spaceEntity, this.maryIdentity.getRemoteId(), SpaceMemberEntity.Status.MEMBER);
        this.addMember(spaceEntity, this.johnIdentity.getRemoteId(), SpaceMemberEntity.Status.MEMBER);
        this.addMember(spaceEntity, this.demoIdentity.getRemoteId(), SpaceMemberEntity.Status.MEMBER);
        IdentityEntity spaceIdentity = (IdentityEntity)this.identityDAO.create((Object)this.createIdentity("space", spaceEntity.getPrettyName()));
        this.end();
        this.begin();
        HashSet<Long> activityIds = new HashSet<Long>();
        for (int i = 0; i < 15; ++i) {
            ActivityEntity activity = this.createActivityInstance(activityTitle, this.maryIdentity.getId());
            activity = this.createActivity(spaceIdentity, activity);
            Long activityId = activity.getId();
            activityIds.add(activityId);
            ActivityEntity got = (ActivityEntity)this.activityDao.find((Serializable)activityId);
            SpaceDAOTest.assertNotNull((Object)got);
            this.addCommentsLikersMentionners(activity, commentTitle);
            activity = (ActivityEntity)this.activityDao.update((Object)activity);
        }
        this.end();
        this.begin();
        spaceEntity = (SpaceEntity)this.spaceDAO.find((Serializable)spaceEntity.getId());
        this.spaceDAO.delete((Object)spaceEntity);
        spaceIdentity = (IdentityEntity)this.identityDAO.find((Serializable)Long.valueOf(spaceIdentity.getId()));
        this.identityDAO.delete((Object)spaceIdentity);
        this.activityDao.deleteActivitiesByOwnerId(String.valueOf(spaceIdentity.getId()));
    }

    private void addCommentsLikersMentionners(ActivityEntity activity, String commentTitle) {
        this.commentOnActivity(activity, commentTitle, this.demoIdentity.getId());
        this.commentOnActivity(activity, commentTitle, this.johnIdentity.getId());
        activity.addLiker(this.demoIdentity.getId());
        activity.addLiker(this.johnIdentity.getId());
        activity.addLiker(this.maryIdentity.getId());
        HashSet<String> mentionners = new HashSet<String>();
        mentionners.add(this.demoIdentity.getId());
        mentionners.add(this.johnIdentity.getId());
        mentionners.add(this.maryIdentity.getId());
        activity.setMentionerIds(mentionners);
    }

    private void commentOnActivity(ActivityEntity activity, String commentTitle, String identityId) {
        ActivityEntity comment = new ActivityEntity();
        comment.setTitle(commentTitle);
        comment.setOwnerId(identityId);
        comment.setPosterId(identityId);
        activity.addComment(comment);
        this.activityDao.create((Object)comment);
    }

    private ActivityEntity createActivityInstance(String activityTitle, String posterId) {
        ActivityEntity activity = new ActivityEntity();
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        templateParams.put("key1", "value 1");
        templateParams.put("key2", "value 2");
        templateParams.put("key3", "value 3");
        activity.setTemplateParams(templateParams);
        activity.setTitle(activityTitle);
        activity.setBody("The body of " + activityTitle);
        activity.setPosterId(posterId);
        activity.setType("DEFAULT_ACTIVITY");
        activity.setHidden(Boolean.valueOf(false));
        activity.setLocked(Boolean.valueOf(false));
        return activity;
    }

    private ActivityEntity createActivity(IdentityEntity ownerIdentity, ActivityEntity activity) {
        activity.setOwnerId(String.valueOf(ownerIdentity.getId()));
        activity.setPosterId(activity.getOwnerId());
        activity = (ActivityEntity)this.activityDao.create((Object)activity);
        return activity;
    }

    private IdentityEntity createIdentity(String providerId, String remoteId) {
        IdentityEntity entity = new IdentityEntity();
        entity.setProviderId(providerId);
        entity.setRemoteId(remoteId);
        entity.setEnabled(true);
        entity.setDeleted(false);
        return entity;
    }
}

