/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.jpa.storage.dao.SpaceDAO;
import org.exoplatform.social.core.jpa.storage.dao.SpaceMemberDAO;
import org.exoplatform.social.core.jpa.storage.entity.AppEntity;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceMemberEntity;
import org.exoplatform.social.core.jpa.test.BaseCoreTest;

public class SpaceMemberDAOTest
extends BaseCoreTest {
    private List<IdentityEntity> toDeleteIdentities = new ArrayList<IdentityEntity>();
    private SpaceDAO spaceDAO;
    private SpaceMemberDAO spaceMemberDAO;
    private IdentityDAO identityDAO;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.spaceDAO = this.getService(SpaceDAO.class);
        this.spaceMemberDAO = this.getService(SpaceMemberDAO.class);
        this.identityDAO = this.getService(IdentityDAO.class);
    }

    @Override
    public void tearDown() throws Exception {
        this.spaceDAO.deleteAll();
        for (IdentityEntity e : this.toDeleteIdentities) {
            this.identityDAO.delete((Object)e);
        }
        super.tearDown();
    }

    public void testGetUserSpaces() throws Exception {
        String userId = "test";
        String spacePrettyName = "test";
        IdentityEntity userIdentity = this.createIdentity(userId, "organization");
        this.identityDAO.create((Object)userIdentity);
        this.toDeleteIdentities.add(userIdentity);
        IdentityEntity spaceIdentity = this.createIdentity(spacePrettyName, "space");
        this.identityDAO.create((Object)spaceIdentity);
        this.toDeleteIdentities.add(spaceIdentity);
        List spacesIds = this.spaceMemberDAO.getSpacesIdsByUserName(userId, 0, 10);
        SpaceMemberDAOTest.assertTrue((spacesIds == null || spacesIds.isEmpty() ? 1 : 0) != 0);
        SpaceEntity space = this.createSpace("test");
        this.addIdentityToSpace(space, SpaceMemberEntity.Status.MANAGER, userId);
        this.addIdentityToSpace(space, SpaceMemberEntity.Status.MEMBER, userId);
        this.spaceDAO.create((Object)space);
        spacesIds = this.spaceMemberDAO.getSpacesIdsByUserName(userId, 0, 10);
        SpaceMemberDAOTest.assertEquals((int)1, (int)spacesIds.size());
        space = this.createSpace("test2");
        this.addIdentityToSpace(space, SpaceMemberEntity.Status.MANAGER, userId);
        this.addIdentityToSpace(space, SpaceMemberEntity.Status.MEMBER, userId);
        spaceIdentity = this.createIdentity("test2", "space");
        this.identityDAO.create((Object)spaceIdentity);
        this.toDeleteIdentities.add(spaceIdentity);
        this.spaceDAO.create((Object)space);
        spacesIds = this.spaceMemberDAO.getSpacesIdsByUserName(userId, 0, 10);
        SpaceMemberDAOTest.assertEquals((int)2, (int)spacesIds.size());
        space = this.createSpace("testspace2");
        this.addIdentityToSpace(space, SpaceMemberEntity.Status.MANAGER, userId);
        spaceIdentity = this.createIdentity("testspace2", "space");
        this.identityDAO.create((Object)spaceIdentity);
        this.toDeleteIdentities.add(spaceIdentity);
        this.spaceDAO.create((Object)space);
        spacesIds = this.spaceMemberDAO.getSpacesIdsByUserName(userId, 0, 10);
        SpaceMemberDAOTest.assertEquals((int)2, (int)spacesIds.size());
        space = this.createSpace("testspace3");
        this.addIdentityToSpace(space, SpaceMemberEntity.Status.PENDING, userId);
        spaceIdentity = this.createIdentity("testspace3", "space");
        this.identityDAO.create((Object)spaceIdentity);
        this.toDeleteIdentities.add(spaceIdentity);
        this.spaceDAO.create((Object)space);
        spacesIds = this.spaceMemberDAO.getSpacesIdsByUserName(userId, 0, 10);
        SpaceMemberDAOTest.assertEquals((int)2, (int)spacesIds.size());
    }

    private SpaceEntity createSpace(String name) {
        SpaceEntity spaceEntity = new SpaceEntity();
        spaceEntity.setApp(this.createApp());
        spaceEntity.setAvatarLastUpdated(new Date());
        spaceEntity.setDescription("testDesc");
        spaceEntity.setDisplayName(name);
        spaceEntity.setGroupId(name + "GroupId");
        spaceEntity.setPrettyName(name);
        spaceEntity.setPriority(SpaceEntity.PRIORITY.HIGH);
        spaceEntity.setRegistration(SpaceEntity.REGISTRATION.OPEN);
        spaceEntity.setUrl("testUrl");
        spaceEntity.setVisibility(SpaceEntity.VISIBILITY.PRIVATE);
        spaceEntity.setBannerLastUpdated(new Date());
        return spaceEntity;
    }

    private void addIdentityToSpace(SpaceEntity spaceEntity, SpaceMemberEntity.Status status, String userId) {
        SpaceMemberEntity mem = new SpaceMemberEntity();
        mem.setSpace(spaceEntity);
        mem.setStatus(status);
        mem.setUserId(userId);
        spaceEntity.getMembers().add(mem);
    }

    private Set<AppEntity> createApp() {
        HashSet<AppEntity> apps = new HashSet<AppEntity>();
        AppEntity app = new AppEntity();
        app.setAppId("appId");
        app.setAppName("appName");
        app.setRemovable(true);
        app.setStatus(AppEntity.Status.ACTIVE);
        apps.add(app);
        return apps;
    }

    private IdentityEntity createIdentity(String id, String providerId) {
        IdentityEntity entity = new IdentityEntity();
        entity.setProviderId(providerId);
        entity.setRemoteId(id);
        entity.setEnabled(true);
        entity.setDeleted(false);
        return entity;
    }
}

