/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataDAO;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.metadata.tag.model.TagName;
import org.exoplatform.social.metadata.tag.model.TagObject;

public class ActivityTagMetadataListenerTest
extends AbstractCoreTest {
    private final Log LOG = ExoLogger.getLogger(ActivityTagMetadataListenerTest.class);
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private MetadataService metadataService;
    private TagService tagService;
    private MetadataDAO metadataDAO;
    private List<ExoSocialActivity> tearDownActivityList;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        this.metadataService = (MetadataService)this.getContainer().getComponentInstanceOfType(MetadataService.class);
        this.tagService = (TagService)this.getContainer().getComponentInstanceOfType(TagService.class);
        this.metadataDAO = (MetadataDAO)this.getContainer().getComponentInstanceOfType(MetadataDAO.class);
        this.rootIdentity = this.identityManager.getOrCreateUserIdentity("root");
        this.johnIdentity = this.identityManager.getOrCreateUserIdentity("john");
        this.maryIdentity = this.identityManager.getOrCreateUserIdentity("mary");
        this.tearDownActivityList = new ArrayList<ExoSocialActivity>();
    }

    @Override
    public void tearDown() throws Exception {
        this.end();
        this.begin();
        this.identityManager.deleteIdentity(this.rootIdentity);
        this.identityManager.deleteIdentity(this.johnIdentity);
        this.identityManager.deleteIdentity(this.maryIdentity);
        this.metadataDAO.deleteAll();
        for (ExoSocialActivity activity : this.tearDownActivityList) {
            try {
                this.activityManager.deleteActivity(activity.getId());
            }
            catch (Exception e) {
                this.LOG.warn((Object)("can not delete activity with id: " + activity.getId()));
            }
        }
        super.tearDown();
    }

    public void testSaveActivity() {
        String activityTitle = "<div>Test tag #NoTagHere test test <a target=\"_blank\" class=\"metadata-tag\" rel=\"noopener\">#ANewTagHere</a>&nbsp;.</div>";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        this.tearDownActivityList.add((ExoSocialActivity)activity);
        TagObject metadataObjectKey = new TagObject("activity", activity.getId());
        List metadataItems = this.metadataService.getMetadataItemsByObject((MetadataObject)metadataObjectKey);
        ActivityTagMetadataListenerTest.assertNotNull((Object)metadataItems);
        ActivityTagMetadataListenerTest.assertEquals((int)1, (int)metadataItems.size());
        ActivityTagMetadataListenerTest.assertEquals(Collections.singleton(new TagName("ANewTagHere")), metadataItems.stream().map(MetadataItem::getMetadata).map(Metadata::getName).map(TagName::new).collect(Collectors.toSet()));
        Set tagNames = this.tagService.getTagNames(metadataObjectKey);
        ActivityTagMetadataListenerTest.assertEquals(Collections.singleton(new TagName("ANewTagHere")), (Object)tagNames);
    }

    public void testUpdateActivity() {
        String activityTitle = "<div>Test tag #NoTagHere test test <a target=\"_blank\" class=\"metadata-tag\" rel=\"noopener\">#ANewTagHere</a>&nbsp;.</div>";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        this.tearDownActivityList.add((ExoSocialActivity)activity);
        TagObject metadataObjectKey = new TagObject("activity", activity.getId());
        Set tagNames = this.tagService.getTagNames(metadataObjectKey);
        String tagName1 = "ANewTagHere";
        ActivityTagMetadataListenerTest.assertEquals(Collections.singleton(new TagName(tagName1)), (Object)tagNames);
        activity = this.activityManager.getActivity(activity.getId());
        String activityTitle2 = "<div>Test tag #NoTagHere test test <a target=\"_blank\" class=\"metadata-tag\" rel=\"noopener\">#ANewTagHere2</a>&nbsp;.</div>";
        activity.setTitle(activityTitle2);
        this.activityManager.updateActivity((ExoSocialActivity)activity);
        tagNames = this.tagService.getTagNames(metadataObjectKey);
        String tagName2 = "ANewTagHere2";
        ActivityTagMetadataListenerTest.assertEquals(Collections.singleton(new TagName(tagName2)), (Object)tagNames);
        activity.setTitle("");
        this.activityManager.updateActivity((ExoSocialActivity)activity);
        tagNames = this.tagService.getTagNames(metadataObjectKey);
        ActivityTagMetadataListenerTest.assertEquals(Collections.emptySet(), (Object)tagNames);
        String activityTitle3 = "<div>Test tag #NoTagHere test test <a target=\"_blank\" class=\"metadata-tag\" rel=\"noopener\">#ANewTagHere</a> <a target=\"_blank\" class=\"metadata-tag\" rel=\"noopener\">#ANewTagHere2</a>&nbsp;.</div>";
        activity.setTitle(activityTitle3);
        this.activityManager.updateActivity((ExoSocialActivity)activity);
        tagNames = this.tagService.getTagNames(metadataObjectKey);
        ActivityTagMetadataListenerTest.assertEquals((int)2, (int)tagNames.size());
        ActivityTagMetadataListenerTest.assertTrue((boolean)tagNames.contains(new TagName(tagName1)));
        ActivityTagMetadataListenerTest.assertTrue((boolean)tagNames.contains(new TagName(tagName2)));
    }
}

