/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.upgrade;

import io.meeds.social.upgrade.SpaceNavigationIconUpgradePlugin$AjcClosure1;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SpaceNavigationIconUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG;
    private static final String ICON_UPDATE_SQL = "  UPDATE PORTAL_NAVIGATION_NODES\n  SET ICON =\n    CASE\n      WHEN PARENT_ID IN (SELECT NODE_ID FROM (SELECT * FROM PORTAL_NAVIGATION_NODES WHERE NAME LIKE 'default') AS PARENT_NAVIGATION) THEN TRIM('fas fa-stream')\n      %s\n    END\n  WHERE ICON IS NULL\n  AND EXISTS (SELECT * FROM PORTAL_PAGES p INNER JOIN PORTAL_SITES s ON s.ID = p.SITE_ID WHERE PAGE_ID = p.ID AND s.TYPE = 1 AND s.NAME LIKE '/spaces/%%')\n";
    private static final String ICON_UPDATE_CASE_SQL = "   WHEN NAME in (%s) THEN TRIM('%s')\n";
    private static final String SPACE_NODE_NAMES = "space.node.names";
    private static final String SPACE_NODE_ICONS = "space.node.icons";
    private final EntityManagerService entityManagerService;
    private final Map<String, String> spaceNodes = new HashMap<String, String>();
    private int migratedSpaceNodeIcons;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public SpaceNavigationIconUpgradePlugin(EntityManagerService entityManagerService, InitParams initParams) {
        super(initParams);
        this.entityManagerService = entityManagerService;
        if (initParams.containsKey((Object)SPACE_NODE_NAMES) && initParams.containsKey((Object)SPACE_NODE_ICONS)) {
            String[] spaceNodeNames = initParams.getValueParam(SPACE_NODE_NAMES).getValue().split(";");
            String[] spaceNodeIcons = initParams.getValueParam(SPACE_NODE_ICONS).getValue().split(";");
            for (int i = 0; i < spaceNodeNames.length; ++i) {
                this.spaceNodes.put(spaceNodeNames[i], spaceNodeIcons[i]);
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return !this.spaceNodes.isEmpty();
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        LOG.info((Object)"Start:: Upgrade of space node icons");
        Set<Map.Entry<String, String>> spaceNodesEntrySet = this.spaceNodes.entrySet();
        this.migratedSpaceNodeIcons = this.upgradeSpaceNodeIcons(spaceNodesEntrySet);
        LOG.info("End:: Upgrade of '{}' space node icons. It tooks {} ms", new Object[]{this.migratedSpaceNodeIcons, System.currentTimeMillis() - startupTime});
    }

    @ExoTransactional
    public int upgradeSpaceNodeIcons(Set<Map.Entry<String, String>> spaceNodesEntrySet) {
        Set<Map.Entry<String, String>> set = spaceNodesEntrySet;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), set);
        Object[] objectArray = new Object[]{this, set, joinPoint};
        SpaceNavigationIconUpgradePlugin$AjcClosure1 spaceNavigationIconUpgradePlugin$AjcClosure1 = new SpaceNavigationIconUpgradePlugin$AjcClosure1(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(spaceNavigationIconUpgradePlugin$AjcClosure1.linkClosureAndJoinPoint(69648)));
    }

    public int getMigratedSpaceNodeIcons() {
        return this.migratedSpaceNodeIcons;
    }

    static {
        SpaceNavigationIconUpgradePlugin.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(SpaceNavigationIconUpgradePlugin.class);
    }

    static /* synthetic */ int upgradeSpaceNodeIcons_aroundBody0(SpaceNavigationIconUpgradePlugin ajc$this, Set spaceNodesEntrySet, JoinPoint joinPoint) {
        EntityManager entityManager = ajc$this.entityManagerService.getEntityManager();
        String sqlStatement = String.format(ICON_UPDATE_SQL, ajc$this.spaceNodes.entrySet().stream().map(e -> {
            String keys = Arrays.stream(((String)e.getKey()).split(",")).map(key -> String.format("'%s'", key)).collect(Collectors.joining(","));
            return String.format(ICON_UPDATE_CASE_SQL, keys, e.getValue());
        }).collect(Collectors.joining()));
        Query query = entityManager.createNativeQuery(sqlStatement);
        return query.executeUpdate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpaceNavigationIconUpgradePlugin.java", SpaceNavigationIconUpgradePlugin.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "upgradeSpaceNodeIcons", "io.meeds.social.upgrade.SpaceNavigationIconUpgradePlugin", "java.util.Set", "spaceNodesEntrySet", "", "int"), 97);
    }
}

