/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao.jpa;

import jakarta.persistence.NoResultException;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.social.core.jpa.storage.dao.SpaceDAO;
import org.exoplatform.social.core.jpa.storage.entity.SpaceEntity;

public class SpaceDAOImpl
extends GenericDAOJPAImpl<SpaceEntity, Long>
implements SpaceDAO {
    @Override
    public List<Long> getLastSpaces(int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.getLastSpaces", Tuple.class);
        query.setMaxResults(limit);
        List resultList = query.getResultList();
        if (resultList == null || resultList.isEmpty()) {
            return Collections.emptyList();
        }
        return resultList.stream().map(tuple -> (Long)tuple.get(0, Long.class)).collect(Collectors.toList());
    }

    @Override
    public SpaceEntity getSpaceByGroupId(String groupId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.getSpaceByGroupId", SpaceEntity.class);
        query.setParameter("groupId", (Object)groupId);
        try {
            return (SpaceEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public SpaceEntity getSpaceByURL(String url) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.getSpaceByURL", SpaceEntity.class);
        query.setParameter("url", (Object)url);
        try {
            return (SpaceEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public SpaceEntity getSpaceByDisplayName(String spaceDisplayName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.getSpaceByDisplayName", SpaceEntity.class);
        query.setParameter("displayName", (Object)spaceDisplayName);
        try {
            return (SpaceEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public SpaceEntity getSpaceByPrettyName(String spacePrettyName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.getSpaceByPrettyName", SpaceEntity.class);
        query.setParameter("prettyName", (Object)spacePrettyName);
        query.setMaxResults(1);
        try {
            return (SpaceEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public List<SpaceEntity> getCommonSpaces(String userId, String otherUserId, int offset, int limit) {
        if (userId == null || userId.equals("")) {
            throw new IllegalArgumentException("the userId is null or equals to 0");
        }
        if (otherUserId == null || otherUserId.equals("")) {
            throw new IllegalArgumentException("the otherUserId is null or equals to 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset must be positive");
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be > 0");
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.getCommonSpacesBetweenTwoUsers", SpaceEntity.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("otherUserId", (Object)otherUserId);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    @Override
    public int countCommonSpaces(String userId, String otherUserId) {
        if (userId == null || userId.equals("")) {
            throw new IllegalArgumentException("userId is null or equals to 0");
        }
        if (otherUserId == null || otherUserId.equals("")) {
            throw new IllegalArgumentException("otherUserId is null or equals to 0");
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.countCommonSpacesBetweenTwoUsers", Long.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("otherUserId", (Object)otherUserId);
        return ((Long)query.getSingleResult()).intValue();
    }
}

