/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.spi;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.mock.SpaceListenerPluginMock;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.model.SpaceExternalInvitation;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceListAccess;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.SpacesAdministrationService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.exoplatform.social.core.storage.IdentityStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.junit.Assert;

public class SpaceServiceTest
extends AbstractCoreTest {
    private IdentityStorage identityStorage;
    private OrganizationService organizationService;
    protected SpacesAdministrationService spacesAdministrationService;
    private List<Space> tearDownSpaceList;
    private List<org.exoplatform.social.core.identity.model.Identity> tearDownUserList;
    private final Log LOG = ExoLogger.getLogger(SpaceServiceTest.class);
    private org.exoplatform.social.core.identity.model.Identity demo;
    private org.exoplatform.social.core.identity.model.Identity tom;
    private org.exoplatform.social.core.identity.model.Identity raul;
    private org.exoplatform.social.core.identity.model.Identity ghost;
    private org.exoplatform.social.core.identity.model.Identity dragon;
    private org.exoplatform.social.core.identity.model.Identity register1;
    private org.exoplatform.social.core.identity.model.Identity john;
    private org.exoplatform.social.core.identity.model.Identity mary;
    private org.exoplatform.social.core.identity.model.Identity harry;
    private org.exoplatform.social.core.identity.model.Identity root;
    private org.exoplatform.social.core.identity.model.Identity jame;
    private org.exoplatform.social.core.identity.model.Identity paul;
    private org.exoplatform.social.core.identity.model.Identity hacker;
    private org.exoplatform.social.core.identity.model.Identity hearBreaker;
    private org.exoplatform.social.core.identity.model.Identity newInvitedUser;
    private org.exoplatform.social.core.identity.model.Identity newPendingUser;
    private org.exoplatform.social.core.identity.model.Identity user_new;
    private org.exoplatform.social.core.identity.model.Identity user_new1;
    private org.exoplatform.social.core.identity.model.Identity user_new_dot;
    private org.exoplatform.social.core.identity.model.Identity creator;
    private org.exoplatform.social.core.identity.model.Identity manager;
    private org.exoplatform.social.core.identity.model.Identity member1;
    private org.exoplatform.social.core.identity.model.Identity member2;
    private org.exoplatform.social.core.identity.model.Identity member3;
    private org.exoplatform.social.core.identity.model.Identity externalUser;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.organizationService = (OrganizationService)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
        this.spacesAdministrationService = (SpacesAdministrationService)this.getContainer().getComponentInstanceOfType(SpacesAdministrationService.class);
        this.tearDownSpaceList = new ArrayList<Space>();
        this.tearDownUserList = new ArrayList<org.exoplatform.social.core.identity.model.Identity>();
        this.user_new = new org.exoplatform.social.core.identity.model.Identity("organization", "user-new");
        this.user_new1 = new org.exoplatform.social.core.identity.model.Identity("organization", "user-new.1");
        this.user_new_dot = new org.exoplatform.social.core.identity.model.Identity("organization", "user.new");
        this.demo = new org.exoplatform.social.core.identity.model.Identity("organization", "demo");
        this.tom = new org.exoplatform.social.core.identity.model.Identity("organization", "tom");
        this.raul = new org.exoplatform.social.core.identity.model.Identity("organization", "raul");
        this.ghost = new org.exoplatform.social.core.identity.model.Identity("organization", "ghost");
        this.dragon = new org.exoplatform.social.core.identity.model.Identity("organization", "dragon");
        this.register1 = new org.exoplatform.social.core.identity.model.Identity("organization", "register1");
        this.mary = new org.exoplatform.social.core.identity.model.Identity("organization", "mary");
        this.john = new org.exoplatform.social.core.identity.model.Identity("organization", "john");
        this.harry = new org.exoplatform.social.core.identity.model.Identity("organization", "harry");
        this.root = new org.exoplatform.social.core.identity.model.Identity("organization", "root");
        this.jame = new org.exoplatform.social.core.identity.model.Identity("organization", "jame");
        this.paul = new org.exoplatform.social.core.identity.model.Identity("organization", "paul");
        this.hacker = new org.exoplatform.social.core.identity.model.Identity("organization", "hacker");
        this.hearBreaker = new org.exoplatform.social.core.identity.model.Identity("organization", "hearBreaker");
        this.newInvitedUser = new org.exoplatform.social.core.identity.model.Identity("organization", "newInvitedUser");
        this.newPendingUser = new org.exoplatform.social.core.identity.model.Identity("organization", "newPendingUser");
        this.manager = new org.exoplatform.social.core.identity.model.Identity("organization", "manager");
        this.creator = new org.exoplatform.social.core.identity.model.Identity("organization", "creator");
        this.member1 = new org.exoplatform.social.core.identity.model.Identity("organization", "member1");
        this.member2 = new org.exoplatform.social.core.identity.model.Identity("organization", "member2");
        this.member3 = new org.exoplatform.social.core.identity.model.Identity("organization", "member3");
        this.externalUser = new org.exoplatform.social.core.identity.model.Identity("organization", "externalUser");
        this.identityStorage.saveIdentity(this.demo);
        this.identityStorage.saveIdentity(this.tom);
        this.identityStorage.saveIdentity(this.raul);
        this.identityStorage.saveIdentity(this.ghost);
        this.identityStorage.saveIdentity(this.dragon);
        this.identityStorage.saveIdentity(this.register1);
        this.identityStorage.saveIdentity(this.mary);
        this.identityStorage.saveIdentity(this.harry);
        this.identityStorage.saveIdentity(this.john);
        this.identityStorage.saveIdentity(this.root);
        this.identityStorage.saveIdentity(this.jame);
        this.identityStorage.saveIdentity(this.paul);
        this.identityStorage.saveIdentity(this.hacker);
        this.identityStorage.saveIdentity(this.hearBreaker);
        this.identityStorage.saveIdentity(this.newInvitedUser);
        this.identityStorage.saveIdentity(this.newPendingUser);
        this.identityStorage.saveIdentity(this.user_new1);
        this.identityStorage.saveIdentity(this.user_new);
        this.identityStorage.saveIdentity(this.user_new_dot);
        this.identityStorage.saveIdentity(this.manager);
        this.identityStorage.saveIdentity(this.creator);
        this.identityStorage.saveIdentity(this.member1);
        this.identityStorage.saveIdentity(this.member2);
        this.identityStorage.saveIdentity(this.member3);
        this.tearDownUserList.add(this.demo);
        this.tearDownUserList.add(this.tom);
        this.tearDownUserList.add(this.raul);
        this.tearDownUserList.add(this.ghost);
        this.tearDownUserList.add(this.dragon);
        this.tearDownUserList.add(this.register1);
        this.tearDownUserList.add(this.mary);
        this.tearDownUserList.add(this.harry);
        this.tearDownUserList.add(this.john);
        this.tearDownUserList.add(this.root);
        this.tearDownUserList.add(this.jame);
        this.tearDownUserList.add(this.paul);
        this.tearDownUserList.add(this.hacker);
        this.tearDownUserList.add(this.hearBreaker);
        this.tearDownUserList.add(this.newInvitedUser);
        this.tearDownUserList.add(this.newPendingUser);
        this.tearDownUserList.add(this.user_new1);
        this.tearDownUserList.add(this.user_new);
        this.tearDownUserList.add(this.user_new_dot);
        this.tearDownUserList.add(this.manager);
        this.tearDownUserList.add(this.creator);
        this.tearDownUserList.add(this.member1);
        this.tearDownUserList.add(this.member2);
        this.tearDownUserList.add(this.member3);
    }

    @Override
    public void tearDown() throws Exception {
        this.end();
        this.begin();
        for (org.exoplatform.social.core.identity.model.Identity identity : this.tearDownUserList) {
            this.identityRegistry.unregister(identity.getRemoteId());
            try {
                this.identityStorage.deleteIdentity(identity);
            }
            catch (IdentityStorageException identityStorageException) {}
        }
        super.tearDown();
    }

    public void testGetAllSpacesWithListAccess() throws Exception {
        int count = 5;
        for (int i = 0; i < count; ++i) {
            this.getSpaceInstance(i);
        }
        ListAccess allSpaces = this.spaceService.getAllSpacesWithListAccess();
        SpaceServiceTest.assertNotNull((String)"allSpaces must not be null", (Object)allSpaces);
        SpaceServiceTest.assertEquals((String)("allSpaces.getSize() must return: " + count), (int)count, (int)allSpaces.getSize());
        SpaceServiceTest.assertEquals((String)"allSpaces.load(0, 1).length must return: 1", (int)1, (int)((Space[])allSpaces.load(0, 1)).length);
        SpaceServiceTest.assertEquals((String)("allSpaces.load(0, count).length must return: " + count), (int)count, (int)((Space[])allSpaces.load(0, count)).length);
    }

    public void testGetSpaceMembershipDate() throws Exception {
        Space space = this.populateData();
        SpaceServiceTest.assertNotNull((Object)this.spaceService.getSpaceMembershipDate(Long.parseLong(space.getId()), "root"));
        SpaceServiceTest.assertNotNull((Object)this.spaceService.getSpaceMembershipDate(Long.parseLong(space.getId()), "john"));
        SpaceServiceTest.assertNull((Object)this.spaceService.getSpaceMembershipDate(Long.parseLong(space.getId()), "notExistingUser"));
    }

    public void testGetSpaceByDisplayName() throws Exception {
        Space space = this.populateData();
        Space gotSpace1 = this.spaceService.getSpaceByDisplayName("Space1");
        SpaceServiceTest.assertNotNull((String)"gotSpace1 must not be null", (Object)gotSpace1);
        SpaceServiceTest.assertEquals((String)space.getDisplayName(), (String)gotSpace1.getDisplayName());
    }

    public void testGetSpaceByPrettyName() throws Exception {
        int count = 5;
        for (int i = 0; i < count; ++i) {
            this.getSpaceInstance(i);
        }
        Space foundSpace = this.spaceService.getSpaceByPrettyName("my_space_4");
        SpaceServiceTest.assertNotNull((String)"foundSpace must not be null", (Object)foundSpace);
        SpaceServiceTest.assertEquals((String)"foundSpace.getDisplayName() must return: my space 4", (String)"my space 4", (String)foundSpace.getDisplayName());
        SpaceServiceTest.assertEquals((String)"foundSpace.getPrettyName() must return: my_space_4", (String)"my_space_4", (String)foundSpace.getPrettyName());
        foundSpace = this.spaceService.getSpaceByPrettyName("my_space_0");
        SpaceServiceTest.assertNotNull((String)"foundSpace must not be null", (Object)foundSpace);
        SpaceServiceTest.assertEquals((String)"foundSpace.getDisplayName() must return: my space 0", (String)"my space 0", (String)foundSpace.getDisplayName());
        SpaceServiceTest.assertEquals((String)"foundSpace.getPrettyName() must return: my_space_0", (String)"my_space_0", (String)foundSpace.getPrettyName());
        foundSpace = this.spaceService.getSpaceByPrettyName("my_space_5");
        SpaceServiceTest.assertNull((String)"foundSpace must be null", (Object)foundSpace);
    }

    public void testDefaultSpaceAvatar() throws Exception {
        this.getSpaceInstance(0);
        Space space = this.spaceService.getSpaceByPrettyName("my_space_0");
        SpaceServiceTest.assertNotNull((String)"space must not be null", (Object)space);
        org.exoplatform.social.core.identity.model.Identity identity = new org.exoplatform.social.core.identity.model.Identity("space", space.getPrettyName());
        this.identityStorage.saveIdentity(identity);
        this.tearDownUserList.add(identity);
        Profile profile = new Profile(identity);
        profile.setProperty("fullName", (Object)space.getDisplayName());
        this.identityStorage.saveProfile(profile);
        identity.setProfile(profile);
        String identityId = identity.getId();
        SpaceServiceTest.assertNotNull((Object)identityId);
        FileItem avatarFile = this.identityStorage.getAvatarFile(identity);
        SpaceServiceTest.assertNotNull((Object)avatarFile);
        Long avatarFileId = avatarFile.getFileInfo().getId();
        SpaceServiceTest.assertNotNull((Object)avatarFileId);
        SpaceServiceTest.assertEquals((String)"DEFAULT_AVATAR", (String)avatarFile.getFileInfo().getName());
        profile = this.identityStorage.loadProfile(profile);
        SpaceServiceTest.assertTrue((boolean)profile.isDefaultAvatar());
    }

    public void testUpdateSpaceAvatar() throws Exception {
        this.getSpaceInstance(0);
        Space space = this.spaceService.getSpaceByPrettyName("my_space_0");
        SpaceServiceTest.assertNotNull((String)"space must not be null", (Object)space);
        org.exoplatform.social.core.identity.model.Identity identity = new org.exoplatform.social.core.identity.model.Identity("space", space.getPrettyName());
        this.identityStorage.saveIdentity(identity);
        this.tearDownUserList.add(identity);
        FileItem avatarFile = this.identityStorage.getAvatarFile(identity);
        SpaceServiceTest.assertNotNull((Object)avatarFile);
        SpaceServiceTest.assertEquals((String)"DEFAULT_AVATAR", (String)avatarFile.getFileInfo().getName());
        Profile profile = new Profile(identity);
        identity.setProfile(profile);
        profile = this.identityStorage.loadProfile(profile);
        SpaceServiceTest.assertTrue((boolean)profile.isDefaultAvatar());
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        AvatarAttachment avatarAttachment = new AvatarAttachment(null, "space-avatar", "png", inputStream, System.currentTimeMillis());
        space.setAvatarAttachment(avatarAttachment);
        this.spaceService.updateSpaceAvatar(space, space.getManagers()[0]);
        profile = new Profile(identity);
        profile.setProperty("avatar", (Object)space.getAvatarAttachment());
        this.identityStorage.saveProfile(profile);
        FileItem newAvatarFile = this.identityStorage.getAvatarFile(identity);
        SpaceServiceTest.assertNotNull((Object)avatarFile);
        Assert.assertNotEquals((Object)"DEFAULT_AVATAR", (Object)newAvatarFile.getFileInfo().getName());
        profile = this.identityStorage.loadProfile(profile);
        SpaceServiceTest.assertFalse((boolean)profile.isDefaultAvatar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRenameSpaceWithDefaultAvatar() throws Exception {
        Space space = this.getSpaceInstance(0);
        SpaceServiceTest.assertNotNull((Object)space);
        org.exoplatform.social.core.identity.model.Identity identity = new org.exoplatform.social.core.identity.model.Identity("space", space.getPrettyName());
        SpaceServiceTest.assertNotNull((Object)identity);
        this.identityStorage.saveIdentity(identity);
        this.tearDownUserList.add(identity);
        String newDisplayName = "new display name";
        SpaceListenerPluginMock spaceListenerPlugin = new SpaceListenerPluginMock();
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        try {
            this.spaceService.renameSpace(space, newDisplayName, this.root.getRemoteId());
        }
        finally {
            this.spaceService.unregisterSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        }
        Space got = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((String)newDisplayName, (String)got.getDisplayName());
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.SPACE_RENAMED, (Object)spaceListenerPlugin.getEvents().get(0));
    }

    public void testGetBookmarkedSpace() throws Exception {
        Space space1 = this.createSpace("Space1", this.john.getRemoteId());
        this.createSpace("Space2", this.john.getRemoteId());
        Space space3 = this.createSpace("Space3", this.john.getRemoteId());
        this.createSpace("Space4", this.john.getRemoteId());
        FavoriteService favoriteService = (FavoriteService)ExoContainerContext.getService(FavoriteService.class);
        Favorite space1Favorite = new Favorite("space", space1.getId(), null, Long.parseLong(this.john.getId()));
        favoriteService.createFavorite(space1Favorite);
        Favorite space2Favorite = new Favorite("space", space3.getId(), null, Long.parseLong(this.john.getId()));
        favoriteService.createFavorite(space2Favorite);
        SpaceFilter spaceFilter = new SpaceFilter();
        SpaceServiceTest.assertEquals((int)4, (int)this.spaceService.getAccessibleSpacesByFilter(this.john.getRemoteId(), spaceFilter).getSize());
        spaceFilter.setRemoteId(this.john.getRemoteId());
        ListAccess listAccess = this.spaceService.getAllSpacesByFilter(spaceFilter);
        SpaceServiceTest.assertEquals((int)4, (int)listAccess.getSize());
        Space[] spacesList = (Space[])listAccess.load(0, 10);
        SpaceServiceTest.assertEquals((int)4, (int)spacesList.length);
        SpaceServiceTest.assertEquals((int)4, (int)this.spaceService.getAccessibleSpacesByFilter(this.john.getRemoteId(), spaceFilter).getSize());
        spaceFilter.setIsFavorite(true);
        listAccess = this.spaceService.getAllSpacesByFilter(spaceFilter);
        SpaceServiceTest.assertEquals((int)2, (int)listAccess.getSize());
        spacesList = (Space[])listAccess.load(0, 10);
        SpaceServiceTest.assertEquals((int)2, (int)spacesList.length);
        SpaceServiceTest.assertEquals((int)2, (int)this.spaceService.getAccessibleSpacesByFilter(this.john.getRemoteId(), spaceFilter).getSize());
        favoriteService.deleteFavorite(space1Favorite);
        listAccess = this.spaceService.getAllSpacesByFilter(spaceFilter);
        SpaceServiceTest.assertEquals((int)1, (int)listAccess.getSize());
        spacesList = (Space[])listAccess.load(0, 10);
        SpaceServiceTest.assertEquals((int)1, (int)spacesList.length);
        SpaceServiceTest.assertEquals((int)1, (int)this.spaceService.getAccessibleSpacesByFilter(this.john.getRemoteId(), spaceFilter).getSize());
        favoriteService.deleteFavorite(space2Favorite);
        listAccess = this.spaceService.getAllSpacesByFilter(spaceFilter);
        SpaceServiceTest.assertEquals((int)0, (int)listAccess.getSize());
        spacesList = (Space[])listAccess.load(0, 10);
        SpaceServiceTest.assertEquals((int)0, (int)spacesList.length);
        SpaceServiceTest.assertEquals((int)0, (int)this.spaceService.getAccessibleSpacesByFilter(this.john.getRemoteId(), spaceFilter).getSize());
    }

    public void testGetFavoriteSpacesByFilter() throws Exception {
        Space space1 = this.createSpace("Space1", this.john.getRemoteId());
        this.createSpace("Space2", this.john.getRemoteId());
        Space space3 = this.createSpace("Space3", this.john.getRemoteId());
        this.createSpace("Space4", this.john.getRemoteId());
        FavoriteService favoriteService = (FavoriteService)ExoContainerContext.getService(FavoriteService.class);
        Favorite space1Favorite = new Favorite("space", space1.getId(), null, Long.parseLong(this.john.getId()));
        favoriteService.createFavorite(space1Favorite);
        Favorite space3Favorite = new Favorite("space", space3.getId(), null, Long.parseLong(this.john.getId()));
        favoriteService.createFavorite(space3Favorite);
        favoriteService.createFavorite(new Favorite("space", space3.getId(), null, Long.parseLong(this.root.getId())));
        SpaceFilter spaceFilter = new SpaceFilter();
        SpaceServiceTest.assertEquals((int)4, (int)this.spaceService.getAccessibleSpacesByFilter(this.john.getRemoteId(), spaceFilter).getSize());
        SpaceServiceTest.assertEquals((int)2, (int)this.spaceService.getFavoriteSpacesByFilter(this.john.getRemoteId(), spaceFilter).getSize());
        SpaceServiceTest.assertEquals((int)1, (int)this.spaceService.getFavoriteSpacesByFilter(this.root.getRemoteId(), spaceFilter).getSize());
        SpaceServiceTest.assertEquals((int)0, (int)this.spaceService.getFavoriteSpacesByFilter(this.mary.getRemoteId(), spaceFilter).getSize());
        ListAccess listAccess = this.spaceService.getFavoriteSpacesByFilter(this.john.getRemoteId(), spaceFilter);
        Space[] spacesList = (Space[])listAccess.load(0, 10);
        SpaceServiceTest.assertEquals((int)2, (int)spacesList.length);
        favoriteService.deleteFavorite(space1Favorite);
        listAccess = this.spaceService.getFavoriteSpacesByFilter(this.john.getRemoteId(), spaceFilter);
        SpaceServiceTest.assertEquals((int)1, (int)listAccess.getSize());
        spacesList = (Space[])listAccess.load(0, 10);
        SpaceServiceTest.assertEquals((int)1, (int)spacesList.length);
        this.spaceService.deleteSpace(space3);
        listAccess = this.spaceService.getFavoriteSpacesByFilter(this.john.getRemoteId(), spaceFilter);
        SpaceServiceTest.assertEquals((int)0, (int)listAccess.getSize());
        spacesList = (Space[])listAccess.load(0, 10);
        SpaceServiceTest.assertEquals((int)0, (int)spacesList.length);
    }

    public void testGetSpaceById() throws Exception {
        Space space = this.populateData();
        this.createMoreSpace("Space2");
        SpaceServiceTest.assertEquals((String)space.getDisplayName(), (String)this.spaceService.getSpaceById(space.getId()).getDisplayName());
    }

    public void testGetSpaceByUrl() throws Exception {
        Space space = this.populateData();
        SpaceServiceTest.assertEquals((String)space.getDisplayName(), (String)this.spaceService.getSpaceByUrl("space1").getDisplayName());
    }

    public void testCanRedact() throws Exception {
        Identity rootACLIdentity = new Identity("root");
        Identity johnACLIdentity = new Identity("john", Collections.singleton(new MembershipEntry("/platform/administrators", "*")));
        Identity demoACLIdentity = new Identity("demo");
        Identity jamesACLIdentity = new Identity("james");
        Identity maryACLIdentity = new Identity("mary");
        Identity raulACLIdentity = new Identity("raul");
        ConversationState.setCurrent((ConversationState)new ConversationState(demoACLIdentity));
        Space space = this.createSpace("spaceTestRedact", "demo");
        space.setMembers(new String[]{"demo", "james", "raul"});
        this.spaceService.updateSpace(space);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, rootACLIdentity));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, johnACLIdentity));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, demoACLIdentity));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, jamesACLIdentity));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, raulACLIdentity));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canRedactOnSpace(space, maryACLIdentity));
        space.setMembers(new String[]{"demo", "james", "raul", "mary"});
        space.setRedactors(new String[]{"james"});
        space.setPublishers(new String[]{"mary"});
        this.spaceService.updateSpace(space);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, rootACLIdentity));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, johnACLIdentity));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, demoACLIdentity));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canRedactOnSpace(space, jamesACLIdentity));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canRedactOnSpace(space, maryACLIdentity));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canRedactOnSpace(space, raulACLIdentity));
    }

    public void testCanView() throws Exception {
        Identity rootACLIdentity = new Identity("root");
        Identity johnACLIdentity = new Identity("john", Collections.singleton(new MembershipEntry("/platform/administrators", "*")));
        Identity demoACLIdentity = new Identity("demo");
        Identity jamesACLIdentity = new Identity("james");
        Identity maryACLIdentity = new Identity("mary");
        ConversationState.setCurrent((ConversationState)new ConversationState(demoACLIdentity));
        Space space = this.createSpace("spaceTestView", "demo");
        space.setMembers(new String[]{"demo", "james"});
        this.spaceService.updateSpace(space);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canViewSpace(space, rootACLIdentity.getUserId()));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canViewSpace(space, johnACLIdentity.getUserId()));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canViewSpace(space, jamesACLIdentity.getUserId()));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canViewSpace(space, maryACLIdentity.getUserId()));
    }

    public void testCanManage() throws Exception {
        Identity rootACLIdentity = new Identity("root");
        Identity johnACLIdentity = new Identity("john", Collections.singleton(new MembershipEntry("/platform/administrators", "*")));
        Identity demoACLIdentity = new Identity("demo");
        Identity jamesACLIdentity = new Identity("james");
        Identity maryACLIdentity = new Identity("mary");
        Identity raulACLIdentity = new Identity("raul");
        Identity paulACLIdentity = new Identity("paul");
        ConversationState.setCurrent((ConversationState)new ConversationState(demoACLIdentity));
        Space space = this.createSpace("spaceTestManage", "demo");
        space.setMembers(new String[]{"demo", "james", "mary", "raul"});
        space.setManagers(new String[]{"mary"});
        space.setPublishers(new String[]{"raul"});
        space.setRedactors(new String[]{"james"});
        this.spaceService.updateSpace(space);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canManageSpace(space, rootACLIdentity.getUserId()));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canManageSpace(space, johnACLIdentity.getUserId()));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canManageSpace(space, maryACLIdentity.getUserId()));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canManageSpace(space, raulACLIdentity.getUserId()));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canManageSpace(space, jamesACLIdentity.getUserId()));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canManageSpace(space, demoACLIdentity.getUserId()));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canManageSpace(space, paulACLIdentity.getUserId()));
    }

    public void testCanPublish() throws Exception {
        Identity rootACLIdentity = new Identity("root");
        Identity johnACLIdentity = new Identity("john", Collections.singleton(new MembershipEntry("/platform/administrators", "*")));
        Identity demoACLIdentity = new Identity("demo");
        Identity jamesACLIdentity = new Identity("james");
        Identity maryACLIdentity = new Identity("mary");
        Identity raulACLIdentity = new Identity("raul");
        Identity paulACLIdentity = new Identity("paul");
        ConversationState.setCurrent((ConversationState)new ConversationState(demoACLIdentity));
        Space space = this.createSpace("spaceTestPublish", "demo");
        space.setMembers(new String[]{"demo", "james", "mary", "raul"});
        space.setManagers(new String[]{"mary"});
        space.setPublishers(new String[]{"raul"});
        space.setRedactors(new String[]{"james"});
        this.spaceService.updateSpace(space);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canPublishOnSpace(space, rootACLIdentity.getUserId()));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canPublishOnSpace(space, johnACLIdentity.getUserId()));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canPublishOnSpace(space, maryACLIdentity.getUserId()));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.canPublishOnSpace(space, raulACLIdentity.getUserId()));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canPublishOnSpace(space, jamesACLIdentity.getUserId()));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canPublishOnSpace(space, demoACLIdentity.getUserId()));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.canPublishOnSpace(space, paulACLIdentity.getUserId()));
    }

    public void testGetSettingableSpaces() throws Exception {
        int count = 5;
        for (int i = 0; i < count; ++i) {
            this.getSpaceInstance(i);
        }
        ListAccess editableSpaceListAccess = this.spaceService.getSettingableSpaces("demo");
        SpaceServiceTest.assertNotNull((String)"editableSpaceListAccess must not be null", (Object)editableSpaceListAccess);
        SpaceServiceTest.assertEquals((String)("editableSpaceListAccess.getSize() must return: " + count), (int)count, (int)editableSpaceListAccess.getSize());
        SpaceServiceTest.assertEquals((String)"editableSpaceListAccess.load(0, 1).length must return: 1", (int)1, (int)((Space[])editableSpaceListAccess.load(0, 1)).length);
        SpaceServiceTest.assertEquals((String)("editableSpaceListAccess.load(0, count).length must return: " + count), (int)count, (int)((Space[])editableSpaceListAccess.load(0, count)).length);
        editableSpaceListAccess = this.spaceService.getSettingableSpaces("tom");
        SpaceServiceTest.assertNotNull((String)"editableSpaceListAccess must not be null", (Object)editableSpaceListAccess);
        SpaceServiceTest.assertEquals((String)("editableSpaceListAccess.getSize() must return: " + count), (int)count, (int)editableSpaceListAccess.getSize());
        editableSpaceListAccess = this.spaceService.getSettingableSpaces("root");
        SpaceServiceTest.assertNotNull((String)"editableSpaceListAccess must not be null", (Object)editableSpaceListAccess);
        SpaceServiceTest.assertEquals((String)("editableSpaceListAccess.getSize() must return: " + count), (int)count, (int)editableSpaceListAccess.getSize());
        editableSpaceListAccess = this.spaceService.getSettingableSpaces("raul");
        SpaceServiceTest.assertNotNull((String)"editableSpaceListAccess must not be null", (Object)editableSpaceListAccess);
        SpaceServiceTest.assertEquals((String)"editableSpaceListAccess.getSize() must return: 0", (int)0, (int)editableSpaceListAccess.getSize());
        editableSpaceListAccess = this.spaceService.getSettingableSpaces("ghost");
        SpaceServiceTest.assertNotNull((String)"editableSpaceListAccess must not be null", (Object)editableSpaceListAccess);
        SpaceServiceTest.assertEquals((String)"editableSpaceListAccess.getSize() must return: 0", (int)0, (int)editableSpaceListAccess.getSize());
    }

    public void testGetSettingableSpacesByFilter() throws Exception {
        int count = 5;
        for (int i = 0; i < count; ++i) {
            this.getSpaceInstance(i);
        }
        ListAccess editableSpaceListAccess = this.spaceService.getSettingabledSpacesByFilter("demo", new SpaceFilter("add"));
        SpaceServiceTest.assertNotNull((String)"editableSpaceListAccess must not be null", (Object)editableSpaceListAccess);
        SpaceServiceTest.assertEquals((String)("editableSpaceListAccess.getSize() must return: " + count), (int)count, (int)editableSpaceListAccess.getSize());
        SpaceServiceTest.assertEquals((String)"editableSpaceListAccess.load(0, 1).length must return: 1", (int)1, (int)((Space[])editableSpaceListAccess.load(0, 1)).length);
        SpaceServiceTest.assertEquals((String)("editableSpaceListAccess.load(0, count).length must return: " + count), (int)count, (int)((Space[])editableSpaceListAccess.load(0, count)).length);
        editableSpaceListAccess = this.spaceService.getSettingabledSpacesByFilter(this.demo.getRemoteId(), new SpaceFilter("4"));
        SpaceServiceTest.assertEquals((String)"editableSpaceListAccess.getSize() must return 1", (int)1, (int)editableSpaceListAccess.getSize());
        SpaceServiceTest.assertEquals((String)"editableSpaceListAccess.load(0, 1).length must return 1", (int)1, (int)((Space[])editableSpaceListAccess.load(0, 1)).length);
        editableSpaceListAccess = this.spaceService.getSettingabledSpacesByFilter("demo", new SpaceFilter("my"));
        SpaceServiceTest.assertNotNull((String)"editableSpaceListAccess must not be null", (Object)editableSpaceListAccess);
        SpaceServiceTest.assertEquals((String)("editableSpaceListAccess.getSize() must return: " + count), (int)count, (int)editableSpaceListAccess.getSize());
        editableSpaceListAccess = this.spaceService.getSettingabledSpacesByFilter("demo", new SpaceFilter("new"));
        SpaceServiceTest.assertNotNull((String)"editableSpaceListAccess must not be null", (Object)editableSpaceListAccess);
        SpaceServiceTest.assertEquals((String)("editableSpaceListAccess.getSize() must return: " + count), (int)count, (int)editableSpaceListAccess.getSize());
        editableSpaceListAccess = this.spaceService.getSettingabledSpacesByFilter("demo", new SpaceFilter());
        SpaceServiceTest.assertNotNull((String)"editableSpaceListAccess must not be null", (Object)editableSpaceListAccess);
        SpaceServiceTest.assertEquals((String)("editableSpaceListAccess.getSize() must return: " + count), (int)count, (int)editableSpaceListAccess.getSize());
        editableSpaceListAccess = this.spaceService.getSettingabledSpacesByFilter("demo", new SpaceFilter());
        SpaceServiceTest.assertNotNull((String)"editableSpaceListAccess must not be null", (Object)editableSpaceListAccess);
        SpaceServiceTest.assertEquals((String)("editableSpaceListAccess.getSize() must return: " + count), (int)count, (int)editableSpaceListAccess.getSize());
        editableSpaceListAccess = this.spaceService.getSettingabledSpacesByFilter("demo", new SpaceFilter());
        SpaceServiceTest.assertNotNull((String)"editableSpaceListAccess must not be null", (Object)editableSpaceListAccess);
        SpaceServiceTest.assertEquals((String)("editableSpaceListAccess.getSize() must return: " + count), (int)count, (int)editableSpaceListAccess.getSize());
        editableSpaceListAccess = this.spaceService.getSettingabledSpacesByFilter("tom", new SpaceFilter("new"));
        SpaceServiceTest.assertNotNull((String)"editableSpaceListAccess must not be null", (Object)editableSpaceListAccess);
        SpaceServiceTest.assertEquals((String)("editableSpaceListAccess.getSize() must return: " + count), (int)count, (int)editableSpaceListAccess.getSize());
        editableSpaceListAccess = this.spaceService.getSettingabledSpacesByFilter("root", new SpaceFilter("space"));
        SpaceServiceTest.assertNotNull((String)"editableSpaceListAccess must not be null", (Object)editableSpaceListAccess);
        SpaceServiceTest.assertEquals((String)("editableSpaceListAccess.getSize() must return: " + count), (int)count, (int)editableSpaceListAccess.getSize());
        editableSpaceListAccess = this.spaceService.getSettingabledSpacesByFilter("raul", new SpaceFilter("my"));
        SpaceServiceTest.assertNotNull((String)"editableSpaceListAccess must not be null", (Object)editableSpaceListAccess);
        SpaceServiceTest.assertEquals((String)"editableSpaceListAccess.getSize() must return: 0", (int)0, (int)editableSpaceListAccess.getSize());
        editableSpaceListAccess = this.spaceService.getSettingabledSpacesByFilter("ghost", new SpaceFilter("space"));
        SpaceServiceTest.assertNotNull((String)"editableSpaceListAccess must not be null", (Object)editableSpaceListAccess);
        SpaceServiceTest.assertEquals((String)"editableSpaceListAccess.getSize() must return: 0", (int)0, (int)editableSpaceListAccess.getSize());
    }

    public void testGetInvitedSpacesWithListAccess() throws Exception {
        int count = 5;
        for (int i = 0; i < count; ++i) {
            this.getSpaceInstance(i);
        }
        ListAccess invitedSpaces = this.spaceService.getInvitedSpacesWithListAccess("register1");
        SpaceServiceTest.assertNotNull((String)"invitedSpaces must not be null", (Object)invitedSpaces);
        SpaceServiceTest.assertEquals((String)("invitedSpaces.getSize() must return: " + count), (int)count, (int)invitedSpaces.getSize());
        SpaceServiceTest.assertEquals((String)"invitedSpaces.load(0, 1).length must return: 1", (int)1, (int)((Space[])invitedSpaces.load(0, 1)).length);
        SpaceServiceTest.assertEquals((String)("invitedSpaces.load(0, count).length must return: " + count), (int)count, (int)((Space[])invitedSpaces.load(0, count)).length);
        invitedSpaces = this.spaceService.getInvitedSpacesWithListAccess("mary");
        SpaceServiceTest.assertNotNull((String)"invitedSpaces must not be null", (Object)invitedSpaces);
        SpaceServiceTest.assertEquals((String)("invitedSpaces.getSize() must return: " + count), (int)count, (int)invitedSpaces.getSize());
        invitedSpaces = this.spaceService.getInvitedSpacesWithListAccess("demo");
        SpaceServiceTest.assertNotNull((String)"invitedSpaces must not be null", (Object)invitedSpaces);
        SpaceServiceTest.assertEquals((String)"invitedSpaces.getSize() must return: 0", (int)0, (int)invitedSpaces.getSize());
    }

    public void testGetPublicSpacesWithListAccess() throws Exception {
        int count = 5;
        for (int i = 0; i < count; ++i) {
            this.getSpaceInstance(i);
        }
        ListAccess foundSpaces = this.spaceService.getPublicSpacesWithListAccess("tom");
        SpaceServiceTest.assertNotNull((String)"foundSpaces must not be null", (Object)foundSpaces);
        SpaceServiceTest.assertEquals((String)"foundSpaces.getSize() must return: 0", (int)0, (int)foundSpaces.getSize());
        foundSpaces = this.spaceService.getPublicSpacesWithListAccess("hacker");
        SpaceServiceTest.assertNotNull((String)"foundSpaces must not be null", (Object)foundSpaces);
        SpaceServiceTest.assertEquals((String)"foundSpaces.getSize() must return: 0", (int)0, (int)foundSpaces.getSize());
        foundSpaces = this.spaceService.getPublicSpacesWithListAccess("mary");
        SpaceServiceTest.assertNotNull((String)"foundSpaces must not be null", (Object)foundSpaces);
        SpaceServiceTest.assertEquals((String)"foundSpaces.getSize() must return: 0", (int)0, (int)foundSpaces.getSize());
        foundSpaces = this.spaceService.getPublicSpacesWithListAccess("root");
        SpaceServiceTest.assertNotNull((String)"foundSpaces must not be null", (Object)foundSpaces);
        SpaceServiceTest.assertEquals((String)"foundSpaces.getSize() must return: 0", (int)0, (int)foundSpaces.getSize());
        foundSpaces = this.spaceService.getPublicSpacesWithListAccess("nobody");
        SpaceServiceTest.assertNotNull((String)"foundSpaces must not be null", (Object)foundSpaces);
        SpaceServiceTest.assertEquals((String)"foundSpaces.getSize() must return: 5", (int)count, (int)foundSpaces.getSize());
        SpaceServiceTest.assertEquals((String)"foundSpaces.load(0, 1).length must return: 1", (int)1, (int)((Space[])foundSpaces.load(0, 1)).length);
        SpaceServiceTest.assertEquals((String)"foundSpaces.load(0, 5).length must return: 5", (int)5, (int)((Space[])foundSpaces.load(0, 5)).length);
        foundSpaces = this.spaceService.getPublicSpacesWithListAccess("bluray");
        SpaceServiceTest.assertNotNull((String)"foundSpaces must not be null", (Object)foundSpaces);
        SpaceServiceTest.assertEquals((String)"foundSpaces.getSize() must return: 5", (int)count, (int)foundSpaces.getSize());
    }

    public void testCountPendingSpaceRequestsToManage() throws Exception {
        this.populateData();
        Space space = this.spaceService.getSpaceByDisplayName("Space1");
        this.spaceService.requestJoin(space, "paul");
        this.spaceService.requestJoin(space, "james");
        ListAccess listAccess = this.spaceService.getPendingSpaceRequestsToManage("root");
        SpaceServiceTest.assertNotNull((Object)listAccess);
        SpaceServiceTest.assertEquals((int)2, (int)listAccess.getSize());
        SpaceServiceTest.assertEquals((int)2, (int)((Space[])listAccess.load(0, 10)).length);
        Space[] pendingSpaceRequestsToManage = (Space[])listAccess.load(0, 1);
        SpaceServiceTest.assertEquals((int)1, (int)pendingSpaceRequestsToManage.length);
        Space spaceToManage = pendingSpaceRequestsToManage[0];
        String[] pendingUsers = spaceToManage.getPendingUsers();
        SpaceServiceTest.assertEquals((int)1, (int)pendingUsers.length);
        pendingSpaceRequestsToManage = (Space[])listAccess.load(0, 10);
        SpaceServiceTest.assertEquals((int)2, (int)pendingSpaceRequestsToManage.length);
        boolean hasPaul = pendingSpaceRequestsToManage[0].getPendingUsers()[0].equals("paul") || pendingSpaceRequestsToManage[1].getPendingUsers()[0].equals("paul");
        boolean hasJames = pendingSpaceRequestsToManage[0].getPendingUsers()[0].equals("james") || pendingSpaceRequestsToManage[1].getPendingUsers()[0].equals("james");
        SpaceServiceTest.assertTrue((hasJames && hasPaul ? 1 : 0) != 0);
    }

    public void testGetPendingSpacesWithListAccess() throws Exception {
        int count = 5;
        for (int i = 0; i < count; ++i) {
            this.getSpaceInstance(i);
        }
        ListAccess foundSpaces = this.spaceService.getPendingSpacesWithListAccess("jame");
        SpaceServiceTest.assertNotNull((String)"foundSpaces must not be null", (Object)foundSpaces);
        SpaceServiceTest.assertEquals((String)("foundSpaces.getSize() must return: " + count), (int)count, (int)foundSpaces.getSize());
        SpaceServiceTest.assertEquals((String)"foundSpaces.load(0, 1).length must return: 1", (int)1, (int)((Space[])foundSpaces.load(0, 1)).length);
        SpaceServiceTest.assertEquals((String)("foundSpaces.load(0, count).length must return: " + count), (int)count, (int)((Space[])foundSpaces.load(0, count)).length);
        foundSpaces = this.spaceService.getPendingSpacesWithListAccess("paul");
        SpaceServiceTest.assertNotNull((String)"foundSpaces must not be null", (Object)foundSpaces);
        SpaceServiceTest.assertEquals((String)("foundSpaces.getSize() must return: " + count), (int)count, (int)foundSpaces.getSize());
        foundSpaces = this.spaceService.getPendingSpacesWithListAccess("hacker");
        SpaceServiceTest.assertNotNull((String)"foundSpaces must not be null", (Object)foundSpaces);
        SpaceServiceTest.assertEquals((String)("foundSpaces.getSize() must return: " + count), (int)count, (int)foundSpaces.getSize());
        foundSpaces = this.spaceService.getPendingSpacesWithListAccess("ghost");
        SpaceServiceTest.assertNotNull((String)"foundSpaces must not be null", (Object)foundSpaces);
        SpaceServiceTest.assertEquals((String)"foundSpaces.getSize() must return: 0", (int)0, (int)foundSpaces.getSize());
        foundSpaces = this.spaceService.getPendingSpacesWithListAccess("hellgate");
        SpaceServiceTest.assertNotNull((String)"foundSpaces must not be null", (Object)foundSpaces);
        SpaceServiceTest.assertEquals((String)"foundSpaces.getSize() must return: 0", (int)0, (int)foundSpaces.getSize());
    }

    public void testCreateSpace() throws Exception {
        this.populateData();
        this.createMoreSpace("Space2");
        ListAccess spaceListAccess = this.spaceService.getAllSpacesWithListAccess();
        SpaceServiceTest.assertNotNull((String)"spaceListAccess must not be null", (Object)spaceListAccess);
        SpaceServiceTest.assertEquals((String)"spaceListAccess.getSize() must return: 2", (int)2, (int)spaceListAccess.getSize());
    }

    public void testCreateSpaceWithManagersAndMembers() throws SpaceException {
        String[] managers = new String[]{"manager"};
        String[] members = new String[]{"member1", "member2", "member3"};
        String creator = "root";
        String invitedGroup = "invited";
        Space space = new Space();
        space.setDisplayName("testSpace");
        space.setDescription("Space Description for Testing");
        String shortName = Utils.cleanString((String)space.getDisplayName());
        space.setGroupId("/spaces/" + shortName);
        space.setManagers(managers);
        space.setMembers(members);
        space.setPrettyName(space.getDisplayName());
        space.setPriority("3");
        space.setRegistration("validation");
        space.setTag("Space Tag for Testing");
        space.setType("classic");
        space.setUrl(shortName);
        space.setVisibility("public");
        this.spaceService.createSpace(space, creator);
        this.tearDownSpaceList.add(space);
        SpaceServiceTest.assertEquals((int)2, (int)space.getManagers().length);
        SpaceServiceTest.assertEquals((int)4, (int)space.getMembers().length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateSpaceEvent() throws SpaceException {
        String[] managers = new String[]{"manager"};
        String creator = "root";
        String[] users = new String[]{"member1", "member2"};
        ArrayList<org.exoplatform.social.core.identity.model.Identity> invitedIdentities = new ArrayList<org.exoplatform.social.core.identity.model.Identity>(Arrays.asList(this.tom, this.dragon, this.hearBreaker));
        Space space = new Space();
        space.setDisplayName("testSpace");
        space.setDescription("Space Description for Testing");
        String shortName = Utils.cleanString((String)space.getDisplayName());
        space.setGroupId("/spaces/" + shortName);
        space.setManagers(managers);
        space.setPrettyName(space.getDisplayName());
        space.setPriority("3");
        space.setRegistration("validation");
        space.setTag("Space Tag for Testing");
        space.setType("classic");
        space.setUrl(shortName);
        space.setVisibility("public");
        SpaceListenerPluginMock spaceListenerPlugin = new SpaceListenerPluginMock();
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        try {
            this.spaceService.createSpace(space, creator, invitedIdentities);
            this.tearDownSpaceList.add(space);
        }
        finally {
            this.spaceService.unregisterSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        }
        SpaceServiceTest.assertEquals((int)4, (int)spaceListenerPlugin.getEvents().size());
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.SPACE_CREATED, (Object)spaceListenerPlugin.getEvents().get(0));
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.ADD_INVITED_USER, (Object)spaceListenerPlugin.getEvents().get(1));
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.ADD_INVITED_USER, (Object)spaceListenerPlugin.getEvents().get(2));
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.ADD_INVITED_USER, (Object)spaceListenerPlugin.getEvents().get(3));
    }

    public void testUpdateSpaceDescription() throws Exception {
        Space space = this.createSpace("spaceUpdateDescription", "demo");
        SpaceListenerPluginMock spaceListenerPlugin = new SpaceListenerPluginMock();
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        try {
            space.setDescription("Updated Description");
            this.spaceService.updateSpace(space);
            this.tearDownSpaceList.add(space);
        }
        finally {
            this.spaceService.unregisterSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        }
        SpaceServiceTest.assertEquals((int)1, (int)spaceListenerPlugin.getEvents().size());
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.SPACE_DESCRIPTION_EDITED, (Object)spaceListenerPlugin.getEvents().get(0));
    }

    public void testUpdateSpaceAccess() throws Exception {
        Space space = this.createSpace("spaceUpdateAccess", "demo");
        SpaceListenerPluginMock spaceListenerPlugin = new SpaceListenerPluginMock();
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        try {
            space.setVisibility("hidden");
            this.spaceService.updateSpace(space);
            this.tearDownSpaceList.add(space);
        }
        finally {
            this.spaceService.unregisterSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        }
        SpaceServiceTest.assertEquals((int)1, (int)spaceListenerPlugin.getEvents().size());
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.SPACE_HIDDEN, (Object)spaceListenerPlugin.getEvents().get(0));
    }

    public void testUpdateSpaceRegistration() throws Exception {
        Space space = this.createSpace("spaceUpdateRegistration", "demo");
        SpaceListenerPluginMock spaceListenerPlugin = new SpaceListenerPluginMock();
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        try {
            space.setRegistration("validation");
            this.spaceService.updateSpace(space);
            this.tearDownSpaceList.add(space);
        }
        finally {
            this.spaceService.unregisterSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        }
        SpaceServiceTest.assertEquals((int)1, (int)spaceListenerPlugin.getEvents().size());
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.SPACE_REGISTRATION, (Object)spaceListenerPlugin.getEvents().get(0));
    }

    public void testSpaceUserInvitation() throws Exception {
        Space space = this.createSpace("spaceUserInvitation", "demo");
        SpaceListenerPluginMock spaceListenerPlugin = new SpaceListenerPluginMock();
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        try {
            this.spaceService.addInvitedUser(space, this.john.getRemoteId());
            this.tearDownSpaceList.add(space);
        }
        finally {
            this.spaceService.unregisterSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        }
        SpaceServiceTest.assertEquals((int)1, (int)spaceListenerPlugin.getEvents().size());
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.ADD_INVITED_USER, (Object)spaceListenerPlugin.getEvents().get(0));
    }

    public void testSpaceUserInvitationDeny() throws Exception {
        Space space = this.createSpace("spaceUserInvitationDeny", "demo");
        this.spaceService.addInvitedUser(space, this.john.getRemoteId());
        SpaceListenerPluginMock spaceListenerPlugin = new SpaceListenerPluginMock();
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        try {
            this.spaceService.removeInvitedUser(space, this.john.getRemoteId());
            this.tearDownSpaceList.add(space);
        }
        finally {
            this.spaceService.unregisterSpaceListenerPlugin((SpaceListenerPlugin)spaceListenerPlugin);
        }
        SpaceServiceTest.assertEquals((int)1, (int)spaceListenerPlugin.getEvents().size());
        SpaceServiceTest.assertEquals((Object)SpaceLifeCycleEvent.Type.DENY_INVITED_USER, (Object)spaceListenerPlugin.getEvents().get(0));
    }

    public void testCreateSpaceWithInvitation() throws Exception {
        String[] managers = new String[]{"manager"};
        String creator = "root";
        Space spaceCreated = this.createMoreSpace("invitedSpace");
        String[] users = new String[]{"member1", "member2"};
        spaceCreated.setMembers(users);
        this.spaceService.updateSpace(spaceCreated);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.getService(IdentityManager.class).getOrCreateIdentity("space", "invitedspace", false);
        ArrayList<org.exoplatform.social.core.identity.model.Identity> invitedIdentities = new ArrayList<org.exoplatform.social.core.identity.model.Identity>(Arrays.asList(this.tom, this.dragon, this.hearBreaker, spaceIdentity));
        Space space = new Space();
        space.setDisplayName("testSpace");
        space.setDescription("Space Description for Testing");
        String shortName = Utils.cleanString((String)space.getDisplayName());
        space.setGroupId("/spaces/" + shortName);
        space.setManagers(managers);
        space.setPrettyName(space.getDisplayName());
        space.setPriority("3");
        space.setRegistration("validation");
        space.setTag("Space Tag for Testing");
        space.setType("classic");
        space.setUrl(shortName);
        space.setVisibility("public");
        this.spaceService.createSpace(space, creator, invitedIdentities);
        this.tearDownSpaceList.add(space);
        SpaceServiceTest.assertEquals((int)2, (int)space.getManagers().length);
        SpaceServiceTest.assertEquals((int)5, (int)space.getInvitedUsers().length);
    }

    public void testCreateSpaceExceedingNameLimit() throws RuntimeException {
        Space space = new Space();
        String spaceDisplayName = "zzz0123456791011121314151617181920012345679101112131415161718192001234567910111213141516171819200123456791011121314151617181920012345679101112131415161718192001234567910111213141516171819200123456791011121314151617181920012345679101112131415161718192001234567910111213141516171819200123456791011121314151617181920";
        String shortName = "zzz";
        space.setDisplayName(spaceDisplayName);
        space.setPrettyName(shortName);
        space.setRegistration("open");
        space.setDescription("add new space ");
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        String creator = "root";
        space.setGroupId("/spaces/" + shortName);
        try {
            this.spaceService.createSpace(space, creator);
            SpaceServiceTest.fail((String)"Should have thrown an RuntimeException because Name length exceeds limits");
        }
        catch (RuntimeException e) {
            SpaceServiceTest.assertTrue((boolean)e.getMessage().contains("space name cannot exceed 200 characters"));
        }
    }

    public void testCreateSpaceWithInvalidSpaceName() throws RuntimeException {
        Space space = new Space();
        String spaceDisplayName = "%zzz:^!/<>\ud83d\ude01";
        space.setDisplayName(spaceDisplayName);
        String creator = "root";
        String shortName = "zzz";
        space.setDisplayName(spaceDisplayName);
        space.setPrettyName(shortName);
        space.setRegistration("open");
        space.setDescription("add new space ");
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space = this.spaceService.createSpace(space, creator);
        SpaceServiceTest.assertEquals((String)spaceDisplayName, (String)space.getDisplayName());
        SpaceServiceTest.assertFalse((boolean)space.getPrettyName().contains("%"));
        SpaceServiceTest.assertFalse((boolean)space.getPrettyName().contains("^"));
        SpaceServiceTest.assertFalse((boolean)space.getPrettyName().contains(":"));
        SpaceServiceTest.assertFalse((boolean)space.getPrettyName().contains("!"));
        SpaceServiceTest.assertFalse((boolean)space.getPrettyName().contains("/"));
        SpaceServiceTest.assertFalse((boolean)space.getPrettyName().contains("<"));
        SpaceServiceTest.assertFalse((boolean)space.getPrettyName().contains(">"));
        SpaceServiceTest.assertFalse((boolean)space.getPrettyName().contains("\ud83d\ude01"));
    }

    public void testSaveSpace() throws Exception {
        Space space = this.getSpaceInstance(0);
        String spaceDisplayName = space.getDisplayName();
        String spaceDescription = space.getDescription();
        String groupId = space.getGroupId();
        Space savedSpace = this.spaceService.getSpaceByDisplayName(spaceDisplayName);
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceServiceTest.assertEquals((String)("savedSpace.getDisplayName() must return: " + spaceDisplayName), (String)spaceDisplayName, (String)savedSpace.getDisplayName());
        SpaceServiceTest.assertEquals((String)("savedSpace.getDescription() must return: " + spaceDescription), (String)spaceDescription, (String)savedSpace.getDescription());
        SpaceServiceTest.assertEquals((String)("savedSpace.getGroupId() must return: " + groupId), (String)groupId, (String)savedSpace.getGroupId());
        SpaceServiceTest.assertNotNull((Object)savedSpace.getAvatarUrl());
    }

    public void testRenameSpace() throws Exception {
        Space space = this.getSpaceInstance(0);
        org.exoplatform.social.core.identity.model.Identity identity = new org.exoplatform.social.core.identity.model.Identity("space", space.getPrettyName());
        this.identityStorage.saveIdentity(identity);
        this.tearDownUserList.add(identity);
        String newDisplayName = "new display name";
        this.spaceService.renameSpace(space, newDisplayName);
        Space got = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((String)newDisplayName, (String)got.getDisplayName());
        newDisplayName = "new display name with super admin";
        this.spaceService.renameSpace(space, newDisplayName, this.root.getRemoteId());
        got = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((String)newDisplayName, (String)got.getDisplayName());
        Assert.assertThrows(SpaceException.class, () -> this.spaceService.renameSpace(space, "new display name with normal admin", this.mary.getRemoteId()));
        SpaceServiceTest.assertNotNull((Object)this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()));
        String oldPrettyName = space.getPrettyName();
        newDisplayName = "new display name with null remoteId";
        this.spaceService.renameSpace(space, newDisplayName);
        got = this.spaceService.getSpaceById(space.getId());
        SpaceServiceTest.assertEquals((String)newDisplayName, (String)got.getDisplayName());
        SpaceServiceTest.assertNotNull((Object)this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()));
        SpaceServiceTest.assertNull((Object)this.identityManager.getOrCreateSpaceIdentity(oldPrettyName));
    }

    public void testDeleteSpace() throws Exception {
        Space space = this.getSpaceInstance(0);
        String spaceDisplayName = space.getDisplayName();
        String spaceDescription = space.getDescription();
        String groupId = space.getGroupId();
        Space savedSpace = this.spaceService.getSpaceByDisplayName(spaceDisplayName);
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceServiceTest.assertEquals((String)("savedSpace.getDisplayName() must return: " + spaceDisplayName), (String)spaceDisplayName, (String)savedSpace.getDisplayName());
        SpaceServiceTest.assertEquals((String)("savedSpace.getDescription() must return: " + spaceDescription), (String)spaceDescription, (String)savedSpace.getDescription());
        SpaceServiceTest.assertEquals((String)("savedSpace.getGroupId() must return: " + groupId), (String)groupId, (String)savedSpace.getGroupId());
        SpaceServiceTest.assertNotNull((String)("the group " + groupId + " must exist"), (Object)this.organizationService.getGroupHandler().findGroupById(groupId));
        this.spaceService.deleteSpace(space);
        savedSpace = this.spaceService.getSpaceByDisplayName(spaceDisplayName);
        SpaceServiceTest.assertNull((String)"savedSpace must be null", (Object)savedSpace);
        SpaceServiceTest.assertNull((String)("the group " + groupId + " must be deleted after space deletion "), (Object)this.organizationService.getGroupHandler().findGroupById(groupId));
    }

    public void testDeleteSpaceWithoutDelitingGroup() throws Exception {
        Space space = this.getSpaceInstance(0);
        String spaceDisplayName = space.getDisplayName();
        String spaceDescription = space.getDescription();
        String groupId = space.getGroupId();
        Space savedSpace = this.spaceService.getSpaceByDisplayName(spaceDisplayName);
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceServiceTest.assertEquals((String)("savedSpace.getDisplayName() must return: " + spaceDisplayName), (String)spaceDisplayName, (String)savedSpace.getDisplayName());
        SpaceServiceTest.assertEquals((String)("savedSpace.getDescription() must return: " + spaceDescription), (String)spaceDescription, (String)savedSpace.getDescription());
        SpaceServiceTest.assertEquals((String)("savedSpace.getGroupId() must return: " + groupId), (String)groupId, (String)savedSpace.getGroupId());
        SpaceServiceTest.assertNotNull((String)("the group " + groupId + " must exist"), (Object)this.organizationService.getGroupHandler().findGroupById(groupId));
        this.spaceService.deleteSpace(space, false);
        savedSpace = this.spaceService.getSpaceByDisplayName(spaceDisplayName);
        SpaceServiceTest.assertNull((String)"savedSpace must be null", (Object)savedSpace);
        SpaceServiceTest.assertNotNull((String)("the group " + groupId + " must exist after space deletion"), (Object)this.organizationService.getGroupHandler().findGroupById(groupId));
        Group group = this.organizationService.getGroupHandler().findGroupById(groupId);
        this.organizationService.getGroupHandler().removeGroup(group, true);
    }

    public void testUpdateSpacePermissions() throws Exception {
        Space space = this.getSpaceInstance(0);
        try {
            this.spaceService.updateSpaceBanner(space, "raul");
            SpaceServiceTest.fail((String)"Space member shouldn't be able to update space banner");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.spaceService.updateSpaceAvatar(space, "raul");
            SpaceServiceTest.fail((String)"Space member shouldn't be able to update space avatar");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testUpdateSpace() throws Exception {
        Space space = this.getSpaceInstance(0);
        String spaceDisplayName = space.getDisplayName();
        String spaceDescription = space.getDescription();
        String groupId = space.getGroupId();
        Space savedSpace = this.spaceService.getSpaceByDisplayName(spaceDisplayName);
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceServiceTest.assertEquals((String)("savedSpace.getDisplayName() must return: " + spaceDisplayName), (String)spaceDisplayName, (String)savedSpace.getDisplayName());
        SpaceServiceTest.assertEquals((String)("savedSpace.getDescription() must return: " + spaceDescription), (String)spaceDescription, (String)savedSpace.getDescription());
        SpaceServiceTest.assertEquals((String)("savedSpace.getGroupId() must return: " + groupId), (String)groupId, (String)savedSpace.getGroupId());
        String updateSpaceDisplayName = "update new space display name";
        space.setDisplayName(updateSpaceDisplayName);
        space.setPrettyName(space.getDisplayName());
        this.spaceService.updateSpace(space);
        savedSpace = this.spaceService.getSpaceByDisplayName(updateSpaceDisplayName);
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceServiceTest.assertEquals((String)("savedSpace.getDisplayName() must return: " + updateSpaceDisplayName), (String)updateSpaceDisplayName, (String)savedSpace.getDisplayName());
        SpaceServiceTest.assertEquals((String)("savedSpace.getDescription() must return: " + spaceDescription), (String)spaceDescription, (String)savedSpace.getDescription());
        SpaceServiceTest.assertEquals((String)("savedSpace.getGroupId() must return: " + groupId), (String)groupId, (String)savedSpace.getGroupId());
    }

    public void testAddPendingUser() throws Exception {
        Space space = this.getSpaceInstance(0);
        int pendingUsersCount = space.getPendingUsers().length;
        SpaceServiceTest.assertFalse((String)"ArrayUtils.contains(space.getPendingUsers(), newPendingUser.getRemoteId()) must be false", (boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
        this.spaceService.addPendingUser(space, this.newPendingUser.getRemoteId());
        space = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)("space.getPendingUsers().length must return: " + pendingUsersCount + "1"), (int)(pendingUsersCount + 1), (int)space.getPendingUsers().length);
        SpaceServiceTest.assertTrue((String)"ArrayUtils.contains(space.getPendingUsers(), newPendingUser.getRemoteId()) must be true", (boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
    }

    public void testRemovePendingUser() throws Exception {
        Space space = this.getSpaceInstance(0);
        int pendingUsersCount = space.getPendingUsers().length;
        SpaceServiceTest.assertFalse((String)"ArrayUtils.contains(space.getPendingUsers(), newPendingUser.getRemoteId()) must be false", (boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
        this.spaceService.addPendingUser(space, this.newPendingUser.getRemoteId());
        space = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)("space.getPendingUsers().length must return: " + pendingUsersCount + "1"), (int)(pendingUsersCount + 1), (int)space.getPendingUsers().length);
        SpaceServiceTest.assertTrue((String)"ArrayUtils.contains(space.getPendingUsers(), newPendingUser.getRemoteId()) must be true", (boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
        this.spaceService.removePendingUser(space, this.newPendingUser.getRemoteId());
        space = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)("space.getPendingUsers().length must return: " + pendingUsersCount), (int)pendingUsersCount, (int)space.getPendingUsers().length);
        SpaceServiceTest.assertFalse((String)"ArrayUtils.contains(space.getPendingUsers(), newPendingUser.getRemoteId()) must be true", (boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
    }

    public void testIsPendingUser() throws Exception {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceServiceTest.assertTrue((String)"spaceService.isPendingUser(savedSpace, \"jame\") must return true", (boolean)this.spaceService.isPendingUser(savedSpace, "jame"));
        SpaceServiceTest.assertTrue((String)"spaceService.isPendingUser(savedSpace, \"paul\") must return true", (boolean)this.spaceService.isPendingUser(savedSpace, "paul"));
        SpaceServiceTest.assertTrue((String)"spaceService.isPendingUser(savedSpace, \"hacker\") must return true", (boolean)this.spaceService.isPendingUser(savedSpace, "hacker"));
        SpaceServiceTest.assertFalse((String)"spaceService.isPendingUser(savedSpace, \"newpendinguser\") must return false", (boolean)this.spaceService.isPendingUser(savedSpace, "newpendinguser"));
    }

    public void testAddInvitedUser() throws Exception {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        int invitedUsersCount = savedSpace.getInvitedUsers().length;
        SpaceServiceTest.assertFalse((String)"ArrayUtils.contains(savedSpace.getInvitedUsers(), newInvitedUser.getRemoteId()) must return false", (boolean)ArrayUtils.contains((Object[])savedSpace.getInvitedUsers(), (Object)this.newInvitedUser.getRemoteId()));
        this.spaceService.addInvitedUser(savedSpace, this.newInvitedUser.getRemoteId());
        savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)("savedSpace.getInvitedUsers().length must return: " + invitedUsersCount + "1"), (int)(invitedUsersCount + 1), (int)savedSpace.getInvitedUsers().length);
        SpaceServiceTest.assertTrue((String)"ArrayUtils.contains(savedSpace.getInvitedUsers(), newInvitedUser.getRemoteId()) must return true", (boolean)ArrayUtils.contains((Object[])savedSpace.getInvitedUsers(), (Object)this.newInvitedUser.getRemoteId()));
    }

    public void testRemoveInvitedUser() throws Exception {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        int invitedUsersCount = savedSpace.getInvitedUsers().length;
        SpaceServiceTest.assertFalse((String)"ArrayUtils.contains(savedSpace.getInvitedUsers(), newInvitedUser.getRemoteId()) must return false", (boolean)ArrayUtils.contains((Object[])savedSpace.getInvitedUsers(), (Object)this.newInvitedUser.getRemoteId()));
        this.spaceService.addInvitedUser(savedSpace, this.newInvitedUser.getRemoteId());
        savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)("savedSpace.getInvitedUsers().length must return: " + invitedUsersCount + "1"), (int)(invitedUsersCount + 1), (int)savedSpace.getInvitedUsers().length);
        SpaceServiceTest.assertTrue((String)"ArrayUtils.contains(savedSpace.getInvitedUsers(), newInvitedUser.getRemoteId()) must return true", (boolean)ArrayUtils.contains((Object[])savedSpace.getInvitedUsers(), (Object)this.newInvitedUser.getRemoteId()));
        this.spaceService.removeInvitedUser(savedSpace, this.newInvitedUser.getRemoteId());
        savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)("savedSpace.getInvitedUsers().length must return: " + invitedUsersCount), (int)invitedUsersCount, (int)savedSpace.getInvitedUsers().length);
        SpaceServiceTest.assertFalse((String)"ArrayUtils.contains(savedSpace.getInvitedUsers(), newInvitedUser.getRemoteId()) must return false", (boolean)ArrayUtils.contains((Object[])savedSpace.getInvitedUsers(), (Object)this.newInvitedUser.getRemoteId()));
    }

    public void testIsInvitedUser() throws Exception {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceServiceTest.assertTrue((String)"spaceService.isInvitedUser(savedSpace, \"register1\") must return true", (boolean)this.spaceService.isInvitedUser(savedSpace, "register1"));
        SpaceServiceTest.assertTrue((String)"spaceService.isInvitedUser(savedSpace, \"mary\") must return true", (boolean)this.spaceService.isInvitedUser(savedSpace, "mary"));
        SpaceServiceTest.assertFalse((String)"spaceService.isInvitedUser(savedSpace, \"hacker\") must return false", (boolean)this.spaceService.isInvitedUser(savedSpace, "hacker"));
        SpaceServiceTest.assertFalse((String)"spaceService.isInvitedUser(savedSpace, \"nobody\") must return false", (boolean)this.spaceService.isInvitedUser(savedSpace, "nobody"));
    }

    public void testSetManager() throws Exception {
        int number = 0;
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/space/space" + number);
        space.setUrl(space.getPrettyName());
        String[] spaceManagers = new String[]{"demo", "tom"};
        String[] members = new String[]{"raul", "ghost", "dragon"};
        String[] invitedUsers = new String[]{"register1", "mary"};
        String[] pendingUsers = new String[]{"jame", "paul", "hacker"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(spaceManagers);
        space.setMembers(members);
        space = this.createSpaceNonInitApps(space, "demo", null);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        int managers = savedSpace.getManagers().length;
        this.spaceService.setManager(savedSpace, "demo", true);
        savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)("savedSpace.getManagers().length must return: " + managers), (int)managers, (int)savedSpace.getManagers().length);
        this.spaceService.setManager(savedSpace, "john", true);
        savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)("savedSpace.getManagers().length must return: " + managers + "1"), (int)(managers + 1), (int)savedSpace.getManagers().length);
        this.spaceService.setManager(savedSpace, "demo", false);
        savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)("savedSpace.getManagers().length must return: " + managers), (int)managers, (int)savedSpace.getManagers().length);
    }

    public void testIsManager() throws Exception {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceServiceTest.assertTrue((String)"spaceService.isManager(savedSpace, \"demo\") must return true", (boolean)this.spaceService.isManager(savedSpace, "demo"));
        SpaceServiceTest.assertTrue((String)"spaceService.isManager(savedSpace, \"tom\") must return true", (boolean)this.spaceService.isManager(savedSpace, "tom"));
        SpaceServiceTest.assertFalse((String)"spaceService.isManager(savedSpace, \"mary\") must return false", (boolean)this.spaceService.isManager(savedSpace, "mary"));
        SpaceServiceTest.assertFalse((String)"spaceService.isManager(savedSpace, \"john\") must return false", (boolean)this.spaceService.isManager(savedSpace, "john"));
    }

    public void testSetRedactor() throws Exception {
        Space space = new Space();
        space.setDisplayName("space1");
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space1");
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/space/space1");
        space.setUrl(space.getPrettyName());
        space = this.spaceService.createSpace(space, "root");
        String[] members = new String[]{"ghost", "john"};
        space.setMembers(members);
        MembershipType redactorMembershipType = this.organizationService.getMembershipTypeHandler().createMembershipTypeInstance();
        redactorMembershipType.setName("redactor");
        this.spaceService.addRedactor(space, "ghost");
        this.spaceService.addRedactor(space, "john");
        SpaceServiceTest.assertEquals((int)2, (int)space.getRedactors().length);
        this.spaceService.removeRedactor(space, "john");
        SpaceServiceTest.assertEquals((int)1, (int)space.getRedactors().length);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.isRedactor(space, "ghost"));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.isRedactor(space, "john"));
    }

    public void testSetPublisher() throws Exception {
        Space space = new Space();
        space.setDisplayName("space1");
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space1");
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/space/space1");
        space.setUrl(space.getPrettyName());
        space = this.spaceService.createSpace(space, "root");
        String[] members = new String[]{"ghost", "john"};
        space.setMembers(members);
        MembershipType publisherMembershipType = this.organizationService.getMembershipTypeHandler().createMembershipTypeInstance();
        publisherMembershipType.setName("publisher");
        this.spaceService.addPublisher(space, "ghost");
        this.spaceService.addPublisher(space, "john");
        SpaceServiceTest.assertEquals((int)2, (int)space.getPublishers().length);
        this.spaceService.removePublisher(space, "john");
        SpaceServiceTest.assertEquals((int)1, (int)space.getPublishers().length);
        SpaceServiceTest.assertTrue((boolean)this.spaceService.isPublisher(space, "ghost"));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.isPublisher(space, "john"));
    }

    public void testIsOnlyManager() throws Exception {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceServiceTest.assertFalse((String)"spaceService.isOnlyManager(savedSpace, \"tom\") must return false", (boolean)this.spaceService.isOnlyManager(savedSpace, "tom"));
        SpaceServiceTest.assertFalse((String)"spaceService.isOnlyManager(savedSpace, \"demo\") must return false", (boolean)this.spaceService.isOnlyManager(savedSpace, "demo"));
        savedSpace.setManagers(new String[]{"demo"});
        this.spaceService.updateSpace(savedSpace);
        SpaceServiceTest.assertTrue((String)"spaceService.isOnlyManager(savedSpace, \"demo\") must return true", (boolean)this.spaceService.isOnlyManager(savedSpace, "demo"));
        SpaceServiceTest.assertFalse((String)"spaceService.isOnlyManager(savedSpace, \"tom\") must return false", (boolean)this.spaceService.isOnlyManager(savedSpace, "tom"));
        savedSpace.setManagers(new String[]{"tom"});
        this.spaceService.updateSpace(savedSpace);
        SpaceServiceTest.assertFalse((String)"spaceService.isOnlyManager(savedSpace, \"demo\") must return false", (boolean)this.spaceService.isOnlyManager(savedSpace, "demo"));
        SpaceServiceTest.assertTrue((String)"spaceService.isOnlyManager(savedSpace, \"tom\") must return true", (boolean)this.spaceService.isOnlyManager(savedSpace, "tom"));
    }

    public void testHasSettingPermission() throws Exception {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceServiceTest.assertTrue((String)"spaceService.hasSettingPermission(savedSpace, \"demo\") must return true", (boolean)this.spaceService.hasSettingPermission(savedSpace, "demo"));
        SpaceServiceTest.assertTrue((String)"spaceService.hasSettingPermission(savedSpace, \"tom\") must return true", (boolean)this.spaceService.hasSettingPermission(savedSpace, "tom"));
        SpaceServiceTest.assertTrue((String)"spaceService.hasSettingPermission(savedSpace, \"root\") must return true", (boolean)this.spaceService.hasSettingPermission(savedSpace, "root"));
        SpaceServiceTest.assertFalse((String)"spaceService.hasSettingPermission(savedSpace, \"mary\") must return false", (boolean)this.spaceService.hasSettingPermission(savedSpace, "mary"));
        SpaceServiceTest.assertTrue((String)"spaceService.hasSettingPermission(savedSpace, \"john\") must return true", (boolean)this.spaceService.hasSettingPermission(savedSpace, "john"));
    }

    public void testAddMember() throws Exception {
        int number = 0;
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/space/space" + number);
        space.setUrl(space.getPrettyName());
        String[] spaceManagers = new String[]{"demo"};
        String[] members = new String[]{};
        String[] invitedUsers = new String[]{"register1", "mary"};
        String[] pendingUsers = new String[]{"jame", "paul", "hacker"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(spaceManagers);
        space.setMembers(members);
        space = this.createSpaceNonInitApps(space, "demo", null);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        this.spaceService.addMember(savedSpace, "root");
        this.spaceService.addMember(savedSpace, "mary");
        this.spaceService.addMember(savedSpace, "john");
        savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)"savedSpace.getMembers().length must return 4", (int)4, (int)savedSpace.getMembers().length);
    }

    public void testAddMemberSpecialCharacter() throws Exception {
        String reg = "^\\p{L}[\\p{L}\\d\\s._,-]+$";
        Pattern pattern = Pattern.compile(reg);
        SpaceServiceTest.assertTrue((boolean)pattern.matcher("user-new.1").matches());
        SpaceServiceTest.assertTrue((boolean)pattern.matcher("user.new").matches());
        SpaceServiceTest.assertTrue((boolean)pattern.matcher("user-new").matches());
        int number = 0;
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/space/space" + number);
        space.setUrl(space.getPrettyName());
        String[] spaceManagers = new String[]{"demo"};
        String[] members = new String[]{};
        String[] invitedUsers = new String[]{"register1", "mary"};
        String[] pendingUsers = new String[]{"jame", "paul", "hacker"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(spaceManagers);
        space.setMembers(members);
        space = this.createSpaceNonInitApps(space, "demo", null);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        User user = this.organizationService.getUserHandler().createUserInstance("user-new.1");
        this.organizationService.getUserHandler().createUser(user, false);
        user = this.organizationService.getUserHandler().createUserInstance("user.new");
        this.organizationService.getUserHandler().createUser(user, false);
        user = this.organizationService.getUserHandler().createUserInstance("user-new");
        this.organizationService.getUserHandler().createUser(user, false);
        this.spaceService.addMember(savedSpace, "user-new.1");
        this.spaceService.addMember(savedSpace, "user.new");
        this.spaceService.addMember(savedSpace, "user-new");
        savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((int)4, (int)savedSpace.getMembers().length);
    }

    public void testRemoveMember() throws Exception {
        int number = 0;
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/space/space" + number);
        space.setUrl(space.getPrettyName());
        String[] spaceManagers = new String[]{"demo"};
        String[] members = new String[]{};
        String[] invitedUsers = new String[]{"register1", "mary"};
        String[] pendingUsers = new String[]{"jame", "paul", "hacker"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(spaceManagers);
        space.setMembers(members);
        space = this.createSpaceNonInitApps(space, "demo", null);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        this.spaceService.addMember(savedSpace, "root");
        this.spaceService.addMember(savedSpace, "mary");
        this.spaceService.addMember(savedSpace, "john");
        this.spaceService.setManager(savedSpace, "john", true);
        this.spaceService.addRedactor(savedSpace, "john");
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        UserHandler userHandler = this.organizationService.getUserHandler();
        MembershipType mbShipTypeMember = this.organizationService.getMembershipTypeHandler().findMembershipType("*");
        User user = userHandler.findUserByName("john");
        this.organizationService.getMembershipHandler().linkMembership(user, groupHandler.findGroupById(space.getGroupId()), mbShipTypeMember, true);
        savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)"savedSpace.getMembers().length must return 4", (int)4, (int)savedSpace.getMembers().length);
        this.spaceService.removeMember(savedSpace, "root");
        this.spaceService.removeMember(savedSpace, "mary");
        this.spaceService.removeMember(savedSpace, "john");
        Membership any = this.organizationService.getMembershipHandler().findMembershipByUserGroupAndType("john", space.getGroupId(), "*");
        SpaceServiceTest.assertNull((Object)any);
        SpaceServiceTest.assertFalse((boolean)this.spaceService.isManager(savedSpace, "john"));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.isRedactor(savedSpace, "john"));
        SpaceServiceTest.assertFalse((boolean)this.spaceService.isMember(savedSpace, "john"));
        SpaceServiceTest.assertEquals((String)"savedSpace.getMembers().length must return 1", (int)1, (int)savedSpace.getMembers().length);
        IdentityManager identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        ActivityManager activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
    }

    public void testGetMembers() throws Exception {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceServiceTest.assertEquals((String)("spaceService.getMembers(savedSpace).size() must return: " + savedSpace.getMembers().length), (int)savedSpace.getMembers().length, (int)this.spaceService.getMembers(savedSpace).size());
    }

    public void testGetMemberSpaces() throws Exception {
        Space[] listSpace = new Space[10];
        for (int i = 0; i < listSpace.length; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
        }
        this.restartTransaction();
        String raulUsername = "raul";
        String jameUsername = "jame";
        List spaceIds = this.spaceService.getMemberSpacesIds(raulUsername, 0, -1);
        SpaceServiceTest.assertNotNull((Object)spaceIds);
        SpaceServiceTest.assertEquals((int)listSpace.length, (int)spaceIds.size());
        spaceIds = this.spaceService.getMemberSpacesIds(raulUsername, 0, listSpace.length);
        SpaceServiceTest.assertNotNull((Object)spaceIds);
        SpaceServiceTest.assertEquals((int)listSpace.length, (int)spaceIds.size());
        spaceIds = this.spaceService.getMemberSpacesIds(raulUsername, 0, listSpace.length / 2);
        SpaceServiceTest.assertNotNull((Object)spaceIds);
        SpaceServiceTest.assertEquals((int)(listSpace.length / 2), (int)spaceIds.size());
        spaceIds = this.spaceService.getMemberSpacesIds(raulUsername, listSpace.length / 2, listSpace.length / 2);
        SpaceServiceTest.assertNotNull((Object)spaceIds);
        SpaceServiceTest.assertEquals((int)(listSpace.length / 2), (int)spaceIds.size());
        Space space0 = this.spaceService.getSpaceById((String)spaceIds.get(0));
        SpaceServiceTest.assertNotNull((Object)space0);
        this.spaceService.removeMember(space0, raulUsername);
        this.restartTransaction();
        spaceIds = this.spaceService.getMemberSpacesIds(raulUsername, 0, -1);
        SpaceServiceTest.assertNotNull((Object)spaceIds);
        SpaceServiceTest.assertEquals((int)(listSpace.length - 1), (int)spaceIds.size());
        spaceIds = this.spaceService.getMemberSpacesIds(jameUsername, 0, -1);
        SpaceServiceTest.assertNotNull((Object)spaceIds);
        SpaceServiceTest.assertEquals((int)0, (int)spaceIds.size());
    }

    public void testIsMember() throws Exception {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceServiceTest.assertTrue((String)"spaceService.isMember(savedSpace, \"raul\") must return true", (boolean)this.spaceService.isMember(savedSpace, "raul"));
        SpaceServiceTest.assertTrue((String)"spaceService.isMember(savedSpace, \"ghost\") must return true", (boolean)this.spaceService.isMember(savedSpace, "ghost"));
        SpaceServiceTest.assertTrue((String)"spaceService.isMember(savedSpace, \"dragon\") must return true", (boolean)this.spaceService.isMember(savedSpace, "dragon"));
        SpaceServiceTest.assertFalse((String)"spaceService.isMember(savedSpace, \"stranger\") must return true", (boolean)this.spaceService.isMember(savedSpace, "stranger"));
    }

    public void testHasAccessPermission() throws Exception {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceServiceTest.assertTrue((String)"spaceService.hasAccessPermission(savedSpace, \"raul\") must return true", (boolean)this.spaceService.hasAccessPermission(savedSpace, "raul"));
        SpaceServiceTest.assertTrue((String)"spaceService.hasAccessPermission(savedSpace, \"ghost\") must return true", (boolean)this.spaceService.hasAccessPermission(savedSpace, "ghost"));
        SpaceServiceTest.assertTrue((String)"spaceService.hasAccessPermission(savedSpace, \"dragon\") must return true", (boolean)this.spaceService.hasAccessPermission(savedSpace, "dragon"));
        SpaceServiceTest.assertTrue((String)"spaceService.hasAccessPermission(savedSpace, \"tom\") must return true", (boolean)this.spaceService.hasAccessPermission(savedSpace, "tom"));
        SpaceServiceTest.assertTrue((String)"spaceService.hasAccessPermission(savedSpace, \"demo\") must return true", (boolean)this.spaceService.hasAccessPermission(savedSpace, "demo"));
        SpaceServiceTest.assertTrue((String)"spaceService.hasAccessPermission(savedSpace, \"root\") must return true", (boolean)this.spaceService.hasAccessPermission(savedSpace, "root"));
        SpaceServiceTest.assertFalse((String)"spaceService.hasAccessPermission(savedSpace, \"mary\") must return false", (boolean)this.spaceService.hasAccessPermission(savedSpace, "mary"));
        SpaceServiceTest.assertTrue((String)"spaceService.hasAccessPermission(savedSpace, \"john\") must return true", (boolean)this.spaceService.hasAccessPermission(savedSpace, "john"));
    }

    public void testHasEditPermission() throws Exception {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceServiceTest.assertTrue((String)"spaceService.hasEditPermission(savedSpace, \"root\") must return true", (boolean)this.spaceService.hasEditPermission(savedSpace, "root"));
        SpaceServiceTest.assertTrue((String)"spaceService.hasEditPermission(savedSpace, \"demo\") must return true", (boolean)this.spaceService.hasEditPermission(savedSpace, "demo"));
        SpaceServiceTest.assertTrue((String)"spaceService.hasEditPermission(savedSpace, \"tom\") must return true", (boolean)this.spaceService.hasEditPermission(savedSpace, "tom"));
        SpaceServiceTest.assertFalse((String)"spaceService.hasEditPermission(savedSpace, \"mary\") must return false", (boolean)this.spaceService.hasEditPermission(savedSpace, "mary"));
        SpaceServiceTest.assertTrue((String)"spaceService.hasEditPermission(savedSpace, \"john\") must return true", (boolean)this.spaceService.hasEditPermission(savedSpace, "john"));
        SpaceServiceTest.assertFalse((String)"spaceService.hasEditPermission(savedSpace, \"raul\") must return false", (boolean)this.spaceService.hasEditPermission(savedSpace, "raul"));
        SpaceServiceTest.assertFalse((String)"spaceService.hasEditPermission(savedSpace, \"ghost\") must return false", (boolean)this.spaceService.hasEditPermission(savedSpace, "ghost"));
        SpaceServiceTest.assertFalse((String)"spaceService.hasEditPermission(savedSpace, \"dragon\") must return false", (boolean)this.spaceService.hasEditPermission(savedSpace, "dragon"));
    }

    public void testIsInvited() throws Exception {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceServiceTest.assertTrue((String)"spaceService.isInvited(savedSpace, \"register1\") must return true", (boolean)this.spaceService.isInvited(savedSpace, "register1"));
        SpaceServiceTest.assertTrue((String)"spaceService.isInvited(savedSpace, \"mary\") must return true", (boolean)this.spaceService.isInvited(savedSpace, "mary"));
        SpaceServiceTest.assertFalse((String)"spaceService.isInvited(savedSpace, \"demo\") must return false", (boolean)this.spaceService.isInvited(savedSpace, "demo"));
        SpaceServiceTest.assertFalse((String)"spaceService.isInvited(savedSpace, \"john\") must return false", (boolean)this.spaceService.isInvited(savedSpace, "john"));
    }

    public void testIsPending() throws Exception {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceServiceTest.assertTrue((String)"spaceService.isPending(savedSpace, \"jame\") must return true", (boolean)this.spaceService.isPending(savedSpace, "jame"));
        SpaceServiceTest.assertTrue((String)"spaceService.isPending(savedSpace, \"paul\") must return true", (boolean)this.spaceService.isPending(savedSpace, "paul"));
        SpaceServiceTest.assertTrue((String)"spaceService.isPending(savedSpace, \"hacker\") must return true", (boolean)this.spaceService.isPending(savedSpace, "hacker"));
        SpaceServiceTest.assertFalse((String)"spaceService.isPending(savedSpace, \"mary\") must return false", (boolean)this.spaceService.isPending(savedSpace, "mary"));
        SpaceServiceTest.assertFalse((String)"spaceService.isPending(savedSpace, \"john\") must return false", (boolean)this.spaceService.isPending(savedSpace, "john"));
    }

    public void testActivateApplication() throws Exception {
        this.startSessionAs("root");
        String spaceName = "testSpace";
        String creator = "john";
        Space space = new Space();
        space.setDisplayName(spaceName);
        space.setPrettyName(spaceName);
        space.setGroupId("/spaces/" + space.getPrettyName());
        space.setRegistration("open");
        space.setDescription("description of space" + spaceName);
        space.setType("classic");
        space.setVisibility("private");
        space.setRegistration("open");
        space.setPriority("2");
        space.setManagers(new String[]{creator});
        space.setMembers(new String[]{creator});
        space = this.spaceService.createSpace(space, "root");
        this.tearDownSpaceList.add(space);
        SpaceServiceTest.assertTrue((boolean)space.getApp().contains("DashboardPortlet"));
        this.spaceService.removeApplication(space, "DashboardPortlet", "Dashboard");
        SpaceServiceTest.assertFalse((boolean)space.getApp().contains("DashboardPortlet"));
        this.spaceService.activateApplication(space, "DashboardPortlet");
        SpaceServiceTest.assertTrue((boolean)space.getApp().contains("DashboardPortlet"));
        NavigationContext navContext = SpaceUtils.getGroupNavigationContext((String)space.getGroupId());
        NodeContext homeNodeCtx = SpaceUtils.getHomeNodeWithChildren((NavigationContext)navContext, (String)space.getUrl());
        boolean found = homeNodeCtx.getNodes().stream().filter(node -> "dashboard".equals(node.getName())).findAny().isPresent();
        SpaceServiceTest.assertTrue((boolean)found);
    }

    public void testRequestJoin() throws Exception {
        Space space = this.getSpaceInstance(0);
        int pendingUsersCount = space.getPendingUsers().length;
        SpaceServiceTest.assertFalse((String)"ArrayUtils.contains(space.getPendingUsers(), newPendingUser.getRemoteId()) must be false", (boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
        this.spaceService.requestJoin(space, this.newPendingUser.getRemoteId());
        space = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)("space.getPendingUsers().length must return: " + pendingUsersCount + "1"), (int)(pendingUsersCount + 1), (int)space.getPendingUsers().length);
        SpaceServiceTest.assertTrue((String)"ArrayUtils.contains(space.getPendingUsers(), newPendingUser.getRemoteId()) must be true", (boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
    }

    public void testRevokeRequestJoin() throws Exception {
        Space space = this.getSpaceInstance(0);
        int pendingUsersCount = space.getPendingUsers().length;
        SpaceServiceTest.assertFalse((String)"ArrayUtils.contains(space.getPendingUsers(), newPendingUser) must be false", (boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
        this.spaceService.requestJoin(space, this.newPendingUser.getRemoteId());
        space = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)("space.getPendingUsers().length must return: " + pendingUsersCount + "1"), (int)(pendingUsersCount + 1), (int)space.getPendingUsers().length);
        SpaceServiceTest.assertTrue((String)"ArrayUtils.contains(space.getPendingUsers(), newPendingUser.getRemoteId()) must be true", (boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
        this.spaceService.revokeRequestJoin(space, this.newPendingUser.getRemoteId());
        space = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)("space.getPendingUsers().length must return: " + pendingUsersCount), (int)pendingUsersCount, (int)space.getPendingUsers().length);
        SpaceServiceTest.assertFalse((String)"ArrayUtils.contains(space.getPendingUsers(), newPendingUser.getRemoteId()) must be true", (boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
    }

    public void testInviteMember() throws Exception {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        int invitedUsersCount = savedSpace.getInvitedUsers().length;
        SpaceServiceTest.assertFalse((String)"ArrayUtils.contains(savedSpace.getInvitedUsers(), newInvitedUser.getRemoteId()) must return false", (boolean)ArrayUtils.contains((Object[])savedSpace.getInvitedUsers(), (Object)this.newInvitedUser.getRemoteId()));
        this.spaceService.inviteMember(savedSpace, this.newInvitedUser.getRemoteId());
        savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)("savedSpace.getInvitedUsers().length must return: " + invitedUsersCount + "1"), (int)(invitedUsersCount + 1), (int)savedSpace.getInvitedUsers().length);
        SpaceServiceTest.assertTrue((String)"ArrayUtils.contains(savedSpace.getInvitedUsers(), newInvitedUser.getRemoteId()) must return true", (boolean)ArrayUtils.contains((Object[])savedSpace.getInvitedUsers(), (Object)this.newInvitedUser.getRemoteId()));
    }

    public void testRevokeInvitation() throws Exception {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        int invitedUsersCount = savedSpace.getInvitedUsers().length;
        SpaceServiceTest.assertFalse((String)"ArrayUtils.contains(savedSpace.getInvitedUsers(), newInvitedUser.getRemoteId()) must return false", (boolean)ArrayUtils.contains((Object[])savedSpace.getInvitedUsers(), (Object)this.newInvitedUser.getRemoteId()));
        this.spaceService.addInvitedUser(savedSpace, this.newInvitedUser.getRemoteId());
        savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)("savedSpace.getInvitedUsers().length must return: " + invitedUsersCount + "1"), (int)(invitedUsersCount + 1), (int)savedSpace.getInvitedUsers().length);
        SpaceServiceTest.assertTrue((String)"ArrayUtils.contains(savedSpace.getInvitedUsers(), newInvitedUser.getRemoteId()) must return true", (boolean)ArrayUtils.contains((Object[])savedSpace.getInvitedUsers(), (Object)this.newInvitedUser.getRemoteId()));
        this.spaceService.revokeInvitation(savedSpace, this.newInvitedUser.getRemoteId());
        savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)("savedSpace.getInvitedUsers().length must return: " + invitedUsersCount), (int)invitedUsersCount, (int)savedSpace.getInvitedUsers().length);
        SpaceServiceTest.assertFalse((String)"ArrayUtils.contains(savedSpace.getInvitedUsers(), newInvitedUser.getRemoteId()) must return false", (boolean)ArrayUtils.contains((Object[])savedSpace.getInvitedUsers(), (Object)this.newInvitedUser.getRemoteId()));
    }

    public void testGetVisibleSpacesWithCondition() throws Exception {
        Space sp1 = this.createSpace("space test", "demo");
        Space sp2 = this.createSpace("space 11", "demo");
        SpaceListAccess list = this.spaceService.getVisibleSpacesWithListAccess("demo", new SpaceFilter("space test"));
        SpaceServiceTest.assertEquals((int)1, (int)list.getSize());
        SpaceServiceTest.assertEquals((int)1, (int)list.load(0, 10).length);
        list = this.spaceService.getVisibleSpacesWithListAccess("demo", new SpaceFilter("space 11"));
        SpaceServiceTest.assertEquals((int)1, (int)list.getSize());
        SpaceServiceTest.assertEquals((int)1, (int)list.load(0, 10).length);
        list = this.spaceService.getVisibleSpacesWithListAccess("demo", new SpaceFilter("space_11"));
        SpaceServiceTest.assertEquals((int)1, (int)list.getSize());
        SpaceServiceTest.assertEquals((int)1, (int)list.load(0, 10).length);
        list = this.spaceService.getVisibleSpacesWithListAccess("demo", new SpaceFilter("space"));
        SpaceServiceTest.assertEquals((int)2, (int)list.getSize());
        SpaceServiceTest.assertEquals((int)2, (int)list.load(0, 10).length);
    }

    public void testAcceptInvitation() throws Exception {
        int number = 0;
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/space/space" + number);
        space.setUrl(space.getPrettyName());
        String[] spaceManagers = new String[]{"demo"};
        String[] members = new String[]{};
        String[] invitedUsers = new String[]{"register1", "mary"};
        String[] pendingUsers = new String[]{"jame", "paul", "hacker"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(spaceManagers);
        space.setMembers(members);
        space = this.createSpaceNonInitApps(space, "demo", null);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        this.spaceService.acceptInvitation(savedSpace, "root");
        this.spaceService.acceptInvitation(savedSpace, "mary");
        this.spaceService.acceptInvitation(savedSpace, "john");
        savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)"savedSpace.getMembers().length must return 4", (int)4, (int)savedSpace.getMembers().length);
        IdentityManager identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        ActivityManager activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
    }

    public void testDenyInvitation() throws Exception {
        Space space = this.getSpaceInstance(0);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        this.spaceService.denyInvitation(savedSpace, "new member 1");
        this.spaceService.denyInvitation(savedSpace, "new member 2");
        this.spaceService.denyInvitation(savedSpace, "new member 3");
        SpaceServiceTest.assertEquals((String)"savedSpace.getMembers().length must return 2", (int)2, (int)savedSpace.getInvitedUsers().length);
        this.spaceService.denyInvitation(savedSpace, "raul");
        this.spaceService.denyInvitation(savedSpace, "ghost");
        this.spaceService.denyInvitation(savedSpace, "dragon");
        SpaceServiceTest.assertEquals((String)"savedSpace.getMembers().length must return 2", (int)2, (int)savedSpace.getInvitedUsers().length);
        this.spaceService.denyInvitation(savedSpace, "register1");
        this.spaceService.denyInvitation(savedSpace, "mary");
        SpaceServiceTest.assertEquals((String)"savedSpace.getMembers().length must return 0", (int)0, (int)savedSpace.getInvitedUsers().length);
    }

    public void testValidateRequest() throws Exception {
        int number = 0;
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/space/space" + number);
        space.setUrl(space.getPrettyName());
        String[] spaceManagers = new String[]{"demo"};
        String[] members = new String[]{};
        String[] invitedUsers = new String[]{"register1", "mary"};
        String[] pendingUsers = new String[]{"jame", "paul", "hacker"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(spaceManagers);
        space.setMembers(members);
        space = this.createSpaceNonInitApps(space, "demo", null);
        Space savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        this.spaceService.validateRequest(savedSpace, "root");
        this.spaceService.validateRequest(savedSpace, "mary");
        this.spaceService.validateRequest(savedSpace, "john");
        savedSpace = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)"savedSpace.getMembers().length must return 4", (int)4, (int)savedSpace.getMembers().length);
    }

    public void testDeclineRequest() throws Exception {
        Space space = this.getSpaceInstance(0);
        int pendingUsersCount = space.getPendingUsers().length;
        SpaceServiceTest.assertFalse((String)"ArrayUtils.contains(space.getPendingUsers(), newPendingUser) must be false", (boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newPendingUser.getRemoteId()));
        this.spaceService.addPendingUser(space, this.newInvitedUser.getRemoteId());
        space = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)("space.getPendingUsers().length must return: " + pendingUsersCount + "1"), (int)(pendingUsersCount + 1), (int)space.getPendingUsers().length);
        SpaceServiceTest.assertTrue((String)"ArrayUtils.contains(space.getPendingUsers(), newInvitedUser.getRemoteId()) must be true", (boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newInvitedUser.getRemoteId()));
        this.spaceService.declineRequest(space, this.newInvitedUser.getRemoteId());
        space = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        SpaceServiceTest.assertEquals((String)("space.getPendingUsers().length must return: " + pendingUsersCount), (int)pendingUsersCount, (int)space.getPendingUsers().length);
        SpaceServiceTest.assertFalse((String)"ArrayUtils.contains(space.getPendingUsers(), newInvitedUser.getRemoteId()) must be true", (boolean)ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)this.newInvitedUser.getRemoteId()));
    }

    public void testGetVisibleSpaces() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = i < 6 ? this.getSpaceInstance(i, "private", "open", "demo", new String[0]) : this.getSpaceInstance(i, "hidden", "open", "demo", new String[0]);
            this.spaceService.saveSpace(listSpace[i], true);
        }
        List visibleAllSpaces = this.spaceService.getVisibleSpaces("demo", null);
        SpaceServiceTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)visibleAllSpaces);
        SpaceServiceTest.assertEquals((String)("visibleSpaces() must return: " + countSpace), (int)countSpace, (int)visibleAllSpaces.size());
    }

    public void testGetVisibleSpacesCloseRegistration() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = i < 6 ? this.getSpaceInstance(i, "private", "closed", "demo", new String[0]) : this.getSpaceInstance(i, "hidden", "closed", "demo", new String[0]);
            this.spaceService.saveSpace(listSpace[i], true);
        }
        List visibleAllSpaces = this.spaceService.getVisibleSpaces("demo", null);
        SpaceServiceTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)visibleAllSpaces);
        SpaceServiceTest.assertEquals((String)("visibleSpaces() must return: " + countSpace), (int)countSpace, (int)visibleAllSpaces.size());
        int registrationCloseSpaceCount = 6;
        List registrationCloseSpaces = this.spaceService.getVisibleSpaces("mary", null);
        SpaceServiceTest.assertNotNull((String)"registrationCloseSpaces must not be  null", (Object)registrationCloseSpaces);
        SpaceServiceTest.assertEquals((String)("registrationCloseSpaces must return: " + registrationCloseSpaceCount), (int)registrationCloseSpaceCount, (int)registrationCloseSpaces.size());
    }

    public void testGetVisibleSpacesInvitedMember() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = i < 6 ? this.getSpaceInstanceInvitedMember(i, "private", "closed", new String[]{"mary", "hacker"}, "demo", new String[0]) : this.getSpaceInstance(i, "hidden", "closed", "demo", new String[0]);
            this.spaceService.saveSpace(listSpace[i], true);
        }
        List visibleAllSpaces = this.spaceService.getVisibleSpaces("demo", null);
        SpaceServiceTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)visibleAllSpaces);
        SpaceServiceTest.assertEquals((String)("visibleSpaces() must return: " + countSpace), (int)countSpace, (int)visibleAllSpaces.size());
        int invitedSpaceCount1 = 6;
        List invitedSpaces1 = this.spaceService.getVisibleSpaces("mary", null);
        SpaceServiceTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces1);
        SpaceServiceTest.assertEquals((String)("invitedSpaces must return: " + invitedSpaceCount1), (int)invitedSpaceCount1, (int)invitedSpaces1.size());
        invitedSpaceCount1 = 6;
        invitedSpaces1 = this.spaceService.getVisibleSpaces("hacker", null);
        SpaceServiceTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces1);
        SpaceServiceTest.assertEquals((String)("invitedSpaces must return: " + invitedSpaceCount1), (int)invitedSpaceCount1, (int)invitedSpaces1.size());
        int invitedSpaceCount2 = 6;
        List invitedSpaces2 = this.spaceService.getVisibleSpaces("paul", null);
        SpaceServiceTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces2);
        SpaceServiceTest.assertEquals((String)("invitedSpaces must return: " + invitedSpaceCount2), (int)invitedSpaceCount2, (int)invitedSpaces2.size());
    }

    public void testGetLastSpaces() throws Exception {
        this.populateData();
        this.createMoreSpace("Space2");
        List lastSpaces = this.spaceService.getLastSpaces(1);
        SpaceServiceTest.assertEquals((int)1, (int)lastSpaces.size());
        Space sp1 = (Space)lastSpaces.get(0);
        lastSpaces = this.spaceService.getLastSpaces(1);
        SpaceServiceTest.assertEquals((int)1, (int)lastSpaces.size());
        SpaceServiceTest.assertEquals((Object)sp1, lastSpaces.get(0));
        lastSpaces = this.spaceService.getLastSpaces(5);
        SpaceServiceTest.assertEquals((int)2, (int)lastSpaces.size());
        SpaceServiceTest.assertEquals((Object)sp1, lastSpaces.get(0));
        Space newSp1 = this.createMoreSpace("newSp1");
        lastSpaces = this.spaceService.getLastSpaces(1);
        SpaceServiceTest.assertEquals((int)1, (int)lastSpaces.size());
        SpaceServiceTest.assertEquals((Object)newSp1, lastSpaces.get(0));
        lastSpaces = this.spaceService.getLastSpaces(5);
        SpaceServiceTest.assertEquals((int)3, (int)lastSpaces.size());
        SpaceServiceTest.assertEquals((Object)newSp1, lastSpaces.get(0));
        Space newSp2 = this.createMoreSpace("newSp2");
        lastSpaces = this.spaceService.getLastSpaces(1);
        SpaceServiceTest.assertEquals((int)1, (int)lastSpaces.size());
        SpaceServiceTest.assertEquals((Object)newSp2, lastSpaces.get(0));
        lastSpaces = this.spaceService.getLastSpaces(5);
        SpaceServiceTest.assertEquals((int)4, (int)lastSpaces.size());
        SpaceServiceTest.assertEquals((Object)newSp2, lastSpaces.get(0));
        SpaceServiceTest.assertEquals((Object)newSp1, lastSpaces.get(1));
        this.spaceService.deleteSpace(newSp1);
        lastSpaces = this.spaceService.getLastSpaces(5);
        SpaceServiceTest.assertEquals((int)3, (int)lastSpaces.size());
        SpaceServiceTest.assertEquals((Object)newSp2, lastSpaces.get(0));
        SpaceServiceTest.assertFalse((boolean)newSp1.equals(lastSpaces.get(1)));
        this.spaceService.deleteSpace(newSp2);
        lastSpaces = this.spaceService.getLastSpaces(5);
        SpaceServiceTest.assertEquals((int)2, (int)lastSpaces.size());
        SpaceServiceTest.assertEquals((Object)sp1, lastSpaces.get(0));
    }

    public void testInviteSuperManager() throws Exception {
        String username = "ali";
        User superManager = this.organizationService.getUserHandler().createUserInstance(username);
        this.organizationService.getUserHandler().createUser(superManager, false);
        org.exoplatform.social.core.identity.model.Identity superManagerIdentity = this.identityManager.getOrCreateUserIdentity(username);
        SpaceServiceTest.assertFalse((boolean)this.spaceService.isSuperManager(username));
        Group group = this.organizationService.getGroupHandler().createGroupInstance();
        group.setGroupName("space-managers");
        this.organizationService.getGroupHandler().addChild(null, group, true);
        MembershipType msType = this.organizationService.getMembershipTypeHandler().createMembershipTypeInstance();
        msType.setName("test-ms");
        this.organizationService.getMembershipTypeHandler().createMembershipType(msType, true);
        this.organizationService.getMembershipHandler().linkMembership(superManager, group, msType, true);
        this.spacesAdministrationService.updateSpacesAdministratorsMemberships(Arrays.asList(new MembershipEntry("/space-managers", "test-ms")));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.isSuperManager(username));
        Space space = this.createSpace("spacename1", "root");
        space.setVisibility("public");
        space.setRegistration("open");
        this.spaceService.inviteIdentities(space, Collections.singletonList(superManagerIdentity));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.isInvitedUser(space, username));
    }

    public void testExternalSpaceInvitations() {
        this.spaceService.saveSpaceExternalInvitation("5", "external@external.com", "test");
        this.spaceService.saveSpaceExternalInvitation("5", "external1@external1.com", "test");
        this.spaceService.saveSpaceExternalInvitation("6", "external@external.com", "test");
        this.spaceService.saveSpaceExternalInvitation("7", "external2@external2.com", "test");
        this.spaceService.saveSpaceExternalInvitation("7", "external3@external3.com", "test");
        List spaceExternalInvitationEntities = this.spaceService.findSpaceExternalInvitationsBySpaceId("5");
        SpaceServiceTest.assertNotNull((Object)spaceExternalInvitationEntities);
        SpaceServiceTest.assertEquals((int)2, (int)spaceExternalInvitationEntities.size());
        List spaceIds = this.spaceService.findExternalInvitationsSpacesByEmail("external@external.com");
        SpaceServiceTest.assertNotNull((Object)spaceIds);
        SpaceServiceTest.assertEquals((int)2, (int)spaceExternalInvitationEntities.size());
        this.spaceService.deleteExternalUserInvitations("external@external.com");
        List spaceExternalInvitationEntities1 = this.spaceService.findSpaceExternalInvitationsBySpaceId("5");
        SpaceServiceTest.assertNotNull((Object)spaceExternalInvitationEntities);
        SpaceServiceTest.assertEquals((int)1, (int)spaceExternalInvitationEntities1.size());
        List spaceIds2 = this.spaceService.findExternalInvitationsSpacesByEmail("external2@external2.com");
        SpaceServiceTest.assertEquals((int)1, (int)spaceIds2.size());
    }

    public void testDeleteSpaceExternalInvitation() {
        this.spaceService.saveSpaceExternalInvitation("8", "external@external.com", "token");
        this.spaceService.saveSpaceExternalInvitation("8", "external1@external1.com", "token1");
        this.spaceService.saveSpaceExternalInvitation("8", "external2@external2.com", "token2");
        List spaceExternalInvitationEntities = this.spaceService.findSpaceExternalInvitationsBySpaceId("8");
        SpaceServiceTest.assertNotNull((Object)spaceExternalInvitationEntities);
        SpaceServiceTest.assertEquals((int)3, (int)spaceExternalInvitationEntities.size());
        this.spaceService.deleteSpaceExternalInvitation(((SpaceExternalInvitation)spaceExternalInvitationEntities.get(0)).getInvitationId().toString());
        List spaceExternalInvitationEntities1 = this.spaceService.findSpaceExternalInvitationsBySpaceId("8");
        SpaceServiceTest.assertNotNull((Object)spaceExternalInvitationEntities1);
        SpaceServiceTest.assertEquals((int)2, (int)spaceExternalInvitationEntities1.size());
        this.spaceService.deleteSpaceExternalInvitation(((SpaceExternalInvitation)spaceExternalInvitationEntities1.get(0)).getInvitationId().toString());
        this.spaceService.deleteSpaceExternalInvitation(((SpaceExternalInvitation)spaceExternalInvitationEntities1.get(1)).getInvitationId().toString());
        List spaceExternalInvitationEntities2 = this.spaceService.findSpaceExternalInvitationsBySpaceId("8");
        SpaceServiceTest.assertNotNull((Object)spaceExternalInvitationEntities2);
        SpaceServiceTest.assertEquals((int)0, (int)spaceExternalInvitationEntities2.size());
    }

    public void testIsSuperManager() throws Exception {
        Space space = this.createSpace("spacename1", "root");
        space.setVisibility("public");
        space.setRegistration("open");
        this.spaceService.updateSpace(space);
        space = this.createSpace("spacename2", "root");
        space.setVisibility("public");
        space.setRegistration("closed");
        this.spaceService.updateSpace(space);
        space = this.createSpace("spacename3", "root");
        space.setVisibility("private");
        space.setRegistration("open");
        this.spaceService.updateSpace(space);
        space = this.createSpace("spacename4", "root");
        space.setVisibility("private");
        space.setRegistration("closed");
        this.spaceService.updateSpace(space);
        space = this.createSpace("spacename5", "root");
        space.setVisibility("hidden");
        space.setRegistration("open");
        this.spaceService.updateSpace(space);
        space = this.createSpace("spacename6", "root");
        space.setVisibility("hidden");
        space.setRegistration("closed");
        this.spaceService.updateSpace(space);
        User user = this.organizationService.getUserHandler().createUserInstance("user-space-admin");
        this.organizationService.getUserHandler().createUser(user, false);
        Group group = this.organizationService.getGroupHandler().createGroupInstance();
        group.setGroupName("testgroup");
        this.organizationService.getGroupHandler().addChild(null, group, true);
        MembershipType mstype = this.organizationService.getMembershipTypeHandler().createMembershipTypeInstance();
        mstype.setName("mstypetest");
        this.organizationService.getMembershipTypeHandler().createMembershipType(mstype, true);
        this.organizationService.getMembershipHandler().linkMembership(user, group, mstype, true);
        String userName = user.getUserName();
        SpaceServiceTest.assertEquals((int)6, (int)this.spaceService.getAllSpacesWithListAccess().getSize());
        SpaceServiceTest.assertFalse((boolean)this.spaceService.isSuperManager(userName));
        this.spacesAdministrationService.updateSpacesAdministratorsMemberships(Arrays.asList(new MembershipEntry("/testgroup", "mstypetest")));
        SpaceServiceTest.assertTrue((boolean)this.spaceService.isSuperManager(userName));
    }

    private Space populateData() throws Exception {
        String spaceDisplayName = "Space1";
        Space space1 = new Space();
        space1.setApp("Calendar;FileSharing");
        space1.setDisplayName(spaceDisplayName);
        space1.setPrettyName(space1.getDisplayName());
        String shortName = Utils.cleanString((String)spaceDisplayName);
        space1.setGroupId("/spaces/" + shortName);
        space1.setUrl(shortName);
        space1.setRegistration("validation");
        space1.setDescription("This is my first space for testing");
        space1.setType("classic");
        space1.setVisibility("public");
        space1.setPriority("2");
        String[] manager = new String[]{"root"};
        String[] members = new String[]{"demo", "john", "mary", "tom", "harry"};
        space1.setManagers(manager);
        space1.setMembers(members);
        this.spaceService.saveSpace(space1, true);
        this.tearDownSpaceList.add(space1);
        return space1;
    }

    private Space createSpace(String spaceName, String creator) throws Exception {
        Space space = new Space();
        space.setDisplayName(spaceName);
        space.setPrettyName(spaceName);
        space.setGroupId("/spaces/" + space.getPrettyName());
        space.setRegistration("open");
        space.setDescription("description of space" + spaceName);
        space.setType("classic");
        space.setVisibility("private");
        space.setPriority("2");
        String[] managers = new String[]{creator};
        String[] members = new String[]{creator};
        space.setManagers(managers);
        space.setMembers(members);
        this.spaceService.saveSpace(space, true);
        this.tearDownSpaceList.add(space);
        return space;
    }

    private Space getSpaceInstance(int number) throws Exception {
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/space/space" + number);
        String[] managers = new String[]{"demo", "tom"};
        String[] members = new String[]{"demo", "raul", "ghost", "dragon"};
        String[] invitedUsers = new String[]{"register1", "mary"};
        String[] pendingUsers = new String[]{"jame", "paul", "hacker"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        space.setUrl(space.getPrettyName());
        this.spaceService.createSpace(space, "root");
        this.tearDownSpaceList.add(space);
        return space;
    }

    @Override
    public Space getSpaceInstance(int number, String visible, String registration, String manager, String ... members) {
        Space space = super.getSpaceInstance(number, visible, registration, manager, members);
        this.tearDownSpaceList.add(space);
        return space;
    }

    private Space getSpaceInstanceInvitedMember(int number, String visible, String registration, String[] invitedMember, String manager, String ... members) {
        Space space = new Space();
        space.setApp("app");
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration(registration);
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility(visible);
        space.setPriority("2");
        space.setGroupId("/spaces/space" + number);
        space.setUrl(space.getPrettyName());
        String[] managers = new String[]{manager};
        String[] pendingUsers = new String[]{};
        space.setInvitedUsers(invitedMember);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        this.tearDownSpaceList.add(space);
        return space;
    }

    private Space createMoreSpace(String spaceName) throws Exception {
        Space space2 = new Space();
        space2.setApp("Contact,Forum");
        space2.setDisplayName(spaceName);
        space2.setPrettyName(space2.getDisplayName());
        String shortName = Utils.cleanString((String)spaceName);
        space2.setGroupId("/spaces/" + shortName);
        space2.setUrl(shortName);
        space2.setRegistration("open");
        space2.setDescription("This is my second space for testing");
        space2.setType("classic");
        space2.setVisibility("public");
        space2.setPriority("2");
        this.spaceService.saveSpace(space2, true);
        this.tearDownSpaceList.add(space2);
        Thread.sleep(1L);
        return space2;
    }

    public void testSpaceContainsExternalMembers() throws Exception {
        this.externalUser.getProfile().setProperty("external", (Object)"true");
        this.identityStorage.saveIdentity(this.externalUser);
        User external = this.organizationService.getUserHandler().createUserInstance("externalUser");
        this.organizationService.getUserHandler().createUser(external, false);
        Space space = this.getSpaceInstance(10);
        boolean hasExternals = this.spaceService.isSpaceContainsExternals(Long.valueOf(space.getId()));
        SpaceServiceTest.assertEquals((boolean)false, (boolean)hasExternals);
        this.spaceService.addMember(space, "externalUser");
        hasExternals = this.spaceService.isSpaceContainsExternals(Long.valueOf(space.getId()));
        SpaceServiceTest.assertEquals((boolean)true, (boolean)hasExternals);
        this.tearDownUserList.add(this.externalUser);
    }

    public void testGetCommonSpaces() throws Exception {
        this.getSpaceInstance(11);
        Space space1 = this.getSpaceInstance(12);
        Space space2 = this.getSpaceInstance(13);
        Space space3 = this.getSpaceInstance(14);
        Space space4 = this.getSpaceInstance(15);
        Space space5 = this.getSpaceInstance(16);
        User otherUser = this.organizationService.getUserHandler().createUserInstance("otherUser");
        this.organizationService.getUserHandler().createUser(otherUser, false);
        this.spaceService.addMember(space1, "otherUser");
        this.spaceService.addMember(space2, "otherUser");
        this.spaceService.addMember(space3, "otherUser");
        this.spaceService.addMember(space4, "otherUser");
        this.spaceService.addMember(space5, "otherUser");
        ListAccess resultListCommonSpacesAccessList1 = this.spaceService.getCommonSpaces("root", "otherUser");
        SpaceServiceTest.assertEquals((int)5, (int)resultListCommonSpacesAccessList1.getSize());
        Space[] spaceArray = (Space[])resultListCommonSpacesAccessList1.load(0, 2);
        SpaceServiceTest.assertEquals((int)2, (int)spaceArray.length);
        Space testSpace1 = spaceArray[0];
        SpaceServiceTest.assertEquals((Object)space1, (Object)testSpace1);
        Space testSpace2 = spaceArray[1];
        SpaceServiceTest.assertEquals((Object)space2, (Object)testSpace2);
        spaceArray = (Space[])resultListCommonSpacesAccessList1.load(2, 2);
        SpaceServiceTest.assertEquals((int)2, (int)spaceArray.length);
        Space testSpace3 = spaceArray[0];
        SpaceServiceTest.assertEquals((Object)space3, (Object)testSpace3);
        Space testSpace4 = spaceArray[1];
        SpaceServiceTest.assertEquals((Object)space4, (Object)testSpace4);
        spaceArray = (Space[])resultListCommonSpacesAccessList1.load(4, 2);
        SpaceServiceTest.assertEquals((int)1, (int)spaceArray.length);
        Space testSpace5 = spaceArray[0];
        SpaceServiceTest.assertEquals((Object)space5, (Object)testSpace5);
    }

    public void testRestoreSpacePageLayout() throws Exception {
        Identity rootACLIdentity = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(rootACLIdentity));
        Space space = new Space();
        space.setDisplayName("testSpaceHomeLayout");
        space.setDescription("Space Description for Testing");
        String shortName = Utils.cleanString((String)space.getDisplayName());
        space.setGroupId("/spaces/" + shortName);
        String[] managers = new String[]{rootACLIdentity.getUserId()};
        space.setManagers(managers);
        space.setPrettyName(space.getDisplayName());
        space.setPriority("3");
        space.setRegistration("validation");
        space.setTag("Space Tag for Testing");
        String template = "classic";
        space.setTemplate(template);
        space.setUrl(shortName);
        space.setVisibility("public");
        space = this.spaceService.createSpace(space, rootACLIdentity.getUserId());
        SpaceTemplateService spaceTemplateService = (SpaceTemplateService)this.getContainer().getComponentInstanceOfType(SpaceTemplateService.class);
        String spaceTemplateName = space.getTemplate();
        SpaceTemplate spaceTemplate = spaceTemplateService.getSpaceTemplateByName(spaceTemplateName);
        SpaceServiceTest.assertNotNull((Object)spaceTemplate);
        SpaceServiceTest.assertEquals((String)template, (String)spaceTemplate.getName());
        NavigationService navService = (NavigationService)this.getContainer().getComponentInstanceOfType(NavigationService.class);
        NavigationContext navContext = SpaceUtils.getGroupNavigationContext((String)space.getGroupId());
        SpaceServiceTest.assertNotNull((Object)navContext);
        NodeContext parentNodeCtx = navService.loadNode(NodeModel.SELF_MODEL, navContext, Scope.CHILDREN, null);
        SpaceServiceTest.assertNotNull((Object)parentNodeCtx);
        NodeContext homeNodeContext = (NodeContext)parentNodeCtx.get(0);
        SpaceServiceTest.assertNotNull((Object)homeNodeContext);
        PageKey homePageKey = homeNodeContext.getState().getPageRef();
        SpaceServiceTest.assertNotNull((Object)homePageKey);
        LayoutService layoutService = (LayoutService)this.getContainer().getComponentInstanceOfType(LayoutService.class);
        Page page = layoutService.getPage(homePageKey.format());
        SpaceServiceTest.assertNotNull((Object)page);
        SpaceServiceTest.assertEquals((int)5, (int)this.countPageApplications(page.getChildren(), 0));
        space.setTemplate("meeds");
        space = this.spaceService.updateSpace(space);
        String spaceId = space.getId();
        Assert.assertThrows(IllegalAccessException.class, () -> this.spaceService.restoreSpacePageLayout(spaceId, "home", new Identity("demo")));
        this.spaceService.restoreSpacePageLayout(spaceId, "home", rootACLIdentity);
        page = layoutService.getPage(homePageKey.format());
        SpaceServiceTest.assertNotNull((Object)page);
        SpaceServiceTest.assertEquals((int)2, (int)this.countPageApplications(page.getChildren(), 0));
    }

    private int countPageApplications(ArrayList<ModelObject> children, int size) {
        for (ModelObject modelObject : children) {
            if (modelObject instanceof Application) {
                ++size;
                continue;
            }
            if (!(modelObject instanceof Container)) continue;
            Container container = (Container)modelObject;
            size = this.countPageApplications(container.getChildren(), size);
        }
        return size;
    }
}

