/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search;

import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.search.ProfileIndexingServiceConnector;
import org.exoplatform.social.core.jpa.storage.dao.ConnectionDAO;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.IdentityManagerImpl;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProfileIndexingServiceConnectorTest
extends AbstractCoreTest {
    private IdentityManager identityManager;
    private Identity userIdentity;
    @Mock
    private ConnectionDAO connectionDAO;
    @Mock
    private IdentityDAO identityDAO;
    private ProfilePropertyService profilePropertyService;
    private ProfileIndexingServiceConnector profileIndexingServiceConnector;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.identityManager = (IdentityManager)this.getService(IdentityManagerImpl.class);
        this.profilePropertyService = this.getService(ProfilePropertyService.class);
        InitParams initParams = new InitParams();
        PropertiesParam params = new PropertiesParam();
        params.setName("constructor.params");
        params.setProperty("index_alias", "profile_alias");
        params.setProperty("index_current", "profile_v2");
        initParams.addParam((Object)params);
        this.userIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        Profile profile = this.userIdentity.getProfile();
        profile.setProperty("profession", (Object)"Developer");
        this.identityManager.updateProfile(profile, true);
        this.profileIndexingServiceConnector = new ProfileIndexingServiceConnector(initParams, this.identityManager, this.identityDAO, this.connectionDAO, this.profilePropertyService);
    }

    @Test
    public void testUpdate() {
        Document document = this.profileIndexingServiceConnector.update(this.userIdentity.getId());
        ProfileIndexingServiceConnectorTest.assertEquals((String)"Developer", (String)((String)document.getFields().get("profession")));
        this.profilePropertyService.hidePropertySetting(Long.parseLong(this.userIdentity.getId()), this.profilePropertyService.getProfileSettingByName("profession").getId().longValue());
        document = this.profileIndexingServiceConnector.update(this.userIdentity.getId());
        ProfileIndexingServiceConnectorTest.assertEquals((String)"hidden", (String)((String)document.getFields().get("profession")));
    }
}

