/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.core.jpa.storage.SpaceStorageTest;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.core.storage.cache.SocialStorageCacheService;

public class RDBMSSpaceStorageTest
extends SpaceStorageTest {
    private SpaceStorage spaceStorage;
    private SocialStorageCacheService cacheService;
    private List<Space> tearDownSpaceList = new ArrayList<Space>();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.spaceStorage = this.getService(SpaceStorage.class);
        this.cacheService = this.getService(SocialStorageCacheService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        for (Space space : this.tearDownSpaceList) {
            this.spaceService.deleteSpace(space);
        }
        super.tearDown();
    }

    public void testVisited() throws Exception {
        Space space0 = this.getSpaceInstance(5);
        this.spaceStorage.saveSpace(space0, true);
        this.tearDownSpaceList.add(space0);
        Space space1 = this.getSpaceInstance(6);
        this.spaceStorage.saveSpace(space1, true);
        this.tearDownSpaceList.add(space1);
        SpaceFilter filter = new SpaceFilter();
        filter.setRemoteId("ghost");
        List result = this.spaceStorage.getVisitedSpaces(filter, 0, -1);
        RDBMSSpaceStorageTest.assertEquals((int)2, (int)result.size());
        RDBMSSpaceStorageTest.assertEquals((String)space0.getId(), (String)((Space)result.get(0)).getId());
        this.restartTransaction();
        this.spaceStorage.updateSpaceAccessed("ghost", space1);
        result = this.spaceStorage.getVisitedSpaces(filter, 0, -1);
        RDBMSSpaceStorageTest.assertEquals((int)2, (int)result.size());
        RDBMSSpaceStorageTest.assertEquals((String)space1.getId(), (String)((Space)result.get(0)).getId());
    }

    public void testLastAccess() throws Exception {
        Space space2 = this.getSpaceInstance(7);
        this.spaceStorage.saveSpace(space2, true);
        this.tearDownSpaceList.add(space2);
        Space space3 = this.getSpaceInstance(8);
        this.spaceStorage.saveSpace(space3, true);
        this.tearDownSpaceList.add(space3);
        SpaceFilter filter = new SpaceFilter();
        filter.setRemoteId("ghost");
        List result = this.spaceStorage.getLastAccessedSpace(filter, 0, -1);
        RDBMSSpaceStorageTest.assertEquals((int)2, (int)result.size());
        RDBMSSpaceStorageTest.assertEquals((String)space2.getId(), (String)((Space)result.get(0)).getId());
        this.restartTransaction();
        this.spaceStorage.updateSpaceAccessed("ghost", space3);
        result = this.spaceStorage.getLastAccessedSpace(filter, 0, -1);
        RDBMSSpaceStorageTest.assertEquals((int)2, (int)result.size());
        RDBMSSpaceStorageTest.assertEquals((String)space3.getId(), (String)((Space)result.get(0)).getId());
    }

    public void testGetLastAccessedSpace() {
        Space space = this.getSpaceInstance(1);
        this.spaceStorage.saveSpace(space, true);
        this.tearDownSpaceList.add(space);
        this.spaceStorage.updateSpaceAccessed("raul", space);
        this.cacheService.getSpacesCache().clearCache();
        SpaceFilter filter = new SpaceFilter();
        filter.setRemoteId("raul");
        this.spaceStorage.getLastAccessedSpace(filter, 0, 10);
        this.cacheService.getSpaceCache().clearCache();
        this.cacheService.getSpaceSimpleCache().clearCache();
        this.spaceStorage.getLastAccessedSpace(filter, 0, 10);
        Space spaceFromCache = this.spaceStorage.getSpaceById(space.getId());
        RDBMSSpaceStorageTest.assertNotNull((Object)spaceFromCache.getMembers());
        RDBMSSpaceStorageTest.assertEquals((int)5, (int)spaceFromCache.getMembers().length);
        RDBMSSpaceStorageTest.assertNotNull((Object)spaceFromCache.getManagers());
        RDBMSSpaceStorageTest.assertEquals((int)2, (int)spaceFromCache.getManagers().length);
    }

    public void testGetLastAccessedPagination() throws Exception {
        RDBMSSpaceStorageTest.assertEquals((int)0, (int)this.spaceService.getLastAccessedSpace("raul").getSize());
        int numberOfSpaces = 5;
        for (int i = 0; i < numberOfSpaces; ++i) {
            Space s = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(s, true);
            s = this.spaceStorage.getSpaceByPrettyName(s.getPrettyName());
            RDBMSSpaceStorageTest.assertNotNull((Object)s);
            this.tearDownSpaceList.add(s);
            this.restartTransaction();
            this.spaceService.updateSpaceAccessed("raul", s);
            this.restartTransaction();
            SpaceFilter filter = new SpaceFilter();
            filter.setRemoteId("raul");
            List spaces = this.spaceStorage.getLastAccessedSpace(filter, 0, 10);
            RDBMSSpaceStorageTest.assertEquals((String)s.getPrettyName(), (String)((Space)spaces.get(0)).getPrettyName());
            spaces = this.spaceStorage.getLastAccessedSpace(filter, 0, i + 1);
            RDBMSSpaceStorageTest.assertEquals((String)s.getPrettyName(), (String)((Space)spaces.get(0)).getPrettyName());
        }
        ListAccess spacesListAccess = this.spaceService.getLastAccessedSpace("raul");
        Space[] spaces = (Space[])spacesListAccess.load(0, 2);
        RDBMSSpaceStorageTest.assertEquals((int)2, (int)spaces.length);
        RDBMSSpaceStorageTest.assertEquals((String)"my_space_test_4", (String)spaces[0].getPrettyName());
        RDBMSSpaceStorageTest.assertEquals((String)"my_space_test_3", (String)spaces[1].getPrettyName());
        Space space6 = this.getSpaceInstance(6);
        this.spaceStorage.saveSpace(space6, true);
        this.tearDownSpaceList.add(space6);
        spacesListAccess = this.spaceService.getLastAccessedSpace("raul");
        spaces = (Space[])spacesListAccess.load(0, 2);
        RDBMSSpaceStorageTest.assertEquals((int)2, (int)spaces.length);
        RDBMSSpaceStorageTest.assertEquals((String)"my_space_test_4", (String)spaces[0].getPrettyName());
        RDBMSSpaceStorageTest.assertEquals((String)"my_space_test_3", (String)spaces[1].getPrettyName());
        spacesListAccess = this.spaceService.getLastAccessedSpace("raul");
        spaces = (Space[])spacesListAccess.load(2, 10);
        RDBMSSpaceStorageTest.assertEquals((int)4, (int)spaces.length);
        RDBMSSpaceStorageTest.assertEquals((String)"my_space_test_2", (String)spaces[0].getPrettyName());
        RDBMSSpaceStorageTest.assertEquals((String)"my_space_test_1", (String)spaces[1].getPrettyName());
        RDBMSSpaceStorageTest.assertEquals((String)"my_space_test_0", (String)spaces[2].getPrettyName());
        RDBMSSpaceStorageTest.assertEquals((String)"my_space_test_6", (String)spaces[3].getPrettyName());
        this.spaceService.updateSpaceAccessed("raul", space6);
        spacesListAccess = this.spaceService.getLastAccessedSpace("raul");
        spaces = (Space[])spacesListAccess.load(0, 2);
        RDBMSSpaceStorageTest.assertEquals((int)2, (int)spaces.length);
        RDBMSSpaceStorageTest.assertEquals((String)"my_space_test_6", (String)spaces[0].getPrettyName());
        RDBMSSpaceStorageTest.assertEquals((String)"my_space_test_4", (String)spaces[1].getPrettyName());
        spacesListAccess = this.spaceService.getLastAccessedSpace("raul");
        spaces = (Space[])spacesListAccess.load(2, 10);
        RDBMSSpaceStorageTest.assertEquals((int)4, (int)spaces.length);
        RDBMSSpaceStorageTest.assertEquals((String)"my_space_test_3", (String)spaces[0].getPrettyName());
        RDBMSSpaceStorageTest.assertEquals((String)"my_space_test_2", (String)spaces[1].getPrettyName());
        RDBMSSpaceStorageTest.assertEquals((String)"my_space_test_1", (String)spaces[2].getPrettyName());
        RDBMSSpaceStorageTest.assertEquals((String)"my_space_test_0", (String)spaces[3].getPrettyName());
    }

    public void testGetCommonSpaces() throws Exception {
        Space space1 = this.getSpaceInstance(11, "public", "open", "demo", "ghost", "dragon");
        Space space2 = this.getSpaceInstance(12, "public", "open", "demo", "ghost", "dragon", "raul");
        Space space3 = this.getSpaceInstance(13, "public", "open", "demo", "ghost", "dragon", "raul");
        Space space4 = this.getSpaceInstance(14, "public", "open", "demo", "ghost", "dragon", "raul");
        Space space5 = this.getSpaceInstance(15, "public", "open", "demo", "ghost", "dragon", "raul");
        Space space6 = this.getSpaceInstance(16, "public", "open", "demo", "ghost", "dragon", "raul");
        this.spaceStorage.saveSpace(space1, true);
        this.spaceStorage.saveSpace(space2, true);
        this.spaceStorage.saveSpace(space3, true);
        this.spaceStorage.saveSpace(space4, true);
        this.spaceStorage.saveSpace(space5, true);
        this.spaceStorage.saveSpace(space6, true);
        List resultListCommonSpaces1 = this.spaceStorage.getCommonSpaces("demo", "raul", 0, 2);
        RDBMSSpaceStorageTest.assertEquals((int)2, (int)resultListCommonSpaces1.size());
        Space testSpace2 = (Space)resultListCommonSpaces1.get(0);
        RDBMSSpaceStorageTest.assertEquals((Object)space2, (Object)testSpace2);
        Space testSpace3 = (Space)resultListCommonSpaces1.get(1);
        RDBMSSpaceStorageTest.assertEquals((Object)space3, (Object)testSpace3);
        List resultListCommonSpaces2 = this.spaceStorage.getCommonSpaces("demo", "raul", 2, 2);
        RDBMSSpaceStorageTest.assertEquals((int)2, (int)resultListCommonSpaces2.size());
        Space testSpace4 = (Space)resultListCommonSpaces2.get(0);
        RDBMSSpaceStorageTest.assertEquals((Object)space4, (Object)testSpace4);
        Space testSpace5 = (Space)resultListCommonSpaces2.get(1);
        RDBMSSpaceStorageTest.assertEquals((Object)space5, (Object)testSpace5);
        List resultListCommonSpaces3 = this.spaceStorage.getCommonSpaces("demo", "raul", 4, 2);
        RDBMSSpaceStorageTest.assertEquals((int)1, (int)resultListCommonSpaces3.size());
        Space testSpace6 = (Space)resultListCommonSpaces3.get(0);
        RDBMSSpaceStorageTest.assertEquals((Object)space6, (Object)testSpace6);
    }

    public void testCountCommonSpaces() throws Exception {
        Space space3 = this.getSpaceInstance(11, "public", "open", "demo", "ghost", "dragon");
        Space space1 = this.getSpaceInstance(12, "public", "open", "demo", "ghost", "dragon", "raul");
        Space space2 = this.getSpaceInstance(13, "public", "open", "demo", "ghost", "dragon", "raul");
        this.spaceStorage.saveSpace(space3, true);
        this.spaceStorage.saveSpace(space1, true);
        this.spaceStorage.saveSpace(space2, true);
        int resultListCommonSpaces = this.spaceStorage.countCommonSpaces("demo", "raul");
        RDBMSSpaceStorageTest.assertEquals((int)2, (int)resultListCommonSpaces);
    }
}

