/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import io.meeds.social.core.search.SpaceSearchConnector;
import io.meeds.social.core.search.model.SpaceSearchFilter;
import io.meeds.social.core.search.model.SpaceSearchResult;
import io.meeds.social.space.constant.SpaceMembershipStatus;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceListAccessType;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.SpaceStorage;

public class SpaceListAccess
implements ListAccess<Space> {
    private SpaceStorage spaceStorage;
    private SpaceSearchConnector spaceSearchConnector;
    private String userId;
    private String otherUserId;
    private SpaceFilter spaceFilter;
    SpaceListAccessType type;

    public SpaceListAccess(SpaceStorage spaceStorage, SpaceSearchConnector spaceSearchConnector, String userId, SpaceFilter spaceFilter, SpaceListAccessType type) {
        this.spaceStorage = spaceStorage;
        this.spaceSearchConnector = spaceSearchConnector;
        this.userId = userId;
        this.spaceFilter = spaceFilter;
        this.type = type;
    }

    public SpaceListAccess(SpaceStorage spaceStorage, SpaceSearchConnector spaceSearchConnector, SpaceListAccessType type) {
        this.spaceStorage = spaceStorage;
        this.spaceSearchConnector = spaceSearchConnector;
        this.spaceFilter = new SpaceFilter();
        this.type = type;
    }

    public SpaceListAccess(SpaceStorage spaceStorage, SpaceSearchConnector spaceSearchConnector, String userId, SpaceListAccessType type) {
        this.spaceStorage = spaceStorage;
        this.spaceSearchConnector = spaceSearchConnector;
        this.userId = userId;
        this.spaceFilter = new SpaceFilter();
        this.type = type;
    }

    public SpaceListAccess(SpaceStorage spaceStorage, SpaceSearchConnector spaceSearchConnector, SpaceFilter spaceFilter, SpaceListAccessType type) {
        this.spaceStorage = spaceStorage;
        this.spaceSearchConnector = spaceSearchConnector;
        this.spaceFilter = spaceFilter;
        this.type = type;
    }

    public SpaceListAccess(SpaceStorage spaceStorage, SpaceSearchConnector spaceSearchConnector, SpaceListAccessType type, String userId, String otherUserId) {
        this.spaceStorage = spaceStorage;
        this.spaceSearchConnector = spaceSearchConnector;
        this.otherUserId = otherUserId;
        this.userId = userId;
        this.type = type;
        this.spaceFilter = new SpaceFilter();
    }

    public int getSize() {
        SpaceSearchFilter searchFilter;
        if (this.spaceFilter != null && this.spaceFilter.isFavorite() && StringUtils.isBlank((CharSequence)this.spaceFilter.getRemoteId())) {
            this.spaceFilter.setRemoteId(this.userId);
        }
        if ((searchFilter = this.getSpaceSearchFilter()) != null) {
            return this.spaceSearchConnector.count(searchFilter);
        }
        switch (this.type) {
            case ALL: {
                return this.spaceStorage.getAllSpacesCount();
            }
            case ALL_FILTER: {
                return this.spaceStorage.getAllSpacesByFilterCount(this.spaceFilter);
            }
            case ACCESSIBLE: {
                return this.spaceStorage.getAccessibleSpacesCount(this.userId);
            }
            case ACCESSIBLE_FILTER: {
                return this.spaceStorage.getAccessibleSpacesByFilterCount(this.userId, this.spaceFilter);
            }
            case INVITED: {
                return this.spaceStorage.getInvitedSpacesCount(this.userId);
            }
            case INVITED_FILTER: {
                return this.spaceStorage.getInvitedSpacesByFilterCount(this.userId, this.spaceFilter);
            }
            case PENDING: {
                return this.spaceStorage.getPendingSpacesCount(this.userId);
            }
            case PENDING_FILTER: {
                return this.spaceStorage.getPendingSpacesByFilterCount(this.userId, this.spaceFilter);
            }
            case MEMBER: {
                return this.spaceStorage.getMemberSpacesCount(this.userId);
            }
            case MEMBER_FILTER: {
                return this.spaceStorage.getMemberSpacesByFilterCount(this.userId, this.spaceFilter);
            }
            case FAVORITE_FILTER: {
                return this.spaceStorage.getFavoriteSpacesByFilterCount(this.userId, this.spaceFilter);
            }
            case MANAGER: {
                return this.spaceStorage.getManagerSpacesCount(this.userId);
            }
            case MANAGER_FILTER: {
                return this.spaceStorage.getManagerSpacesByFilterCount(this.userId, this.spaceFilter);
            }
            case VISIBLE: {
                return this.spaceStorage.getVisibleSpacesCount(this.userId, this.spaceFilter);
            }
            case LASTEST_ACCESSED: {
                return this.spaceStorage.getLastAccessedSpaceCount(this.spaceFilter);
            }
            case PENDING_REQUESTS: {
                return this.spaceStorage.countPendingSpaceRequestsToManage(this.userId);
            }
            case COMMON: {
                return this.spaceStorage.countCommonSpaces(this.userId, this.otherUserId);
            }
        }
        return 0;
    }

    public Space[] load(int offset, int limit) {
        if (this.spaceFilter != null && StringUtils.isBlank((CharSequence)this.spaceFilter.getRemoteId())) {
            this.spaceFilter.setRemoteId(this.userId);
        }
        List<Space> listSpaces = null;
        SpaceSearchFilter searchFilter = this.getSpaceSearchFilter();
        if (searchFilter != null) {
            List<SpaceSearchResult> spaces = this.spaceSearchConnector.search(searchFilter, offset, limit);
            listSpaces = spaces.stream().map(SpaceSearchResult::getId).map(String::valueOf).map(arg_0 -> ((SpaceStorage)this.spaceStorage).getSpaceById(arg_0)).filter(Objects::nonNull).toList();
        } else {
            switch (this.type) {
                case ALL: {
                    listSpaces = this.spaceStorage.getSpaces((long)offset, (long)limit);
                    break;
                }
                case ALL_FILTER: {
                    listSpaces = this.spaceStorage.getSpacesByFilter(this.spaceFilter, (long)offset, (long)limit);
                    break;
                }
                case ACCESSIBLE: {
                    listSpaces = this.spaceStorage.getAccessibleSpaces(this.userId, (long)offset, (long)limit);
                    break;
                }
                case ACCESSIBLE_FILTER: {
                    listSpaces = this.spaceStorage.getAccessibleSpacesByFilter(this.userId, this.spaceFilter, (long)offset, (long)limit);
                    break;
                }
                case INVITED: {
                    listSpaces = this.spaceStorage.getInvitedSpaces(this.userId, (long)offset, (long)limit);
                    break;
                }
                case INVITED_FILTER: {
                    listSpaces = this.spaceStorage.getInvitedSpacesByFilter(this.userId, this.spaceFilter, (long)offset, (long)limit);
                    break;
                }
                case PENDING: {
                    listSpaces = this.spaceStorage.getPendingSpaces(this.userId, (long)offset, (long)limit);
                    break;
                }
                case PENDING_FILTER: {
                    listSpaces = this.spaceStorage.getPendingSpacesByFilter(this.userId, this.spaceFilter, (long)offset, (long)limit);
                    break;
                }
                case MEMBER: {
                    listSpaces = this.spaceStorage.getMemberSpaces(this.userId, (long)offset, (long)limit);
                    break;
                }
                case MEMBER_FILTER: {
                    listSpaces = this.spaceStorage.getMemberSpacesByFilter(this.userId, this.spaceFilter, (long)offset, (long)limit);
                    break;
                }
                case FAVORITE_FILTER: {
                    listSpaces = this.spaceStorage.getFavoriteSpacesByFilter(this.userId, this.spaceFilter, (long)offset, (long)limit);
                    break;
                }
                case MANAGER: {
                    listSpaces = this.spaceStorage.getManagerSpaces(this.userId, (long)offset, (long)limit);
                    break;
                }
                case MANAGER_FILTER: {
                    listSpaces = this.spaceStorage.getManagerSpacesByFilter(this.userId, this.spaceFilter, (long)offset, (long)limit);
                    break;
                }
                case VISIBLE: {
                    listSpaces = this.spaceStorage.getVisibleSpaces(this.userId, this.spaceFilter, (long)offset, (long)limit);
                    break;
                }
                case LASTEST_ACCESSED: {
                    listSpaces = this.spaceStorage.getLastAccessedSpace(this.spaceFilter, offset, limit);
                    break;
                }
                case VISITED: {
                    listSpaces = this.spaceStorage.getVisitedSpaces(this.spaceFilter, offset, limit);
                    break;
                }
                case COMMON: {
                    listSpaces = this.spaceStorage.getCommonSpaces(this.userId, this.otherUserId, offset, limit);
                    break;
                }
                case PENDING_REQUESTS: {
                    List pendingSpaceRequestsToManage = this.spaceStorage.getPendingSpaceRequestsToManage(this.userId, offset, limit);
                    listSpaces = pendingSpaceRequestsToManage.stream().map(space -> {
                        Space storedSpace = this.spaceStorage.getSpaceById(space.getId());
                        storedSpace.setPendingUsers(space.getPendingUsers());
                        return storedSpace;
                    }).toList();
                }
            }
        }
        return listSpaces == null ? new Space[]{} : listSpaces.toArray(new Space[listSpaces.size()]);
    }

    private SpaceSearchFilter getSpaceSearchFilter() {
        if (this.spaceFilter == null || !this.spaceSearchConnector.isEnabled()) {
            return null;
        }
        String username = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.userId, this.spaceFilter.getRemoteId()});
        if (username == null) {
            return null;
        }
        SpaceMembershipStatus statusType = this.getUnifiedSearchStatusType(this.spaceFilter.getStatus());
        if (this.spaceFilter.isUnifiedSearch() && (this.type == SpaceListAccessType.ALL_FILTER || this.type == SpaceListAccessType.ALL || this.type == SpaceListAccessType.ACCESSIBLE_FILTER || this.type == SpaceListAccessType.ACCESSIBLE || this.type == SpaceListAccessType.VISIBLE || statusType != null)) {
            return new SpaceSearchFilter(username, this.spaceFilter.getIdentityId(), this.spaceFilter.getSpaceNameSearchCondition(), this.spaceFilter.isFavorite(), this.spaceFilter.getTagNames(), statusType);
        }
        return null;
    }

    private SpaceMembershipStatus getUnifiedSearchStatusType(SpaceMembershipStatus spaceMembershipStatus) {
        return switch (this.type) {
            case SpaceListAccessType.MEMBER_FILTER, SpaceListAccessType.FAVORITE_FILTER -> SpaceMembershipStatus.MEMBER;
            case SpaceListAccessType.MANAGER_FILTER -> SpaceMembershipStatus.MANAGER;
            case SpaceListAccessType.INVITED_FILTER -> SpaceMembershipStatus.INVITED;
            case SpaceListAccessType.PENDING_FILTER -> SpaceMembershipStatus.PENDING;
            default -> {
                if (spaceMembershipStatus == null) {
                    yield null;
                }
                switch (spaceMembershipStatus) {
                    case MEMBER: {
                        yield SpaceMembershipStatus.MEMBER;
                    }
                    case MANAGER: {
                        yield SpaceMembershipStatus.MANAGER;
                    }
                    case INVITED: {
                        yield SpaceMembershipStatus.INVITED;
                    }
                    case PENDING: {
                        yield SpaceMembershipStatus.PENDING;
                    }
                    case PUBLISHER: {
                        yield SpaceMembershipStatus.PUBLISHER;
                    }
                    case REDACTOR: {
                        yield SpaceMembershipStatus.REDACTOR;
                    }
                }
                yield null;
            }
        };
    }
}

