/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.metadata.MetadataService;

public class SpaceMetadataListenerImpl
extends SpaceListenerPlugin {
    private MetadataService metadataService;
    private IdentityManager identityManager;

    public SpaceMetadataListenerImpl(MetadataService metadataService, IdentityManager identityManager) {
        this.metadataService = metadataService;
        this.identityManager = identityManager;
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
        long spaceId = Long.parseLong(event.getSpace().getId());
        this.metadataService.deleteMetadataBySpaceId(spaceId);
    }

    public void left(SpaceLifeCycleEvent event) {
        long spaceId = Long.parseLong(event.getSpace().getId());
        String username = (String)event.getSource();
        Identity identity = this.identityManager.getOrCreateUserIdentity(username);
        if (identity != null) {
            long userId = Long.parseLong(identity.getId());
            this.metadataService.deleteMetadataBySpaceIdAndAudienceId(spaceId, userId);
        }
    }
}

