/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.template.service;

import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.model.SpaceTemplateFilter;
import io.meeds.social.space.template.storage.SpaceTemplateStorage;
import io.meeds.social.translation.service.TranslationService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.core.space.SpacesAdministrationService;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SpaceTemplateService {
    public static final String SPACE_TEMPLATE_CREATED_EVENT = "space.template.created";
    public static final String SPACE_TEMPLATE_UPDATED_EVENT = "space.template.updated";
    public static final String SPACE_TEMPLATE_DELETED_EVENT = "space.template.deleted";
    public static final String SPACE_TEMPLATE_SITE_PROP_NAME = "SPACE_TEMPLATE";
    public static final String SPACE_TEMPLATE_ID_PROP_NAME = "SPACE_TEMPLATE_ID";
    public static final String DEFAULT_SITE_TEMPLATE = "space";
    private static final Log LOG = ExoLogger.getLogger(SpaceTemplateService.class);
    private TranslationService translationService;
    private AttachmentService attachmentService;
    private SpacesAdministrationService spacesAdministrationService;
    private UserACL userAcl;
    private SpaceTemplateStorage spaceTemplateStorage;
    private UserPortalConfigService userPortalConfigService;
    private LayoutService layoutService;
    private NavigationService navigationService;
    private ListenerService listenerService;

    public SpaceTemplateService(TranslationService translationService, AttachmentService attachmentService, UserPortalConfigService userPortalConfigService, LayoutService layoutService, NavigationService navigationService, ListenerService listenerService, UserACL userAcl, SpacesAdministrationService spacesAdministrationService, SpaceTemplateStorage spaceTemplateStorage) {
        this.userPortalConfigService = userPortalConfigService;
        this.translationService = translationService;
        this.attachmentService = attachmentService;
        this.userAcl = userAcl;
        this.spacesAdministrationService = spacesAdministrationService;
        this.spaceTemplateStorage = spaceTemplateStorage;
        this.layoutService = layoutService;
        this.navigationService = navigationService;
        this.listenerService = listenerService;
    }

    public List<SpaceTemplate> getSpaceTemplates() {
        return this.getSpaceTemplates(null, Pageable.unpaged(), false);
    }

    public List<SpaceTemplate> getSpaceTemplates(SpaceTemplateFilter spaceTemplateFilter, Pageable pageable, boolean expand) {
        if (spaceTemplateFilter != null && StringUtils.isBlank((CharSequence)spaceTemplateFilter.getUsername())) {
            return Collections.emptyList();
        }
        boolean includeDisabled = spaceTemplateFilter == null || spaceTemplateFilter.isIncludeDisabled();
        List<SpaceTemplate> spaceTemplates = includeDisabled ? this.spaceTemplateStorage.getSpaceTemplates(pageable) : this.spaceTemplateStorage.getEnabledSpaceTemplates(pageable);
        return spaceTemplates.stream().map(spaceTemplate -> {
            if (spaceTemplateFilter != null && !this.canViewTemplate(spaceTemplate.getId(), spaceTemplateFilter.getUsername())) {
                return null;
            }
            if (expand) {
                this.computeSpaceTemplateAttributes((SpaceTemplate)spaceTemplate, spaceTemplateFilter == null ? null : spaceTemplateFilter.getLocale());
            }
            return spaceTemplate;
        }).filter(Objects::nonNull).toList();
    }

    public SpaceTemplate getSpaceTemplate(long templateId) {
        return this.spaceTemplateStorage.getSpaceTemplate(templateId);
    }

    public SpaceTemplate getSpaceTemplate(long templateId, String username, Locale locale, boolean expand) throws IllegalAccessException {
        SpaceTemplate spaceTemplate = this.spaceTemplateStorage.getSpaceTemplate(templateId);
        if (spaceTemplate == null) {
            return null;
        }
        if (!this.canViewTemplate(spaceTemplate, username)) {
            throw new IllegalAccessException();
        }
        if (expand) {
            this.computeSpaceTemplateAttributes(spaceTemplate, locale);
        }
        return spaceTemplate;
    }

    public SpaceTemplate getSpaceTemplateByLayout(String layout) {
        return this.spaceTemplateStorage.getSpaceTemplateByLayout(layout);
    }

    public long getSpaceTemplateBannerId(long templateId) {
        List attachmentFileIds = this.attachmentService.getAttachmentFileIds("spaceTemplateBanner", String.valueOf(templateId));
        if (CollectionUtils.isNotEmpty((Collection)attachmentFileIds)) {
            return Long.parseLong((String)attachmentFileIds.get(0));
        }
        return 0L;
    }

    public boolean canManageTemplates(String username) {
        return this.spacesAdministrationService.isSuperManager(username);
    }

    public boolean canViewTemplate(long templateId, String username) {
        SpaceTemplate spaceTemplate = this.getSpaceTemplate(templateId);
        return this.canViewTemplate(spaceTemplate, username);
    }

    public boolean canCreateSpace(long templateId, String username) {
        SpaceTemplate spaceTemplate = this.getSpaceTemplate(templateId);
        return this.canViewTemplate(spaceTemplate, username) && spaceTemplate.isEnabled();
    }

    public boolean canCreateSpace(String username) {
        return this.spaceTemplateStorage.getEnabledSpaceTemplates(Pageable.unpaged()).stream().anyMatch(t -> this.canViewTemplate((SpaceTemplate)t, username));
    }

    public SpaceTemplate createSpaceTemplate(SpaceTemplate spaceTemplate, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (!this.canManageTemplates(username)) {
            throw new IllegalAccessException("User isn't authorized to create a space template");
        }
        return this.createSpaceTemplate(spaceTemplate);
    }

    public SpaceTemplate createSpaceTemplate(SpaceTemplate spaceTemplate) throws ObjectNotFoundException {
        if (spaceTemplate.getId() != 0L) {
            throw new IllegalArgumentException("Space template to create shouldn't have an id");
        }
        String layout = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{spaceTemplate.getLayout(), DEFAULT_SITE_TEMPLATE});
        if (this.layoutService.getPortalConfig(SiteKey.groupTemplate((String)layout)) == null) {
            throw new ObjectNotFoundException(String.format("Space Template layout '%s' wasn't found", layout));
        }
        SpaceTemplate spaceTemplateToCreate = spaceTemplate.clone();
        spaceTemplateToCreate.setSystem(false);
        spaceTemplateToCreate.setDeleted(false);
        spaceTemplateToCreate.setLayout(null);
        SpaceTemplate createdSpaceTemplate = this.spaceTemplateStorage.createSpaceTemplate(spaceTemplateToCreate);
        createdSpaceTemplate = this.createSpaceTemplateLayout(createdSpaceTemplate, layout);
        this.listenerService.broadcast(SPACE_TEMPLATE_CREATED_EVENT, (Object)spaceTemplate, (Object)createdSpaceTemplate);
        return createdSpaceTemplate;
    }

    public SpaceTemplate updateSpaceTemplate(SpaceTemplate spaceTemplate, String username) throws ObjectNotFoundException, IllegalAccessException {
        if (!this.canManageTemplates(username)) {
            throw new IllegalAccessException("User isn't authorized to update a space template");
        }
        if (spaceTemplate.isDeleted()) {
            throw new IllegalArgumentException("Can't mark space template as deleted through update method");
        }
        return this.updateSpaceTemplate(spaceTemplate);
    }

    public SpaceTemplate updateSpaceTemplate(SpaceTemplate spaceTemplate) throws ObjectNotFoundException {
        SpaceTemplate storedSpaceTemplate = this.spaceTemplateStorage.getSpaceTemplate(spaceTemplate.getId());
        if (storedSpaceTemplate == null || storedSpaceTemplate.isDeleted()) {
            throw new ObjectNotFoundException("Space Template doesn't exist");
        }
        spaceTemplate.setSystem(storedSpaceTemplate.isSystem());
        spaceTemplate.setDeleted(storedSpaceTemplate.isDeleted());
        spaceTemplate.setLayout(storedSpaceTemplate.getLayout());
        SpaceTemplate updatedSpaceTemplate = this.spaceTemplateStorage.updateSpaceTemplate(spaceTemplate);
        this.listenerService.broadcast(SPACE_TEMPLATE_UPDATED_EVENT, (Object)storedSpaceTemplate, (Object)updatedSpaceTemplate);
        return updatedSpaceTemplate;
    }

    public void deleteSpaceTemplate(long templateId, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (!this.canManageTemplates(username)) {
            throw new IllegalAccessException("User isn't authorized to create a space template");
        }
        SpaceTemplate spaceTemplate = this.getSpaceTemplate(templateId);
        if (spaceTemplate != null && spaceTemplate.isSystem()) {
            throw new IllegalAccessException("Can't delete a system space template");
        }
        this.deleteSpaceTemplate(templateId);
    }

    public void deleteSpaceTemplate(long templateId) throws ObjectNotFoundException {
        SpaceTemplate spaceTemplate = this.spaceTemplateStorage.getSpaceTemplate(templateId);
        if (spaceTemplate == null || spaceTemplate.isDeleted()) {
            throw new ObjectNotFoundException(String.format("Space template with id %s doesn't exist", templateId));
        }
        try {
            this.attachmentService.deleteAttachments("spaceTemplateBanner", String.valueOf(templateId));
        }
        catch (Exception e) {
            LOG.debug((Object)"Error while deleting attachments of deleted Page Template", (Throwable)e);
        }
        try {
            this.translationService.deleteTranslationLabels("spaceTemplate", templateId);
        }
        catch (ObjectNotFoundException e) {
            LOG.debug((Object)"Error while deleting translation labels of deleted Page Template", (Throwable)e);
        }
        PortalConfig portalConfig = this.layoutService.getPortalConfig(SiteKey.groupTemplate((String)spaceTemplate.getLayout()));
        if (portalConfig != null) {
            SiteKey siteKey = SiteKey.portal((String)portalConfig.getName());
            this.navigationService.destroyNavigation(siteKey);
            this.layoutService.removePages(siteKey);
            this.layoutService.remove(portalConfig);
        }
        spaceTemplate.setDeleted(true);
        this.spaceTemplateStorage.updateSpaceTemplate(spaceTemplate);
        this.listenerService.broadcast(SPACE_TEMPLATE_DELETED_EVENT, (Object)spaceTemplate, (Object)spaceTemplate);
    }

    private SpaceTemplate createSpaceTemplateLayout(SpaceTemplate spaceTemplate, String sourceLayout) throws ObjectNotFoundException {
        SiteKey sourceSiteKey = SiteKey.groupTemplate((String)sourceLayout);
        SiteKey targetSiteKey = SiteKey.groupTemplate((String)String.valueOf(spaceTemplate.getId()));
        this.userPortalConfigService.createSiteFromTemplate(sourceSiteKey, targetSiteKey);
        PortalConfig targetPortalConfig = this.layoutService.getPortalConfig(targetSiteKey);
        targetPortalConfig.setProperty(SPACE_TEMPLATE_SITE_PROP_NAME, "true");
        targetPortalConfig.setProperty(SPACE_TEMPLATE_ID_PROP_NAME, targetSiteKey.getName());
        this.layoutService.save(targetPortalConfig);
        spaceTemplate.setLayout(targetSiteKey.getName());
        return this.spaceTemplateStorage.updateSpaceTemplate(spaceTemplate);
    }

    private void computeSpaceTemplateAttributes(SpaceTemplate spaceTemplate, Locale locale) {
        spaceTemplate.setName(this.translationService.getTranslationLabelOrDefault("spaceTemplate", spaceTemplate.getId(), "name", locale));
        spaceTemplate.setDescription(this.translationService.getTranslationLabelOrDefault("spaceTemplate", spaceTemplate.getId(), "description", locale));
        spaceTemplate.setBannerFileId(this.getSpaceTemplateBannerId(spaceTemplate.getId()));
    }

    private boolean canViewTemplate(SpaceTemplate spaceTemplate, String username) {
        if (spaceTemplate == null || spaceTemplate.isDeleted() || this.userAcl.isAnonymousUser(username)) {
            return false;
        }
        if (this.canManageTemplates(username)) {
            return true;
        }
        if (!spaceTemplate.isEnabled()) {
            return false;
        }
        Identity aclIdentity = this.userAcl.getUserIdentity(username);
        return aclIdentity != null && spaceTemplate.getPermissions().stream().anyMatch(expression -> aclIdentity.isMemberOf(this.getMembershipEntry((String)expression)));
    }

    private MembershipEntry getMembershipEntry(String expression) {
        return expression.contains(":") ? MembershipEntry.parse((String)expression) : new MembershipEntry(expression);
    }
}

