/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.link.plugin;

import io.meeds.social.link.dao.LinkDAO;
import io.meeds.social.link.dao.LinkSettingDAO;
import io.meeds.social.link.model.Link;
import io.meeds.social.link.model.LinkSetting;
import io.meeds.social.link.service.LinkService;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.junit.Assert;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/exo.social.component.core-local-root-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.core-local-configuration.xml")})
public class LinkTranslationPluginTest
extends AbstractKernelTest {
    private static final String FIELD_NAME = "name";
    private static final String USERS_GROUP = "*:/platform/users";
    private static final String ADMINISTRATORS_GROUP = "*:/platform/administrators";
    private static final String USERNAME = "testuser";
    private static final String LINK_SETTING_NAME = "linkSettingName";
    private LayoutService layoutService;
    private LinkService linkService;
    private TranslationService translationService;
    private IdentityRegistry identityRegistry;

    protected void setUp() throws Exception {
        super.setUp();
        this.linkService = (LinkService)this.getContainer().getComponentInstanceOfType(LinkService.class);
        this.layoutService = (LayoutService)this.getContainer().getComponentInstanceOfType(LayoutService.class);
        this.identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
        this.translationService = (TranslationService)this.getContainer().getComponentInstanceOfType(TranslationService.class);
        this.begin();
    }

    protected void tearDown() throws Exception {
        this.restartTransaction();
        ((LinkDAO)this.getContainer().getComponentInstanceOfType(LinkDAO.class)).deleteAll();
        this.restartTransaction();
        ((LinkSettingDAO)this.getContainer().getComponentInstanceOfType(LinkSettingDAO.class)).deleteAll();
        ((CacheService)this.getContainer().getComponentInstanceOfType(CacheService.class)).getCacheInstance("social.linkSettings").clearCache();
        this.end();
        super.tearDown();
    }

    public void testLinkSettingHeaderTranslation() throws ObjectNotFoundException, IllegalAccessException {
        String pageId = this.createPage("testLinkSettingHeaderTranslation1", "Everyone", ADMINISTRATORS_GROUP);
        this.linkService.initLinkSetting(LINK_SETTING_NAME, pageId, 0L);
        LinkSetting linkSetting = this.linkService.getLinkSetting(LINK_SETTING_NAME);
        LinkTranslationPluginTest.assertNotNull((Object)linkSetting);
        Link linkToSave = new Link(0L, Collections.singletonMap("en", "Website"), Collections.singletonMap("en", "Website description"), "https://localhost/", true, 5, 0L);
        this.linkService.saveLinkSetting(linkSetting, Collections.singletonList(linkToSave), this.registerAdministratorUser(USERNAME));
        List links = this.linkService.getLinks(LINK_SETTING_NAME);
        LinkTranslationPluginTest.assertNotNull((Object)links);
        LinkTranslationPluginTest.assertEquals((int)1, (int)links.size());
        Link link = (Link)links.get(0);
        pageId = this.createPage("testLinkSettingHeaderTranslation1", USERS_GROUP, ADMINISTRATORS_GROUP);
        this.linkService.initLinkSetting(LINK_SETTING_NAME, pageId, 0L);
        Assert.assertThrows(IllegalAccessException.class, () -> this.translationService.getTranslationField("links", link.getId(), FIELD_NAME, null));
        this.registerInternalUser(USERNAME);
        TranslationField nameTranslationField = this.translationService.getTranslationField("links", link.getId(), FIELD_NAME, USERNAME);
        TranslationField descriptionTranslationField = this.translationService.getTranslationField("links", link.getId(), "description", USERNAME);
        LinkTranslationPluginTest.assertNotNull((Object)nameTranslationField);
        LinkTranslationPluginTest.assertNotNull((Object)nameTranslationField.getLabels());
        LinkTranslationPluginTest.assertFalse((boolean)nameTranslationField.getLabels().isEmpty());
        LinkTranslationPluginTest.assertEquals((String)((String)linkToSave.getName().get(Locale.ENGLISH.toLanguageTag())), (String)((String)nameTranslationField.getLabels().get(Locale.ENGLISH)));
        LinkTranslationPluginTest.assertEquals((String)((String)linkToSave.getDescription().get(Locale.ENGLISH.toLanguageTag())), (String)((String)descriptionTranslationField.getLabels().get(Locale.ENGLISH)));
    }

    private String createPage(String pageName, String accessPermission, String editPermission) {
        String siteType = "portal";
        String siteName = "test";
        if (this.layoutService.getPortalConfig(siteName) == null) {
            PortalConfig portal = new PortalConfig();
            portal.setType(siteType);
            portal.setName(siteName);
            portal.setLocale("en");
            portal.setLabel("Test");
            portal.setDescription("Test");
            portal.setAccessPermissions(new String[]{"Everyone"});
            this.layoutService.create(portal);
        }
        PageKey pageKey = new PageKey(siteType, siteName, pageName);
        PageState pageState = new PageState(pageName, null, false, null, Collections.singletonList(accessPermission), editPermission);
        this.layoutService.save(new PageContext(pageKey, pageState));
        return pageKey.format();
    }

    private Identity registerAdministratorUser(String user) {
        Identity identity = new Identity(user, Arrays.asList(new MembershipEntry("/platform/administrators")));
        this.identityRegistry.register(identity);
        return identity;
    }

    private Identity registerInternalUser(String username) {
        Identity identity = new Identity(username, Arrays.asList(new MembershipEntry("/platform/users")));
        this.identityRegistry.register(identity);
        return identity;
    }
}

