/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import io.meeds.social.navigation.AbstractNavigationConfigurationTest;
import io.meeds.social.navigation.constant.SidebarItemType;
import io.meeds.social.navigation.model.SidebarItem;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.space.model.Space;
import org.junit.Before;
import org.junit.Test;

public class SpaceTemplateSidebarPluginTest
extends AbstractNavigationConfigurationTest {
    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        if (this.spaceTemplate == null) {
            this.mockSpaceTemplate();
            for (int i = 0; i < 5; ++i) {
                Space space = new Space();
                space.setRegistration("open");
                space.setVisibility("public");
                space.setTemplateId(this.spaceTemplate.getId());
                this.spaceService.createSpace(space, this.userAcl.getSuperUser());
            }
        }
    }

    @Test
    public void testGetType() {
        SpaceTemplateSidebarPluginTest.assertEquals((Object)SidebarItemType.SPACE_TEMPLATE, (Object)this.spaceTemplateSidebarPlugin.getType());
    }

    @Test
    public void testGetDefaultItems() {
        List defaultItems = this.spaceTemplateSidebarPlugin.getDefaultItems();
        SpaceTemplateSidebarPluginTest.assertNotNull((Object)defaultItems);
        SpaceTemplateSidebarPluginTest.assertTrue((boolean)defaultItems.stream().anyMatch(item -> item.getProperties() != null && StringUtils.equals((CharSequence)((CharSequence)item.getProperties().get("spaceTemplateId")), (CharSequence)String.valueOf(this.spaceTemplate.getId()))));
    }

    @Test
    public void testItemExists() {
        SpaceTemplateSidebarPluginTest.assertFalse((boolean)this.spaceTemplateSidebarPlugin.itemExists(null, null));
        SpaceTemplateSidebarPluginTest.assertFalse((boolean)this.spaceTemplateSidebarPlugin.itemExists(new SidebarItem(), null));
        SidebarItem item = new SidebarItem(SidebarItemType.SPACE_TEMPLATE);
        item.setProperties(Collections.singletonMap("spaceTemplateId", String.valueOf(this.spaceTemplate.getId())));
        SpaceTemplateSidebarPluginTest.assertTrue((boolean)this.spaceTemplateSidebarPlugin.itemExists(item, null));
    }

    @Test
    public void testResolveProperties() {
        SidebarItem item = new SidebarItem(SidebarItemType.SPACE_TEMPLATE);
        item.setProperties(Collections.singletonMap("spaceTemplateId", String.valueOf(this.spaceTemplate.getId())));
        this.spaceTemplateSidebarPlugin.resolveProperties(item, this.userAcl.getSuperUser(), Locale.ENGLISH);
        SpaceTemplateSidebarPluginTest.assertEquals((String)this.spaceTemplate.getName(), (String)item.getName());
        SpaceTemplateSidebarPluginTest.assertEquals((String)this.spaceTemplate.getIcon(), (String)item.getIcon());
        SpaceTemplateSidebarPluginTest.assertNull((Object)item.getUrl());
        SpaceTemplateSidebarPluginTest.assertNull((Object)item.getTarget());
        SpaceTemplateSidebarPluginTest.assertNull((Object)item.getAvatar());
        SpaceTemplateSidebarPluginTest.assertNotNull((Object)item.getItems());
        SpaceTemplateSidebarPluginTest.assertEquals((int)4, (int)item.getItems().size());
    }
}

