/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.service;

import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.service.SpaceTemplateService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.stereotype.Service;

@Service
public class SpaceLayoutService {
    public static final String DEFAULT_PUBLIC_SITE_TEMPLATE = "spacePublic";
    public static final String DEFAULT_SITE_TEMPLATE = "space";
    public static final String DEFAULT_SITE_TEMPLATE_PATH = "war:/conf/portal";
    private UserPortalConfigService portalConfigService;
    private LayoutService layoutService;
    private NavigationService navigationService;
    private SpaceService spaceService;
    private SpaceTemplateService spaceTemplateService;

    public SpaceLayoutService(SpaceService spaceService, SpaceTemplateService spaceTemplateService, UserPortalConfigService portalConfigService, LayoutService layoutService, NavigationService navigationService) {
        this.portalConfigService = portalConfigService;
        this.layoutService = layoutService;
        this.navigationService = navigationService;
        this.spaceService = spaceService;
        this.spaceTemplateService = spaceTemplateService;
    }

    public void createSpaceSite(Space space) throws ObjectNotFoundException {
        SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplate(space.getTemplateId());
        if (spaceTemplate == null || !spaceTemplate.isEnabled() || spaceTemplate.isDeleted()) {
            throw new ObjectNotFoundException(String.format("Enabled Space Template with id %s not found", space.getTemplateId()));
        }
        this.portalConfigService.createSiteFromTemplate(SiteKey.groupTemplate((String)((String)StringUtils.firstNonBlank((CharSequence[])new String[]{spaceTemplate.getLayout(), DEFAULT_SITE_TEMPLATE}))), SiteKey.group((String)space.getGroupId()), space.getGroupId());
        PortalConfig portalConfig = this.layoutService.getPortalConfig(PortalConfig.GROUP_TYPE, space.getGroupId());
        portalConfig.setEditPermission(StringUtils.join(spaceTemplate.getSpaceLayoutPermissions(), (String)","));
        portalConfig.setLabel(space.getDisplayName());
        this.layoutService.save(portalConfig);
        String url = this.getFirstSpacePageUri(space.getGroupId());
        space = this.spaceService.getSpaceById(space.getId());
        space.setUrl(url);
        this.spaceService.updateSpace(space);
    }

    public void updateSpaceSite(Space space) throws ObjectNotFoundException {
        SiteKey spaceSiteKey = SiteKey.group((String)space.getGroupId());
        PortalConfig portalConfig = this.layoutService.getPortalConfig(spaceSiteKey);
        if (portalConfig != null) {
            this.navigationService.destroyNavigation(spaceSiteKey);
            this.layoutService.removePages(spaceSiteKey);
            this.layoutService.remove(portalConfig);
        }
        this.createSpaceSite(space);
    }

    public void saveSpacePublicSite(String spaceId, String publicSiteVisibility, String username) throws ObjectNotFoundException, IllegalAccessException {
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            throw new ObjectNotFoundException("Space not found");
        }
        if (!this.spaceService.canManageSpacePublicSite(space, username)) {
            throw new IllegalAccessException("User can't manage the space public site");
        }
        space.setEditor(username);
        this.saveSpacePublicSite(space, publicSiteVisibility, username);
    }

    public void saveSpacePublicSite(Space space, String publicSiteVisibility) {
        this.saveSpacePublicSite(space, publicSiteVisibility, space.getEditor());
    }

    public void removeSpacePublicSite(Space space) {
        if (space.getPublicSiteId() == 0L) {
            return;
        }
        PortalConfig portalConfig = this.layoutService.getPortalConfig(space.getPublicSiteId());
        if (portalConfig == null) {
            return;
        }
        SiteKey siteKey = SiteKey.portal((String)portalConfig.getName());
        this.navigationService.destroyNavigation(siteKey);
        this.layoutService.removePages(siteKey);
        this.layoutService.remove(portalConfig);
    }

    public String getSpacePublicSiteName(Space space) {
        if (space == null || space.getPublicSiteId() == 0L) {
            return null;
        }
        PortalConfig portalConfig = this.layoutService.getPortalConfig(space.getPublicSiteId());
        return portalConfig == null ? null : portalConfig.getName();
    }

    private long createSpacePublicSite(Space space, String name, String label, String[] accessPermissions) {
        String siteName = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{name, space.getPrettyName()});
        this.portalConfigService.createUserPortalConfig(PortalConfig.PORTAL_TYPE, siteName, DEFAULT_PUBLIC_SITE_TEMPLATE, DEFAULT_SITE_TEMPLATE_PATH);
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteName);
        String editPermission = "manager:" + space.getGroupId();
        if (accessPermissions != null) {
            portalConfig.setAccessPermissions(accessPermissions);
            portalConfig.setEditPermission(editPermission);
        }
        portalConfig.setLabel((String)StringUtils.firstNonBlank((CharSequence[])new String[]{label, space.getDisplayName()}));
        portalConfig.setDefaultSite(false);
        portalConfig.setProperty("SPACE_ID", space.getId());
        portalConfig.setProperty("IS_SPACE_PUBLIC_SITE", "true");
        this.layoutService.save(portalConfig);
        List pages = this.layoutService.findPages(SiteKey.portal((String)siteName));
        pages.forEach(page -> {
            page.setState(page.getState().builder().editPermission(editPermission).build());
            this.layoutService.save(page);
        });
        return Long.parseLong(portalConfig.getStorageId().split("_")[1]);
    }

    private void saveSpacePublicSite(Space space, String publicSiteVisibility, String authenticatedUser) {
        boolean visibilityChanged;
        boolean bl = visibilityChanged = StringUtils.isNotBlank((CharSequence)publicSiteVisibility) && !StringUtils.equals((CharSequence)space.getPublicSiteVisibility(), (CharSequence)publicSiteVisibility);
        if (space.getPublicSiteId() == 0L || this.layoutService.getPortalConfig(space.getPublicSiteId()) == null) {
            long siteId = this.createSpacePublicSite(space, space.getPrettyName(), space.getDisplayName(), this.getPublicSitePermissions(publicSiteVisibility, space.getGroupId()));
            space = this.spaceService.getSpaceById(space.getId());
            space.setPublicSiteId(siteId);
            space.setPublicSiteVisibility(publicSiteVisibility);
            space.setEditor(authenticatedUser == null ? space.getManagers()[0] : authenticatedUser);
            this.spaceService.updateSpace(space);
        } else {
            PortalConfig portalConfig = this.layoutService.getPortalConfig(space.getPublicSiteId());
            if (visibilityChanged) {
                String[] publicSitePermissions = this.getPublicSitePermissions(publicSiteVisibility, space.getGroupId());
                portalConfig.setAccessPermissions(publicSitePermissions);
                portalConfig.setDefaultSite(false);
                this.layoutService.save(portalConfig);
                space = this.spaceService.getSpaceById(space.getId());
                space.setPublicSiteVisibility(publicSiteVisibility);
                space.setEditor(authenticatedUser == null ? space.getManagers()[0] : authenticatedUser);
                this.spaceService.updateSpace(space);
            }
        }
    }

    private String[] getPublicSitePermissions(String publicSiteVisibility, String spaceGroupId) {
        if (StringUtils.isBlank((CharSequence)publicSiteVisibility)) {
            return null;
        }
        switch (publicSiteVisibility) {
            case "manager": {
                return new String[]{"manager:" + spaceGroupId};
            }
            case "member": {
                return new String[]{"member:" + spaceGroupId};
            }
            case "internal": {
                return new String[]{"member:/platform/users"};
            }
            case "authenticated": {
                return new String[]{"member:/platform/users", "member:/platform/externals"};
            }
            case "everyone": {
                return new String[]{"Everyone"};
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + publicSiteVisibility);
    }

    public String getFirstSpacePageUri(String groupId) {
        NodeContext rootNode = this.navigationService.loadNode(SiteKey.group((String)groupId));
        if (rootNode == null || rootNode.getNodeCount() == 0) {
            return "home";
        }
        return ((NodeContext)((NodeContext)rootNode.getFirst()).getNode()).getName();
    }
}

