/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.profileproperty;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.profileproperty.ProfileProperty;
import org.exoplatform.social.core.profileproperty.ProfilePropertyConfig;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;

public class ProfilePropertyDatabaseInitializer
extends BaseComponentPlugin
implements ComponentPlugin {
    private static final Log LOG = ExoLogger.getLogger(ProfilePropertyDatabaseInitializer.class);
    private final ProfilePropertyConfig config;
    protected static final int CHECK_EMPTY = 0;
    protected static final int CHECK_ENTRY = 1;
    private int checkDatabaseAlgorithm = 0;
    private boolean updateProperties;

    public ProfilePropertyDatabaseInitializer(InitParams params) {
        String checkConfig = params.getValueParam("checkDatabaseAlgorithm").getValue();
        this.checkDatabaseAlgorithm = checkConfig.trim().equalsIgnoreCase("entry") ? 1 : 0;
        ValueParam usParam = params.getValueParam("updateProperties");
        if (usParam != null) {
            String updateUsersParam = usParam.getValue();
            this.updateProperties = updateUsersParam != null && updateUsersParam.trim().equalsIgnoreCase("true");
        }
        this.config = (ProfilePropertyConfig)params.getObjectParamValues(ProfilePropertyConfig.class).get(0);
    }

    public void init(ProfilePropertyService service) {
        if (this.checkDatabaseAlgorithm == 0 && this.checkExistDatabase(service)) {
            return;
        }
        if (this.checkDatabaseAlgorithm == 1) {
            LOG.info((Object)"Start initialization of the Profile settings service data");
            this.createProperties(service);
            LOG.info((Object)"Profile settings service data initialized");
        }
    }

    protected boolean checkExistDatabase(ProfilePropertyService service) {
        List properties = service.getPropertySettings();
        return properties != null && !properties.isEmpty();
    }

    protected void createProperties(ProfilePropertyService profilePropertyService) {
        List<ProfileProperty> properties = this.config.getProfileProperties();
        for (ProfileProperty data : properties) {
            try {
                ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
                profilePropertySetting.setPropertyName(data.getPropertyName());
                profilePropertySetting.setMultiValued(data.isMultiValued());
                profilePropertySetting.setActive(true);
                profilePropertySetting.setEditable(data.isEditable());
                profilePropertySetting.setOrder(Long.valueOf(data.getOrder()));
                profilePropertySetting.setDropdownList(data.isDropdownList());
                profilePropertySetting.setVisible(data.isVisible());
                profilePropertySetting.setGroupSynchronized(data.isGroupSynchronized());
                profilePropertySetting.setRequired(data.isRequired());
                profilePropertySetting.setHiddenbale(data.isHiddenable());
                profilePropertySetting.setPropertyType(data.getPropertyType());
                if (StringUtils.isNotEmpty((CharSequence)data.getParentName())) {
                    ProfilePropertySetting parent = profilePropertyService.getProfileSettingByName(data.getParentName());
                    if (parent != null) {
                        profilePropertySetting.setParentId(parent.getId());
                    } else {
                        LOG.warn("There is nor property with parent name: {} defined for the property: {}, the parent will net be defined for this property", new Object[]{data.getParentName(), data.getPropertyName()});
                    }
                }
                profilePropertyService.createPropertySetting(profilePropertySetting);
                LOG.info("New profile property setting {} created", new Object[]{data.getPropertyName()});
            }
            catch (ObjectAlreadyExistsException e) {
                LOG.info((Object)("    Profile property " + data.getPropertyName() + " already exists, ignoring the entry"));
            }
        }
    }

    protected ProfilePropertyConfig getConfig() {
        return this.config;
    }

    protected int getCheckDatabaseAlgorithm() {
        return this.checkDatabaseAlgorithm;
    }

    public boolean isUpdateProperties() {
        return this.updateProperties;
    }
}

