/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.entity;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

@Entity(name="SocMetadataEntity")
@Table(name="SOC_METADATAS")
@NamedQueries(value={@NamedQuery(name="SocMetadataEntity.findMetadata", query="SELECT sm FROM SocMetadataEntity sm WHERE sm.type = :type AND sm.name = :name AND sm.audienceId = :audienceId"), @NamedQuery(name="SocMetadataEntity.getMetadataNamesByAudiences", query="SELECT sm.name FROM SocMetadataEntity sm WHERE sm.type = :type AND sm.audienceId IN ( :audienceIds ) ORDER BY sm.name ASC"), @NamedQuery(name="SocMetadataEntity.getMetadataNamesByCreator", query="SELECT sm.name FROM SocMetadataEntity sm WHERE sm.type = :type AND sm.creatorId = :creatorId ORDER BY sm.name ASC"), @NamedQuery(name="SocMetadataEntity.getMetadataNamesByUser", query="SELECT sm.name FROM SocMetadataEntity sm WHERE sm.type = :type AND sm.creatorId = :creatorId or sm.audienceId IN ( :audienceIds ) ORDER BY sm.createdDate DESC, sm.name DESC"), @NamedQuery(name="SocMetadataEntity.findMetadataNameByAudiencesAndQuery", query="SELECT sm.name FROM SocMetadataEntity sm WHERE sm.type = :type AND sm.audienceId IN ( :audienceIds ) AND LOWER(sm.name) LIKE :term ORDER BY sm.name ASC"), @NamedQuery(name="SocMetadataEntity.findMetadataNameByCreatorAndQuery", query="SELECT sm.name FROM SocMetadataEntity sm WHERE sm.type = :type AND sm.creatorId = :creatorId AND LOWER(sm.name) LIKE :term ORDER BY sm.name ASC"), @NamedQuery(name="SocMetadataEntity.findMetadataNameByUserAndQuery", query="SELECT sm.name FROM SocMetadataEntity sm WHERE sm.type = :type AND (sm.creatorId = :creatorId OR sm.audienceId IN ( :audienceIds )) AND LOWER(sm.name) LIKE :term ORDER BY sm.createdDate DESC, sm.name DESC"), @NamedQuery(name="SocMetadataEntity.getMetadatas", query="SELECT sm FROM SocMetadataEntity sm WHERE sm.type = :type ORDER BY sm.name ASC"), @NamedQuery(name="SocMetadataEntity.getMetadatasByPropertyOrderByName", query="  SELECT sm.id FROM SocMetadataEntity sm\n  INNER JOIN sm.properties prop\n  ON key(prop) = :propertyName\n  AND value(prop) = :propertyValue\n  ORDER BY sm.name ASC\n"), @NamedQuery(name="SocMetadataEntity.getMetadatasByPropertyOrderById", query="  SELECT sm.id FROM SocMetadataEntity sm\n  INNER JOIN sm.properties prop\n  ON key(prop) = :propertyName\n  AND value(prop) = :propertyValue\n  ORDER BY sm.id DESC\n"), @NamedQuery(name="SocMetadataEntity.countMetadataIdsByProperty", query="  SELECT COUNT(sm.id) FROM SocMetadataEntity sm\n  INNER JOIN sm.properties prop\n  ON key(prop) = :propertyName\n  AND value(prop) = :propertyValue\n")})
public class MetadataEntity
implements Serializable {
    private static final long serialVersionUID = -743950558885709009L;
    @Id
    @SequenceGenerator(name="SEQ_SOC_METADATA_ID", sequenceName="SEQ_SOC_METADATA_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SOC_METADATA_ID")
    @Column(name="METADATA_ID")
    private Long id;
    @Column(name="TYPE", nullable=false)
    private Long type;
    @Column(name="NAME")
    private String name;
    @Column(name="CREATOR_ID", nullable=false)
    private long creatorId;
    @Column(name="AUDIENCE_ID")
    private long audienceId;
    @Column(name="CREATED_DATE", nullable=false)
    private Date createdDate;
    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="NAME")
    @Column(name="VALUE")
    @CollectionTable(name="SOC_METADATA_PROPERTIES", joinColumns={@JoinColumn(name="METADATA_ID")})
    private Map<String, String> properties;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getType() {
        return this.type;
    }

    public void setType(Long type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(long creatorId) {
        this.creatorId = creatorId;
    }

    public long getAudienceId() {
        return this.audienceId;
    }

    public void setAudienceId(long audienceId) {
        this.audienceId = audienceId;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }
}

