/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import io.meeds.portal.navigation.constant.SidebarItemType;
import io.meeds.portal.navigation.model.SidebarItem;
import io.meeds.social.category.AbstractCategoryConfigurationTest;
import io.meeds.social.category.model.Category;
import io.meeds.social.category.model.CategoryFilter;
import io.meeds.social.category.model.CategoryTree;
import io.meeds.social.navigation.plugin.SpaceCategorySidebarPlugin;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.social.core.space.model.Space;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class SpaceCategorySidebarPluginTest
extends AbstractCategoryConfigurationTest {
    @Autowired
    protected SpaceCategorySidebarPlugin spaceCategorySidebarPlugin;

    @Test
    public void testGetType() {
        SpaceCategorySidebarPluginTest.assertEquals((Object)SidebarItemType.SPACE_CATEGORY, (Object)this.spaceCategorySidebarPlugin.getType());
    }

    @Test
    public void testGetDefaultItems() {
        List defaultItems = this.spaceCategorySidebarPlugin.getDefaultItems();
        SpaceCategorySidebarPluginTest.assertNotNull((Object)defaultItems);
        SpaceCategorySidebarPluginTest.assertTrue((boolean)defaultItems.isEmpty());
    }

    @Test
    public void testItemExists() {
        SpaceCategorySidebarPluginTest.assertFalse((boolean)this.spaceCategorySidebarPlugin.itemExists(null, null));
        SpaceCategorySidebarPluginTest.assertFalse((boolean)this.spaceCategorySidebarPlugin.itemExists(new SidebarItem(), null));
        SpaceCategorySidebarPluginTest.assertFalse((boolean)this.spaceCategorySidebarPlugin.itemExists(new SidebarItem(), "root"));
        SidebarItem item = new SidebarItem(SidebarItemType.SPACE_CATEGORY);
        item.setProperties(Collections.singletonMap("spaceCategoryId", "12"));
        SpaceCategorySidebarPluginTest.assertFalse((boolean)this.spaceCategorySidebarPlugin.itemExists(item, "root"));
        this.buildCategoryTree();
        CategoryFilter filter = new CategoryFilter(null, 0L, 0L, 5L, 0L, 2L, false, false);
        CategoryTree categoryTree = this.categoryService.getCategoryTree(filter, "john", Locale.ENGLISH);
        CategoryTree subCategory1 = (CategoryTree)categoryTree.getCategories().get(0);
        item.setProperties(Collections.singletonMap("spaceCategoryId", String.valueOf(subCategory1.getId())));
        SpaceCategorySidebarPluginTest.assertTrue((boolean)this.spaceCategorySidebarPlugin.itemExists(item, "root"));
        SpaceCategorySidebarPluginTest.assertTrue((boolean)this.spaceCategorySidebarPlugin.itemExists(item, "mary"));
        subCategory1.setAccessPermissionIds(Collections.singletonList(this.getAdminGroupIdentityId()));
        this.categoryService.updateCategory((Category)subCategory1, "john");
        SpaceCategorySidebarPluginTest.assertTrue((boolean)this.spaceCategorySidebarPlugin.itemExists(item, "root"));
        SpaceCategorySidebarPluginTest.assertFalse((boolean)this.spaceCategorySidebarPlugin.itemExists(item, "mary"));
    }

    @Test
    public void testResolveProperties() {
        this.buildCategoryTree();
        CategoryFilter filter = new CategoryFilter(null, 0L, 0L, 5L, 0L, 2L, false, false);
        CategoryTree categoryTree = this.categoryService.getCategoryTree(filter, "john", Locale.ENGLISH);
        CategoryTree subCategory1 = (CategoryTree)categoryTree.getCategories().get(0);
        CategoryTree subCategory2 = (CategoryTree)categoryTree.getCategories().get(1);
        SidebarItem item = new SidebarItem(SidebarItemType.SPACE_CATEGORY);
        item.setProperties(Collections.singletonMap("spaceCategoryId", String.valueOf(subCategory1.getId())));
        this.spaceCategorySidebarPlugin.resolveProperties(item, "root", Locale.ENGLISH);
        SpaceCategorySidebarPluginTest.assertNotNull((Object)item.getName());
        SpaceCategorySidebarPluginTest.assertEquals((String)subCategory1.getName(), (String)item.getName());
        SpaceCategorySidebarPluginTest.assertNotNull((Object)item.getIcon());
        SpaceCategorySidebarPluginTest.assertEquals((String)subCategory1.getIcon(), (String)item.getIcon());
        SpaceCategorySidebarPluginTest.assertNull((Object)item.getUrl());
        SpaceCategorySidebarPluginTest.assertNull((Object)item.getTarget());
        SpaceCategorySidebarPluginTest.assertNull((Object)item.getAvatar());
        SpaceCategorySidebarPluginTest.assertNotNull((Object)item.getItems());
        SpaceCategorySidebarPluginTest.assertEquals((int)0, (int)item.getItems().size());
        for (int i = 0; i < 5; ++i) {
            Space space = new Space();
            space.setRegistration("open");
            space.setVisibility("public");
            space = this.spaceService.createSpace(space, "root");
            space.setCategoryIds(Collections.singletonList(subCategory1.getId()));
            this.spaceService.updateSpace(space);
        }
        item = new SidebarItem(SidebarItemType.SPACE_CATEGORY);
        item.setProperties(Collections.singletonMap("spaceCategoryId", String.valueOf(categoryTree.getId())));
        this.spaceCategorySidebarPlugin.resolveProperties(item, "root", Locale.ENGLISH);
        SpaceCategorySidebarPluginTest.assertNotNull((Object)item.getItems());
        SpaceCategorySidebarPluginTest.assertEquals((int)4, (int)item.getItems().size());
        item.setProperties(Collections.singletonMap("spaceCategoryId", String.valueOf(subCategory1.getId())));
        this.spaceCategorySidebarPlugin.resolveProperties(item, "root", Locale.ENGLISH);
        SpaceCategorySidebarPluginTest.assertNotNull((Object)item.getItems());
        SpaceCategorySidebarPluginTest.assertEquals((int)4, (int)item.getItems().size());
        item = new SidebarItem(SidebarItemType.SPACE_CATEGORY);
        item.setProperties(Collections.singletonMap("spaceCategoryId", String.valueOf(subCategory1.getId())));
        this.spaceCategorySidebarPlugin.resolveProperties(item, "mary", Locale.ENGLISH);
        SpaceCategorySidebarPluginTest.assertNotNull((Object)item.getItems());
        SpaceCategorySidebarPluginTest.assertEquals((int)0, (int)item.getItems().size());
        item = new SidebarItem(SidebarItemType.SPACE_CATEGORY);
        item.setProperties(Collections.singletonMap("spaceCategoryId", String.valueOf(subCategory2.getId())));
        this.spaceCategorySidebarPlugin.resolveProperties(item, "root", Locale.ENGLISH);
        SpaceCategorySidebarPluginTest.assertNotNull((Object)item.getItems());
        SpaceCategorySidebarPluginTest.assertEquals((int)0, (int)item.getItems().size());
    }
}

