/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.activity.plugin;

import io.meeds.portal.plugin.AclPlugin;
import jakarta.annotation.PostConstruct;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityAclPlugin
implements AclPlugin {
    private static final String OBJECT_TYPE = "activity";
    @Autowired
    private PortalContainer container;
    @Autowired
    private ActivityManager activityManager;

    @PostConstruct
    public void init() {
        ((UserACL)this.container.getComponentInstanceOfType(UserACL.class)).addAclPlugin((AclPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasPermission(String objectId, String permissionType, Identity identity) {
        ExoSocialActivity activity = this.activityManager.getActivity(objectId);
        if (activity == null) {
            return false;
        }
        return switch (permissionType) {
            case "VIEW" -> this.activityManager.isActivityViewable(activity, identity);
            case "EDIT" -> this.activityManager.isActivityEditable(activity, identity);
            case "DELETE" -> this.activityManager.isActivityDeletable(activity, identity);
            default -> false;
        };
    }
}

