/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.cache.SocialStorageCacheService;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class SpaceUtilsRestTest
extends AbstractCoreTest {
    private final Log LOG = ExoLogger.getLogger(SpaceUtilsRestTest.class);
    private IdentityStorage identityStorage;
    private UserPortalConfigService userPortalConfigSer_;
    private Authenticator authenticator = null;
    private List<Identity> tearDownUserList = null;
    private Identity root = null;
    private SocialStorageCacheService cacheService;

    @Override
    public void setUp() throws Exception {
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
        this.cacheService = (SocialStorageCacheService)this.getContainer().getComponentInstanceOfType(SocialStorageCacheService.class);
        this.cacheService.getIdentityCache().clearCache();
        this.cacheService.getIdentityIndexCache().clearCache();
        this.root = new Identity("organization", "root");
        this.identityStorage.saveIdentity(this.root);
        this.tearDownUserList = new ArrayList<Identity>();
        this.tearDownUserList.add(this.root);
    }

    @Override
    public void tearDown() throws Exception {
        for (Identity identity : this.tearDownUserList) {
            this.identityStorage.deleteIdentity(identity);
        }
    }

    private abstract class UnitTest {
        private UnitTest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void execute(String userId) {
            Exception failure = null;
            SpaceUtilsRestTest.this.begin();
            ConversationState conversationState = null;
            if (userId != null) {
                try {
                    conversationState = new ConversationState(SpaceUtilsRestTest.this.authenticator.createIdentity(userId));
                }
                catch (Exception e) {
                    failure = e;
                }
            }
            if (failure == null) {
                ConversationState.setCurrent(conversationState);
                try {
                    this.execute();
                }
                catch (Exception e) {
                    failure = e;
                }
                finally {
                    ConversationState.setCurrent(null);
                    SpaceUtilsRestTest.this.end();
                }
            }
            if (failure != null) {
                AssertionFailedError err = new AssertionFailedError();
                err.initCause((Throwable)failure);
                throw err;
            }
        }

        protected abstract void execute() throws Exception;
    }
}

