/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.html.utils;

import io.meeds.social.html.model.HtmlProcessorContext;
import io.meeds.social.html.model.HtmlTransformerContext;
import io.meeds.social.html.service.HtmlProcessorService;
import io.meeds.social.html.service.HtmlTransformerService;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.localization.LocalizationFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

public class HtmlUtils {
    private static final Log LOG = ExoLogger.getLogger(HtmlUtils.class);
    private static HtmlProcessorService htmlProcessorService;
    private static HtmlTransformerService htmlTransformerService;

    private HtmlUtils() {
    }

    public static String process(String html, HtmlProcessorContext context) {
        HtmlProcessorService service = HtmlUtils.getHtmlProcessorService();
        if (service == null) {
            return html;
        }
        try {
            if (context == null) {
                context = new HtmlProcessorContext();
            }
            if (context.getUserIdentity() == null && ConversationState.getCurrent() != null) {
                context.setUserIdentity(ConversationState.getCurrent().getIdentity());
            }
            return service.process(html, context);
        }
        catch (Exception e) {
            LOG.warn("Error while processing html content: {}. The error is considered as non-blocker, thus continue processing", new Object[]{html, e});
            return html;
        }
    }

    public static String transform(String html, HtmlTransformerContext context) {
        if (StringUtils.isBlank((CharSequence)html)) {
            return html;
        }
        HtmlTransformerService service = HtmlUtils.getHtmlTransformerService();
        if (service == null) {
            return html;
        }
        try {
            if (context == null) {
                context = new HtmlTransformerContext();
            }
            HtmlUtils.setUserIdentity(context);
            HtmlUtils.setUserLocale(context);
            return service.transform(html, context);
        }
        catch (Exception e) {
            LOG.warn("Error while transforming html content: {}. The error is considered as non-blocker, thus continue transformation", new Object[]{html, e});
            return html;
        }
    }

    private static void setUserIdentity(HtmlTransformerContext context) {
        if (context.getUserIdentity() == null) {
            if (ConversationState.getCurrent() == null) {
                context.setSystem(true);
            } else if (!context.isSystem()) {
                context.setUserIdentity(ConversationState.getCurrent().getIdentity());
            }
        }
    }

    private static void setUserLocale(HtmlTransformerContext context) {
        if (context.getLocale() == null) {
            context.setLocale(LocalizationFilter.getCurrentLocale());
        }
    }

    private static HtmlProcessorService getHtmlProcessorService() {
        if (htmlProcessorService == null && PortalContainer.getInstanceIfPresent() != null) {
            htmlProcessorService = (HtmlProcessorService)PortalContainer.getInstance().getComponentInstanceOfType(HtmlProcessorService.class);
        }
        return htmlProcessorService;
    }

    private static HtmlTransformerService getHtmlTransformerService() {
        if (htmlTransformerService == null && PortalContainer.getInstanceIfPresent() != null) {
            htmlTransformerService = (HtmlTransformerService)PortalContainer.getInstance().getComponentInstanceOfType(HtmlTransformerService.class);
        }
        return htmlTransformerService;
    }
}

