/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.translation.service;

import io.meeds.social.html.model.HtmlProcessorContext;
import io.meeds.social.html.model.HtmlTransformerContext;
import io.meeds.social.html.utils.HtmlUtils;
import io.meeds.social.translation.model.TranslationEvent;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.plugin.TranslationPlugin;
import io.meeds.social.translation.service.TranslationService;
import io.meeds.social.translation.storage.TranslationStorage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.social.core.utils.MentionUtils;

public class TranslationServiceImpl
implements TranslationService {
    private static final Log LOG = ExoLogger.getLogger(TranslationServiceImpl.class);
    private static final String NO_PERMISSION_TO_ACCESS_MESSAGE = "User %s doesn't have enough permissions to access translations of object of type %s identified by %s";
    private static final String NO_PERMISSION_TO_EDIT_MESSAGE = "User %s doesn't have enough permissions to write translations of object of type %s identified by %s";
    private static final String NO_PERMISSION_TO_DELETE_MESSAGE = "User %s doesn't have enough permissions to delete translations of object of type %s identified by %s";
    private String portalOwner;
    private LocaleConfigService localeConfigService;
    private ListenerService listenerService;
    private TranslationStorage translationStorage;
    private Map<String, TranslationPlugin> translationPlugins = new HashMap<String, TranslationPlugin>();

    public TranslationServiceImpl(TranslationStorage translationStorage, LocaleConfigService localeConfigService, ListenerService listenerService) {
        this.localeConfigService = localeConfigService;
        this.translationStorage = translationStorage;
        this.listenerService = listenerService;
    }

    public void addPlugin(TranslationPlugin translationPlugin) {
        this.translationPlugins.put(translationPlugin.getObjectType(), translationPlugin);
    }

    public void removePlugin(String objectType) {
        this.translationPlugins.remove(objectType);
    }

    public TranslationField getTranslationField(String objectType, String objectId, String fieldName, String username) throws IllegalAccessException, ObjectNotFoundException {
        this.checkParameters(objectType, objectId, fieldName);
        this.checkAccessPermission(objectType, objectId, username);
        return this.getTranslationField(objectType, objectId, fieldName);
    }

    public TranslationField getTranslationField(String objectType, String objectId, String fieldName) {
        TranslationField translationField = this.translationStorage.getTranslationField(objectType, objectId, fieldName);
        if (translationField != null && translationField.getLabels() != null) {
            Map<Locale, String> labels = translationField.getLabels();
            labels = labels.entrySet().stream().map(entry -> Pair.of((Object)((Locale)entry.getKey()), (Object)HtmlUtils.transform((String)entry.getValue(), new HtmlTransformerContext((Locale)entry.getKey())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            translationField.setLabels(labels);
        }
        return translationField;
    }

    public String getTranslationLabel(String objectType, String objectId, String fieldName, Locale locale) {
        String translationLabel = this.translationStorage.getTranslationLabel(objectType, objectId, fieldName, locale);
        if (StringUtils.isNotBlank((CharSequence)translationLabel)) {
            translationLabel = HtmlUtils.transform(translationLabel, new HtmlTransformerContext(locale));
        }
        return translationLabel;
    }

    public String getTranslationLabelOrDefault(String objectType, String objectId, String fieldName, Locale locale) {
        TranslationField translationField;
        if (locale == null) {
            locale = this.localeConfigService.getDefaultLocaleConfig().getLocale();
        }
        if ((translationField = this.getTranslationField(objectType, objectId, fieldName)) != null && MapUtils.isNotEmpty((Map)translationField.getLabels())) {
            String label = (String)translationField.getLabels().get(locale);
            if (label == null) {
                Locale defaultLocale = this.localeConfigService.getDefaultLocaleConfig().getLocale();
                label = (String)translationField.getLabels().get(defaultLocale);
            }
            if (label == null) {
                label = (String)translationField.getLabels().values().iterator().next();
            }
            return label;
        }
        return null;
    }

    public void saveTranslationLabels(String objectType, String objectId, String fieldName, Map<Locale, String> labels, String username) throws IllegalAccessException, ObjectNotFoundException {
        this.checkParameters(objectType, objectId, fieldName);
        this.checkEditPermission(objectType, objectId, username, NO_PERMISSION_TO_EDIT_MESSAGE);
        this.saveTranslationLabelsNoBroadcast(objectType, objectId, fieldName, labels);
        this.broadcastEvent("translation.saved", objectType, objectId, fieldName, null, username);
    }

    public void saveTranslationLabels(String objectType, String objectId, String fieldName, Map<Locale, String> labels) throws ObjectNotFoundException {
        this.checkParameters(objectType, objectId, fieldName);
        this.saveTranslationLabelsNoBroadcast(objectType, objectId, fieldName, labels);
        this.broadcastEvent("translation.saved", objectType, objectId, fieldName, null, null);
    }

    public void saveTranslationLabel(String objectType, String objectId, String fieldName, Locale locale, String label) throws ObjectNotFoundException {
        this.checkParameters(objectType, objectId, fieldName, locale);
        TranslationPlugin translationPlugin = this.translationPlugins.get(objectType);
        long audienceId = translationPlugin.getAudienceId(objectId);
        long spaceId = translationPlugin.getSpaceId(objectId);
        label = this.processLabelLocale(objectType, objectId, fieldName, locale, label);
        this.translationStorage.saveTranslationLabel(objectType, objectId, fieldName, locale, label, audienceId, spaceId);
        this.broadcastEvent("translation.saved", objectType, objectId, fieldName, locale, null);
    }

    public void deleteTranslationLabels(String objectType, String objectId, String username) throws IllegalAccessException, ObjectNotFoundException {
        this.checkParameters(objectType, objectId);
        this.checkEditPermission(objectType, objectId, username, NO_PERMISSION_TO_DELETE_MESSAGE);
        this.deleteTranslationLabelsNoBroadcast(objectType, objectId);
        this.broadcastEvent("translation.deleted", objectType, objectId, null, null, username);
    }

    public void deleteTranslationLabels(String objectType, String objectId) throws ObjectNotFoundException {
        this.checkParameters(objectType, objectId);
        this.deleteTranslationLabelsNoBroadcast(objectType, objectId);
        this.broadcastEvent("translation.deleted", objectType, objectId, null, null, null);
    }

    public void deleteTranslationLabel(String objectType, String objectId, String fieldName, Locale locale) throws ObjectNotFoundException {
        this.checkParameters(objectType, objectId, fieldName, locale);
        this.translationStorage.deleteTranslationLabel(objectType, objectId, fieldName, locale);
        this.processLabelLocale(objectType, objectId, fieldName, locale, "");
        this.broadcastEvent("translation.deleted", objectType, objectId, fieldName, locale, null);
    }

    private void saveTranslationLabelsNoBroadcast(String objectType, String objectId, String fieldName, Map<Locale, String> labels) throws ObjectNotFoundException {
        if (MapUtils.isEmpty(labels)) {
            throw new IllegalArgumentException("labels is empty");
        }
        TranslationPlugin translationPlugin = this.translationPlugins.get(objectType);
        long audienceId = translationPlugin.getAudienceId(objectId);
        long spaceId = translationPlugin.getSpaceId(objectId);
        labels = labels.entrySet().stream().map(entry -> Pair.of((Object)((Locale)entry.getKey()), (Object)this.processLabelLocale(objectType, objectId, fieldName, (Locale)entry.getKey(), (String)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Set<Locale> labelLocales = labels.keySet();
        this.translationStorage.saveTranslationLabels(objectType, objectId, fieldName, labels, audienceId, spaceId);
        this.processLabelLocalesDeletion(objectType, objectId, fieldName, labelLocales);
    }

    private void deleteTranslationLabelsNoBroadcast(String objectType, String objectId) {
        this.translationStorage.deleteTranslationLabels(objectType, objectId);
        this.processLabelLocalesDeletion(objectType, objectId, null, Collections.emptySet());
    }

    private void processLabelLocalesDeletion(String objectType, String objectId, String fieldName, Set<Locale> labelLocales) {
        TranslationField translationField = this.getTranslationField(objectType, objectId, fieldName);
        if (translationField != null && MapUtils.isNotEmpty((Map)translationField.getLabels())) {
            translationField.getLabels().keySet().stream().filter(locale -> !labelLocales.contains(locale)).forEach(locale -> this.processLabelLocale(objectType, objectId, fieldName, (Locale)locale, ""));
        }
    }

    private String processLabelLocale(String objectType, String objectId, String fieldName, Locale locale, String label) {
        return HtmlUtils.process(this.processMentions(label), new HtmlProcessorContext(objectType, String.valueOf(objectId), fieldName, locale));
    }

    private void broadcastEvent(String eventName, String objectType, String objectId, String fieldName, Locale locale, String username) {
        try {
            this.listenerService.broadcast(eventName, (Object)new TranslationEvent(objectType, objectId, fieldName, locale), (Object)username);
        }
        catch (Exception e) {
            LOG.warn("An error occurred while broadcasting event {} for object type {} identified by {}", new Object[]{objectType, objectId, e});
        }
    }

    private void checkAccessPermission(String objectType, String objectId, String username) throws ObjectNotFoundException, IllegalAccessException {
        TranslationPlugin translationPlugin = this.translationPlugins.get(objectType);
        if (!translationPlugin.hasAccessPermission(objectId, username)) {
            throw new IllegalAccessException(String.format(NO_PERMISSION_TO_ACCESS_MESSAGE, username, objectType, objectId));
        }
    }

    private void checkEditPermission(String objectType, String objectId, String username, String message) throws ObjectNotFoundException, IllegalAccessException {
        TranslationPlugin translationPlugin = this.translationPlugins.get(objectType);
        if (!translationPlugin.hasEditPermission(objectId, username)) {
            throw new IllegalAccessException(String.format(message, username, objectType, objectId));
        }
    }

    private void checkParameters(String objectType, String objectId, String fieldName, Locale locale) {
        this.checkParameters(objectType, objectId, fieldName);
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new IllegalArgumentException("Field name is mandatory");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale is mandatory");
        }
    }

    private void checkParameters(String objectType, String objectId, String fieldName) {
        this.checkParameters(objectType, objectId);
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new IllegalArgumentException("Field name is mandatory");
        }
    }

    private void checkParameters(String objectType, String objectId) {
        if (StringUtils.isBlank((CharSequence)objectType)) {
            throw new IllegalArgumentException("Object type is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)objectId)) {
            throw new IllegalArgumentException("Object identifier is mandatory");
        }
        this.checkObjectTypePlugin(objectType);
    }

    private void checkObjectTypePlugin(String objectType) {
        if (!this.translationPlugins.containsKey(objectType)) {
            throw new IllegalStateException("TranslationPlugin associated to " + objectType + " wasn't found");
        }
    }

    private String processMentions(String label) {
        String sanitizedBody = HTMLSanitizer.sanitize((String)label);
        sanitizedBody = sanitizedBody.replace("&#64;", "@");
        return MentionUtils.substituteUsernames(this.getPortalOwner(), sanitizedBody);
    }

    private String getPortalOwner() {
        if (this.portalOwner == null) {
            this.portalOwner = CommonsUtils.getCurrentPortalOwner();
        }
        return this.portalOwner;
    }
}

