/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.thumbnail;

import io.meeds.portal.thumbnail.model.FileContent;
import io.meeds.portal.thumbnail.plugin.ImageThumbnailPlugin;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.thumbnail.ImageResizeService;
import org.exoplatform.services.thumbnail.ImageThumbnailService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.exoplatform.social.metadata.thumbnail.model.ThumbnailObject;

public class ImageThumbnailServiceImpl
implements ImageThumbnailService {
    private static final Log LOG = ExoLogger.getExoLogger(ImageThumbnailService.class);
    private static final MetadataType THUMBNAIL_METADATA_TYPE = new MetadataType(5L, "thumbnail");
    private static final String SOCIAL_NAME_SPACE = "social";
    private static final String THUMBNAIL_OBJECT_TYPE = "file";
    private static final String THUMBNAIL_WIDTH_PROPERTY = "width";
    private static final String THUMBNAIL_HEIGHT_PROPERTY = "height";
    private final MetadataService metadataService;
    private final FileService fileService;
    private final ImageResizeService imageResizeService;
    private static final Map<String, ImageThumbnailPlugin> imageThumbnailPlugins = new HashMap<String, ImageThumbnailPlugin>();

    public ImageThumbnailServiceImpl(MetadataService metadataService, FileService fileService, ImageResizeService imageResizeService) {
        this.metadataService = metadataService;
        this.fileService = fileService;
        this.imageResizeService = imageResizeService;
    }

    public void addPlugin(ImageThumbnailPlugin imageThumbnailPlugin) {
        imageThumbnailPlugins.put(imageThumbnailPlugin.getFileType(), imageThumbnailPlugin);
    }

    public void removePlugin(String fileType) {
        imageThumbnailPlugins.remove(fileType);
    }

    public FileItem getOrCreateThumbnail(FileItem file, int width, int height) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("file argument is mandatory");
        }
        if (width == 0 && height == 0) {
            return file;
        }
        FileInfo fileInfo = file.getFileInfo();
        try {
            return this.getOrCreateThumbnail(null, file, width, height);
        }
        catch (FileStorageException e) {
            LOG.warn("Error while getting thumbnail for image with file Id {}, original Image will be returned", new Object[]{fileInfo.getId(), e});
            return file;
        }
    }

    public FileItem getOrCreateThumbnail(ImageResizeService resizeSupplier, FileItem file, int width, int height) throws Exception {
        FileInfo fileInfo;
        FileItem thumbnail;
        if (file == null) {
            throw new IllegalArgumentException("file argument is mandatory");
        }
        if (width == 0 && height == 0) {
            return file;
        }
        if (resizeSupplier == null) {
            resizeSupplier = this.imageResizeService;
        }
        if ((thumbnail = this.getThumbnail(Long.toString((fileInfo = file.getFileInfo()).getId()), width, height)) != null) {
            return thumbnail;
        }
        FileContent fileContent = new FileContent(Long.toString(fileInfo.getId()), fileInfo.getName(), fileInfo.getMimetype(), file.getAsStream());
        return this.createThumbnail(resizeSupplier, Long.toString(fileInfo.getId()), fileContent, file.getFileInfo().getUpdater(), width, height);
    }

    public FileItem getOrCreateThumbnail(String fileType, String id, String userName, int width, int height) throws Exception {
        Object thumnailId = fileType.equals(THUMBNAIL_OBJECT_TYPE) ? id : fileType + id;
        FileItem thumbnail = this.getThumbnail((String)thumnailId, width, height);
        if (thumbnail != null) {
            return thumbnail;
        }
        ImageThumbnailPlugin imageThumbnailPlugin = imageThumbnailPlugins.get(fileType);
        if (imageThumbnailPlugin != null) {
            FileContent fileContent = imageThumbnailPlugin.getImage(id, userName);
            if (fileContent != null) {
                return this.createThumbnail(this.imageResizeService, (String)thumnailId, fileContent, userName, width, height);
            }
            return null;
        }
        return null;
    }

    public FileItem getThumbnail(String id, int width, int height) throws Exception {
        ThumbnailObject thumbnailObject = new ThumbnailObject(THUMBNAIL_OBJECT_TYPE, id);
        List metadataItemList = this.metadataService.getMetadataItemsByMetadataTypeAndObject(THUMBNAIL_METADATA_TYPE.getName(), (MetadataObject)thumbnailObject);
        List<MetadataItem> items = metadataItemList.stream().filter(metadataItem -> metadataItem.getProperties() != null && ((String)metadataItem.getProperties().get(THUMBNAIL_WIDTH_PROPERTY)).equals(String.valueOf(width)) && ((String)metadataItem.getProperties().get(THUMBNAIL_HEIGHT_PROPERTY)).equals(String.valueOf(height))).toList();
        if (!items.isEmpty()) {
            long fileId = Long.parseLong(items.get(0).getParentObjectId());
            try {
                return this.fileService.getFile(fileId);
            }
            catch (FileStorageException e) {
                LOG.warn("Error while getting thumbnail for image with file Id {}, original Image will be returned", new Object[]{fileId, e.getMessage()});
                return null;
            }
        }
        return null;
    }

    public FileItem createThumbnail(String id, FileContent fileContent, String userName, int width, int height) throws Exception {
        return this.createThumbnail(this.imageResizeService, id, fileContent, userName, width, height);
    }

    private FileItem createThumbnail(ImageResizeService resizeSupplier, String id, FileContent fileContent, String userName, int width, int height) throws Exception {
        byte[] imageContent = resizeSupplier.scaleImage(IOUtils.toByteArray((InputStream)fileContent.getContent()), width, height, false, false);
        FileItem thumbnail = new FileItem(null, fileContent.getName(), fileContent.getMimeType(), SOCIAL_NAME_SPACE, (long)imageContent.length, new Date(), userName, false, (InputStream)new ByteArrayInputStream(imageContent));
        FileItem thumbnailFileItem = this.fileService.writeFile(thumbnail);
        FileInfo thumbnailFileInfo = thumbnailFileItem.getFileInfo();
        ThumbnailObject thumbnailMetadataObject = new ThumbnailObject(THUMBNAIL_OBJECT_TYPE, id, Long.toString(thumbnailFileInfo.getId()));
        MetadataKey metadataKey = new MetadataKey(THUMBNAIL_METADATA_TYPE.getName(), THUMBNAIL_METADATA_TYPE.getName(), 0L);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(THUMBNAIL_WIDTH_PROPERTY, String.valueOf(width));
        properties.put(THUMBNAIL_HEIGHT_PROPERTY, String.valueOf(height));
        this.metadataService.createMetadataItem((MetadataObject)thumbnailMetadataObject, metadataKey, properties);
        return thumbnailFileItem;
    }

    public void deleteThumbnails(Long fileId) {
        this.deleteThumbnails(THUMBNAIL_OBJECT_TYPE, Long.toString(fileId));
    }

    public void deleteThumbnails(String fileType, String fileId) {
        String thumnailId = fileType.equals(THUMBNAIL_OBJECT_TYPE) ? fileId : fileType + fileId;
        ThumbnailObject thumbnailObject = new ThumbnailObject(THUMBNAIL_OBJECT_TYPE, thumnailId);
        this.metadataService.deleteMetadataItemsByMetadataTypeAndObject(THUMBNAIL_METADATA_TYPE.getName(), (MetadataObject)thumbnailObject);
    }
}

