/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.storage.elasticsearch;

import io.meeds.social.category.model.Category;
import io.meeds.social.category.storage.CategoryStorage;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.social.core.search.DocumentWithMetadata;

public class CategoryIndexingConnector
extends ElasticIndexingServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(CategoryIndexingConnector.class);
    public static final String TYPE = "category";
    public static final String ES_MAPPING = "    {\n       \"properties\" : {\n        \"id\" : {\"type\" : \"keyword\"},\n        @name_mappings@,\n        \"ownerId\" : {\"type\" : \"keyword\"},\n        \"parentId\" : {\"type\" : \"keyword\"},\n        \"creatorId\" : {\"type\" : \"keyword\"},\n        \"icon\" : {\"type\" : \"keyword\"},\n        \"linkPermissions\" : {\"type\" : \"keyword\"},\n        \"lastUpdatedDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"}\n      }\n    }\n";
    public static final String NAME_MAPPING = "  \"@name@\" : {\n    \"type\" : \"text\",\n    \"analyzer\": \"ngram_analyzer\",\n    \"search_analyzer\": \"ngram_analyzer_search\",\n    \"index_options\": \"offsets\",\n    \"fields\": {\n      \"raw\": {\n        \"type\": \"keyword\"\n      }\n    }\n  }\n";
    private CategoryStorage categoryStorage;
    private TranslationService translationService;
    private LocaleConfigService localeConfigService;

    public CategoryIndexingConnector(TranslationService translationService, LocaleConfigService localeConfigService, InitParams initParams) {
        super(initParams);
        this.translationService = translationService;
        this.localeConfigService = localeConfigService;
    }

    public String getConnectorName() {
        return TYPE;
    }

    public Document create(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("id is mandatory");
        }
        Category category = this.getCategoryStorage().getCategory(Long.parseLong(id));
        if (category == null) {
            return null;
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("id", String.valueOf(category.getId()));
        fields.put("ownerId", String.valueOf(category.getOwnerId()));
        fields.put("parentId", String.valueOf(category.getParentId()));
        fields.put("creatorId", String.valueOf(category.getCreatorId()));
        fields.put("icon", String.valueOf(category.getIcon()));
        DocumentWithMetadata document = new DocumentWithMetadata();
        document.setId(id);
        document.setLastUpdatedDate(new Date());
        document.setFields(fields);
        document.addListField("linkPermissions", (Collection)category.getLinkPermissions());
        this.addTranslatedNames(category, document);
        LOG.info("Category document generated for id={}", new Object[]{id});
        return document;
    }

    public Document update(String id) {
        return this.create(id);
    }

    public List<String> getAllIds(int offset, int limit) {
        return this.getCategoryStorage().getAllCategoryIds(offset, limit).stream().map(String::valueOf).toList();
    }

    public String getMapping() {
        String nameMappings = this.localeConfigService.getLocalConfigs().stream().map(l -> NAME_MAPPING.replace("@name@", "name-" + this.toLanguageTag((LocaleConfig)l))).collect(Collectors.joining(",\n"));
        return ES_MAPPING.replace("@name_mappings@", nameMappings);
    }

    private CategoryStorage getCategoryStorage() {
        if (this.categoryStorage == null) {
            this.categoryStorage = (CategoryStorage)ExoContainerContext.getService(CategoryStorage.class);
        }
        return this.categoryStorage;
    }

    private void addTranslatedNames(Category category, DocumentWithMetadata document) {
        TranslationField translationField = this.translationService.getTranslationField(TYPE, category.getId(), "name");
        if (translationField != null && MapUtils.isNotEmpty((Map)translationField.getLabels())) {
            this.localeConfigService.getLocalConfigs().forEach(localeConfig -> document.addField("name-" + this.toLanguageTag((LocaleConfig)localeConfig), this.getTranslationLabelOrDefault(translationField, localeConfig.getLocale())));
        }
    }

    private String getTranslationLabelOrDefault(TranslationField translationField, Locale locale) {
        if (translationField != null && MapUtils.isNotEmpty((Map)translationField.getLabels())) {
            String label = (String)translationField.getLabels().get(locale);
            if (label == null) {
                Locale defaultLocale = this.localeConfigService.getDefaultLocaleConfig().getLocale();
                label = (String)translationField.getLabels().get(defaultLocale);
            }
            if (label == null) {
                label = (String)translationField.getLabels().values().iterator().next();
            }
            return label;
        }
        return null;
    }

    private String toLanguageTag(LocaleConfig localeConfig) {
        return localeConfig.getLocale().toLanguageTag();
    }
}

