/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.listener.Event;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.listeners.ProfilePropertySettingOptionTranslationListener;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertyOption;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ProfilePropertySettingOptionTranslationListenerTest {
    @Mock
    private ProfilePropertyService profilePropertyService;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private IndexingService indexingService;
    private ProfilePropertySettingOptionTranslationListener profilePropertySettingOptionListener;

    @Before
    public void setUp() throws Exception {
        this.profilePropertySettingOptionListener = new ProfilePropertySettingOptionTranslationListener(this.identityManager, this.profilePropertyService, this.indexingService);
    }

    @Test
    public void testOnEvent() throws Exception {
        final Identity identity1 = (Identity)Mockito.mock(Identity.class);
        final Identity identity2 = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity1.getId()).thenReturn((Object)"identity1");
        Mockito.when((Object)identity2.getId()).thenReturn((Object)"identity2");
        HashMap<Locale, String> labels = new HashMap<Locale, String>();
        labels.put(Locale.US, "option en");
        labels.put(Locale.FRANCE, "option fr");
        ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
        profilePropertySetting.setId(Long.valueOf(1L));
        profilePropertySetting.setPropertyName("test1");
        ProfilePropertyOption profilePropertyOption1 = new ProfilePropertyOption();
        profilePropertyOption1.setId(Long.valueOf(1L));
        profilePropertyOption1.setValue("value");
        profilePropertyOption1.setPropertySettingId(Long.valueOf(1L));
        Event event = new Event("property_options_updated", (Object)profilePropertyOption1, labels);
        ListAccess<Identity> identityListAccess = new ListAccess<Identity>(this){

            public Identity[] load(int index, int length) {
                ArrayList<Identity> identities = new ArrayList<Identity>();
                identities.add(identity1);
                identities.add(identity2);
                Identity[] result = new Identity[identities.size()];
                return identities.toArray(result);
            }

            public int getSize() {
                return 2;
            }
        };
        Mockito.when((Object)this.profilePropertyService.getProfileSettingById(Long.valueOf(Mockito.eq((long)1L)))).thenReturn((Object)profilePropertySetting);
        Mockito.when((Object)this.identityManager.getIdentitiesByProfileFilter(Mockito.anyString(), (ProfileFilter)Mockito.any(), Mockito.anyBoolean())).thenReturn((Object)identityListAccess);
        this.profilePropertySettingOptionListener.onEvent(event);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).reindex("profile", "identity1");
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).reindex("profile", "identity1");
    }
}

