/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao.jpa;

import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.social.core.jpa.storage.entity.MetadataEntity;

public class MetadataDAO
extends GenericDAOJPAImpl<MetadataEntity, Long> {
    private static final String AUDIENCE_IDS = "audienceIds";
    private static final String CREATOR_ID = "creatorId";
    private static final String METADATA_TYPE = "type";
    private static final String METADATA_NAME_PART = "term";

    public List<String> getMetadataNamesByAudiences(long metadataTypeId, Set<Long> audienceIds, long limit) {
        List result;
        if (CollectionUtils.isEmpty(audienceIds)) {
            return Collections.emptyList();
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.getMetadataNamesByAudiences", String.class);
        query.setParameter(METADATA_TYPE, (Object)metadataTypeId);
        query.setParameter(AUDIENCE_IDS, audienceIds);
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (CollectionUtils.isEmpty((Collection)(result = query.getResultList()))) {
            return Collections.emptyList();
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    public List<String> getMetadataNamesByCreator(long metadataTypeId, long creatorIdentityId, long limit) {
        List result;
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.getMetadataNamesByCreator", String.class);
        query.setParameter(METADATA_TYPE, (Object)metadataTypeId);
        query.setParameter(CREATOR_ID, (Object)creatorIdentityId);
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (CollectionUtils.isEmpty((Collection)(result = query.getResultList()))) {
            return Collections.emptyList();
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    public List<String> getMetadataNamesByUser(long metadataTypeId, long creatorIdentityId, Set<Long> audienceIds, long limit) {
        List result;
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.getMetadataNamesByUser", String.class);
        query.setParameter(METADATA_TYPE, (Object)metadataTypeId);
        query.setParameter(AUDIENCE_IDS, audienceIds);
        query.setParameter(CREATOR_ID, (Object)creatorIdentityId);
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (CollectionUtils.isEmpty((Collection)(result = query.getResultList()))) {
            return Collections.emptyList();
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    public List<String> findMetadataNameByAudiencesAndQuery(String term, long metadataTypeId, Set<Long> audienceIds, long limit) {
        List result;
        if (CollectionUtils.isEmpty(audienceIds)) {
            return Collections.emptyList();
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.findMetadataNameByAudiencesAndQuery", String.class);
        query.setParameter(METADATA_TYPE, (Object)metadataTypeId);
        query.setParameter(AUDIENCE_IDS, audienceIds);
        query.setParameter(METADATA_NAME_PART, (Object)("%" + StringUtils.lowerCase((String)term) + "%"));
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (CollectionUtils.isEmpty((Collection)(result = query.getResultList()))) {
            return Collections.emptyList();
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    public List<String> findMetadataNameByCreatorAndQuery(String term, long metadataTypeId, long creatorIdentityId, long limit) {
        List result;
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.findMetadataNameByCreatorAndQuery", String.class);
        query.setParameter(METADATA_TYPE, (Object)metadataTypeId);
        query.setParameter(CREATOR_ID, (Object)creatorIdentityId);
        query.setParameter(METADATA_NAME_PART, (Object)("%" + StringUtils.lowerCase((String)term) + "%"));
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (CollectionUtils.isEmpty((Collection)(result = query.getResultList()))) {
            return Collections.emptyList();
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    public List<String> findMetadataNamesByUserAndQuery(String term, long metadataTypeId, long creatorIdentityId, Set<Long> audienceIds, long limit) {
        List result;
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.findMetadataNameByUserAndQuery", String.class);
        query.setParameter(METADATA_TYPE, (Object)metadataTypeId);
        query.setParameter(AUDIENCE_IDS, audienceIds);
        query.setParameter(CREATOR_ID, (Object)creatorIdentityId);
        query.setParameter(METADATA_NAME_PART, (Object)("%" + StringUtils.lowerCase((String)term) + "%"));
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (CollectionUtils.isEmpty((Collection)(result = query.getResultList()))) {
            return Collections.emptyList();
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    public MetadataEntity findMetadata(long type, String name, long audienceId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.findMetadata", MetadataEntity.class);
        query.setParameter(METADATA_TYPE, (Object)type);
        query.setParameter("name", (Object)name);
        query.setParameter("audienceId", (Object)audienceId);
        try {
            return (MetadataEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<MetadataEntity> getMetadatas(long type, long limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.getMetadatas", MetadataEntity.class);
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        query.setParameter(METADATA_TYPE, (Object)type);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<Long> getMetadataIds(long type, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.getMetadataIds", Long.class);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        query.setParameter(METADATA_TYPE, (Object)type);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<Long> getMetadataIdsByProperty(String propertyKey, String propertyValue, long offset, long limit, boolean orderByName) {
        TypedQuery query = this.getEntityManager().createNamedQuery(orderByName ? "SocMetadataEntity.getMetadatasByPropertyOrderByName" : "SocMetadataEntity.getMetadatasByPropertyOrderById", Long.class);
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (offset > 0L) {
            query.setFirstResult((int)offset);
        }
        query.setParameter("propertyName", (Object)propertyKey);
        query.setParameter("propertyValue", (Object)propertyValue);
        return query.getResultList();
    }

    public long countMetadataIdsByProperty(String propertyKey, String propertyValue) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataEntity.countMetadataIdsByProperty", Long.class);
        query.setParameter("propertyName", (Object)propertyKey);
        query.setParameter("propertyValue", (Object)propertyValue);
        try {
            Long result = (Long)query.getSingleResult();
            return result == null ? 0L : result;
        }
        catch (NoResultException e) {
            return 0L;
        }
    }
}

