/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.utils;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class Utils {
    private Utils() {
    }

    public static boolean isMemberOf(IdentityManager identityManager, SpaceService spaceService, UserACL userAcl, long identityId, String username) {
        org.exoplatform.services.security.Identity userAclIdentity = userAcl.getUserIdentity(username);
        if (identityId == 0L) {
            return true;
        }
        if (userAclIdentity == null) {
            return false;
        }
        Identity identity = identityManager.getIdentity(identityId);
        if (identity == null) {
            return false;
        }
        return switch (identity.getProviderId()) {
            case "space" -> {
                Space space = spaceService.getSpaceByPrettyName(identity.getRemoteId());
                if (space != null && spaceService.canViewSpace(space, userAclIdentity.getUserId())) {
                    yield true;
                }
                yield false;
            }
            case "group" -> userAclIdentity.isMemberOf(identity.getRemoteId());
            case "organization" -> StringUtils.equals((CharSequence)identity.getRemoteId(), (CharSequence)userAclIdentity.getUserId());
            default -> false;
        };
    }

    public static boolean isManagerOf(IdentityManager identityManager, SpaceService spaceService, UserACL userAcl, long identityId, String username) {
        org.exoplatform.services.security.Identity userAclIdentity = userAcl.getUserIdentity(username);
        if (identityId == 0L) {
            return true;
        }
        if (userAclIdentity == null) {
            return false;
        }
        Identity identity = identityManager.getIdentity(identityId);
        if (identity == null) {
            return false;
        }
        return switch (identity.getProviderId()) {
            case "space" -> {
                Space space = spaceService.getSpaceByPrettyName(identity.getRemoteId());
                if (space != null && spaceService.canManageSpace(space, userAclIdentity.getUserId())) {
                    yield true;
                }
                yield false;
            }
            case "group" -> userAclIdentity.isMemberOf(identity.getRemoteId(), userAcl.getAdminMSType());
            case "organization" -> StringUtils.equals((CharSequence)identity.getRemoteId(), (CharSequence)userAclIdentity.getUserId());
            default -> false;
        };
    }
}

