/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.image;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import junit.framework.TestCase;
import org.exoplatform.social.core.image.ImageUtils;
import org.exoplatform.social.core.model.AvatarAttachment;

public class ImageUtilsTest
extends TestCase {
    public void testBuildFileName() {
        String oldFileName = "avatar";
        String extendsion = ".jpg";
        String subfix = "RESIZED_";
        String postfix = "_100x100";
        String newFileName = ImageUtils.buildFileName((String)(oldFileName + extendsion), (String)subfix, (String)postfix);
        ImageUtilsTest.assertEquals((String)("Should be " + subfix + oldFileName + postfix + extendsion), (String)(subfix + oldFileName + postfix + extendsion), (String)newFileName);
    }

    public void testBuildImagePostfix() {
        String postfix = ImageUtils.buildImagePostfix((int)100, (int)-10);
        ImageUtilsTest.assertEquals((String)"_100x0", (String)postfix);
    }

    public void testCreateResizedAvatarAttachment() throws IOException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        int width = 100;
        int height = 100;
        String avatarId = "null";
        String avatarMimeType = "image/jpeg";
        String avatarFileName = "eXo-Social.png";
        String avatarWorkspace = "null";
        AvatarAttachment avatar = ImageUtils.createResizedAvatarAttachment((InputStream)inputStream, (int)width, (int)height, (String)avatarId, (String)avatarFileName, (String)avatarMimeType, (String)avatarWorkspace);
        ImageUtilsTest.assertNotNull((Object)avatar);
        ImageUtilsTest.assertNotNull((Object)avatar.getImageBytes());
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(avatar.getImageBytes()));
        ImageUtilsTest.assertEquals((int)100, (int)image.getWidth());
        ImageUtilsTest.assertEquals((int)27, (int)image.getHeight());
    }

    public void testCreateDefaultAvatar() throws IOException {
        int width = 350;
        int height = 350;
        String letters = "AB";
        AvatarAttachment avatar = ImageUtils.createDefaultAvatar((String)"50", (String)letters);
        ImageUtilsTest.assertNotNull((Object)avatar);
        ImageUtilsTest.assertNotNull((Object)avatar.getImageBytes());
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(avatar.getImageBytes()));
        ImageUtilsTest.assertEquals((int)350, (int)image.getWidth());
        ImageUtilsTest.assertEquals((int)350, (int)image.getHeight());
    }
}

