/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.utils;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.utils.MentionUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MentionUtilsTest {
    private static final String ROOT_FULL_NAME = "Root Root";
    private static final String ROOT_FULL_NAME_MATCH = "<span>Root Root</span>";
    private static final String JOHN_FULL_NAME = "John Anthony";
    private static final String JOHN_FULL_NAME_MATCH = "<span>John Anthony</span>";
    private static final String PORTAL_OWNER = "public";
    private static final MockedStatic<LinkProvider> LINK_PROVIDER_UTIL = Mockito.mockStatic(LinkProvider.class);
    @Mock
    private IdentityManager identityManager;
    @Mock
    private Identity identity;

    @AfterClass
    public static void afterClass() {
        LINK_PROVIDER_UTIL.close();
    }

    @Before
    public void beforeMethod() {
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(ArgumentMatchers.anyString())).thenReturn((Object)this.identity);
        Mockito.when((Object)this.identity.isEnable()).thenReturn((Object)true);
        LINK_PROVIDER_UTIL.when(() -> LinkProvider.getProfileLink((String)"root", (String)PORTAL_OWNER)).thenAnswer(invocation -> ROOT_FULL_NAME_MATCH);
        LINK_PROVIDER_UTIL.when(() -> LinkProvider.getProfileLink((String)"john", (String)PORTAL_OWNER)).thenAnswer(invocation -> JOHN_FULL_NAME_MATCH);
    }

    @Test
    public void testSubstituteUsernames() {
        String message = "hello <p>@root</p>";
        message = MentionUtils.substituteUsernames((IdentityManager)this.identityManager, (String)PORTAL_OWNER, (String)message);
        Assert.assertEquals((long)1L, (long)StringUtils.countMatches((CharSequence)message, (CharSequence)ROOT_FULL_NAME_MATCH));
    }

    @Test
    public void testWrongFormatMentionWithSubstituteUsernames() {
        String message = "hello @ jhon";
        message = MentionUtils.substituteUsernames((IdentityManager)this.identityManager, (String)PORTAL_OWNER, (String)message);
        Assert.assertEquals((Object)"hello @ jhon", (Object)message);
    }

    @Test
    public void testMultipleSubstituteUsernames() {
        String message = "hello <p>@root</p> hey! <p>@john</p> ";
        message = MentionUtils.substituteUsernames((IdentityManager)this.identityManager, (String)PORTAL_OWNER, (String)message);
        Assert.assertEquals((long)1L, (long)StringUtils.countMatches((CharSequence)message, (CharSequence)ROOT_FULL_NAME_MATCH));
        Assert.assertEquals((long)1L, (long)StringUtils.countMatches((CharSequence)message, (CharSequence)JOHN_FULL_NAME_MATCH));
    }

    @Test
    public void testMultipleSubstituteUsernamesWithSpecialCharacters() {
        String message = "hello <p>@root</p> http://test.com/@john/testtest hey!";
        message = MentionUtils.substituteUsernames((IdentityManager)this.identityManager, (String)PORTAL_OWNER, (String)message);
        Assert.assertEquals((long)1L, (long)StringUtils.countMatches((CharSequence)message, (CharSequence)ROOT_FULL_NAME_MATCH));
        Assert.assertEquals((long)0L, (long)StringUtils.countMatches((CharSequence)message, (CharSequence)">John Anthony"));
        message = "hello <p>@root</p> http://test.com/@john/testtest hey! @john";
        message = MentionUtils.substituteUsernames((IdentityManager)this.identityManager, (String)PORTAL_OWNER, (String)message);
        Assert.assertEquals((long)1L, (long)StringUtils.countMatches((CharSequence)message, (CharSequence)ROOT_FULL_NAME_MATCH));
        Assert.assertEquals((long)1L, (long)StringUtils.countMatches((CharSequence)message, (CharSequence)JOHN_FULL_NAME_MATCH));
    }
}

