/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.processor.OSHtmlSanitizerProcessor;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class OSHtmlSanitizerProcessorTest
extends AbstractCoreTest {
    private OSHtmlSanitizerProcessor processor;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.processor = (OSHtmlSanitizerProcessor)PortalContainer.getInstance().getComponentInstanceOfType(OSHtmlSanitizerProcessor.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testProcessActivity() throws Exception {
        System.setProperty("gatein.email.domain.url", "test.com");
        try {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            String sample = "this is a <strong> tag to keep</strong>";
            activity.setTitle(sample);
            activity.setBody(sample);
            this.processor.processActivity((ExoSocialActivity)activity);
            OSHtmlSanitizerProcessorTest.assertEquals((String)sample, (String)activity.getTitle());
            OSHtmlSanitizerProcessorTest.assertEquals((String)sample, (String)activity.getBody());
            sample = "text <a href='test.com'>bar</a> zed";
            activity.setTitle(sample);
            this.processor.processActivity((ExoSocialActivity)activity);
            OSHtmlSanitizerProcessorTest.assertEquals((String)"text <a href=\"test.com\" rel=\"nofollow\" target=\"_self\">bar</a> zed", (String)activity.getTitle());
            sample = "<strong> only open!!!";
            activity.setTitle(sample);
            this.processor.processActivity((ExoSocialActivity)activity);
            OSHtmlSanitizerProcessorTest.assertEquals((String)"<strong> only open!!!</strong>", (String)activity.getTitle());
            sample = "<script href='#' />bar</a>";
            activity.setTitle(sample);
            this.processor.processActivity((ExoSocialActivity)activity);
            OSHtmlSanitizerProcessorTest.assertEquals((String)"", (String)activity.getTitle());
            sample = "<script>foo</script>";
            activity.setTitle(sample);
            this.processor.processActivity((ExoSocialActivity)activity);
            OSHtmlSanitizerProcessorTest.assertEquals((String)"", (String)activity.getTitle());
            sample = "<span><strong>foo</strong>bar<script>zed</script></span>";
            activity.setTitle(sample);
            this.processor.processActivity((ExoSocialActivity)activity);
            OSHtmlSanitizerProcessorTest.assertEquals((String)"<strong>foo</strong>bar", (String)activity.getTitle().trim());
        }
        finally {
            System.clearProperty("gatein.email.domain.url");
        }
    }
}

