/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.html.service;

import io.meeds.social.AbstractSpringConfigurationTest;
import io.meeds.social.html.model.HtmlTransformerContext;
import io.meeds.social.html.plugin.HtmlTransformerPlugin;
import io.meeds.social.html.service.HtmlTransformerService;
import io.meeds.social.html.utils.HtmlUtils;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.springframework.beans.factory.annotation.Autowired;

public class HtmlTransformerServiceTest
extends AbstractSpringConfigurationTest {
    private static final String CONTENT_NO_MATCH = "Content";
    private static final String CONTENT_MATCH = "Content1\ntest:887\n";
    private static final String CONTENT_MATCH_RESULT = "Content1\nContent2\n";
    @Autowired
    private HtmlTransformerService htmlTransformerService;

    @Test
    public void processContentNoMatch() {
        Assertions.assertEquals((Object)CONTENT_NO_MATCH, (Object)HtmlUtils.transform((String)CONTENT_NO_MATCH, null));
    }

    @Test
    public void processContentWithContext() {
        Assertions.assertEquals((Object)CONTENT_NO_MATCH, (Object)HtmlUtils.transform((String)CONTENT_NO_MATCH, (HtmlTransformerContext)new HtmlTransformerContext()));
    }

    @Test
    public void processContent() {
        HtmlTransformerTest plugin = new HtmlTransformerTest();
        try {
            this.htmlTransformerService.addPlugin((HtmlTransformerPlugin)plugin);
            Assertions.assertEquals((Object)CONTENT_MATCH_RESULT, (Object)HtmlUtils.transform((String)CONTENT_MATCH, (HtmlTransformerContext)new HtmlTransformerContext()));
        }
        finally {
            this.htmlTransformerService.removePlugin((HtmlTransformerPlugin)plugin);
        }
    }

    public static class HtmlTransformerTest
    implements HtmlTransformerPlugin {
        public String transform(String html, HtmlTransformerContext context) {
            return html.replace("test:887", "Content2");
        }
    }
}

