/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.html.service;

import io.meeds.social.AbstractSpringConfigurationTest;
import io.meeds.social.html.model.HtmlProcessorContext;
import io.meeds.social.html.plugin.HtmlProcessorPlugin;
import io.meeds.social.html.service.HtmlProcessorService;
import io.meeds.social.html.utils.HtmlUtils;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.springframework.beans.factory.annotation.Autowired;

public class HtmlProcessorServiceTest
extends AbstractSpringConfigurationTest {
    private static final String CONTENT_NO_MATCH = "Content";
    private static final String CONTENT_MATCH = "Content1\ntest:556\n";
    private static final String CONTENT_MATCH_RESULT = "Content1\nContent2\n";
    @Autowired
    private HtmlProcessorService htmlProcessorService;

    @Test
    public void processContentNoMatch() {
        Assertions.assertEquals((Object)CONTENT_NO_MATCH, (Object)HtmlUtils.process((String)CONTENT_NO_MATCH, null));
    }

    @Test
    public void processContentWithContext() {
        Assertions.assertEquals((Object)CONTENT_NO_MATCH, (Object)HtmlUtils.process((String)CONTENT_NO_MATCH, (HtmlProcessorContext)new HtmlProcessorContext()));
    }

    @Test
    public void processContent() {
        HtmlProcessorTest plugin = new HtmlProcessorTest();
        try {
            this.htmlProcessorService.addPlugin((HtmlProcessorPlugin)plugin);
            Assertions.assertEquals((Object)CONTENT_MATCH_RESULT, (Object)HtmlUtils.process((String)CONTENT_MATCH, (HtmlProcessorContext)new HtmlProcessorContext()));
        }
        finally {
            this.htmlProcessorService.removePlugin((HtmlProcessorPlugin)plugin);
        }
    }

    public static class HtmlProcessorTest
    implements HtmlProcessorPlugin {
        public String process(String html, HtmlProcessorContext context) {
            return html.replace("test:556", "Content2");
        }
    }
}

