/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import io.meeds.portal.navigation.constant.SidebarItemType;
import io.meeds.portal.navigation.model.SidebarItem;
import io.meeds.social.navigation.AbstractNavigationConfigurationTest;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.space.model.Space;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpaceTemplateSidebarPluginTest
extends AbstractNavigationConfigurationTest {
    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
        if (this.spaceTemplate == null) {
            this.mockSpaceTemplate();
            for (int i = 0; i < 5; ++i) {
                Space space = new Space();
                space.setRegistration("open");
                space.setVisibility("public");
                space.setTemplateId(this.spaceTemplate.getId());
                this.spaceService.createSpace(space, this.userAcl.getSuperUser());
            }
        }
    }

    @Test
    public void testGetType() {
        Assert.assertEquals((Object)SidebarItemType.SPACE_TEMPLATE, (Object)this.spaceTemplateSidebarPlugin.getType());
    }

    @Test
    public void testGetDefaultItems() {
        List defaultItems = this.spaceTemplateSidebarPlugin.getDefaultItems();
        Assert.assertNotNull((Object)defaultItems);
        Assert.assertTrue((boolean)defaultItems.stream().anyMatch(item -> item.getProperties() != null && StringUtils.equals((CharSequence)((CharSequence)item.getProperties().get("spaceTemplateId")), (CharSequence)String.valueOf(this.spaceTemplate.getId()))));
    }

    @Test
    public void testItemExists() {
        Assert.assertFalse((boolean)this.spaceTemplateSidebarPlugin.itemExists(null, null));
        Assert.assertFalse((boolean)this.spaceTemplateSidebarPlugin.itemExists(new SidebarItem(), null));
        SidebarItem item = new SidebarItem(SidebarItemType.SPACE_TEMPLATE);
        item.setProperties(Collections.singletonMap("spaceTemplateId", String.valueOf(this.spaceTemplate.getId())));
        Assert.assertTrue((boolean)this.spaceTemplateSidebarPlugin.itemExists(item, null));
    }

    @Test
    public void testResolveProperties() {
        SidebarItem item = new SidebarItem(SidebarItemType.SPACE_TEMPLATE);
        item.setProperties(Collections.singletonMap("spaceTemplateId", String.valueOf(this.spaceTemplate.getId())));
        this.spaceTemplateSidebarPlugin.resolveProperties(item, this.userAcl.getSuperUser(), Locale.ENGLISH);
        Assert.assertEquals((Object)this.spaceTemplate.getName(), (Object)item.getName());
        Assert.assertEquals((Object)this.spaceTemplate.getIcon(), (Object)item.getIcon());
        Assert.assertNull((Object)item.getUrl());
        Assert.assertNull((Object)item.getTarget());
        Assert.assertNull((Object)item.getAvatar());
        Assert.assertFalse((boolean)item.isDefaultPath());
        Assert.assertNotNull((Object)item.getItems());
        Assert.assertEquals((long)4L, (long)item.getItems().size());
        Assert.assertTrue((boolean)((SidebarItem)item.getItems().get(0)).isDefaultPath());
    }
}

