/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.coediting.service;

import io.meeds.social.coediting.model.CoeditionObjectKey;
import io.meeds.social.coediting.model.CoeditionObjectLock;
import io.meeds.social.coediting.service.CoeditingService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.junit4.SpringRunner;

@SpringBootTest(classes={CoeditingService.class})
@RunWith(value=SpringRunner.class)
public class CoeditingServiceTest {
    private static final String REVISION = "revision";
    private static final String USERNAME = "username";
    @MockBean
    private SettingService settingService;
    @MockBean
    private CacheService cacheService;
    @Autowired
    private CoeditingService coeditingService;
    @Mock
    private ExoCache<CoeditionObjectKey, CoeditionObjectLock> lockCache;
    @Mock
    private CoeditionObjectKey key;
    @Mock
    private CoeditionObjectLock lock;
    @Value(value="${meeds.coediting.lockPeriod:20}")
    private long lockPeriod;

    @Before
    public void setup() {
        this.coeditingService.setLockCache(this.lockCache);
    }

    @Test
    public void getLockHoldersEmpty() {
        List lockHolders = this.coeditingService.getLockHolders(this.key);
        Assert.assertNotNull((Object)lockHolders);
        Assert.assertEquals((long)0L, (long)lockHolders.size());
    }

    @Test
    public void getLockHoldersWithOutdatedLocks() {
        Mockito.when((Object)((CoeditionObjectLock)this.lockCache.get((Serializable)this.key))).thenReturn((Object)this.lock);
        Mockito.when((Object)this.lock.getUsers()).thenReturn(Collections.singletonMap(USERNAME, System.currentTimeMillis() - 20001L));
        List lockHolders = this.coeditingService.getLockHolders(this.key);
        Assert.assertNotNull((Object)lockHolders);
        Assert.assertEquals((long)0L, (long)lockHolders.size());
    }

    @Test
    public void getLockHolders() {
        Mockito.when((Object)((CoeditionObjectLock)this.lockCache.get((Serializable)this.key))).thenReturn((Object)this.lock);
        Mockito.when((Object)this.lock.getUsers()).thenReturn(Collections.singletonMap(USERNAME, System.currentTimeMillis()));
        List lockHolders = this.coeditingService.getLockHolders(this.key);
        Assert.assertNotNull((Object)lockHolders);
        Assert.assertEquals((long)1L, (long)lockHolders.size());
    }

    @Test
    public void setLockWithNotExisting() {
        this.coeditingService.setLock(USERNAME, this.key, REVISION);
        ((ExoCache)Mockito.verify(this.lockCache)).put((Serializable)((CoeditionObjectKey)ArgumentMatchers.eq((Object)this.key)), (Object)((CoeditionObjectLock)ArgumentMatchers.argThat(l -> l.getUsers().size() == 1 && l.getUsers().get(USERNAME) != null && (Long)l.getUsers().get(USERNAME) > System.currentTimeMillis() - 1000L)));
        ((SettingService)Mockito.verify((Object)this.settingService)).set((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (SettingValue)ArgumentMatchers.any());
    }

    @Test
    public void setLockWithExisting() {
        Mockito.when((Object)((CoeditionObjectLock)this.lockCache.get((Serializable)this.key))).thenReturn((Object)this.lock);
        ConcurrentHashMap<String, Long> users = new ConcurrentHashMap<String, Long>();
        users.put(USERNAME, System.currentTimeMillis());
        users.put("username2", System.currentTimeMillis() - 20001L);
        Mockito.when((Object)this.lock.getUsers()).thenReturn(users);
        Mockito.when((Object)this.settingService.get((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)SettingValue.create((String)"{\"revision\": \"revision2\"}"));
        this.coeditingService.setLock(USERNAME, this.key, REVISION);
        ((ExoCache)Mockito.verify(this.lockCache)).put((Serializable)this.key, (Object)this.lock);
        ((SettingService)Mockito.verify((Object)this.settingService)).set((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (SettingValue)ArgumentMatchers.any());
        Assert.assertEquals((long)1L, (long)this.lock.getUsers().size());
    }
}

